// services/network/public/mojom/transferable_socket.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRANSFERABLE_SOCKET_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRANSFERABLE_SOCKET_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/transferable_socket.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/transferable_socket.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/transferable_socket.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "services/network/public/cpp/transferable_socket_mojom_traits.h"




namespace network::mojom {








class  TransferableSocket {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TransferableSocket, T>::value>;
  using DataView = TransferableSocketDataView;
  using Data_ = internal::TransferableSocket_Data;

  template <typename... Args>
  static TransferableSocketPtr New(Args&&... args) {
    return TransferableSocketPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TransferableSocketPtr From(const U& u) {
    return mojo::TypeConverter<TransferableSocketPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TransferableSocket>::Convert(*this);
  }


  TransferableSocket();

  explicit TransferableSocket(
      ::mojo::PlatformHandle socket);

TransferableSocket(const TransferableSocket&) = delete;
TransferableSocket& operator=(const TransferableSocket&) = delete;

  ~TransferableSocket();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TransferableSocketPtr>
  TransferableSocketPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TransferableSocket::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TransferableSocket::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TransferableSocket::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TransferableSocket::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TransferableSocket_UnserializedMessageContext<
            UserType, TransferableSocket::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TransferableSocket::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TransferableSocket::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TransferableSocket_UnserializedMessageContext<
            UserType, TransferableSocket::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TransferableSocket::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PlatformHandle socket;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TransferableSocket::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TransferableSocket::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TransferableSocket::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TransferableSocket::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TransferableSocketPtr TransferableSocket::Clone() const {
  return New(
      mojo::Clone(socket)
  );
}

template <typename T, TransferableSocket::EnableIfSame<T>*>
bool TransferableSocket::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->socket, other_struct.socket))
    return false;
  return true;
}

template <typename T, TransferableSocket::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.socket < rhs.socket)
    return true;
  if (rhs.socket < lhs.socket)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::TransferableSocket::DataView,
                                         ::network::mojom::TransferableSocketPtr> {
  static bool IsNull(const ::network::mojom::TransferableSocketPtr& input) { return !input; }
  static void SetToNull(::network::mojom::TransferableSocketPtr* output) { output->reset(); }

  static  decltype(::network::mojom::TransferableSocket::socket)& socket(
       ::network::mojom::TransferableSocketPtr& input) {
    return input->socket;
  }

  static bool Read(::network::mojom::TransferableSocket::DataView input, ::network::mojom::TransferableSocketPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRANSFERABLE_SOCKET_MOJOM_H_