// services/network/public/mojom/tcp_socket.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  AddressList as network_mojom_AddressList,
  AddressListSpec as network_mojom_AddressListSpec
} from './address_list.mojom.m.js';

import {
  IPEndPoint as network_mojom_IPEndPoint,
  IPEndPointSpec as network_mojom_IPEndPointSpec
} from './ip_endpoint.mojom.m.js';

import {
  MutableNetworkTrafficAnnotationTag as network_mojom_MutableNetworkTrafficAnnotationTag,
  MutableNetworkTrafficAnnotationTagSpec as network_mojom_MutableNetworkTrafficAnnotationTagSpec
} from './mutable_network_traffic_annotation_tag.mojom.m.js';

import {
  HostPortPair as network_mojom_HostPortPair,
  HostPortPairSpec as network_mojom_HostPortPairSpec,
  SSLInfo as network_mojom_SSLInfo,
  SSLInfoSpec as network_mojom_SSLInfoSpec
} from './network_param.mojom.m.js';

import {
  TLSClientSocketRemote as network_mojom_TLSClientSocketRemote,
  TLSClientSocketPendingReceiver as network_mojom_TLSClientSocketPendingReceiver,
  TLSClientSocketOptions as network_mojom_TLSClientSocketOptions,
  TLSClientSocketOptionsSpec as network_mojom_TLSClientSocketOptionsSpec
} from './tls_socket.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TCPBoundSocketPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.TCPBoundSocket', scope);
  }
}

/** @interface */
export class TCPBoundSocketInterface {
  
  /**
   * @param { !number } backlog
   * @param { !TCPServerSocketPendingReceiver } socket
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  listen(backlog, socket) {}
  
  /**
   * @param { !network_mojom_AddressList } remoteAddrList
   * @param { ?TCPConnectedSocketOptions } tcpConnectedSocketOptions
   * @param { !TCPConnectedSocketPendingReceiver } socket
   * @param { ?SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        localAddr: ?network_mojom_IPEndPoint,
        peerAddr: ?network_mojom_IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  connect(remoteAddrList, tcpConnectedSocketOptions, socket, observer) {}
}

/**
 * @implements { TCPBoundSocketInterface }
 */
export class TCPBoundSocketRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TCPBoundSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TCPBoundSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TCPBoundSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } backlog
   * @param { !TCPServerSocketPendingReceiver } socket
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  listen(
      backlog,
      socket) {
    return this.proxy.sendMessage(
        0,
        TCPBoundSocket_Listen_ParamsSpec.$,
        TCPBoundSocket_Listen_ResponseParamsSpec.$,
        [
          backlog,
          socket
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_AddressList } remoteAddrList
   * @param { ?TCPConnectedSocketOptions } tcpConnectedSocketOptions
   * @param { !TCPConnectedSocketPendingReceiver } socket
   * @param { ?SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        localAddr: ?network_mojom_IPEndPoint,
        peerAddr: ?network_mojom_IPEndPoint,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
   *  }>}
   */

  connect(
      remoteAddrList,
      tcpConnectedSocketOptions,
      socket,
      observer) {
    return this.proxy.sendMessage(
        1,
        TCPBoundSocket_Connect_ParamsSpec.$,
        TCPBoundSocket_Connect_ResponseParamsSpec.$,
        [
          remoteAddrList,
          tcpConnectedSocketOptions,
          socket,
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TCPBoundSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TCPBoundSocketReceiver {
  /**
   * @param {!TCPBoundSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TCPBoundSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TCPBoundSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TCPBoundSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TCPBoundSocket_Listen_ParamsSpec.$,
        TCPBoundSocket_Listen_ResponseParamsSpec.$,
        impl.listen.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TCPBoundSocket_Connect_ParamsSpec.$,
        TCPBoundSocket_Connect_ResponseParamsSpec.$,
        impl.connect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TCPBoundSocket {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TCPBoundSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TCPBoundSocketRemote}
   */
  static getRemote() {
    let remote = new TCPBoundSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TCPBoundSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TCPBoundSocketCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TCPBoundSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TCPBoundSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.listen =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TCPBoundSocket_Listen_ParamsSpec.$,
        TCPBoundSocket_Listen_ResponseParamsSpec.$,
        this.listen.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TCPBoundSocket_Connect_ParamsSpec.$,
        TCPBoundSocket_Connect_ResponseParamsSpec.$,
        this.connect.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TCPConnectedSocketPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.TCPConnectedSocket', scope);
  }
}

/** @interface */
export class TCPConnectedSocketInterface {
  
  /**
   * @param { !network_mojom_HostPortPair } hostPortPair
   * @param { ?network_mojom_TLSClientSocketOptions } options
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network_mojom_TLSClientSocketPendingReceiver } receiver
   * @param { ?SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
        sslInfo: ?network_mojom_SSLInfo,
   *  }>}
   */

  upgradeToTLS(hostPortPair, options, trafficAnnotation, receiver, observer) {}
  
  /**
   * @param { !number } sendBufferSize
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  setSendBufferSize(sendBufferSize) {}
  
  /**
   * @param { !number } receiveBufferSize
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  setReceiveBufferSize(receiveBufferSize) {}
  
  /**
   * @param { !boolean } noDelay
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setNoDelay(noDelay) {}
  
  /**
   * @param { !boolean } enable
   * @param { !number } delaySecs
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setKeepAlive(enable, delaySecs) {}
}

/**
 * @implements { TCPConnectedSocketInterface }
 */
export class TCPConnectedSocketRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TCPConnectedSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TCPConnectedSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TCPConnectedSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_HostPortPair } hostPortPair
   * @param { ?network_mojom_TLSClientSocketOptions } options
   * @param { !network_mojom_MutableNetworkTrafficAnnotationTag } trafficAnnotation
   * @param { !network_mojom_TLSClientSocketPendingReceiver } receiver
   * @param { ?SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        receiveStream: ?MojoHandle,
        sendStream: ?MojoHandle,
        sslInfo: ?network_mojom_SSLInfo,
   *  }>}
   */

  upgradeToTLS(
      hostPortPair,
      options,
      trafficAnnotation,
      receiver,
      observer) {
    return this.proxy.sendMessage(
        0,
        TCPConnectedSocket_UpgradeToTLS_ParamsSpec.$,
        TCPConnectedSocket_UpgradeToTLS_ResponseParamsSpec.$,
        [
          hostPortPair,
          options,
          trafficAnnotation,
          receiver,
          observer
        ],
        false);
  }

  
  /**
   * @param { !number } sendBufferSize
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  setSendBufferSize(
      sendBufferSize) {
    return this.proxy.sendMessage(
        1,
        TCPConnectedSocket_SetSendBufferSize_ParamsSpec.$,
        TCPConnectedSocket_SetSendBufferSize_ResponseParamsSpec.$,
        [
          sendBufferSize
        ],
        false);
  }

  
  /**
   * @param { !number } receiveBufferSize
   * @return {!Promise<{
        netError: !number,
   *  }>}
   */

  setReceiveBufferSize(
      receiveBufferSize) {
    return this.proxy.sendMessage(
        2,
        TCPConnectedSocket_SetReceiveBufferSize_ParamsSpec.$,
        TCPConnectedSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
        [
          receiveBufferSize
        ],
        false);
  }

  
  /**
   * @param { !boolean } noDelay
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setNoDelay(
      noDelay) {
    return this.proxy.sendMessage(
        3,
        TCPConnectedSocket_SetNoDelay_ParamsSpec.$,
        TCPConnectedSocket_SetNoDelay_ResponseParamsSpec.$,
        [
          noDelay
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   * @param { !number } delaySecs
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setKeepAlive(
      enable,
      delaySecs) {
    return this.proxy.sendMessage(
        4,
        TCPConnectedSocket_SetKeepAlive_ParamsSpec.$,
        TCPConnectedSocket_SetKeepAlive_ResponseParamsSpec.$,
        [
          enable,
          delaySecs
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TCPConnectedSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TCPConnectedSocketReceiver {
  /**
   * @param {!TCPConnectedSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TCPConnectedSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TCPConnectedSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TCPConnectedSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TCPConnectedSocket_UpgradeToTLS_ParamsSpec.$,
        TCPConnectedSocket_UpgradeToTLS_ResponseParamsSpec.$,
        impl.upgradeToTLS.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TCPConnectedSocket_SetSendBufferSize_ParamsSpec.$,
        TCPConnectedSocket_SetSendBufferSize_ResponseParamsSpec.$,
        impl.setSendBufferSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        TCPConnectedSocket_SetReceiveBufferSize_ParamsSpec.$,
        TCPConnectedSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
        impl.setReceiveBufferSize.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        TCPConnectedSocket_SetNoDelay_ParamsSpec.$,
        TCPConnectedSocket_SetNoDelay_ResponseParamsSpec.$,
        impl.setNoDelay.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        TCPConnectedSocket_SetKeepAlive_ParamsSpec.$,
        TCPConnectedSocket_SetKeepAlive_ResponseParamsSpec.$,
        impl.setKeepAlive.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TCPConnectedSocket {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TCPConnectedSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TCPConnectedSocketRemote}
   */
  static getRemote() {
    let remote = new TCPConnectedSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TCPConnectedSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TCPConnectedSocketCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TCPConnectedSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TCPConnectedSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.upgradeToTLS =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TCPConnectedSocket_UpgradeToTLS_ParamsSpec.$,
        TCPConnectedSocket_UpgradeToTLS_ResponseParamsSpec.$,
        this.upgradeToTLS.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSendBufferSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TCPConnectedSocket_SetSendBufferSize_ParamsSpec.$,
        TCPConnectedSocket_SetSendBufferSize_ResponseParamsSpec.$,
        this.setSendBufferSize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setReceiveBufferSize =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        TCPConnectedSocket_SetReceiveBufferSize_ParamsSpec.$,
        TCPConnectedSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
        this.setReceiveBufferSize.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNoDelay =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        TCPConnectedSocket_SetNoDelay_ParamsSpec.$,
        TCPConnectedSocket_SetNoDelay_ResponseParamsSpec.$,
        this.setNoDelay.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setKeepAlive =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        TCPConnectedSocket_SetKeepAlive_ParamsSpec.$,
        TCPConnectedSocket_SetKeepAlive_ResponseParamsSpec.$,
        this.setKeepAlive.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SocketObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.SocketObserver', scope);
  }
}

/** @interface */
export class SocketObserverInterface {
  
  /**
   * @param { !number } netError
   */

  onReadError(netError) {}
  
  /**
   * @param { !number } netError
   */

  onWriteError(netError) {}
}

/**
 * @implements { SocketObserverInterface }
 */
export class SocketObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SocketObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SocketObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SocketObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } netError
   */

  onReadError(
      netError) {
    this.proxy.sendMessage(
        0,
        SocketObserver_OnReadError_ParamsSpec.$,
        null,
        [
          netError
        ],
        false);
  }

  
  /**
   * @param { !number } netError
   */

  onWriteError(
      netError) {
    this.proxy.sendMessage(
        1,
        SocketObserver_OnWriteError_ParamsSpec.$,
        null,
        [
          netError
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SocketObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SocketObserverReceiver {
  /**
   * @param {!SocketObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SocketObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SocketObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SocketObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SocketObserver_OnReadError_ParamsSpec.$,
        null,
        impl.onReadError.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        SocketObserver_OnWriteError_ParamsSpec.$,
        null,
        impl.onWriteError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SocketObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SocketObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SocketObserverRemote}
   */
  static getRemote() {
    let remote = new SocketObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SocketObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SocketObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SocketObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SocketObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onReadError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SocketObserver_OnReadError_ParamsSpec.$,
        null,
        this.onReadError.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWriteError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        SocketObserver_OnWriteError_ParamsSpec.$,
        null,
        this.onWriteError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TCPServerSocketPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.TCPServerSocket', scope);
  }
}

/** @interface */
export class TCPServerSocketInterface {
  
  /**
   * @param { ?SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        remoteAddr: ?network_mojom_IPEndPoint,
        connectedSocket: ?TCPConnectedSocketRemote,
        sendStream: ?MojoHandle,
        receiveStream: ?MojoHandle,
   *  }>}
   */

  accept(observer) {}
}

/**
 * @implements { TCPServerSocketInterface }
 */
export class TCPServerSocketRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TCPServerSocketPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TCPServerSocketPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TCPServerSocketPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?SocketObserverRemote } observer
   * @return {!Promise<{
        netError: !number,
        remoteAddr: ?network_mojom_IPEndPoint,
        connectedSocket: ?TCPConnectedSocketRemote,
        sendStream: ?MojoHandle,
        receiveStream: ?MojoHandle,
   *  }>}
   */

  accept(
      observer) {
    return this.proxy.sendMessage(
        0,
        TCPServerSocket_Accept_ParamsSpec.$,
        TCPServerSocket_Accept_ResponseParamsSpec.$,
        [
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TCPServerSocket
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TCPServerSocketReceiver {
  /**
   * @param {!TCPServerSocketInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TCPServerSocketRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TCPServerSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TCPServerSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TCPServerSocket_Accept_ParamsSpec.$,
        TCPServerSocket_Accept_ResponseParamsSpec.$,
        impl.accept.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TCPServerSocket {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TCPServerSocket";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TCPServerSocketRemote}
   */
  static getRemote() {
    let remote = new TCPServerSocketRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TCPServerSocket
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TCPServerSocketCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TCPServerSocketRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TCPServerSocketRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.accept =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TCPServerSocket_Accept_ParamsSpec.$,
        TCPServerSocket_Accept_ResponseParamsSpec.$,
        this.accept.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPKeepAliveOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPConnectedSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPServerSocketOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPBoundSocket_Listen_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPBoundSocket_Listen_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPBoundSocket_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPBoundSocket_Connect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPConnectedSocket_UpgradeToTLS_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPConnectedSocket_UpgradeToTLS_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPConnectedSocket_SetSendBufferSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPConnectedSocket_SetSendBufferSize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPConnectedSocket_SetReceiveBufferSize_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPConnectedSocket_SetReceiveBufferSize_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPConnectedSocket_SetNoDelay_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPConnectedSocket_SetNoDelay_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPConnectedSocket_SetKeepAlive_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPConnectedSocket_SetKeepAlive_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SocketObserver_OnReadError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SocketObserver_OnWriteError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPServerSocket_Accept_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TCPServerSocket_Accept_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    TCPKeepAliveOptionsSpec.$,
    'TCPKeepAliveOptions',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'delay', 2,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TCPKeepAliveOptions {
  constructor() {
    /** @type { !boolean } */
    this.enable;
    /** @type { !number } */
    this.delay;
  }
}



mojo.internal.Struct(
    TCPConnectedSocketOptionsSpec.$,
    'TCPConnectedSocketOptions',
    [
      mojo.internal.StructField(
        'sendBufferSize', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiveBufferSize', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'noDelay', 8,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'keepAliveOptions', 16,
        0,
        TCPKeepAliveOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TCPConnectedSocketOptions {
  constructor() {
    /** @type { !number } */
    this.sendBufferSize;
    /** @type { !number } */
    this.receiveBufferSize;
    /** @type { !boolean } */
    this.noDelay;
    /** @type { (TCPKeepAliveOptions|undefined) } */
    this.keepAliveOptions;
  }
}



mojo.internal.Struct(
    TCPServerSocketOptionsSpec.$,
    'TCPServerSocketOptions',
    [
      mojo.internal.StructField(
        'backlog', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ipv6_only_$flag', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "ipv6_only_$value",
          originalFieldName: "ipv6Only",
        }
      ),
      mojo.internal.StructField(
        'ipv6_only_$value', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "ipv6Only",
        }
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TCPServerSocketOptions {
  constructor() {
    /** @type { !number } */
    this.backlog;
    /** @type { (boolean|undefined) } */
    this.ipv6Only;
  }
}



mojo.internal.Struct(
    TCPBoundSocket_Listen_ParamsSpec.$,
    'TCPBoundSocket_Listen_Params',
    [
      mojo.internal.StructField(
        'backlog', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'socket', 4,
        0,
        mojo.internal.InterfaceRequest(TCPServerSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TCPBoundSocket_Listen_Params {
  constructor() {
    /** @type { !number } */
    this.backlog;
    /** @type { !TCPServerSocketPendingReceiver } */
    this.socket;
  }
}



mojo.internal.Struct(
    TCPBoundSocket_Listen_ResponseParamsSpec.$,
    'TCPBoundSocket_Listen_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TCPBoundSocket_Listen_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.netError;
  }
}



mojo.internal.Struct(
    TCPBoundSocket_Connect_ParamsSpec.$,
    'TCPBoundSocket_Connect_Params',
    [
      mojo.internal.StructField(
        'remoteAddrList', 0,
        0,
        network_mojom_AddressListSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tcpConnectedSocketOptions', 8,
        0,
        TCPConnectedSocketOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'socket', 16,
        0,
        mojo.internal.InterfaceRequest(TCPConnectedSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 20,
        0,
        mojo.internal.InterfaceProxy(SocketObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class TCPBoundSocket_Connect_Params {
  constructor() {
    /** @type { !network_mojom_AddressList } */
    this.remoteAddrList;
    /** @type { (TCPConnectedSocketOptions|undefined) } */
    this.tcpConnectedSocketOptions;
    /** @type { !TCPConnectedSocketPendingReceiver } */
    this.socket;
    /** @type { (SocketObserverRemote|undefined) } */
    this.observer;
  }
}



mojo.internal.Struct(
    TCPBoundSocket_Connect_ResponseParamsSpec.$,
    'TCPBoundSocket_Connect_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'localAddr', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'peerAddr', 16,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiveStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sendStream', 24,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class TCPBoundSocket_Connect_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.netError;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.localAddr;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.peerAddr;
    /** @type { (MojoHandle|undefined) } */
    this.receiveStream;
    /** @type { (MojoHandle|undefined) } */
    this.sendStream;
  }
}



mojo.internal.Struct(
    TCPConnectedSocket_UpgradeToTLS_ParamsSpec.$,
    'TCPConnectedSocket_UpgradeToTLS_Params',
    [
      mojo.internal.StructField(
        'hostPortPair', 0,
        0,
        network_mojom_HostPortPairSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        network_mojom_TLSClientSocketOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 16,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 24,
        0,
        mojo.internal.InterfaceRequest(network_mojom_TLSClientSocketPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 28,
        0,
        mojo.internal.InterfaceProxy(SocketObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class TCPConnectedSocket_UpgradeToTLS_Params {
  constructor() {
    /** @type { !network_mojom_HostPortPair } */
    this.hostPortPair;
    /** @type { (network_mojom_TLSClientSocketOptions|undefined) } */
    this.options;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @type { !network_mojom_TLSClientSocketPendingReceiver } */
    this.receiver;
    /** @type { (SocketObserverRemote|undefined) } */
    this.observer;
  }
}



mojo.internal.Struct(
    TCPConnectedSocket_UpgradeToTLS_ResponseParamsSpec.$,
    'TCPConnectedSocket_UpgradeToTLS_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiveStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sendStream', 8,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sslInfo', 16,
        0,
        network_mojom_SSLInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TCPConnectedSocket_UpgradeToTLS_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.netError;
    /** @type { (MojoHandle|undefined) } */
    this.receiveStream;
    /** @type { (MojoHandle|undefined) } */
    this.sendStream;
    /** @type { (network_mojom_SSLInfo|undefined) } */
    this.sslInfo;
  }
}



mojo.internal.Struct(
    TCPConnectedSocket_SetSendBufferSize_ParamsSpec.$,
    'TCPConnectedSocket_SetSendBufferSize_Params',
    [
      mojo.internal.StructField(
        'sendBufferSize', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TCPConnectedSocket_SetSendBufferSize_Params {
  constructor() {
    /** @type { !number } */
    this.sendBufferSize;
  }
}



mojo.internal.Struct(
    TCPConnectedSocket_SetSendBufferSize_ResponseParamsSpec.$,
    'TCPConnectedSocket_SetSendBufferSize_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TCPConnectedSocket_SetSendBufferSize_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.netError;
  }
}



mojo.internal.Struct(
    TCPConnectedSocket_SetReceiveBufferSize_ParamsSpec.$,
    'TCPConnectedSocket_SetReceiveBufferSize_Params',
    [
      mojo.internal.StructField(
        'receiveBufferSize', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TCPConnectedSocket_SetReceiveBufferSize_Params {
  constructor() {
    /** @type { !number } */
    this.receiveBufferSize;
  }
}



mojo.internal.Struct(
    TCPConnectedSocket_SetReceiveBufferSize_ResponseParamsSpec.$,
    'TCPConnectedSocket_SetReceiveBufferSize_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TCPConnectedSocket_SetReceiveBufferSize_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.netError;
  }
}



mojo.internal.Struct(
    TCPConnectedSocket_SetNoDelay_ParamsSpec.$,
    'TCPConnectedSocket_SetNoDelay_Params',
    [
      mojo.internal.StructField(
        'noDelay', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TCPConnectedSocket_SetNoDelay_Params {
  constructor() {
    /** @type { !boolean } */
    this.noDelay;
  }
}



mojo.internal.Struct(
    TCPConnectedSocket_SetNoDelay_ResponseParamsSpec.$,
    'TCPConnectedSocket_SetNoDelay_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TCPConnectedSocket_SetNoDelay_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    TCPConnectedSocket_SetKeepAlive_ParamsSpec.$,
    'TCPConnectedSocket_SetKeepAlive_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'delaySecs', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TCPConnectedSocket_SetKeepAlive_Params {
  constructor() {
    /** @type { !boolean } */
    this.enable;
    /** @type { !number } */
    this.delaySecs;
  }
}



mojo.internal.Struct(
    TCPConnectedSocket_SetKeepAlive_ResponseParamsSpec.$,
    'TCPConnectedSocket_SetKeepAlive_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TCPConnectedSocket_SetKeepAlive_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    SocketObserver_OnReadError_ParamsSpec.$,
    'SocketObserver_OnReadError_Params',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SocketObserver_OnReadError_Params {
  constructor() {
    /** @type { !number } */
    this.netError;
  }
}



mojo.internal.Struct(
    SocketObserver_OnWriteError_ParamsSpec.$,
    'SocketObserver_OnWriteError_Params',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SocketObserver_OnWriteError_Params {
  constructor() {
    /** @type { !number } */
    this.netError;
  }
}



mojo.internal.Struct(
    TCPServerSocket_Accept_ParamsSpec.$,
    'TCPServerSocket_Accept_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(SocketObserverRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TCPServerSocket_Accept_Params {
  constructor() {
    /** @type { (SocketObserverRemote|undefined) } */
    this.observer;
  }
}



mojo.internal.Struct(
    TCPServerSocket_Accept_ResponseParamsSpec.$,
    'TCPServerSocket_Accept_ResponseParams',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteAddr', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connectedSocket', 16,
        0,
        mojo.internal.InterfaceProxy(TCPConnectedSocketRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sendStream', 4,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiveStream', 24,
        0,
        mojo.internal.Handle,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class TCPServerSocket_Accept_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.netError;
    /** @type { (network_mojom_IPEndPoint|undefined) } */
    this.remoteAddr;
    /** @type { (TCPConnectedSocketRemote|undefined) } */
    this.connectedSocket;
    /** @type { (MojoHandle|undefined) } */
    this.sendStream;
    /** @type { (MojoHandle|undefined) } */
    this.receiveStream;
  }
}

