// services/network/public/mojom/ssl_config.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/ssl_config.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/ssl_config.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::SSLVersion>
    : public mojo::internal::EnumHashImpl<::network::mojom::SSLVersion> {};

template <>
struct hash<::network::mojom::SSLNamedGroupsPreset>
    : public mojo::internal::EnumHashImpl<::network::mojom::SSLNamedGroupsPreset> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SSLVersion, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SSLVersion, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SSLVersion>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SSLNamedGroupsPreset, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SSLNamedGroupsPreset, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SSLNamedGroupsPreset>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SSLConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SSLConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SSLConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->rev_checking_enabled = Traits::rev_checking_enabled(input);

    fragment->rev_checking_required_local_anchors = Traits::rev_checking_required_local_anchors(input);

    fragment->sha1_local_anchors_enabled = Traits::sha1_local_anchors_enabled(input);

    
    mojo::internal::Serialize<::network::mojom::SSLVersion>(
      Traits::version_min(input),
      &fragment->version_min);

    
    mojo::internal::Serialize<::network::mojom::SSLVersion>(
      Traits::version_max(input),
      &fragment->version_max);

    decltype(Traits::disabled_cipher_suites(input)) in_disabled_cipher_suites = Traits::disabled_cipher_suites(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->disabled_cipher_suites)::BaseType>
        disabled_cipher_suites_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& disabled_cipher_suites_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>>(
      in_disabled_cipher_suites,
      disabled_cipher_suites_fragment,
      &disabled_cipher_suites_validate_params);

    fragment->disabled_cipher_suites.Set(
        disabled_cipher_suites_fragment.is_null() ? nullptr : disabled_cipher_suites_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->disabled_cipher_suites.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null disabled_cipher_suites in SSLConfig struct");

    fragment->tls13_cipher_prefer_aes_256 = Traits::tls13_cipher_prefer_aes_256(input);

    decltype(Traits::client_cert_pooling_policy(input)) in_client_cert_pooling_policy = Traits::client_cert_pooling_policy(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->client_cert_pooling_policy)::BaseType>
        client_cert_pooling_policy_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& client_cert_pooling_policy_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_client_cert_pooling_policy,
      client_cert_pooling_policy_fragment,
      &client_cert_pooling_policy_validate_params);

    fragment->client_cert_pooling_policy.Set(
        client_cert_pooling_policy_fragment.is_null() ? nullptr : client_cert_pooling_policy_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->client_cert_pooling_policy.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null client_cert_pooling_policy in SSLConfig struct");

    
    mojo::internal::Serialize<::network::mojom::SSLNamedGroupsPreset>(
      Traits::named_groups_preset(input),
      &fragment->named_groups_preset);

    fragment->post_quantum_key_agreement_enabled = Traits::post_quantum_key_agreement_enabled(input);

    fragment->ech_enabled = Traits::ech_enabled(input);

    decltype(Traits::trust_anchor_ids(input)) in_trust_anchor_ids = Traits::trust_anchor_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_anchor_ids)::BaseType>
        trust_anchor_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& trust_anchor_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
      in_trust_anchor_ids,
      trust_anchor_ids_fragment,
      &trust_anchor_ids_validate_params);

    fragment->trust_anchor_ids.Set(
        trust_anchor_ids_fragment.is_null() ? nullptr : trust_anchor_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->trust_anchor_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trust_anchor_ids in SSLConfig struct");
  }

  static bool Deserialize(::network::mojom::internal::SSLConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SSLConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void SSLConfigDataView::GetDisabledCipherSuitesDataView(
    mojo::ArrayDataView<uint16_t>* output) {
  auto pointer = data_->disabled_cipher_suites.Get();
  *output = mojo::ArrayDataView<uint16_t>(pointer, message_);
}
inline void SSLConfigDataView::GetClientCertPoolingPolicyDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->client_cert_pooling_policy.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void SSLConfigDataView::GetTrustAnchorIdsDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->trust_anchor_ids.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SSLVersion> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SSLVersion value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SSLNamedGroupsPreset> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SSLNamedGroupsPreset value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SSL_CONFIG_MOJOM_SHARED_H_