// services/network/public/mojom/site_for_cookies.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SITE_FOR_COOKIES_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SITE_FOR_COOKIES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/site_for_cookies.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/site_for_cookies.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/schemeful_site.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "services/network/public/cpp/cookie_manager_shared_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {








class BLINK_PLATFORM_EXPORT SiteForCookies {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SiteForCookies, T>::value>;
  using DataView = SiteForCookiesDataView;
  using Data_ = internal::SiteForCookies_Data;

  template <typename... Args>
  static SiteForCookiesPtr New(Args&&... args) {
    return SiteForCookiesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SiteForCookiesPtr From(const U& u) {
    return mojo::TypeConverter<SiteForCookiesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SiteForCookies>::Convert(*this);
  }


  SiteForCookies();

  SiteForCookies(
      const ::blink::BlinkSchemefulSite& site,
      bool schemefully_same);


  ~SiteForCookies();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SiteForCookiesPtr>
  SiteForCookiesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SiteForCookies::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SiteForCookies::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SiteForCookies::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteForCookies::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SiteForCookies::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SiteForCookies::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SiteForCookies_UnserializedMessageContext<
            UserType, SiteForCookies::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SiteForCookies::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SiteForCookies::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SiteForCookies_UnserializedMessageContext<
            UserType, SiteForCookies::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SiteForCookies::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::BlinkSchemefulSite site;
  
  bool schemefully_same;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SiteForCookies::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SiteForCookies::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SiteForCookies::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SiteForCookies::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SiteForCookiesPtr SiteForCookies::Clone() const {
  return New(
      mojo::Clone(site),
      mojo::Clone(schemefully_same)
  );
}

template <typename T, SiteForCookies::EnableIfSame<T>*>
bool SiteForCookies::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->site, other_struct.site))
    return false;
  if (!mojo::Equals(this->schemefully_same, other_struct.schemefully_same))
    return false;
  return true;
}

template <typename T, SiteForCookies::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.site < rhs.site)
    return true;
  if (rhs.site < lhs.site)
    return false;
  if (lhs.schemefully_same < rhs.schemefully_same)
    return true;
  if (rhs.schemefully_same < lhs.schemefully_same)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::SiteForCookies::DataView,
                                         ::network::mojom::blink::SiteForCookiesPtr> {
  static bool IsNull(const ::network::mojom::blink::SiteForCookiesPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::SiteForCookiesPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::SiteForCookies::site)& site(
      const ::network::mojom::blink::SiteForCookiesPtr& input) {
    return input->site;
  }

  static decltype(::network::mojom::blink::SiteForCookies::schemefully_same) schemefully_same(
      const ::network::mojom::blink::SiteForCookiesPtr& input) {
    return input->schemefully_same;
  }

  static bool Read(::network::mojom::blink::SiteForCookies::DataView input, ::network::mojom::blink::SiteForCookiesPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SITE_FOR_COOKIES_MOJOM_BLINK_H_