// services/network/public/mojom/restricted_cookie_manager.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/restricted_cookie_manager.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/restricted_cookie_manager.mojom-params-data.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom-shared-message-ids.h"

#include "services/network/public/mojom/restricted_cookie_manager.mojom-import-headers.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom-test-utils.h"


namespace network::mojom {
CookieManagerGetOptions::CookieManagerGetOptions()
    : name(),
      match_type() {}

CookieManagerGetOptions::CookieManagerGetOptions(
    const std::string& name_in,
    CookieMatchType match_type_in)
    : name(std::move(name_in)),
      match_type(std::move(match_type_in)) {}

CookieManagerGetOptions::~CookieManagerGetOptions() = default;
size_t CookieManagerGetOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->match_type);
  return seed;
}

void CookieManagerGetOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "match_type"), this->match_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CookieMatchType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookieManagerGetOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CookiesResponse::CookiesResponse()
    : version(),
      version_buffer(),
      cookies() {}

CookiesResponse::CookiesResponse(
    uint64_t version_in,
    ::base::ReadOnlySharedMemoryRegion version_buffer_in,
    const std::string& cookies_in)
    : version(std::move(version_in)),
      version_buffer(std::move(version_buffer_in)),
      cookies(std::move(cookies_in)) {}

CookiesResponse::~CookiesResponse() = default;

void CookiesResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version_buffer"), this->version_buffer,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::ReadOnlySharedMemoryRegion>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cookies"), this->cookies,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CookiesResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

RestrictedCookieManager::IPCStableHashFunction RestrictedCookieManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RestrictedCookieManager>(message.name())) {
    case messages::RestrictedCookieManager::kGetAllForUrl: {
      return &RestrictedCookieManager::GetAllForUrl_Sym::IPCStableHash;
    }
    case messages::RestrictedCookieManager::kSetCanonicalCookie: {
      return &RestrictedCookieManager::SetCanonicalCookie_Sym::IPCStableHash;
    }
    case messages::RestrictedCookieManager::kAddChangeListener: {
      return &RestrictedCookieManager::AddChangeListener_Sym::IPCStableHash;
    }
    case messages::RestrictedCookieManager::kSetCookieFromString: {
      return &RestrictedCookieManager::SetCookieFromString_Sym::IPCStableHash;
    }
    case messages::RestrictedCookieManager::kGetCookiesString: {
      return &RestrictedCookieManager::GetCookiesString_Sym::IPCStableHash;
    }
    case messages::RestrictedCookieManager::kCookiesEnabledFor: {
      return &RestrictedCookieManager::CookiesEnabledFor_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RestrictedCookieManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RestrictedCookieManager>(message.name())) {
      case messages::RestrictedCookieManager::kGetAllForUrl:
            return "Receive network::mojom::RestrictedCookieManager::GetAllForUrl";
      case messages::RestrictedCookieManager::kSetCanonicalCookie:
            return "Receive network::mojom::RestrictedCookieManager::SetCanonicalCookie";
      case messages::RestrictedCookieManager::kAddChangeListener:
            return "Receive network::mojom::RestrictedCookieManager::AddChangeListener";
      case messages::RestrictedCookieManager::kSetCookieFromString:
            return "Receive network::mojom::RestrictedCookieManager::SetCookieFromString";
      case messages::RestrictedCookieManager::kGetCookiesString:
            return "Receive network::mojom::RestrictedCookieManager::GetCookiesString";
      case messages::RestrictedCookieManager::kCookiesEnabledFor:
            return "Receive network::mojom::RestrictedCookieManager::CookiesEnabledFor";
    }
  } else {
    switch (static_cast<messages::RestrictedCookieManager>(message.name())) {
      case messages::RestrictedCookieManager::kGetAllForUrl:
            return "Receive reply network::mojom::RestrictedCookieManager::GetAllForUrl";
      case messages::RestrictedCookieManager::kSetCanonicalCookie:
            return "Receive reply network::mojom::RestrictedCookieManager::SetCanonicalCookie";
      case messages::RestrictedCookieManager::kAddChangeListener:
            return "Receive reply network::mojom::RestrictedCookieManager::AddChangeListener";
      case messages::RestrictedCookieManager::kSetCookieFromString:
            return "Receive reply network::mojom::RestrictedCookieManager::SetCookieFromString";
      case messages::RestrictedCookieManager::kGetCookiesString:
            return "Receive reply network::mojom::RestrictedCookieManager::GetCookiesString";
      case messages::RestrictedCookieManager::kCookiesEnabledFor:
            return "Receive reply network::mojom::RestrictedCookieManager::CookiesEnabledFor";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RestrictedCookieManager::GetAllForUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x60147942;  // IPCStableHash for network::mojom::RestrictedCookieManager::GetAllForUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RestrictedCookieManager::SetCanonicalCookie_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed943bdc;  // IPCStableHash for network::mojom::RestrictedCookieManager::SetCanonicalCookie
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RestrictedCookieManager::AddChangeListener_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x856476cd;  // IPCStableHash for network::mojom::RestrictedCookieManager::AddChangeListener
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RestrictedCookieManager::SetCookieFromString_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xef407824;  // IPCStableHash for network::mojom::RestrictedCookieManager::SetCookieFromString
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RestrictedCookieManager::GetCookiesString_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf4392566;  // IPCStableHash for network::mojom::RestrictedCookieManager::GetCookiesString
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RestrictedCookieManager::CookiesEnabledFor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x697afc5c;  // IPCStableHash for network::mojom::RestrictedCookieManager::CookiesEnabledFor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool RestrictedCookieManager::SetCookieFromString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool get_version_shared_memory, bool is_ad_tagged, bool apply_devtools_overrides, const std::string& cookie, CookiesResponsePtr* out_response) {
  NOTREACHED();
}
bool RestrictedCookieManager::GetCookiesString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool get_version_shared_memory, bool is_ad_tagged, bool apply_devtools_overrides, bool force_disable_third_party_cookies, uint64_t* out_version, ::base::ReadOnlySharedMemoryRegion* out_version_buffer, std::string* out_cookies) {
  NOTREACHED();
}
bool RestrictedCookieManager::CookiesEnabledFor(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool apply_devtools_overrides, bool* out_cookies_enabled) {
  NOTREACHED();
}

class RestrictedCookieManager_GetAllForUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_GetAllForUrl_ForwardToCallback(
      RestrictedCookieManager::GetAllForUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  RestrictedCookieManager_GetAllForUrl_ForwardToCallback(const RestrictedCookieManager_GetAllForUrl_ForwardToCallback&) = delete;
  RestrictedCookieManager_GetAllForUrl_ForwardToCallback& operator=(const RestrictedCookieManager_GetAllForUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RestrictedCookieManager::GetAllForUrlCallback callback_;
};

class RestrictedCookieManager_SetCanonicalCookie_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_SetCanonicalCookie_ForwardToCallback(
      RestrictedCookieManager::SetCanonicalCookieCallback callback
      ) : callback_(std::move(callback)) {
  }

  RestrictedCookieManager_SetCanonicalCookie_ForwardToCallback(const RestrictedCookieManager_SetCanonicalCookie_ForwardToCallback&) = delete;
  RestrictedCookieManager_SetCanonicalCookie_ForwardToCallback& operator=(const RestrictedCookieManager_SetCanonicalCookie_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RestrictedCookieManager::SetCanonicalCookieCallback callback_;
};

class RestrictedCookieManager_AddChangeListener_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_AddChangeListener_ForwardToCallback(
      RestrictedCookieManager::AddChangeListenerCallback callback
      ) : callback_(std::move(callback)) {
  }

  RestrictedCookieManager_AddChangeListener_ForwardToCallback(const RestrictedCookieManager_AddChangeListener_ForwardToCallback&) = delete;
  RestrictedCookieManager_AddChangeListener_ForwardToCallback& operator=(const RestrictedCookieManager_AddChangeListener_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RestrictedCookieManager::AddChangeListenerCallback callback_;
};
class RestrictedCookieManager_SetCookieFromString_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_SetCookieFromString_HandleSyncResponse(
      bool* result, CookiesResponsePtr* out_response)
      : result_(result), out_response_(out_response) {
    DCHECK(!*result_);
  }

  RestrictedCookieManager_SetCookieFromString_HandleSyncResponse(const RestrictedCookieManager_SetCookieFromString_HandleSyncResponse&) = delete;
  RestrictedCookieManager_SetCookieFromString_HandleSyncResponse& operator=(const RestrictedCookieManager_SetCookieFromString_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  CookiesResponsePtr* out_response_;};

class RestrictedCookieManager_SetCookieFromString_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_SetCookieFromString_ForwardToCallback(
      RestrictedCookieManager::SetCookieFromStringCallback callback
      ) : callback_(std::move(callback)) {
  }

  RestrictedCookieManager_SetCookieFromString_ForwardToCallback(const RestrictedCookieManager_SetCookieFromString_ForwardToCallback&) = delete;
  RestrictedCookieManager_SetCookieFromString_ForwardToCallback& operator=(const RestrictedCookieManager_SetCookieFromString_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RestrictedCookieManager::SetCookieFromStringCallback callback_;
};
class RestrictedCookieManager_GetCookiesString_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_GetCookiesString_HandleSyncResponse(
      bool* result, uint64_t* out_version, ::base::ReadOnlySharedMemoryRegion* out_version_buffer, std::string* out_cookies)
      : result_(result), out_version_(out_version), out_version_buffer_(out_version_buffer), out_cookies_(out_cookies) {
    DCHECK(!*result_);
  }

  RestrictedCookieManager_GetCookiesString_HandleSyncResponse(const RestrictedCookieManager_GetCookiesString_HandleSyncResponse&) = delete;
  RestrictedCookieManager_GetCookiesString_HandleSyncResponse& operator=(const RestrictedCookieManager_GetCookiesString_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  uint64_t* out_version_;
  ::base::ReadOnlySharedMemoryRegion* out_version_buffer_;
  std::string* out_cookies_;};

class RestrictedCookieManager_GetCookiesString_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_GetCookiesString_ForwardToCallback(
      RestrictedCookieManager::GetCookiesStringCallback callback
      ) : callback_(std::move(callback)) {
  }

  RestrictedCookieManager_GetCookiesString_ForwardToCallback(const RestrictedCookieManager_GetCookiesString_ForwardToCallback&) = delete;
  RestrictedCookieManager_GetCookiesString_ForwardToCallback& operator=(const RestrictedCookieManager_GetCookiesString_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RestrictedCookieManager::GetCookiesStringCallback callback_;
};
class RestrictedCookieManager_CookiesEnabledFor_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_CookiesEnabledFor_HandleSyncResponse(
      bool* result, bool* out_cookies_enabled)
      : result_(result), out_cookies_enabled_(out_cookies_enabled) {
    DCHECK(!*result_);
  }

  RestrictedCookieManager_CookiesEnabledFor_HandleSyncResponse(const RestrictedCookieManager_CookiesEnabledFor_HandleSyncResponse&) = delete;
  RestrictedCookieManager_CookiesEnabledFor_HandleSyncResponse& operator=(const RestrictedCookieManager_CookiesEnabledFor_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  bool* out_cookies_enabled_;};

class RestrictedCookieManager_CookiesEnabledFor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RestrictedCookieManager_CookiesEnabledFor_ForwardToCallback(
      RestrictedCookieManager::CookiesEnabledForCallback callback
      ) : callback_(std::move(callback)) {
  }

  RestrictedCookieManager_CookiesEnabledFor_ForwardToCallback(const RestrictedCookieManager_CookiesEnabledFor_ForwardToCallback&) = delete;
  RestrictedCookieManager_CookiesEnabledFor_ForwardToCallback& operator=(const RestrictedCookieManager_CookiesEnabledFor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RestrictedCookieManager::CookiesEnabledForCallback callback_;
};

RestrictedCookieManagerProxy::RestrictedCookieManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RestrictedCookieManagerProxy::GetAllForUrl(
    const ::GURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, ::net::StorageAccessApiStatus in_storage_access_api_status, CookieManagerGetOptionsPtr in_options, bool in_is_ad_tagged, bool in_apply_devtools_overrides, bool in_force_disable_third_party_cookies, GetAllForUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::RestrictedCookieManager::GetAllForUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), in_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_frame_origin"), in_top_frame_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_access_api_status"), in_storage_access_api_status,
                        "<value of type ::net::StorageAccessApiStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type CookieManagerGetOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_ad_tagged"), in_is_ad_tagged,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("apply_devtools_overrides"), in_apply_devtools_overrides,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("force_disable_third_party_cookies"), in_force_disable_third_party_cookies,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kGetAllForUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_GetAllForUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in RestrictedCookieManager.GetAllForUrl request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    in_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in RestrictedCookieManager.GetAllForUrl request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_frame_origin)::BaseType> top_frame_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_top_frame_origin,
    top_frame_origin_fragment);

  params->top_frame_origin.Set(
      top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->top_frame_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null top_frame_origin in RestrictedCookieManager.GetAllForUrl request");

  
  mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
    in_storage_access_api_status,
    &params->storage_access_api_status);
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookieManagerGetOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in RestrictedCookieManager.GetAllForUrl request");

  params->is_ad_tagged = in_is_ad_tagged;

  params->apply_devtools_overrides = in_apply_devtools_overrides;

  params->force_disable_third_party_cookies = in_force_disable_third_party_cookies;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("GetAllForUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_GetAllForUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RestrictedCookieManagerProxy::SetCanonicalCookie(
    const ::net::CanonicalCookie& in_cookie, const ::GURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, ::net::StorageAccessApiStatus in_storage_access_api_status, ::net::CookieInclusionStatus in_status, bool in_is_ad_tagged, bool in_apply_devtools_overrides, SetCanonicalCookieCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::RestrictedCookieManager::SetCanonicalCookie", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie,
                        "<value of type const ::net::CanonicalCookie&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), in_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_frame_origin"), in_top_frame_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_access_api_status"), in_storage_access_api_status,
                        "<value of type ::net::StorageAccessApiStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::net::CookieInclusionStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_ad_tagged"), in_is_ad_tagged,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("apply_devtools_overrides"), in_apply_devtools_overrides,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kSetCanonicalCookie), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_SetCanonicalCookie_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookie)::BaseType> cookie_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CanonicalCookieDataView>(
    in_cookie,
    cookie_fragment);

  params->cookie.Set(
      cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookie.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookie in RestrictedCookieManager.SetCanonicalCookie request");
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in RestrictedCookieManager.SetCanonicalCookie request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    in_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in RestrictedCookieManager.SetCanonicalCookie request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_frame_origin)::BaseType> top_frame_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_top_frame_origin,
    top_frame_origin_fragment);

  params->top_frame_origin.Set(
      top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->top_frame_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null top_frame_origin in RestrictedCookieManager.SetCanonicalCookie request");

  
  mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
    in_storage_access_api_status,
    &params->storage_access_api_status);
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookieInclusionStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in RestrictedCookieManager.SetCanonicalCookie request");

  params->is_ad_tagged = in_is_ad_tagged;

  params->apply_devtools_overrides = in_apply_devtools_overrides;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("SetCanonicalCookie");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_SetCanonicalCookie_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RestrictedCookieManagerProxy::AddChangeListener(
    const ::GURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, ::net::StorageAccessApiStatus in_storage_access_api_status, ::mojo::PendingRemote<::network::mojom::CookieChangeListener> in_listener, AddChangeListenerCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::RestrictedCookieManager::AddChangeListener", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), in_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_frame_origin"), in_top_frame_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_access_api_status"), in_storage_access_api_status,
                        "<value of type ::net::StorageAccessApiStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<::network::mojom::CookieChangeListener>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kAddChangeListener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_AddChangeListener_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in RestrictedCookieManager.AddChangeListener request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    in_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in RestrictedCookieManager.AddChangeListener request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_frame_origin)::BaseType> top_frame_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_top_frame_origin,
    top_frame_origin_fragment);

  params->top_frame_origin.Set(
      top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->top_frame_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null top_frame_origin in RestrictedCookieManager.AddChangeListener request");

  
  mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
    in_storage_access_api_status,
    &params->storage_access_api_status);

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieChangeListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in RestrictedCookieManager.AddChangeListener request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("AddChangeListener");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_AddChangeListener_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool RestrictedCookieManagerProxy::SetCookieFromString(
    const ::GURL& param_url, const ::net::SiteForCookies& param_site_for_cookies, const ::url::Origin& param_top_frame_origin, ::net::StorageAccessApiStatus param_storage_access_api_status, bool param_get_version_shared_memory, bool param_is_ad_tagged, bool param_apply_devtools_overrides, const std::string& param_cookie, CookiesResponsePtr* out_param_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call network::mojom::RestrictedCookieManager::SetCookieFromString (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), param_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), param_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_frame_origin"), param_top_frame_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_access_api_status"), param_storage_access_api_status,
                        "<value of type ::net::StorageAccessApiStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("get_version_shared_memory"), param_get_version_shared_memory,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_ad_tagged"), param_is_ad_tagged,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("apply_devtools_overrides"), param_apply_devtools_overrides,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), param_cookie,
                        "<value of type const std::string&>");
   });
#else
  TRACE_EVENT0("mojom", "RestrictedCookieManager::SetCookieFromString");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kSetCookieFromString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_SetCookieFromString_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in RestrictedCookieManager.SetCookieFromString request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    param_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in RestrictedCookieManager.SetCookieFromString request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_frame_origin)::BaseType> top_frame_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    param_top_frame_origin,
    top_frame_origin_fragment);

  params->top_frame_origin.Set(
      top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->top_frame_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null top_frame_origin in RestrictedCookieManager.SetCookieFromString request");

  
  mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
    param_storage_access_api_status,
    &params->storage_access_api_status);

  params->get_version_shared_memory = param_get_version_shared_memory;

  params->is_ad_tagged = param_is_ad_tagged;

  params->apply_devtools_overrides = param_apply_devtools_overrides;
  mojo::internal::MessageFragment<
      typename decltype(params->cookie)::BaseType> cookie_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_cookie,
    cookie_fragment);

  params->cookie.Set(
      cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookie.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookie in RestrictedCookieManager.SetCookieFromString request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("SetCookieFromString");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_SetCookieFromString_HandleSyncResponse(
          &result, out_param_response));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "RestrictedCookieManager::SetCookieFromString", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), out_param_response,
                        "<value of type CookiesResponsePtr>");
   });
#endif
  return result;
}

void RestrictedCookieManagerProxy::SetCookieFromString(
    const ::GURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, ::net::StorageAccessApiStatus in_storage_access_api_status, bool in_get_version_shared_memory, bool in_is_ad_tagged, bool in_apply_devtools_overrides, const std::string& in_cookie, SetCookieFromStringCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::RestrictedCookieManager::SetCookieFromString", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), in_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_frame_origin"), in_top_frame_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_access_api_status"), in_storage_access_api_status,
                        "<value of type ::net::StorageAccessApiStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("get_version_shared_memory"), in_get_version_shared_memory,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_ad_tagged"), in_is_ad_tagged,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("apply_devtools_overrides"), in_apply_devtools_overrides,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookie"), in_cookie,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kSetCookieFromString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_SetCookieFromString_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in RestrictedCookieManager.SetCookieFromString request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    in_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in RestrictedCookieManager.SetCookieFromString request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_frame_origin)::BaseType> top_frame_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_top_frame_origin,
    top_frame_origin_fragment);

  params->top_frame_origin.Set(
      top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->top_frame_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null top_frame_origin in RestrictedCookieManager.SetCookieFromString request");

  
  mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
    in_storage_access_api_status,
    &params->storage_access_api_status);

  params->get_version_shared_memory = in_get_version_shared_memory;

  params->is_ad_tagged = in_is_ad_tagged;

  params->apply_devtools_overrides = in_apply_devtools_overrides;
  mojo::internal::MessageFragment<
      typename decltype(params->cookie)::BaseType> cookie_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_cookie,
    cookie_fragment);

  params->cookie.Set(
      cookie_fragment.is_null() ? nullptr : cookie_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookie.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookie in RestrictedCookieManager.SetCookieFromString request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("SetCookieFromString");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_SetCookieFromString_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool RestrictedCookieManagerProxy::GetCookiesString(
    const ::GURL& param_url, const ::net::SiteForCookies& param_site_for_cookies, const ::url::Origin& param_top_frame_origin, ::net::StorageAccessApiStatus param_storage_access_api_status, bool param_get_version_shared_memory, bool param_is_ad_tagged, bool param_apply_devtools_overrides, bool param_force_disable_third_party_cookies, uint64_t* out_param_version, ::base::ReadOnlySharedMemoryRegion* out_param_version_buffer, std::string* out_param_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call network::mojom::RestrictedCookieManager::GetCookiesString (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), param_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), param_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_frame_origin"), param_top_frame_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_access_api_status"), param_storage_access_api_status,
                        "<value of type ::net::StorageAccessApiStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("get_version_shared_memory"), param_get_version_shared_memory,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_ad_tagged"), param_is_ad_tagged,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("apply_devtools_overrides"), param_apply_devtools_overrides,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("force_disable_third_party_cookies"), param_force_disable_third_party_cookies,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "RestrictedCookieManager::GetCookiesString");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kGetCookiesString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_GetCookiesString_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in RestrictedCookieManager.GetCookiesString request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    param_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in RestrictedCookieManager.GetCookiesString request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_frame_origin)::BaseType> top_frame_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    param_top_frame_origin,
    top_frame_origin_fragment);

  params->top_frame_origin.Set(
      top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->top_frame_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null top_frame_origin in RestrictedCookieManager.GetCookiesString request");

  
  mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
    param_storage_access_api_status,
    &params->storage_access_api_status);

  params->get_version_shared_memory = param_get_version_shared_memory;

  params->is_ad_tagged = param_is_ad_tagged;

  params->apply_devtools_overrides = param_apply_devtools_overrides;

  params->force_disable_third_party_cookies = param_force_disable_third_party_cookies;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("GetCookiesString");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_GetCookiesString_HandleSyncResponse(
          &result, out_param_version, out_param_version_buffer, out_param_cookies));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "RestrictedCookieManager::GetCookiesString", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version"), out_param_version,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version_buffer"), out_param_version_buffer,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies"), out_param_cookies,
                        "<value of type const std::string&>");
   });
#endif
  return result;
}

void RestrictedCookieManagerProxy::GetCookiesString(
    const ::GURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, ::net::StorageAccessApiStatus in_storage_access_api_status, bool in_get_version_shared_memory, bool in_is_ad_tagged, bool in_apply_devtools_overrides, bool in_force_disable_third_party_cookies, GetCookiesStringCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::RestrictedCookieManager::GetCookiesString", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), in_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_frame_origin"), in_top_frame_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_access_api_status"), in_storage_access_api_status,
                        "<value of type ::net::StorageAccessApiStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("get_version_shared_memory"), in_get_version_shared_memory,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_ad_tagged"), in_is_ad_tagged,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("apply_devtools_overrides"), in_apply_devtools_overrides,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("force_disable_third_party_cookies"), in_force_disable_third_party_cookies,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kGetCookiesString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_GetCookiesString_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in RestrictedCookieManager.GetCookiesString request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    in_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in RestrictedCookieManager.GetCookiesString request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_frame_origin)::BaseType> top_frame_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_top_frame_origin,
    top_frame_origin_fragment);

  params->top_frame_origin.Set(
      top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->top_frame_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null top_frame_origin in RestrictedCookieManager.GetCookiesString request");

  
  mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
    in_storage_access_api_status,
    &params->storage_access_api_status);

  params->get_version_shared_memory = in_get_version_shared_memory;

  params->is_ad_tagged = in_is_ad_tagged;

  params->apply_devtools_overrides = in_apply_devtools_overrides;

  params->force_disable_third_party_cookies = in_force_disable_third_party_cookies;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("GetCookiesString");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_GetCookiesString_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool RestrictedCookieManagerProxy::CookiesEnabledFor(
    const ::GURL& param_url, const ::net::SiteForCookies& param_site_for_cookies, const ::url::Origin& param_top_frame_origin, ::net::StorageAccessApiStatus param_storage_access_api_status, bool param_apply_devtools_overrides, bool* out_param_cookies_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call network::mojom::RestrictedCookieManager::CookiesEnabledFor (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), param_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), param_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_frame_origin"), param_top_frame_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_access_api_status"), param_storage_access_api_status,
                        "<value of type ::net::StorageAccessApiStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("apply_devtools_overrides"), param_apply_devtools_overrides,
                        "<value of type bool>");
   });
#else
  TRACE_EVENT0("mojom", "RestrictedCookieManager::CookiesEnabledFor");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kCookiesEnabledFor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_CookiesEnabledFor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    param_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in RestrictedCookieManager.CookiesEnabledFor request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    param_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in RestrictedCookieManager.CookiesEnabledFor request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_frame_origin)::BaseType> top_frame_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    param_top_frame_origin,
    top_frame_origin_fragment);

  params->top_frame_origin.Set(
      top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->top_frame_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null top_frame_origin in RestrictedCookieManager.CookiesEnabledFor request");

  
  mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
    param_storage_access_api_status,
    &params->storage_access_api_status);

  params->apply_devtools_overrides = param_apply_devtools_overrides;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("CookiesEnabledFor");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_CookiesEnabledFor_HandleSyncResponse(
          &result, out_param_cookies_enabled));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "RestrictedCookieManager::CookiesEnabledFor", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies_enabled"), out_param_cookies_enabled,
                        "<value of type bool>");
   });
#endif
  return result;
}

void RestrictedCookieManagerProxy::CookiesEnabledFor(
    const ::GURL& in_url, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, ::net::StorageAccessApiStatus in_storage_access_api_status, bool in_apply_devtools_overrides, CookiesEnabledForCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::RestrictedCookieManager::CookiesEnabledFor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), in_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("top_frame_origin"), in_top_frame_origin,
                        "<value of type const ::url::Origin&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_access_api_status"), in_storage_access_api_status,
                        "<value of type ::net::StorageAccessApiStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("apply_devtools_overrides"), in_apply_devtools_overrides,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kCookiesEnabledFor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_CookiesEnabledFor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in RestrictedCookieManager.CookiesEnabledFor request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    in_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in RestrictedCookieManager.CookiesEnabledFor request");
  mojo::internal::MessageFragment<
      typename decltype(params->top_frame_origin)::BaseType> top_frame_origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_top_frame_origin,
    top_frame_origin_fragment);

  params->top_frame_origin.Set(
      top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->top_frame_origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null top_frame_origin in RestrictedCookieManager.CookiesEnabledFor request");

  
  mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
    in_storage_access_api_status,
    &params->storage_access_api_status);

  params->apply_devtools_overrides = in_apply_devtools_overrides;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("CookiesEnabledFor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RestrictedCookieManager_CookiesEnabledFor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class RestrictedCookieManager_GetAllForUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RestrictedCookieManager::GetAllForUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RestrictedCookieManager_GetAllForUrl_ProxyToResponder> proxy(
        new RestrictedCookieManager_GetAllForUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RestrictedCookieManager_GetAllForUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedCookieManager_GetAllForUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RestrictedCookieManager_GetAllForUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RestrictedCookieManager::GetAllForUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::net::CookieWithAccessResult>& in_cookies);
};

bool RestrictedCookieManager_GetAllForUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_GetAllForUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedCookieManager_GetAllForUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RestrictedCookieManager.0
  bool success = true;
  std::vector<::net::CookieWithAccessResult> p_cookies{};
  RestrictedCookieManager_GetAllForUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_cookies));
  }
  return true;
}

void RestrictedCookieManager_GetAllForUrl_ProxyToResponder::Run(
    const std::vector<::net::CookieWithAccessResult>& in_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::RestrictedCookieManager::GetAllForUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies"), in_cookies,
                        "<value of type const std::vector<::net::CookieWithAccessResult>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kGetAllForUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_GetAllForUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->cookies)::BaseType>
      cookies_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
    in_cookies,
    cookies_fragment,
    &cookies_validate_params);

  params->cookies.Set(
      cookies_fragment.is_null() ? nullptr : cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookies in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("GetAllForUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RestrictedCookieManager::SetCanonicalCookieCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder> proxy(
        new RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RestrictedCookieManager::SetCanonicalCookieCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool RestrictedCookieManager_SetCanonicalCookie_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RestrictedCookieManager.1
  bool success = true;
  bool p_success{};
  RestrictedCookieManager_SetCanonicalCookie_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::RestrictedCookieManager::SetCanonicalCookie", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kSetCanonicalCookie), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("SetCanonicalCookie");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class RestrictedCookieManager_AddChangeListener_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RestrictedCookieManager::AddChangeListenerCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RestrictedCookieManager_AddChangeListener_ProxyToResponder> proxy(
        new RestrictedCookieManager_AddChangeListener_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RestrictedCookieManager_AddChangeListener_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedCookieManager_AddChangeListener_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RestrictedCookieManager_AddChangeListener_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RestrictedCookieManager::AddChangeListenerCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool RestrictedCookieManager_AddChangeListener_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_AddChangeListener_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedCookieManager_AddChangeListener_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RestrictedCookieManager.2
  bool success = true;
  RestrictedCookieManager_AddChangeListener_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void RestrictedCookieManager_AddChangeListener_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::RestrictedCookieManager::AddChangeListener");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kAddChangeListener), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_AddChangeListener_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("AddChangeListener");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class RestrictedCookieManager_SetCookieFromString_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RestrictedCookieManager::SetCookieFromStringCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RestrictedCookieManager_SetCookieFromString_ProxyToResponder> proxy(
        new RestrictedCookieManager_SetCookieFromString_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RestrictedCookieManager_SetCookieFromString_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedCookieManager_SetCookieFromString_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RestrictedCookieManager_SetCookieFromString_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RestrictedCookieManager::SetCookieFromStringCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CookiesResponsePtr in_response);
};

bool RestrictedCookieManager_SetCookieFromString_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RestrictedCookieManager.3
  bool success = true;
  CookiesResponsePtr p_response{};
  RestrictedCookieManager_SetCookieFromString_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_response));
  }
  return true;
}

void RestrictedCookieManager_SetCookieFromString_ProxyToResponder::Run(
    CookiesResponsePtr in_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::RestrictedCookieManager::SetCookieFromString", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("response"), in_response,
                        "<value of type CookiesResponsePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kSetCookieFromString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->response)::BaseType> response_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CookiesResponseDataView>(
    in_response,
    response_fragment);

  params->response.Set(
      response_fragment.is_null() ? nullptr : response_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("SetCookieFromString");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RestrictedCookieManager_SetCookieFromString_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data* params =
      reinterpret_cast<internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for RestrictedCookieManager.3
  bool success = true;
  CookiesResponsePtr p_response{};
  RestrictedCookieManager_SetCookieFromString_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResponse(&p_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 3, true);
    return false;
  }
  *out_response_ = std::move(p_response);
  *result_ = true;
  return true;
}
class RestrictedCookieManager_GetCookiesString_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RestrictedCookieManager::GetCookiesStringCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RestrictedCookieManager_GetCookiesString_ProxyToResponder> proxy(
        new RestrictedCookieManager_GetCookiesString_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RestrictedCookieManager_GetCookiesString_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedCookieManager_GetCookiesString_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RestrictedCookieManager_GetCookiesString_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RestrictedCookieManager::GetCookiesStringCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      uint64_t in_version, ::base::ReadOnlySharedMemoryRegion in_version_buffer, const std::string& in_cookies);
};

bool RestrictedCookieManager_GetCookiesString_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RestrictedCookieManager.4
  bool success = true;
  uint64_t p_version{};
  ::base::ReadOnlySharedMemoryRegion p_version_buffer{};
  std::string p_cookies{};
  RestrictedCookieManager_GetCookiesString_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_version = input_data_view.version();
  if (success && !input_data_view.ReadVersionBuffer(&p_version_buffer))
    success = false;
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_version), 
std::move(p_version_buffer), 
std::move(p_cookies));
  }
  return true;
}

void RestrictedCookieManager_GetCookiesString_ProxyToResponder::Run(
    uint64_t in_version, ::base::ReadOnlySharedMemoryRegion in_version_buffer, const std::string& in_cookies) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::RestrictedCookieManager::GetCookiesString", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version"), in_version,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("version_buffer"), in_version_buffer,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies"), in_cookies,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kGetCookiesString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->version = in_version;
  mojo::internal::MessageFragment<
      typename decltype(params->version_buffer)::BaseType> version_buffer_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_version_buffer,
    version_buffer_fragment);

  params->version_buffer.Set(
      version_buffer_fragment.is_null() ? nullptr : version_buffer_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->cookies)::BaseType> cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_cookies,
    cookies_fragment);

  params->cookies.Set(
      cookies_fragment.is_null() ? nullptr : cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null cookies in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("GetCookiesString");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RestrictedCookieManager_GetCookiesString_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data* params =
      reinterpret_cast<internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for RestrictedCookieManager.4
  bool success = true;
  uint64_t p_version{};
  ::base::ReadOnlySharedMemoryRegion p_version_buffer{};
  std::string p_cookies{};
  RestrictedCookieManager_GetCookiesString_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_version = input_data_view.version();
  if (success && !input_data_view.ReadVersionBuffer(&p_version_buffer))
    success = false;
  if (success && !input_data_view.ReadCookies(&p_cookies))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 4, true);
    return false;
  }
  *out_version_ = std::move(p_version);
  *out_version_buffer_ = std::move(p_version_buffer);
  *out_cookies_ = std::move(p_cookies);
  *result_ = true;
  return true;
}
class RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RestrictedCookieManager::CookiesEnabledForCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder> proxy(
        new RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RestrictedCookieManager::CookiesEnabledForCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_cookies_enabled);
};

bool RestrictedCookieManager_CookiesEnabledFor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RestrictedCookieManager.5
  bool success = true;
  bool p_cookies_enabled{};
  RestrictedCookieManager_CookiesEnabledFor_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_cookies_enabled = input_data_view.cookies_enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_cookies_enabled));
  }
  return true;
}

void RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder::Run(
    bool in_cookies_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::RestrictedCookieManager::CookiesEnabledFor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("cookies_enabled"), in_cookies_enabled,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RestrictedCookieManager::kCookiesEnabledFor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->cookies_enabled = in_cookies_enabled;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RestrictedCookieManager::Name_);
  message.set_method_name("CookiesEnabledFor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool RestrictedCookieManager_CookiesEnabledFor_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data* params =
      reinterpret_cast<internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for RestrictedCookieManager.5
  bool success = true;
  bool p_cookies_enabled{};
  RestrictedCookieManager_CookiesEnabledFor_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_cookies_enabled = input_data_view.cookies_enabled();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RestrictedCookieManager::Name_, 5, true);
    return false;
  }
  *out_cookies_enabled_ = std::move(p_cookies_enabled);
  *result_ = true;
  return true;
}

// static
bool RestrictedCookieManagerStubDispatch::Accept(
    RestrictedCookieManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RestrictedCookieManager>(message->header()->name)) {
    case messages::RestrictedCookieManager::kGetAllForUrl: {
      break;
    }
    case messages::RestrictedCookieManager::kSetCanonicalCookie: {
      break;
    }
    case messages::RestrictedCookieManager::kAddChangeListener: {
      break;
    }
    case messages::RestrictedCookieManager::kSetCookieFromString: {
      break;
    }
    case messages::RestrictedCookieManager::kGetCookiesString: {
      break;
    }
    case messages::RestrictedCookieManager::kCookiesEnabledFor: {
      break;
    }
  }
  return false;
}

// static
bool RestrictedCookieManagerStubDispatch::AcceptWithResponder(
    RestrictedCookieManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RestrictedCookieManager>(message->header()->name)) {
    case messages::RestrictedCookieManager::kGetAllForUrl: {
      internal::RestrictedCookieManager_GetAllForUrl_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedCookieManager_GetAllForUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RestrictedCookieManager.0
      bool success = true;
      ::GURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      ::net::StorageAccessApiStatus p_storage_access_api_status{};
      CookieManagerGetOptionsPtr p_options{};
      bool p_is_ad_tagged{};
      bool p_apply_devtools_overrides{};
      bool p_force_disable_third_party_cookies{};
      RestrictedCookieManager_GetAllForUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (success && !input_data_view.ReadStorageAccessApiStatus(&p_storage_access_api_status))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success)
        p_is_ad_tagged = input_data_view.is_ad_tagged();
      if (success)
        p_apply_devtools_overrides = input_data_view.apply_devtools_overrides();
      if (success)
        p_force_disable_third_party_cookies = input_data_view.force_disable_third_party_cookies();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedCookieManager::Name_, 0, false);
        return false;
      }
      auto callback =
          RestrictedCookieManager_GetAllForUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAllForUrl(        
        std::move(p_url), 
        std::move(p_site_for_cookies), 
        std::move(p_top_frame_origin), 
        std::move(p_storage_access_api_status), 
        std::move(p_options), 
        std::move(p_is_ad_tagged), 
        std::move(p_apply_devtools_overrides), 
        std::move(p_force_disable_third_party_cookies), std::move(callback));
      return true;
    }
    case messages::RestrictedCookieManager::kSetCanonicalCookie: {
      internal::RestrictedCookieManager_SetCanonicalCookie_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedCookieManager_SetCanonicalCookie_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RestrictedCookieManager.1
      bool success = true;
      ::net::CanonicalCookie p_cookie{};
      ::GURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      ::net::StorageAccessApiStatus p_storage_access_api_status{};
      ::net::CookieInclusionStatus p_status{};
      bool p_is_ad_tagged{};
      bool p_apply_devtools_overrides{};
      RestrictedCookieManager_SetCanonicalCookie_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCookie(&p_cookie))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (success && !input_data_view.ReadStorageAccessApiStatus(&p_storage_access_api_status))
        success = false;
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (success)
        p_is_ad_tagged = input_data_view.is_ad_tagged();
      if (success)
        p_apply_devtools_overrides = input_data_view.apply_devtools_overrides();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedCookieManager::Name_, 1, false);
        return false;
      }
      auto callback =
          RestrictedCookieManager_SetCanonicalCookie_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCanonicalCookie(        
        std::move(p_cookie), 
        std::move(p_url), 
        std::move(p_site_for_cookies), 
        std::move(p_top_frame_origin), 
        std::move(p_storage_access_api_status), 
        std::move(p_status), 
        std::move(p_is_ad_tagged), 
        std::move(p_apply_devtools_overrides), std::move(callback));
      return true;
    }
    case messages::RestrictedCookieManager::kAddChangeListener: {
      internal::RestrictedCookieManager_AddChangeListener_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedCookieManager_AddChangeListener_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RestrictedCookieManager.2
      bool success = true;
      ::GURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      ::net::StorageAccessApiStatus p_storage_access_api_status{};
      ::mojo::PendingRemote<::network::mojom::CookieChangeListener> p_listener{};
      RestrictedCookieManager_AddChangeListener_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (success && !input_data_view.ReadStorageAccessApiStatus(&p_storage_access_api_status))
        success = false;
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedCookieManager::Name_, 2, false);
        return false;
      }
      auto callback =
          RestrictedCookieManager_AddChangeListener_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddChangeListener(        
        std::move(p_url), 
        std::move(p_site_for_cookies), 
        std::move(p_top_frame_origin), 
        std::move(p_storage_access_api_status), 
        std::move(p_listener), std::move(callback));
      return true;
    }
    case messages::RestrictedCookieManager::kSetCookieFromString: {
      internal::RestrictedCookieManager_SetCookieFromString_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedCookieManager_SetCookieFromString_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RestrictedCookieManager.3
      bool success = true;
      ::GURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      ::net::StorageAccessApiStatus p_storage_access_api_status{};
      bool p_get_version_shared_memory{};
      bool p_is_ad_tagged{};
      bool p_apply_devtools_overrides{};
      std::string p_cookie{};
      RestrictedCookieManager_SetCookieFromString_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (success && !input_data_view.ReadStorageAccessApiStatus(&p_storage_access_api_status))
        success = false;
      if (success)
        p_get_version_shared_memory = input_data_view.get_version_shared_memory();
      if (success)
        p_is_ad_tagged = input_data_view.is_ad_tagged();
      if (success)
        p_apply_devtools_overrides = input_data_view.apply_devtools_overrides();
      if (success && !input_data_view.ReadCookie(&p_cookie))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedCookieManager::Name_, 3, false);
        return false;
      }
      auto callback =
          RestrictedCookieManager_SetCookieFromString_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCookieFromString(        
        std::move(p_url), 
        std::move(p_site_for_cookies), 
        std::move(p_top_frame_origin), 
        std::move(p_storage_access_api_status), 
        std::move(p_get_version_shared_memory), 
        std::move(p_is_ad_tagged), 
        std::move(p_apply_devtools_overrides), 
        std::move(p_cookie), std::move(callback));
      return true;
    }
    case messages::RestrictedCookieManager::kGetCookiesString: {
      internal::RestrictedCookieManager_GetCookiesString_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedCookieManager_GetCookiesString_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RestrictedCookieManager.4
      bool success = true;
      ::GURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      ::net::StorageAccessApiStatus p_storage_access_api_status{};
      bool p_get_version_shared_memory{};
      bool p_is_ad_tagged{};
      bool p_apply_devtools_overrides{};
      bool p_force_disable_third_party_cookies{};
      RestrictedCookieManager_GetCookiesString_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (success && !input_data_view.ReadStorageAccessApiStatus(&p_storage_access_api_status))
        success = false;
      if (success)
        p_get_version_shared_memory = input_data_view.get_version_shared_memory();
      if (success)
        p_is_ad_tagged = input_data_view.is_ad_tagged();
      if (success)
        p_apply_devtools_overrides = input_data_view.apply_devtools_overrides();
      if (success)
        p_force_disable_third_party_cookies = input_data_view.force_disable_third_party_cookies();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedCookieManager::Name_, 4, false);
        return false;
      }
      auto callback =
          RestrictedCookieManager_GetCookiesString_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCookiesString(        
        std::move(p_url), 
        std::move(p_site_for_cookies), 
        std::move(p_top_frame_origin), 
        std::move(p_storage_access_api_status), 
        std::move(p_get_version_shared_memory), 
        std::move(p_is_ad_tagged), 
        std::move(p_apply_devtools_overrides), 
        std::move(p_force_disable_third_party_cookies), std::move(callback));
      return true;
    }
    case messages::RestrictedCookieManager::kCookiesEnabledFor: {
      internal::RestrictedCookieManager_CookiesEnabledFor_Params_Data* params =
          reinterpret_cast<
              internal::RestrictedCookieManager_CookiesEnabledFor_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RestrictedCookieManager.5
      bool success = true;
      ::GURL p_url{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      ::net::StorageAccessApiStatus p_storage_access_api_status{};
      bool p_apply_devtools_overrides{};
      RestrictedCookieManager_CookiesEnabledFor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (success && !input_data_view.ReadStorageAccessApiStatus(&p_storage_access_api_status))
        success = false;
      if (success)
        p_apply_devtools_overrides = input_data_view.apply_devtools_overrides();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RestrictedCookieManager::Name_, 5, false);
        return false;
      }
      auto callback =
          RestrictedCookieManager_CookiesEnabledFor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CookiesEnabledFor(        
        std::move(p_url), 
        std::move(p_site_for_cookies), 
        std::move(p_top_frame_origin), 
        std::move(p_storage_access_api_status), 
        std::move(p_apply_devtools_overrides), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRestrictedCookieManagerValidationInfo[] = {
    { &internal::RestrictedCookieManager_GetAllForUrl_Params_Data::Validate,
     &internal::RestrictedCookieManager_GetAllForUrl_ResponseParams_Data::Validate},
    { &internal::RestrictedCookieManager_SetCanonicalCookie_Params_Data::Validate,
     &internal::RestrictedCookieManager_SetCanonicalCookie_ResponseParams_Data::Validate},
    { &internal::RestrictedCookieManager_AddChangeListener_Params_Data::Validate,
     &internal::RestrictedCookieManager_AddChangeListener_ResponseParams_Data::Validate},
    { &internal::RestrictedCookieManager_SetCookieFromString_Params_Data::Validate,
     &internal::RestrictedCookieManager_SetCookieFromString_ResponseParams_Data::Validate},
    { &internal::RestrictedCookieManager_GetCookiesString_Params_Data::Validate,
     &internal::RestrictedCookieManager_GetCookiesString_ResponseParams_Data::Validate},
    { &internal::RestrictedCookieManager_CookiesEnabledFor_Params_Data::Validate,
     &internal::RestrictedCookieManager_CookiesEnabledFor_ResponseParams_Data::Validate},
};

bool RestrictedCookieManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::RestrictedCookieManager::Name_,
    kRestrictedCookieManagerValidationInfo);
}

bool RestrictedCookieManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::network::mojom::RestrictedCookieManager::Name_,
    kRestrictedCookieManagerValidationInfo);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::CookieManagerGetOptions::DataView, ::network::mojom::CookieManagerGetOptionsPtr>::Read(
    ::network::mojom::CookieManagerGetOptions::DataView input,
    ::network::mojom::CookieManagerGetOptionsPtr* output) {
  bool success = true;
  ::network::mojom::CookieManagerGetOptionsPtr result(::network::mojom::CookieManagerGetOptions::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadMatchType(&result->match_type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::CookiesResponse::DataView, ::network::mojom::CookiesResponsePtr>::Read(
    ::network::mojom::CookiesResponse::DataView input,
    ::network::mojom::CookiesResponsePtr* output) {
  bool success = true;
  ::network::mojom::CookiesResponsePtr result(::network::mojom::CookiesResponse::New());
  
      if (success)
        result->version = input.version();
      if (success && !input.ReadVersionBuffer(&result->version_buffer))
        success = false;
      if (success && !input.ReadCookies(&result->cookies))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void RestrictedCookieManagerInterceptorForTesting::GetAllForUrl(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, CookieManagerGetOptionsPtr options, bool is_ad_tagged, bool apply_devtools_overrides, bool force_disable_third_party_cookies, GetAllForUrlCallback callback) {
  GetForwardingInterface()->GetAllForUrl(
    std::move(url)
    , 
    std::move(site_for_cookies)
    , 
    std::move(top_frame_origin)
    , 
    std::move(storage_access_api_status)
    , 
    std::move(options)
    , 
    std::move(is_ad_tagged)
    , 
    std::move(apply_devtools_overrides)
    , 
    std::move(force_disable_third_party_cookies)
    , std::move(callback));
}
void RestrictedCookieManagerInterceptorForTesting::SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, ::net::CookieInclusionStatus status, bool is_ad_tagged, bool apply_devtools_overrides, SetCanonicalCookieCallback callback) {
  GetForwardingInterface()->SetCanonicalCookie(
    std::move(cookie)
    , 
    std::move(url)
    , 
    std::move(site_for_cookies)
    , 
    std::move(top_frame_origin)
    , 
    std::move(storage_access_api_status)
    , 
    std::move(status)
    , 
    std::move(is_ad_tagged)
    , 
    std::move(apply_devtools_overrides)
    , std::move(callback));
}
void RestrictedCookieManagerInterceptorForTesting::AddChangeListener(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, ::mojo::PendingRemote<::network::mojom::CookieChangeListener> listener, AddChangeListenerCallback callback) {
  GetForwardingInterface()->AddChangeListener(
    std::move(url)
    , 
    std::move(site_for_cookies)
    , 
    std::move(top_frame_origin)
    , 
    std::move(storage_access_api_status)
    , 
    std::move(listener)
    , std::move(callback));
}
void RestrictedCookieManagerInterceptorForTesting::SetCookieFromString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool get_version_shared_memory, bool is_ad_tagged, bool apply_devtools_overrides, const std::string& cookie, SetCookieFromStringCallback callback) {
  GetForwardingInterface()->SetCookieFromString(
    std::move(url)
    , 
    std::move(site_for_cookies)
    , 
    std::move(top_frame_origin)
    , 
    std::move(storage_access_api_status)
    , 
    std::move(get_version_shared_memory)
    , 
    std::move(is_ad_tagged)
    , 
    std::move(apply_devtools_overrides)
    , 
    std::move(cookie)
    , std::move(callback));
}
void RestrictedCookieManagerInterceptorForTesting::GetCookiesString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool get_version_shared_memory, bool is_ad_tagged, bool apply_devtools_overrides, bool force_disable_third_party_cookies, GetCookiesStringCallback callback) {
  GetForwardingInterface()->GetCookiesString(
    std::move(url)
    , 
    std::move(site_for_cookies)
    , 
    std::move(top_frame_origin)
    , 
    std::move(storage_access_api_status)
    , 
    std::move(get_version_shared_memory)
    , 
    std::move(is_ad_tagged)
    , 
    std::move(apply_devtools_overrides)
    , 
    std::move(force_disable_third_party_cookies)
    , std::move(callback));
}
void RestrictedCookieManagerInterceptorForTesting::CookiesEnabledFor(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool apply_devtools_overrides, CookiesEnabledForCallback callback) {
  GetForwardingInterface()->CookiesEnabledFor(
    std::move(url)
    , 
    std::move(site_for_cookies)
    , 
    std::move(top_frame_origin)
    , 
    std::move(storage_access_api_status)
    , 
    std::move(apply_devtools_overrides)
    , std::move(callback));
}
RestrictedCookieManagerAsyncWaiter::RestrictedCookieManagerAsyncWaiter(
    RestrictedCookieManager* proxy) : proxy_(proxy) {}

RestrictedCookieManagerAsyncWaiter::~RestrictedCookieManagerAsyncWaiter() = default;


void RestrictedCookieManagerAsyncWaiter::GetAllForUrl(
    const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, CookieManagerGetOptionsPtr options, bool is_ad_tagged, bool apply_devtools_overrides, bool force_disable_third_party_cookies, std::vector<::net::CookieWithAccessResult>* out_cookies) {
  base::RunLoop loop;
  proxy_->GetAllForUrl(
      std::move(url),
      std::move(site_for_cookies),
      std::move(top_frame_origin),
      std::move(storage_access_api_status),
      std::move(options),
      std::move(is_ad_tagged),
      std::move(apply_devtools_overrides),
      std::move(force_disable_third_party_cookies),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<::net::CookieWithAccessResult>* out_cookies
,
             const std::vector<::net::CookieWithAccessResult>& cookies) {*out_cookies = std::move(cookies);
            loop->Quit();
          },
          &loop,
          out_cookies));
  loop.Run();
}

std::vector<::net::CookieWithAccessResult> RestrictedCookieManagerAsyncWaiter::GetAllForUrl(
    const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, CookieManagerGetOptionsPtr options, bool is_ad_tagged, bool apply_devtools_overrides, bool force_disable_third_party_cookies) {
  std::vector<::net::CookieWithAccessResult> async_wait_result;
  GetAllForUrl(std::move(url),std::move(site_for_cookies),std::move(top_frame_origin),std::move(storage_access_api_status),std::move(options),std::move(is_ad_tagged),std::move(apply_devtools_overrides),std::move(force_disable_third_party_cookies),&async_wait_result);
  return async_wait_result;
}

void RestrictedCookieManagerAsyncWaiter::SetCanonicalCookie(
    const ::net::CanonicalCookie& cookie, const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, ::net::CookieInclusionStatus status, bool is_ad_tagged, bool apply_devtools_overrides, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetCanonicalCookie(
      std::move(cookie),
      std::move(url),
      std::move(site_for_cookies),
      std::move(top_frame_origin),
      std::move(storage_access_api_status),
      std::move(status),
      std::move(is_ad_tagged),
      std::move(apply_devtools_overrides),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool RestrictedCookieManagerAsyncWaiter::SetCanonicalCookie(
    const ::net::CanonicalCookie& cookie, const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, ::net::CookieInclusionStatus status, bool is_ad_tagged, bool apply_devtools_overrides) {
  bool async_wait_result;
  SetCanonicalCookie(std::move(cookie),std::move(url),std::move(site_for_cookies),std::move(top_frame_origin),std::move(storage_access_api_status),std::move(status),std::move(is_ad_tagged),std::move(apply_devtools_overrides),&async_wait_result);
  return async_wait_result;
}

void RestrictedCookieManagerAsyncWaiter::AddChangeListener(
    const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, ::mojo::PendingRemote<::network::mojom::CookieChangeListener> listener) {
  base::RunLoop loop;
  proxy_->AddChangeListener(
      std::move(url),
      std::move(site_for_cookies),
      std::move(top_frame_origin),
      std::move(storage_access_api_status),
      std::move(listener),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void RestrictedCookieManagerAsyncWaiter::SetCookieFromString(
    const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool get_version_shared_memory, bool is_ad_tagged, bool apply_devtools_overrides, const std::string& cookie, CookiesResponsePtr* out_response) {
  base::RunLoop loop;
  proxy_->SetCookieFromString(
      std::move(url),
      std::move(site_for_cookies),
      std::move(top_frame_origin),
      std::move(storage_access_api_status),
      std::move(get_version_shared_memory),
      std::move(is_ad_tagged),
      std::move(apply_devtools_overrides),
      std::move(cookie),
      base::BindOnce(
          [](base::RunLoop* loop,
             CookiesResponsePtr* out_response
,
             CookiesResponsePtr response) {*out_response = std::move(response);
            loop->Quit();
          },
          &loop,
          out_response));
  loop.Run();
}

CookiesResponsePtr RestrictedCookieManagerAsyncWaiter::SetCookieFromString(
    const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool get_version_shared_memory, bool is_ad_tagged, bool apply_devtools_overrides, const std::string& cookie) {
  CookiesResponsePtr async_wait_result;
  SetCookieFromString(std::move(url),std::move(site_for_cookies),std::move(top_frame_origin),std::move(storage_access_api_status),std::move(get_version_shared_memory),std::move(is_ad_tagged),std::move(apply_devtools_overrides),std::move(cookie),&async_wait_result);
  return async_wait_result;
}

void RestrictedCookieManagerAsyncWaiter::GetCookiesString(
    const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool get_version_shared_memory, bool is_ad_tagged, bool apply_devtools_overrides, bool force_disable_third_party_cookies, uint64_t* out_version, ::base::ReadOnlySharedMemoryRegion* out_version_buffer, std::string* out_cookies) {
  base::RunLoop loop;
  proxy_->GetCookiesString(
      std::move(url),
      std::move(site_for_cookies),
      std::move(top_frame_origin),
      std::move(storage_access_api_status),
      std::move(get_version_shared_memory),
      std::move(is_ad_tagged),
      std::move(apply_devtools_overrides),
      std::move(force_disable_third_party_cookies),
      base::BindOnce(
          [](base::RunLoop* loop,
             uint64_t* out_version
,
             ::base::ReadOnlySharedMemoryRegion* out_version_buffer
,
             std::string* out_cookies
,
             uint64_t version,
             ::base::ReadOnlySharedMemoryRegion version_buffer,
             const std::string& cookies) {*out_version = std::move(version);*out_version_buffer = std::move(version_buffer);*out_cookies = std::move(cookies);
            loop->Quit();
          },
          &loop,
          out_version,
          out_version_buffer,
          out_cookies));
  loop.Run();
}



void RestrictedCookieManagerAsyncWaiter::CookiesEnabledFor(
    const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool apply_devtools_overrides, bool* out_cookies_enabled) {
  base::RunLoop loop;
  proxy_->CookiesEnabledFor(
      std::move(url),
      std::move(site_for_cookies),
      std::move(top_frame_origin),
      std::move(storage_access_api_status),
      std::move(apply_devtools_overrides),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_cookies_enabled
,
             bool cookies_enabled) {*out_cookies_enabled = std::move(cookies_enabled);
            loop->Quit();
          },
          &loop,
          out_cookies_enabled));
  loop.Run();
}

bool RestrictedCookieManagerAsyncWaiter::CookiesEnabledFor(
    const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::net::StorageAccessApiStatus storage_access_api_status, bool apply_devtools_overrides) {
  bool async_wait_result;
  CookiesEnabledFor(std::move(url),std::move(site_for_cookies),std::move(top_frame_origin),std::move(storage_access_api_status),std::move(apply_devtools_overrides),&async_wait_result);
  return async_wait_result;
}






}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif