// services/network/public/mojom/reporting_service.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/reporting_service.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/network_anonymization_key.mojom-shared.h"

#include "services/network/public/mojom/reporting_service.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::ReportingApiReportStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ReportingApiReportDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ReportingApiReportDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ReportingApiReport_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::id(input)) in_id = Traits::id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->id)::BaseType> id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_id,
        id_fragment);

      fragment->id.Set(
          id_fragment.is_null() ? nullptr : id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in ReportingApiReport struct");

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ReportingApiReport struct");

      decltype(Traits::group(input)) in_group = Traits::group(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->group)::BaseType> group_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_group,
        group_fragment);

      fragment->group.Set(
          group_fragment.is_null() ? nullptr : group_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->group.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null group in ReportingApiReport struct");

      decltype(Traits::type(input)) in_type = Traits::type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->type)::BaseType> type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_type,
        type_fragment);

      fragment->type.Set(
          type_fragment.is_null() ? nullptr : type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null type in ReportingApiReport struct");

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in ReportingApiReport struct");

      fragment->depth = Traits::depth(input);

      fragment->attempts = Traits::attempts(input);

      decltype(Traits::body(input)) in_body = Traits::body(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->body)::BaseType> body_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView, send_validation>(
        in_body,
        body_fragment);

      fragment->body.Set(
          body_fragment.is_null() ? nullptr : body_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->body.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null body in ReportingApiReport struct");

      
      mojo::internal::Serialize<::network::mojom::ReportingApiReportStatus>(
        Traits::status(input),
        &fragment->status);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ReportingApiEndpointDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ReportingApiEndpointDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ReportingApiEndpoint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in ReportingApiEndpoint struct");

      fragment->attempted_uploads = Traits::attempted_uploads(input);

      fragment->successful_uploads = Traits::successful_uploads(input);

      fragment->attempted_reports = Traits::attempted_reports(input);

      fragment->successful_reports = Traits::successful_reports(input);

      fragment->priority = Traits::priority(input);

      fragment->weight = Traits::weight(input);

      decltype(Traits::origin(input)) in_origin = Traits::origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->origin)::BaseType> origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_origin,
        origin_fragment);

      fragment->origin.Set(
          origin_fragment.is_null() ? nullptr : origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null origin in ReportingApiEndpoint struct");

      decltype(Traits::group_name(input)) in_group_name = Traits::group_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->group_name)::BaseType> group_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_group_name,
        group_name_fragment);

      fragment->group_name.Set(
          group_name_fragment.is_null() ? nullptr : group_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->group_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null group_name in ReportingApiEndpoint struct");

      decltype(Traits::network_anonymization_key(input)) in_network_anonymization_key = Traits::network_anonymization_key(input);
      mojo::internal::MessageFragment<decltype(fragment->network_anonymization_key)>
          network_anonymization_key_fragment(fragment.message());
      network_anonymization_key_fragment.Claim(&fragment->network_anonymization_key);
      
      mojo::internal::Serialize<::network::mojom::NetworkAnonymizationKeyDataView, send_validation>(
        in_network_anonymization_key,
        network_anonymization_key_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->network_anonymization_key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null network_anonymization_key in ReportingApiEndpoint struct");

      decltype(Traits::reporting_source(input)) in_reporting_source = Traits::reporting_source(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->reporting_source)::BaseType> reporting_source_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_reporting_source,
        reporting_source_fragment);

      fragment->reporting_source.Set(
          reporting_source_fragment.is_null() ? nullptr : reporting_source_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_REPORTING_SERVICE_MOJOM_SEND_VALIDATION_H_