// services/network/public/mojom/proxy_resolving_socket.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_RESOLVING_SOCKET_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_RESOLVING_SOCKET_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/proxy_resolving_socket.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/proxy_resolving_socket.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/proxy_resolving_socket.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom.h"
#include "services/network/public/mojom/network_anonymization_key.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/ssl_config.mojom-forward.h"
#include "services/network/public/mojom/tcp_socket.mojom-forward.h"
#include "services/network/public/mojom/tls_socket.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace network::mojom {

class ProxyResolvingSocketProxy;

template <typename ImplRefTraits>
class ProxyResolvingSocketStub;

class ProxyResolvingSocketRequestValidator;
class ProxyResolvingSocketResponseValidator;


class ProxyResolvingSocket
    : public ProxyResolvingSocketInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.ProxyResolvingSocket";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProxyResolvingSocketInterfaceBase;
  using Proxy_ = ProxyResolvingSocketProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProxyResolvingSocketStub<ImplRefTraits>;

  using RequestValidator_ = ProxyResolvingSocketRequestValidator;
  using ResponseValidator_ = ProxyResolvingSocketResponseValidator;
  enum MethodMinVersions : uint32_t {
    kUpgradeToTLSMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpgradeToTLS_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProxyResolvingSocket() = default;

  using UpgradeToTLSCallback = base::OnceCallback<void(int32_t, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;
  using UpgradeToTLSMojoCallback = base::OnceCallback<void(int32_t, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;

  virtual void UpgradeToTLS(const ::net::HostPortPair& host_port_pair, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TLSClientSocket> receiver, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, UpgradeToTLSCallback callback) = 0;
};

class ProxyResolvingSocketFactoryProxy;

template <typename ImplRefTraits>
class ProxyResolvingSocketFactoryStub;

class ProxyResolvingSocketFactoryRequestValidator;
class ProxyResolvingSocketFactoryResponseValidator;


class ProxyResolvingSocketFactory
    : public ProxyResolvingSocketFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.ProxyResolvingSocketFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ProxyResolvingSocketFactoryInterfaceBase;
  using Proxy_ = ProxyResolvingSocketFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ProxyResolvingSocketFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ProxyResolvingSocketFactoryRequestValidator;
  using ResponseValidator_ = ProxyResolvingSocketFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateProxyResolvingSocketMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateProxyResolvingSocket_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ProxyResolvingSocketFactory() = default;

  using CreateProxyResolvingSocketCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&, const std::optional<::net::IPEndPoint>&, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;
  using CreateProxyResolvingSocketMojoCallback = base::OnceCallback<void(int32_t, const std::optional<::net::IPEndPoint>&, const std::optional<::net::IPEndPoint>&, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;

  virtual void CreateProxyResolvingSocket(const ::GURL& url, const ::net::NetworkAnonymizationKey& network_anonymization_key, ProxyResolvingSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<ProxyResolvingSocket> socket, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, CreateProxyResolvingSocketCallback callback) = 0;
};



class  ProxyResolvingSocketProxy
    : public ProxyResolvingSocket {
 public:
  using InterfaceType = ProxyResolvingSocket;

  explicit ProxyResolvingSocketProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpgradeToTLS(const ::net::HostPortPair& host_port_pair, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TLSClientSocket> receiver, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, UpgradeToTLSCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ProxyResolvingSocketFactoryProxy
    : public ProxyResolvingSocketFactory {
 public:
  using InterfaceType = ProxyResolvingSocketFactory;

  explicit ProxyResolvingSocketFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateProxyResolvingSocket(const ::GURL& url, const ::net::NetworkAnonymizationKey& network_anonymization_key, ProxyResolvingSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<ProxyResolvingSocket> socket, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, CreateProxyResolvingSocketCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ProxyResolvingSocketStubDispatch {
 public:
  static bool Accept(ProxyResolvingSocket* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProxyResolvingSocket* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProxyResolvingSocket>>
class ProxyResolvingSocketStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProxyResolvingSocketStub() = default;
  ~ProxyResolvingSocketStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyResolvingSocketStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyResolvingSocketStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProxyResolvingSocketFactoryStubDispatch {
 public:
  static bool Accept(ProxyResolvingSocketFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ProxyResolvingSocketFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ProxyResolvingSocketFactory>>
class ProxyResolvingSocketFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ProxyResolvingSocketFactoryStub() = default;
  ~ProxyResolvingSocketFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyResolvingSocketFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ProxyResolvingSocketFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ProxyResolvingSocketRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProxyResolvingSocketFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProxyResolvingSocketResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ProxyResolvingSocketFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  ProxyResolvingSocketOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProxyResolvingSocketOptions, T>::value>;
  using DataView = ProxyResolvingSocketOptionsDataView;
  using Data_ = internal::ProxyResolvingSocketOptions_Data;

  template <typename... Args>
  static ProxyResolvingSocketOptionsPtr New(Args&&... args) {
    return ProxyResolvingSocketOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProxyResolvingSocketOptionsPtr From(const U& u) {
    return mojo::TypeConverter<ProxyResolvingSocketOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProxyResolvingSocketOptions>::Convert(*this);
  }


  ProxyResolvingSocketOptions();

  explicit ProxyResolvingSocketOptions(
      bool use_tls);


  ~ProxyResolvingSocketOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProxyResolvingSocketOptionsPtr>
  ProxyResolvingSocketOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProxyResolvingSocketOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProxyResolvingSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProxyResolvingSocketOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyResolvingSocketOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProxyResolvingSocketOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProxyResolvingSocketOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProxyResolvingSocketOptions_UnserializedMessageContext<
            UserType, ProxyResolvingSocketOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProxyResolvingSocketOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProxyResolvingSocketOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProxyResolvingSocketOptions_UnserializedMessageContext<
            UserType, ProxyResolvingSocketOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProxyResolvingSocketOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool use_tls;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProxyResolvingSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProxyResolvingSocketOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProxyResolvingSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProxyResolvingSocketOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
ProxyResolvingSocketOptionsPtr ProxyResolvingSocketOptions::Clone() const {
  return New(
      mojo::Clone(use_tls)
  );
}

template <typename T, ProxyResolvingSocketOptions::EnableIfSame<T>*>
bool ProxyResolvingSocketOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->use_tls, other_struct.use_tls))
    return false;
  return true;
}

template <typename T, ProxyResolvingSocketOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.use_tls < rhs.use_tls)
    return true;
  if (rhs.use_tls < lhs.use_tls)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::ProxyResolvingSocketOptions::DataView,
                                         ::network::mojom::ProxyResolvingSocketOptionsPtr> {
  static bool IsNull(const ::network::mojom::ProxyResolvingSocketOptionsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ProxyResolvingSocketOptionsPtr* output) { output->reset(); }

  static decltype(::network::mojom::ProxyResolvingSocketOptions::use_tls) use_tls(
      const ::network::mojom::ProxyResolvingSocketOptionsPtr& input) {
    return input->use_tls;
  }

  static bool Read(::network::mojom::ProxyResolvingSocketOptions::DataView input, ::network::mojom::ProxyResolvingSocketOptionsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_PROXY_RESOLVING_SOCKET_MOJOM_H_