// services/network/public/mojom/proxy_lookup_client.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ProxyInfo as proxyResolver_mojom_ProxyInfo,
  ProxyInfoSpec as proxyResolver_mojom_ProxyInfoSpec
} from '../../../proxy_resolver/public/mojom/proxy_resolver.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ProxyLookupClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.ProxyLookupClient', scope);
  }
}

/** @interface */
export class ProxyLookupClientInterface {
  
  /**
   * @param { !number } netError
   * @param { ?proxyResolver_mojom_ProxyInfo } proxyInfo
   */

  onProxyLookupComplete(netError, proxyInfo) {}
}

/**
 * @implements { ProxyLookupClientInterface }
 */
export class ProxyLookupClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ProxyLookupClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ProxyLookupClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ProxyLookupClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } netError
   * @param { ?proxyResolver_mojom_ProxyInfo } proxyInfo
   */

  onProxyLookupComplete(
      netError,
      proxyInfo) {
    this.proxy.sendMessage(
        0,
        ProxyLookupClient_OnProxyLookupComplete_ParamsSpec.$,
        null,
        [
          netError,
          proxyInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ProxyLookupClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ProxyLookupClientReceiver {
  /**
   * @param {!ProxyLookupClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ProxyLookupClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ProxyLookupClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyLookupClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ProxyLookupClient_OnProxyLookupComplete_ParamsSpec.$,
        null,
        impl.onProxyLookupComplete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ProxyLookupClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ProxyLookupClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ProxyLookupClientRemote}
   */
  static getRemote() {
    let remote = new ProxyLookupClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ProxyLookupClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ProxyLookupClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ProxyLookupClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ProxyLookupClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onProxyLookupComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ProxyLookupClient_OnProxyLookupComplete_ParamsSpec.$,
        null,
        this.onProxyLookupComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ProxyLookupClient_OnProxyLookupComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ProxyLookupClient_OnProxyLookupComplete_ParamsSpec.$,
    'ProxyLookupClient_OnProxyLookupComplete_Params',
    [
      mojo.internal.StructField(
        'netError', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'proxyInfo', 8,
        0,
        proxyResolver_mojom_ProxyInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ProxyLookupClient_OnProxyLookupComplete_Params {
  constructor() {
    /** @type { !number } */
    this.netError;
    /** @type { (proxyResolver_mojom_ProxyInfo|undefined) } */
    this.proxyInfo;
  }
}

