// services/network/public/mojom/proxy_config_with_annotation.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/proxy_config_with_annotation.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/proxy_config_with_annotation.mojom-params-data.h"
#include "services/network/public/mojom/proxy_config_with_annotation.mojom-shared-message-ids.h"

#include "services/network/public/mojom/proxy_config_with_annotation.mojom-blink-import-headers.h"
#include "services/network/public/mojom/proxy_config_with_annotation.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
ProxyConfigWithAnnotation::ProxyConfigWithAnnotation()
    : value(),
      traffic_annotation() {}

ProxyConfigWithAnnotation::ProxyConfigWithAnnotation(
    ::network::mojom::blink::ProxyConfigPtr value_in,
    const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation_in)
    : value(std::move(value_in)),
      traffic_annotation(std::move(traffic_annotation_in)) {}

ProxyConfigWithAnnotation::~ProxyConfigWithAnnotation() = default;

void ProxyConfigWithAnnotation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::network::mojom::blink::ProxyConfigPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "traffic_annotation"), this->traffic_annotation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ProxyConfigWithAnnotation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ProxyConfigClient::IPCStableHashFunction ProxyConfigClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProxyConfigClient>(message.name())) {
    case messages::ProxyConfigClient::kOnProxyConfigUpdated: {
      return &ProxyConfigClient::OnProxyConfigUpdated_Sym::IPCStableHash;
    }
    case messages::ProxyConfigClient::kFlushProxyConfig: {
      return &ProxyConfigClient::FlushProxyConfig_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProxyConfigClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProxyConfigClient>(message.name())) {
      case messages::ProxyConfigClient::kOnProxyConfigUpdated:
            return "Receive network::mojom::ProxyConfigClient::OnProxyConfigUpdated";
      case messages::ProxyConfigClient::kFlushProxyConfig:
            return "Receive network::mojom::ProxyConfigClient::FlushProxyConfig";
    }
  } else {
    switch (static_cast<messages::ProxyConfigClient>(message.name())) {
      case messages::ProxyConfigClient::kOnProxyConfigUpdated:
            return "Receive reply network::mojom::ProxyConfigClient::OnProxyConfigUpdated";
      case messages::ProxyConfigClient::kFlushProxyConfig:
            return "Receive reply network::mojom::ProxyConfigClient::FlushProxyConfig";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProxyConfigClient::OnProxyConfigUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x15d60ba4;  // IPCStableHash for network::mojom::ProxyConfigClient::OnProxyConfigUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProxyConfigClient::FlushProxyConfig_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0ca16941;  // IPCStableHash for network::mojom::ProxyConfigClient::FlushProxyConfig
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ProxyConfigClient_FlushProxyConfig_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ProxyConfigClient_FlushProxyConfig_ForwardToCallback(
      ProxyConfigClient::FlushProxyConfigCallback callback
      ) : callback_(std::move(callback)) {
  }

  ProxyConfigClient_FlushProxyConfig_ForwardToCallback(const ProxyConfigClient_FlushProxyConfig_ForwardToCallback&) = delete;
  ProxyConfigClient_FlushProxyConfig_ForwardToCallback& operator=(const ProxyConfigClient_FlushProxyConfig_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ProxyConfigClient::FlushProxyConfigCallback callback_;
};

ProxyConfigClientProxy::ProxyConfigClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyConfigClientProxy::OnProxyConfigUpdated(
    ProxyConfigWithAnnotationPtr in_proxy_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ProxyConfigClient::OnProxyConfigUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("proxy_config"), in_proxy_config,
                        "<value of type ProxyConfigWithAnnotationPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyConfigClient::kOnProxyConfigUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyConfigClient_OnProxyConfigUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->proxy_config)::BaseType> proxy_config_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::ProxyConfigWithAnnotationDataView>(
    in_proxy_config,
    proxy_config_fragment);

  params->proxy_config.Set(
      proxy_config_fragment.is_null() ? nullptr : proxy_config_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->proxy_config.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null proxy_config in ProxyConfigClient.OnProxyConfigUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyConfigClient::Name_);
  message.set_method_name("OnProxyConfigUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProxyConfigClientProxy::FlushProxyConfig(
    FlushProxyConfigCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::ProxyConfigClient::FlushProxyConfig");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyConfigClient::kFlushProxyConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyConfigClient_FlushProxyConfig_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyConfigClient::Name_);
  message.set_method_name("FlushProxyConfig");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ProxyConfigClient_FlushProxyConfig_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ProxyConfigClient_FlushProxyConfig_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ProxyConfigClient::FlushProxyConfigCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ProxyConfigClient_FlushProxyConfig_ProxyToResponder> proxy(
        new ProxyConfigClient_FlushProxyConfig_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ProxyConfigClient_FlushProxyConfig_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ProxyConfigClient_FlushProxyConfig_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ProxyConfigClient_FlushProxyConfig_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ProxyConfigClient::FlushProxyConfigCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool ProxyConfigClient_FlushProxyConfig_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ProxyConfigClient_FlushProxyConfig_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ProxyConfigClient_FlushProxyConfig_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ProxyConfigClient.1
  bool success = true;
  ProxyConfigClient_FlushProxyConfig_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ProxyConfigClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void ProxyConfigClient_FlushProxyConfig_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply network::mojom::ProxyConfigClient::FlushProxyConfig");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyConfigClient::kFlushProxyConfig), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyConfigClient_FlushProxyConfig_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyConfigClient::Name_);
  message.set_method_name("FlushProxyConfig");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ProxyConfigClientStubDispatch::Accept(
    ProxyConfigClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProxyConfigClient>(message->header()->name)) {
    case messages::ProxyConfigClient::kOnProxyConfigUpdated: {
      DCHECK(message->is_serialized());
      internal::ProxyConfigClient_OnProxyConfigUpdated_Params_Data* params =
          reinterpret_cast<internal::ProxyConfigClient_OnProxyConfigUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProxyConfigClient.0
      bool success = true;
      ProxyConfigWithAnnotationPtr p_proxy_config{};
      ProxyConfigClient_OnProxyConfigUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadProxyConfig(&p_proxy_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyConfigClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProxyConfigUpdated(        
        std::move(p_proxy_config));
      return true;
    }
    case messages::ProxyConfigClient::kFlushProxyConfig: {
      break;
    }
  }
  return false;
}

// static
bool ProxyConfigClientStubDispatch::AcceptWithResponder(
    ProxyConfigClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProxyConfigClient>(message->header()->name)) {
    case messages::ProxyConfigClient::kOnProxyConfigUpdated: {
      break;
    }
    case messages::ProxyConfigClient::kFlushProxyConfig: {
      internal::ProxyConfigClient_FlushProxyConfig_Params_Data* params =
          reinterpret_cast<
              internal::ProxyConfigClient_FlushProxyConfig_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ProxyConfigClient.1
      bool success = true;
      ProxyConfigClient_FlushProxyConfig_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyConfigClient::Name_, 1, false);
        return false;
      }
      auto callback =
          ProxyConfigClient_FlushProxyConfig_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FlushProxyConfig(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProxyConfigClientValidationInfo[] = {
    { &internal::ProxyConfigClient_OnProxyConfigUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProxyConfigClient_FlushProxyConfig_Params_Data::Validate,
     &internal::ProxyConfigClient_FlushProxyConfig_ResponseParams_Data::Validate},
};

bool ProxyConfigClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::ProxyConfigClient::Name_,
    kProxyConfigClientValidationInfo);
}

bool ProxyConfigClientResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::network::mojom::blink::ProxyConfigClient::Name_,
    kProxyConfigClientValidationInfo);
}
// The declaration includes the definition on other builds.

ProxyConfigPollerClient::IPCStableHashFunction ProxyConfigPollerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProxyConfigPollerClient>(message.name())) {
    case messages::ProxyConfigPollerClient::kOnLazyProxyConfigPoll: {
      return &ProxyConfigPollerClient::OnLazyProxyConfigPoll_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProxyConfigPollerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProxyConfigPollerClient>(message.name())) {
      case messages::ProxyConfigPollerClient::kOnLazyProxyConfigPoll:
            return "Receive network::mojom::ProxyConfigPollerClient::OnLazyProxyConfigPoll";
    }
  } else {
    switch (static_cast<messages::ProxyConfigPollerClient>(message.name())) {
      case messages::ProxyConfigPollerClient::kOnLazyProxyConfigPoll:
            return "Receive reply network::mojom::ProxyConfigPollerClient::OnLazyProxyConfigPoll";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProxyConfigPollerClient::OnLazyProxyConfigPoll_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x451fefd7;  // IPCStableHash for network::mojom::ProxyConfigPollerClient::OnLazyProxyConfigPoll
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProxyConfigPollerClientProxy::ProxyConfigPollerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyConfigPollerClientProxy::OnLazyProxyConfigPoll(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send network::mojom::ProxyConfigPollerClient::OnLazyProxyConfigPoll");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyConfigPollerClient::kOnLazyProxyConfigPoll), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyConfigPollerClient_OnLazyProxyConfigPoll_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyConfigPollerClient::Name_);
  message.set_method_name("OnLazyProxyConfigPoll");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProxyConfigPollerClientStubDispatch::Accept(
    ProxyConfigPollerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProxyConfigPollerClient>(message->header()->name)) {
    case messages::ProxyConfigPollerClient::kOnLazyProxyConfigPoll: {
      DCHECK(message->is_serialized());
      internal::ProxyConfigPollerClient_OnLazyProxyConfigPoll_Params_Data* params =
          reinterpret_cast<internal::ProxyConfigPollerClient_OnLazyProxyConfigPoll_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProxyConfigPollerClient.0
      bool success = true;
      ProxyConfigPollerClient_OnLazyProxyConfigPoll_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyConfigPollerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLazyProxyConfigPoll(        );
      return true;
    }
  }
  return false;
}

// static
bool ProxyConfigPollerClientStubDispatch::AcceptWithResponder(
    ProxyConfigPollerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProxyConfigPollerClient>(message->header()->name)) {
    case messages::ProxyConfigPollerClient::kOnLazyProxyConfigPoll: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProxyConfigPollerClientValidationInfo[] = {
    { &internal::ProxyConfigPollerClient_OnLazyProxyConfigPoll_Params_Data::Validate,
     nullptr /* no response */},
};

bool ProxyConfigPollerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::ProxyConfigPollerClient::Name_,
    kProxyConfigPollerClientValidationInfo);
}

// The declaration includes the definition on other builds.

ProxyErrorClient::IPCStableHashFunction ProxyErrorClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ProxyErrorClient>(message.name())) {
    case messages::ProxyErrorClient::kOnPACScriptError: {
      return &ProxyErrorClient::OnPACScriptError_Sym::IPCStableHash;
    }
    case messages::ProxyErrorClient::kOnRequestMaybeFailedDueToProxySettings: {
      return &ProxyErrorClient::OnRequestMaybeFailedDueToProxySettings_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ProxyErrorClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ProxyErrorClient>(message.name())) {
      case messages::ProxyErrorClient::kOnPACScriptError:
            return "Receive network::mojom::ProxyErrorClient::OnPACScriptError";
      case messages::ProxyErrorClient::kOnRequestMaybeFailedDueToProxySettings:
            return "Receive network::mojom::ProxyErrorClient::OnRequestMaybeFailedDueToProxySettings";
    }
  } else {
    switch (static_cast<messages::ProxyErrorClient>(message.name())) {
      case messages::ProxyErrorClient::kOnPACScriptError:
            return "Receive reply network::mojom::ProxyErrorClient::OnPACScriptError";
      case messages::ProxyErrorClient::kOnRequestMaybeFailedDueToProxySettings:
            return "Receive reply network::mojom::ProxyErrorClient::OnRequestMaybeFailedDueToProxySettings";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ProxyErrorClient::OnPACScriptError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9cd84a45;  // IPCStableHash for network::mojom::ProxyErrorClient::OnPACScriptError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ProxyErrorClient::OnRequestMaybeFailedDueToProxySettings_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb97f3240;  // IPCStableHash for network::mojom::ProxyErrorClient::OnRequestMaybeFailedDueToProxySettings
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ProxyErrorClientProxy::ProxyErrorClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ProxyErrorClientProxy::OnPACScriptError(
    int32_t in_line_number, const ::blink::String& in_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ProxyErrorClient::OnPACScriptError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("line_number"), in_line_number,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("details"), in_details,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyErrorClient::kOnPACScriptError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyErrorClient_OnPACScriptError_Params_Data> params(
          message);
  params.Allocate();

  params->line_number = in_line_number;
  mojo::internal::MessageFragment<
      typename decltype(params->details)::BaseType> details_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_details,
    details_fragment);

  params->details.Set(
      details_fragment.is_null() ? nullptr : details_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->details.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null details in ProxyErrorClient.OnPACScriptError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyErrorClient::Name_);
  message.set_method_name("OnPACScriptError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ProxyErrorClientProxy::OnRequestMaybeFailedDueToProxySettings(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ProxyErrorClient::OnRequestMaybeFailedDueToProxySettings", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ProxyErrorClient::kOnRequestMaybeFailedDueToProxySettings), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Params_Data> params(
          message);
  params.Allocate();

  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ProxyErrorClient::Name_);
  message.set_method_name("OnRequestMaybeFailedDueToProxySettings");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ProxyErrorClientStubDispatch::Accept(
    ProxyErrorClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ProxyErrorClient>(message->header()->name)) {
    case messages::ProxyErrorClient::kOnPACScriptError: {
      DCHECK(message->is_serialized());
      internal::ProxyErrorClient_OnPACScriptError_Params_Data* params =
          reinterpret_cast<internal::ProxyErrorClient_OnPACScriptError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProxyErrorClient.0
      bool success = true;
      int32_t p_line_number{};
      ::blink::String p_details{};
      ProxyErrorClient_OnPACScriptError_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_line_number = input_data_view.line_number();
      if (success && !input_data_view.ReadDetails(&p_details))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyErrorClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPACScriptError(        
        std::move(p_line_number), 
        std::move(p_details));
      return true;
    }
    case messages::ProxyErrorClient::kOnRequestMaybeFailedDueToProxySettings: {
      DCHECK(message->is_serialized());
      internal::ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Params_Data* params =
          reinterpret_cast<internal::ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ProxyErrorClient.1
      bool success = true;
      int32_t p_net_error{};
      ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_net_error = input_data_view.net_error();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ProxyErrorClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnRequestMaybeFailedDueToProxySettings(        
        std::move(p_net_error));
      return true;
    }
  }
  return false;
}

// static
bool ProxyErrorClientStubDispatch::AcceptWithResponder(
    ProxyErrorClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ProxyErrorClient>(message->header()->name)) {
    case messages::ProxyErrorClient::kOnPACScriptError: {
      break;
    }
    case messages::ProxyErrorClient::kOnRequestMaybeFailedDueToProxySettings: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kProxyErrorClientValidationInfo[] = {
    { &internal::ProxyErrorClient_OnPACScriptError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ProxyErrorClient_OnRequestMaybeFailedDueToProxySettings_Params_Data::Validate,
     nullptr /* no response */},
};

bool ProxyErrorClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::blink::ProxyErrorClient::Name_,
    kProxyErrorClientValidationInfo);
}



}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::ProxyConfigWithAnnotation::DataView, ::network::mojom::blink::ProxyConfigWithAnnotationPtr>::Read(
    ::network::mojom::blink::ProxyConfigWithAnnotation::DataView input,
    ::network::mojom::blink::ProxyConfigWithAnnotationPtr* output) {
  bool success = true;
  ::network::mojom::blink::ProxyConfigWithAnnotationPtr result(::network::mojom::blink::ProxyConfigWithAnnotation::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadTrafficAnnotation(&result->traffic_annotation))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {


void ProxyConfigClientInterceptorForTesting::OnProxyConfigUpdated(ProxyConfigWithAnnotationPtr proxy_config) {
  GetForwardingInterface()->OnProxyConfigUpdated(
    std::move(proxy_config)
    );
}
void ProxyConfigClientInterceptorForTesting::FlushProxyConfig(FlushProxyConfigCallback callback) {
  GetForwardingInterface()->FlushProxyConfig(std::move(callback));
}
ProxyConfigClientAsyncWaiter::ProxyConfigClientAsyncWaiter(
    ProxyConfigClient* proxy) : proxy_(proxy) {}

ProxyConfigClientAsyncWaiter::~ProxyConfigClientAsyncWaiter() = default;


void ProxyConfigClientAsyncWaiter::FlushProxyConfig(
    ) {
  base::RunLoop loop;
  proxy_->FlushProxyConfig(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void ProxyConfigPollerClientInterceptorForTesting::OnLazyProxyConfigPoll() {
  GetForwardingInterface()->OnLazyProxyConfigPoll();
}
ProxyConfigPollerClientAsyncWaiter::ProxyConfigPollerClientAsyncWaiter(
    ProxyConfigPollerClient* proxy) : proxy_(proxy) {}

ProxyConfigPollerClientAsyncWaiter::~ProxyConfigPollerClientAsyncWaiter() = default;





void ProxyErrorClientInterceptorForTesting::OnPACScriptError(int32_t line_number, const ::blink::String& details) {
  GetForwardingInterface()->OnPACScriptError(
    std::move(line_number)
    , 
    std::move(details)
    );
}
void ProxyErrorClientInterceptorForTesting::OnRequestMaybeFailedDueToProxySettings(int32_t net_error) {
  GetForwardingInterface()->OnRequestMaybeFailedDueToProxySettings(
    std::move(net_error)
    );
}
ProxyErrorClientAsyncWaiter::ProxyErrorClientAsyncWaiter(
    ProxyErrorClient* proxy) : proxy_(proxy) {}

ProxyErrorClientAsyncWaiter::~ProxyErrorClientAsyncWaiter() = default;







}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif