// services/network/public/mojom/p2p_trusted.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class P2PTrustedSocketManagerClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.P2PTrustedSocketManagerClient', scope);
  }
}

/** @interface */
export class P2PTrustedSocketManagerClientInterface {
  
  /**
   */

  invalidSocketPortRangeRequested() {}
  
  /**
   * @param { !Array<!number> } packetHeader
   * @param { !bigint } packetLength
   * @param { !boolean } incoming
   */

  dumpPacket(packetHeader, packetLength, incoming) {}
}

/**
 * @implements { P2PTrustedSocketManagerClientInterface }
 */
export class P2PTrustedSocketManagerClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!P2PTrustedSocketManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          P2PTrustedSocketManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!P2PTrustedSocketManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  invalidSocketPortRangeRequested() {
    this.proxy.sendMessage(
        0,
        P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } packetHeader
   * @param { !bigint } packetLength
   * @param { !boolean } incoming
   */

  dumpPacket(
      packetHeader,
      packetLength,
      incoming) {
    this.proxy.sendMessage(
        1,
        P2PTrustedSocketManagerClient_DumpPacket_ParamsSpec.$,
        null,
        [
          packetHeader,
          packetLength,
          incoming
        ],
        false);
  }
}

/**
 * An object which receives request messages for the P2PTrustedSocketManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class P2PTrustedSocketManagerClientReceiver {
  /**
   * @param {!P2PTrustedSocketManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!P2PTrustedSocketManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        P2PTrustedSocketManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!P2PTrustedSocketManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_ParamsSpec.$,
        null,
        impl.invalidSocketPortRangeRequested.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        P2PTrustedSocketManagerClient_DumpPacket_ParamsSpec.$,
        null,
        impl.dumpPacket.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class P2PTrustedSocketManagerClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.P2PTrustedSocketManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!P2PTrustedSocketManagerClientRemote}
   */
  static getRemote() {
    let remote = new P2PTrustedSocketManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the P2PTrustedSocketManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class P2PTrustedSocketManagerClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      P2PTrustedSocketManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!P2PTrustedSocketManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.invalidSocketPortRangeRequested =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_ParamsSpec.$,
        null,
        this.invalidSocketPortRangeRequested.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dumpPacket =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        P2PTrustedSocketManagerClient_DumpPacket_ParamsSpec.$,
        null,
        this.dumpPacket.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class P2PTrustedSocketManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.P2PTrustedSocketManager', scope);
  }
}

/** @interface */
export class P2PTrustedSocketManagerInterface {
  
  /**
   * @param { !boolean } incoming
   * @param { !boolean } outgoing
   */

  startRtpDump(incoming, outgoing) {}
  
  /**
   * @param { !boolean } incoming
   * @param { !boolean } outgoing
   */

  stopRtpDump(incoming, outgoing) {}
  
  /**
   */

  pauseNetworkChangeNotifications() {}
  
  /**
   */

  resumeNetworkChangeNotifications() {}
}

/**
 * @implements { P2PTrustedSocketManagerInterface }
 */
export class P2PTrustedSocketManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!P2PTrustedSocketManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          P2PTrustedSocketManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!P2PTrustedSocketManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !boolean } incoming
   * @param { !boolean } outgoing
   */

  startRtpDump(
      incoming,
      outgoing) {
    this.proxy.sendMessage(
        0,
        P2PTrustedSocketManager_StartRtpDump_ParamsSpec.$,
        null,
        [
          incoming,
          outgoing
        ],
        false);
  }

  
  /**
   * @param { !boolean } incoming
   * @param { !boolean } outgoing
   */

  stopRtpDump(
      incoming,
      outgoing) {
    this.proxy.sendMessage(
        1,
        P2PTrustedSocketManager_StopRtpDump_ParamsSpec.$,
        null,
        [
          incoming,
          outgoing
        ],
        false);
  }

  
  /**
   */

  pauseNetworkChangeNotifications() {
    this.proxy.sendMessage(
        2,
        P2PTrustedSocketManager_PauseNetworkChangeNotifications_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resumeNetworkChangeNotifications() {
    this.proxy.sendMessage(
        3,
        P2PTrustedSocketManager_ResumeNetworkChangeNotifications_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the P2PTrustedSocketManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class P2PTrustedSocketManagerReceiver {
  /**
   * @param {!P2PTrustedSocketManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!P2PTrustedSocketManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        P2PTrustedSocketManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!P2PTrustedSocketManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        P2PTrustedSocketManager_StartRtpDump_ParamsSpec.$,
        null,
        impl.startRtpDump.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        P2PTrustedSocketManager_StopRtpDump_ParamsSpec.$,
        null,
        impl.stopRtpDump.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        P2PTrustedSocketManager_PauseNetworkChangeNotifications_ParamsSpec.$,
        null,
        impl.pauseNetworkChangeNotifications.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        P2PTrustedSocketManager_ResumeNetworkChangeNotifications_ParamsSpec.$,
        null,
        impl.resumeNetworkChangeNotifications.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class P2PTrustedSocketManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.P2PTrustedSocketManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!P2PTrustedSocketManagerRemote}
   */
  static getRemote() {
    let remote = new P2PTrustedSocketManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the P2PTrustedSocketManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class P2PTrustedSocketManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      P2PTrustedSocketManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!P2PTrustedSocketManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startRtpDump =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        P2PTrustedSocketManager_StartRtpDump_ParamsSpec.$,
        null,
        this.startRtpDump.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopRtpDump =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        P2PTrustedSocketManager_StopRtpDump_ParamsSpec.$,
        null,
        this.stopRtpDump.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.pauseNetworkChangeNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        P2PTrustedSocketManager_PauseNetworkChangeNotifications_ParamsSpec.$,
        null,
        this.pauseNetworkChangeNotifications.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resumeNetworkChangeNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        P2PTrustedSocketManager_ResumeNetworkChangeNotifications_ParamsSpec.$,
        null,
        this.resumeNetworkChangeNotifications.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PTrustedSocketManagerClient_DumpPacket_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PTrustedSocketManager_StartRtpDump_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PTrustedSocketManager_StopRtpDump_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PTrustedSocketManager_PauseNetworkChangeNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const P2PTrustedSocketManager_ResumeNetworkChangeNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_ParamsSpec.$,
    'P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class P2PTrustedSocketManagerClient_InvalidSocketPortRangeRequested_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    P2PTrustedSocketManagerClient_DumpPacket_ParamsSpec.$,
    'P2PTrustedSocketManagerClient_DumpPacket_Params',
    [
      mojo.internal.StructField(
        'packetHeader', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'packetLength', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'incoming', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class P2PTrustedSocketManagerClient_DumpPacket_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.packetHeader;
    /** @type { !bigint } */
    this.packetLength;
    /** @type { !boolean } */
    this.incoming;
  }
}



mojo.internal.Struct(
    P2PTrustedSocketManager_StartRtpDump_ParamsSpec.$,
    'P2PTrustedSocketManager_StartRtpDump_Params',
    [
      mojo.internal.StructField(
        'incoming', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outgoing', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class P2PTrustedSocketManager_StartRtpDump_Params {
  constructor() {
    /** @type { !boolean } */
    this.incoming;
    /** @type { !boolean } */
    this.outgoing;
  }
}



mojo.internal.Struct(
    P2PTrustedSocketManager_StopRtpDump_ParamsSpec.$,
    'P2PTrustedSocketManager_StopRtpDump_Params',
    [
      mojo.internal.StructField(
        'incoming', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outgoing', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class P2PTrustedSocketManager_StopRtpDump_Params {
  constructor() {
    /** @type { !boolean } */
    this.incoming;
    /** @type { !boolean } */
    this.outgoing;
  }
}



mojo.internal.Struct(
    P2PTrustedSocketManager_PauseNetworkChangeNotifications_ParamsSpec.$,
    'P2PTrustedSocketManager_PauseNetworkChangeNotifications_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class P2PTrustedSocketManager_PauseNetworkChangeNotifications_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    P2PTrustedSocketManager_ResumeNetworkChangeNotifications_ParamsSpec.$,
    'P2PTrustedSocketManager_ResumeNetworkChangeNotifications_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class P2PTrustedSocketManager_ResumeNetworkChangeNotifications_Params {
  constructor() {
  }
}

