// services/network/public/mojom/network_service_test.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/network_service_test.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/address_list.mojom-shared.h"
#include "services/network/public/mojom/host_resolver.mojom-shared.h"
#include "services/network/public/mojom/network_change_manager.mojom-shared.h"
#include "services/network/public/mojom/network_interface_change_listener.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/network_types.mojom-shared.h"
#include "services/network/public/mojom/http_cache_backend_file_operations.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/transferable_socket.mojom-shared.h"


namespace network::mojom {
class RuleDataView;

class SimpleCacheOpenEntryResultDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::RuleDataView> {
  using Data = ::network::mojom::internal::Rule_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SimpleCacheOpenEntryResultDataView> {
  using Data = ::network::mojom::internal::SimpleCacheOpenEntryResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class ResolverType : int32_t {
  
  kResolverTypeFail = 0,
  
  kResolverTypeFailTimeout = 1,
  
  kResolverTypeSystem = 2,
  
  kResolverTypeIPLiteral = 3,
  
  kResolverTypeDirectLookup = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, ResolverType value);
inline bool IsKnownEnumValue(ResolverType value) {
  return internal::ResolverType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SimpleCacheEntryInterfaceBase {};

using SimpleCacheEntryPtrDataView =
    mojo::InterfacePtrDataView<SimpleCacheEntryInterfaceBase>;
using SimpleCacheEntryRequestDataView =
    mojo::InterfaceRequestDataView<SimpleCacheEntryInterfaceBase>;
using SimpleCacheEntryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SimpleCacheEntryInterfaceBase>;
using SimpleCacheEntryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SimpleCacheEntryInterfaceBase>;
class SimpleCacheEntryEnumeratorInterfaceBase {};

using SimpleCacheEntryEnumeratorPtrDataView =
    mojo::InterfacePtrDataView<SimpleCacheEntryEnumeratorInterfaceBase>;
using SimpleCacheEntryEnumeratorRequestDataView =
    mojo::InterfaceRequestDataView<SimpleCacheEntryEnumeratorInterfaceBase>;
using SimpleCacheEntryEnumeratorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SimpleCacheEntryEnumeratorInterfaceBase>;
using SimpleCacheEntryEnumeratorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SimpleCacheEntryEnumeratorInterfaceBase>;
class SimpleCacheInterfaceBase {};

using SimpleCachePtrDataView =
    mojo::InterfacePtrDataView<SimpleCacheInterfaceBase>;
using SimpleCacheRequestDataView =
    mojo::InterfaceRequestDataView<SimpleCacheInterfaceBase>;
using SimpleCacheAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SimpleCacheInterfaceBase>;
using SimpleCacheAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SimpleCacheInterfaceBase>;
class NetworkServiceTestInterfaceBase {};

using NetworkServiceTestPtrDataView =
    mojo::InterfacePtrDataView<NetworkServiceTestInterfaceBase>;
using NetworkServiceTestRequestDataView =
    mojo::InterfaceRequestDataView<NetworkServiceTestInterfaceBase>;
using NetworkServiceTestAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NetworkServiceTestInterfaceBase>;
using NetworkServiceTestAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NetworkServiceTestInterfaceBase>;


class RuleDataView {
 public:
  RuleDataView() = default;

  RuleDataView(
      internal::Rule_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadResolverType(UserType* output) const {
    auto data_value = data_->resolver_type;
    return mojo::internal::Deserialize<::network::mojom::ResolverType>(
        data_value, output);
  }
  ResolverType resolver_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::ResolverType>(data_->resolver_type));
  }
  inline void GetHostPatternDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostPattern(UserType* output) {
    
    auto* pointer = data_->host_pattern.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetReplacementDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadReplacement(UserType* output) {
    
    auto* pointer = data_->replacement.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t host_resolver_flags() const {
    return data_->host_resolver_flags;
  }
  inline void GetDnsAliasesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDnsAliases(UserType* output) {
    
    auto* pointer = data_->dns_aliases.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::Rule_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SimpleCacheOpenEntryResultDataView {
 public:
  SimpleCacheOpenEntryResultDataView() = default;

  SimpleCacheOpenEntryResultDataView(
      internal::SimpleCacheOpenEntryResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t error() const {
    return data_->error;
  }
  inline void GetKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKey(UserType* output) {
    
    auto* pointer = data_->key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeEntry() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::SimpleCacheEntryInterfaceBase>>(
            &data_->entry, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::SimpleCacheOpenEntryResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_DATA_VIEW_H_