// services/network/public/mojom/network_service_test.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_BLINK_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_BLINK_TEST_UTILS_H_

#include "services/network/public/mojom/network_service_test.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace network::mojom::blink {


class BLINK_PLATFORM_EXPORT SimpleCacheEntryInterceptorForTesting : public SimpleCacheEntry {
  virtual SimpleCacheEntry* GetForwardingInterface() = 0;
  void WriteData(int32_t index, int32_t offset, const ::blink::Vector<uint8_t>& data, bool truncate, WriteDataCallback callback) override;
  void ReadData(int32_t index, int32_t offset, uint32_t length, ReadDataCallback callback) override;
  void WriteSparseData(int32_t offset, const ::blink::Vector<uint8_t>& data, WriteSparseDataCallback callback) override;
  void ReadSparseData(int32_t offset, uint32_t length, ReadSparseDataCallback callback) override;
  void Close(CloseCallback callback) override;
};
class BLINK_PLATFORM_EXPORT SimpleCacheEntryAsyncWaiter {
 public:
  explicit SimpleCacheEntryAsyncWaiter(SimpleCacheEntry* proxy);

  SimpleCacheEntryAsyncWaiter(const SimpleCacheEntryAsyncWaiter&) = delete;
  SimpleCacheEntryAsyncWaiter& operator=(const SimpleCacheEntryAsyncWaiter&) = delete;

  ~SimpleCacheEntryAsyncWaiter();
  void WriteData(
      int32_t index, int32_t offset, const ::blink::Vector<uint8_t>& data, bool truncate, int32_t* out_result);
  int32_t WriteData(int32_t index, int32_t offset, const ::blink::Vector<uint8_t>& data, bool truncate);
  void ReadData(
      int32_t index, int32_t offset, uint32_t length, ::blink::Vector<uint8_t>* out_data, int32_t* out_result);
  
  void WriteSparseData(
      int32_t offset, const ::blink::Vector<uint8_t>& data, int32_t* out_result);
  int32_t WriteSparseData(int32_t offset, const ::blink::Vector<uint8_t>& data);
  void ReadSparseData(
      int32_t offset, uint32_t length, ::blink::Vector<uint8_t>* out_data, int32_t* out_result);
  
  void Close(
      );
  

 private:
  SimpleCacheEntry* const proxy_;
};


class BLINK_PLATFORM_EXPORT SimpleCacheEntryEnumeratorInterceptorForTesting : public SimpleCacheEntryEnumerator {
  virtual SimpleCacheEntryEnumerator* GetForwardingInterface() = 0;
  void GetNext(GetNextCallback callback) override;
};
class BLINK_PLATFORM_EXPORT SimpleCacheEntryEnumeratorAsyncWaiter {
 public:
  explicit SimpleCacheEntryEnumeratorAsyncWaiter(SimpleCacheEntryEnumerator* proxy);

  SimpleCacheEntryEnumeratorAsyncWaiter(const SimpleCacheEntryEnumeratorAsyncWaiter&) = delete;
  SimpleCacheEntryEnumeratorAsyncWaiter& operator=(const SimpleCacheEntryEnumeratorAsyncWaiter&) = delete;

  ~SimpleCacheEntryEnumeratorAsyncWaiter();
  void GetNext(
      SimpleCacheOpenEntryResultPtr* out_result);
  SimpleCacheOpenEntryResultPtr GetNext();

 private:
  SimpleCacheEntryEnumerator* const proxy_;
};


class BLINK_PLATFORM_EXPORT SimpleCacheInterceptorForTesting : public SimpleCache {
  virtual SimpleCache* GetForwardingInterface() = 0;
  void CreateEntry(const ::blink::String& key, CreateEntryCallback callback) override;
  void OpenEntry(const ::blink::String& key, OpenEntryCallback callback) override;
  void DoomEntry(const ::blink::String& key, DoomEntryCallback callback) override;
  void DoomAllEntries(DoomAllEntriesCallback callback) override;
  void EnumerateEntries(::mojo::PendingReceiver<SimpleCacheEntryEnumerator> receiver) override;
  void Detach(DetachCallback callback) override;
};
class BLINK_PLATFORM_EXPORT SimpleCacheAsyncWaiter {
 public:
  explicit SimpleCacheAsyncWaiter(SimpleCache* proxy);

  SimpleCacheAsyncWaiter(const SimpleCacheAsyncWaiter&) = delete;
  SimpleCacheAsyncWaiter& operator=(const SimpleCacheAsyncWaiter&) = delete;

  ~SimpleCacheAsyncWaiter();
  void CreateEntry(
      const ::blink::String& key, ::mojo::PendingRemote<SimpleCacheEntry>* out_entry, int32_t* out_error);
  
  void OpenEntry(
      const ::blink::String& key, ::mojo::PendingRemote<SimpleCacheEntry>* out_entry, int32_t* out_error);
  
  void DoomEntry(
      const ::blink::String& key, int32_t* out_result);
  int32_t DoomEntry(const ::blink::String& key);
  void DoomAllEntries(
      int32_t* out_result);
  int32_t DoomAllEntries();
  void Detach(
      );
  

 private:
  SimpleCache* const proxy_;
};


class BLINK_PLATFORM_EXPORT NetworkServiceTestInterceptorForTesting : public NetworkServiceTest {
  virtual NetworkServiceTest* GetForwardingInterface() = 0;
  void AddRules(::blink::Vector<RulePtr> rules, AddRulesCallback callback) override;
  void SimulateNetworkChange(::network::mojom::blink::ConnectionType type, SimulateNetworkChangeCallback callback) override;
  void SimulateNetworkQualityChange(::network::mojom::blink::EffectiveConnectionType type, SimulateNetworkQualityChangeCallback callback) override;
  void ForceNetworkQualityEstimatorReportWifiAsSlow2G(ForceNetworkQualityEstimatorReportWifiAsSlow2GCallback callback) override;
  void SimulateCrash() override;
  void MockCertVerifierSetDefaultResult(int32_t default_result, MockCertVerifierSetDefaultResultCallback callback) override;
  void MockCertVerifierAddResultForCertAndHost(::network::mojom::blink::X509CertificatePtr cert, const ::blink::String& host_pattern, ::network::mojom::blink::CertVerifyResultPtr verify_result, int32_t rv, MockCertVerifierAddResultForCertAndHostCallback callback) override;
  void SetTransportSecurityStateTestSource(bool enable_unittest_source, SetTransportSecurityStateTestSourceCallback callback) override;
  void SetAllowNetworkAccessToHostResolutions(SetAllowNetworkAccessToHostResolutionsCallback callback) override;
  void ReplaceSystemDnsConfig(ReplaceSystemDnsConfigCallback callback) override;
  void SetTestDohConfig(::network::mojom::blink::SecureDnsMode secure_dns_mode, ::network::mojom::blink::DnsOverHttpsConfigPtr doh_config, SetTestDohConfigCallback callback) override;
  void CrashOnResolveHost(const ::blink::String& host) override;
  void CrashOnGetCookieList() override;
  void GetLatestMemoryPressureLevel(GetLatestMemoryPressureLevelCallback callback) override;
  void GetPeerToPeerConnectionsCountChange(GetPeerToPeerConnectionsCountChangeCallback callback) override;
  void GetEnvironmentVariableValue(const ::blink::String& name, GetEnvironmentVariableValueCallback callback) override;
  void Log(const ::blink::String& message, LogCallback callback) override;
  void ActivateFieldTrial(const ::blink::String& field_trial_name) override;
  void SetSCTAuditingRetryDelay(std::optional<::base::TimeDelta> delay, SetSCTAuditingRetryDelayCallback callback) override;
  void OpenFile(const ::base::FilePath& path, OpenFileCallback callback) override;
  void EnumerateFiles(const ::base::FilePath& path, ::mojo::PendingRemote<::network::mojom::blink::HttpCacheBackendFileOperationsFactory> factory, EnumerateFilesCallback callback) override;
  void CreateSimpleCache(::mojo::PendingRemote<::network::mojom::blink::HttpCacheBackendFileOperationsFactory> factory, const ::base::FilePath& path, bool reset, CreateSimpleCacheCallback callback) override;
  void MakeRequestToServer(::network::mojom::blink::TransferableSocketPtr s, const ::net::IPEndPoint& endpoint, MakeRequestToServerCallback callback) override;
  void ResolveOwnHostnameWithSystemDns(ResolveOwnHostnameWithSystemDnsCallback callback) override;
  void SetIPv6ProbeResult(bool success, SetIPv6ProbeResultCallback callback) override;
  void AllowsGSSAPILibraryLoad(AllowsGSSAPILibraryLoadCallback callback) override;
  void IsHappyEyeballsV3Enabled(IsHappyEyeballsV3EnabledCallback callback) override;
};
class BLINK_PLATFORM_EXPORT NetworkServiceTestAsyncWaiter {
 public:
  explicit NetworkServiceTestAsyncWaiter(NetworkServiceTest* proxy);

  NetworkServiceTestAsyncWaiter(const NetworkServiceTestAsyncWaiter&) = delete;
  NetworkServiceTestAsyncWaiter& operator=(const NetworkServiceTestAsyncWaiter&) = delete;

  ~NetworkServiceTestAsyncWaiter();
  void AddRules(
      ::blink::Vector<RulePtr> rules);
  
  void SimulateNetworkChange(
      ::network::mojom::blink::ConnectionType type);
  
  void SimulateNetworkQualityChange(
      ::network::mojom::blink::EffectiveConnectionType type);
  
  void ForceNetworkQualityEstimatorReportWifiAsSlow2G(
      );
  
  void MockCertVerifierSetDefaultResult(
      int32_t default_result);
  
  void MockCertVerifierAddResultForCertAndHost(
      ::network::mojom::blink::X509CertificatePtr cert, const ::blink::String& host_pattern, ::network::mojom::blink::CertVerifyResultPtr verify_result, int32_t rv);
  
  void SetTransportSecurityStateTestSource(
      bool enable_unittest_source);
  
  void SetAllowNetworkAccessToHostResolutions(
      );
  
  void ReplaceSystemDnsConfig(
      );
  
  void SetTestDohConfig(
      ::network::mojom::blink::SecureDnsMode secure_dns_mode, ::network::mojom::blink::DnsOverHttpsConfigPtr doh_config);
  
  void GetLatestMemoryPressureLevel(
      ::mojo_base::mojom::blink::MemoryPressureLevel* out_memory_pressure_level);
  ::mojo_base::mojom::blink::MemoryPressureLevel GetLatestMemoryPressureLevel();
  void GetPeerToPeerConnectionsCountChange(
      uint32_t* out_connection_count);
  uint32_t GetPeerToPeerConnectionsCountChange();
  void GetEnvironmentVariableValue(
      const ::blink::String& name, ::blink::String* out_value);
  ::blink::String GetEnvironmentVariableValue(const ::blink::String& name);
  void Log(
      const ::blink::String& message);
  
  void SetSCTAuditingRetryDelay(
      std::optional<::base::TimeDelta> delay);
  
  void OpenFile(
      const ::base::FilePath& path, bool* out_result);
  bool OpenFile(const ::base::FilePath& path);
  void EnumerateFiles(
      const ::base::FilePath& path, ::mojo::PendingRemote<::network::mojom::blink::HttpCacheBackendFileOperationsFactory> factory, ::blink::Vector<::network::mojom::blink::FileEnumerationEntryPtr>* out_entries, bool* out_error);
  
  void CreateSimpleCache(
      ::mojo::PendingRemote<::network::mojom::blink::HttpCacheBackendFileOperationsFactory> factory, const ::base::FilePath& path, bool reset, ::mojo::PendingRemote<SimpleCache>* out_backend);
  ::mojo::PendingRemote<SimpleCache> CreateSimpleCache(::mojo::PendingRemote<::network::mojom::blink::HttpCacheBackendFileOperationsFactory> factory, const ::base::FilePath& path, bool reset);
  void MakeRequestToServer(
      ::network::mojom::blink::TransferableSocketPtr s, const ::net::IPEndPoint& endpoint, bool* out_result);
  bool MakeRequestToServer(::network::mojom::blink::TransferableSocketPtr s, const ::net::IPEndPoint& endpoint);
  void ResolveOwnHostnameWithSystemDns(
      ::network::mojom::blink::AddressListPtr* out_addr_list, int32_t* out_os_error, int32_t* out_net_error);
  
  void SetIPv6ProbeResult(
      bool success);
  
  void AllowsGSSAPILibraryLoad(
      bool* out_allow_gssapi_library_load);
  bool AllowsGSSAPILibraryLoad();
  void IsHappyEyeballsV3Enabled(
      bool* out_is_happy_eyeballs_v3_enabled);
  bool IsHappyEyeballsV3Enabled();

 private:
  NetworkServiceTest* const proxy_;
};




}  // network::mojom::blink

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_BLINK_TEST_UTILS_H_