// services/network/public/mojom/network_anonymization_key.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ANONYMIZATION_KEY_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ANONYMIZATION_KEY_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/network_anonymization_key.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/network_isolation_partition.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"

#include "services/network/public/mojom/network_anonymization_key.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::EmptyNetworkAnonymizationKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::EmptyNetworkAnonymizationKeyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::EmptyNetworkAnonymizationKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::NonEmptyNetworkAnonymizationKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NonEmptyNetworkAnonymizationKeyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NonEmptyNetworkAnonymizationKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::top_frame_site(input)) in_top_frame_site = Traits::top_frame_site(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->top_frame_site)::BaseType> top_frame_site_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView, send_validation>(
        in_top_frame_site,
        top_frame_site_fragment);

      fragment->top_frame_site.Set(
          top_frame_site_fragment.is_null() ? nullptr : top_frame_site_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->top_frame_site.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_frame_site in NonEmptyNetworkAnonymizationKey struct");

      fragment->is_cross_site = Traits::is_cross_site(input);

      decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->nonce)::BaseType> nonce_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_nonce,
        nonce_fragment);

      fragment->nonce.Set(
          nonce_fragment.is_null() ? nullptr : nonce_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::NetworkIsolationPartition>(
        Traits::network_isolation_partition(input),
        &fragment->network_isolation_partition);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::NetworkAnonymizationKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::NetworkAnonymizationKeyDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::NetworkAnonymizationKey_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::NetworkAnonymizationKeyDataView::Tag::kEmpty: {
    decltype(Traits::empty(input))
    in_empty = Traits::empty(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_empty)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::EmptyNetworkAnonymizationKeyDataView, send_validation>(
  in_empty,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null empty in NetworkAnonymizationKey union");
    fragment->data.f_empty.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::NetworkAnonymizationKeyDataView::Tag::kNonEmpty: {
    decltype(Traits::non_empty(input))
    in_non_empty = Traits::non_empty(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_non_empty)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::NonEmptyNetworkAnonymizationKeyDataView, send_validation>(
  in_non_empty,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null non_empty in NetworkAnonymizationKey union");
    fragment->data.f_non_empty.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ANONYMIZATION_KEY_MOJOM_SEND_VALIDATION_H_