// services/network/public/mojom/net_log.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/net_log.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/net_log.mojom-params-data.h"
#include "services/network/public/mojom/net_log.mojom-shared-message-ids.h"

#include "services/network/public/mojom/net_log.mojom-import-headers.h"
#include "services/network/public/mojom/net_log.mojom-test-utils.h"


namespace network::mojom {
// The declaration includes the definition on other builds.
constexpr uint64_t NetLogExporter::kUnlimitedFileSize;

NetLogExporter::IPCStableHashFunction NetLogExporter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetLogExporter>(message.name())) {
    case messages::NetLogExporter::kStart: {
      return &NetLogExporter::Start_Sym::IPCStableHash;
    }
    case messages::NetLogExporter::kStop: {
      return &NetLogExporter::Stop_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetLogExporter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetLogExporter>(message.name())) {
      case messages::NetLogExporter::kStart:
            return "Receive network::mojom::NetLogExporter::Start";
      case messages::NetLogExporter::kStop:
            return "Receive network::mojom::NetLogExporter::Stop";
    }
  } else {
    switch (static_cast<messages::NetLogExporter>(message.name())) {
      case messages::NetLogExporter::kStart:
            return "Receive reply network::mojom::NetLogExporter::Start";
      case messages::NetLogExporter::kStop:
            return "Receive reply network::mojom::NetLogExporter::Stop";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetLogExporter::Start_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaa21392c;  // IPCStableHash for network::mojom::NetLogExporter::Start
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetLogExporter::Stop_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x891ecb4a;  // IPCStableHash for network::mojom::NetLogExporter::Stop
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class NetLogExporter_Start_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetLogExporter_Start_ForwardToCallback(
      NetLogExporter::StartCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetLogExporter_Start_ForwardToCallback(const NetLogExporter_Start_ForwardToCallback&) = delete;
  NetLogExporter_Start_ForwardToCallback& operator=(const NetLogExporter_Start_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetLogExporter::StartCallback callback_;
};

class NetLogExporter_Stop_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetLogExporter_Stop_ForwardToCallback(
      NetLogExporter::StopCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetLogExporter_Stop_ForwardToCallback(const NetLogExporter_Stop_ForwardToCallback&) = delete;
  NetLogExporter_Stop_ForwardToCallback& operator=(const NetLogExporter_Stop_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetLogExporter::StopCallback callback_;
};

NetLogExporterProxy::NetLogExporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetLogExporterProxy::Start(
    ::base::File in_destination, ::base::Value::Dict in_extra_constants, ::net::NetLogCaptureMode in_capture_mode, uint64_t in_max_file_size, StartCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetLogExporter::Start", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("destination"), in_destination,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extra_constants"), in_extra_constants,
                        "<value of type ::base::Value::Dict>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capture_mode"), in_capture_mode,
                        "<value of type ::net::NetLogCaptureMode>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_file_size"), in_max_file_size,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetLogExporter::kStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetLogExporter_Start_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->destination)::BaseType> destination_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_destination,
    destination_fragment);

  params->destination.Set(
      destination_fragment.is_null() ? nullptr : destination_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->destination.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null destination in NetLogExporter.Start request");
  mojo::internal::MessageFragment<
      typename decltype(params->extra_constants)::BaseType> extra_constants_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_extra_constants,
    extra_constants_fragment);

  params->extra_constants.Set(
      extra_constants_fragment.is_null() ? nullptr : extra_constants_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extra_constants.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extra_constants in NetLogExporter.Start request");

  
  mojo::internal::Serialize<::network::mojom::NetLogCaptureMode>(
    in_capture_mode,
    &params->capture_mode);

  params->max_file_size = in_max_file_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetLogExporter::Name_);
  message.set_method_name("Start");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetLogExporter_Start_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NetLogExporterProxy::Stop(
    ::base::Value::Dict in_polled_values, StopCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetLogExporter::Stop", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("polled_values"), in_polled_values,
                        "<value of type ::base::Value::Dict>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetLogExporter::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetLogExporter_Stop_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->polled_values)::BaseType> polled_values_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_polled_values,
    polled_values_fragment);

  params->polled_values.Set(
      polled_values_fragment.is_null() ? nullptr : polled_values_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->polled_values.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null polled_values in NetLogExporter.Stop request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetLogExporter::Name_);
  message.set_method_name("Stop");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetLogExporter_Stop_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class NetLogExporter_Start_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetLogExporter::StartCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetLogExporter_Start_ProxyToResponder> proxy(
        new NetLogExporter_Start_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetLogExporter_Start_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetLogExporter_Start_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetLogExporter_Start_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NetLogExporter::StartCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error);
};

bool NetLogExporter_Start_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetLogExporter_Start_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetLogExporter_Start_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetLogExporter.0
  bool success = true;
  int32_t p_net_error{};
  NetLogExporter_Start_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetLogExporter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_net_error));
  }
  return true;
}

void NetLogExporter_Start_ProxyToResponder::Run(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetLogExporter::Start", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetLogExporter::kStart), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetLogExporter_Start_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetLogExporter::Name_);
  message.set_method_name("Start");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetLogExporter_Stop_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetLogExporter::StopCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetLogExporter_Stop_ProxyToResponder> proxy(
        new NetLogExporter_Stop_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetLogExporter_Stop_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetLogExporter_Stop_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetLogExporter_Stop_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NetLogExporter::StopCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error);
};

bool NetLogExporter_Stop_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetLogExporter_Stop_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetLogExporter_Stop_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetLogExporter.1
  bool success = true;
  int32_t p_net_error{};
  NetLogExporter_Stop_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetLogExporter::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_net_error));
  }
  return true;
}

void NetLogExporter_Stop_ProxyToResponder::Run(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply network::mojom::NetLogExporter::Stop", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_error"), in_net_error,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetLogExporter::kStop), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetLogExporter_Stop_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->net_error = in_net_error;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetLogExporter::Name_);
  message.set_method_name("Stop");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NetLogExporterStubDispatch::Accept(
    NetLogExporter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetLogExporter>(message->header()->name)) {
    case messages::NetLogExporter::kStart: {
      break;
    }
    case messages::NetLogExporter::kStop: {
      break;
    }
  }
  return false;
}

// static
bool NetLogExporterStubDispatch::AcceptWithResponder(
    NetLogExporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetLogExporter>(message->header()->name)) {
    case messages::NetLogExporter::kStart: {
      internal::NetLogExporter_Start_Params_Data* params =
          reinterpret_cast<
              internal::NetLogExporter_Start_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetLogExporter.0
      bool success = true;
      ::base::File p_destination{};
      ::base::Value::Dict p_extra_constants{};
      ::net::NetLogCaptureMode p_capture_mode{};
      uint64_t p_max_file_size{};
      NetLogExporter_Start_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDestination(&p_destination))
        success = false;
      if (success && !input_data_view.ReadExtraConstants(&p_extra_constants))
        success = false;
      if (success && !input_data_view.ReadCaptureMode(&p_capture_mode))
        success = false;
      if (success)
        p_max_file_size = input_data_view.max_file_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetLogExporter::Name_, 0, false);
        return false;
      }
      auto callback =
          NetLogExporter_Start_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Start(        
        std::move(p_destination), 
        std::move(p_extra_constants), 
        std::move(p_capture_mode), 
        std::move(p_max_file_size), std::move(callback));
      return true;
    }
    case messages::NetLogExporter::kStop: {
      internal::NetLogExporter_Stop_Params_Data* params =
          reinterpret_cast<
              internal::NetLogExporter_Stop_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetLogExporter.1
      bool success = true;
      ::base::Value::Dict p_polled_values{};
      NetLogExporter_Stop_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPolledValues(&p_polled_values))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetLogExporter::Name_, 1, false);
        return false;
      }
      auto callback =
          NetLogExporter_Stop_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Stop(        
        std::move(p_polled_values), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNetLogExporterValidationInfo[] = {
    { &internal::NetLogExporter_Start_Params_Data::Validate,
     &internal::NetLogExporter_Start_ResponseParams_Data::Validate},
    { &internal::NetLogExporter_Stop_Params_Data::Validate,
     &internal::NetLogExporter_Stop_ResponseParams_Data::Validate},
};

bool NetLogExporterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::NetLogExporter::Name_,
    kNetLogExporterValidationInfo);
}

bool NetLogExporterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::network::mojom::NetLogExporter::Name_,
    kNetLogExporterValidationInfo);
}
// The declaration includes the definition on other builds.

NetLogProxySource::IPCStableHashFunction NetLogProxySource::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetLogProxySource>(message.name())) {
    case messages::NetLogProxySource::kUpdateCaptureModes: {
      return &NetLogProxySource::UpdateCaptureModes_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetLogProxySource::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetLogProxySource>(message.name())) {
      case messages::NetLogProxySource::kUpdateCaptureModes:
            return "Receive network::mojom::NetLogProxySource::UpdateCaptureModes";
    }
  } else {
    switch (static_cast<messages::NetLogProxySource>(message.name())) {
      case messages::NetLogProxySource::kUpdateCaptureModes:
            return "Receive reply network::mojom::NetLogProxySource::UpdateCaptureModes";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetLogProxySource::UpdateCaptureModes_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3b7284bd;  // IPCStableHash for network::mojom::NetLogProxySource::UpdateCaptureModes
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NetLogProxySourceProxy::NetLogProxySourceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetLogProxySourceProxy::UpdateCaptureModes(
    uint8_t in_modes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetLogProxySource::UpdateCaptureModes", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("modes"), in_modes,
                        "<value of type uint8_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetLogProxySource::kUpdateCaptureModes), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetLogProxySource_UpdateCaptureModes_Params_Data> params(
          message);
  params.Allocate();

  params->modes = in_modes;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetLogProxySource::Name_);
  message.set_method_name("UpdateCaptureModes");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NetLogProxySourceStubDispatch::Accept(
    NetLogProxySource* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetLogProxySource>(message->header()->name)) {
    case messages::NetLogProxySource::kUpdateCaptureModes: {
      DCHECK(message->is_serialized());
      internal::NetLogProxySource_UpdateCaptureModes_Params_Data* params =
          reinterpret_cast<internal::NetLogProxySource_UpdateCaptureModes_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetLogProxySource.0
      bool success = true;
      uint8_t p_modes{};
      NetLogProxySource_UpdateCaptureModes_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_modes = input_data_view.modes();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetLogProxySource::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateCaptureModes(        
        std::move(p_modes));
      return true;
    }
  }
  return false;
}

// static
bool NetLogProxySourceStubDispatch::AcceptWithResponder(
    NetLogProxySource* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetLogProxySource>(message->header()->name)) {
    case messages::NetLogProxySource::kUpdateCaptureModes: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNetLogProxySourceValidationInfo[] = {
    { &internal::NetLogProxySource_UpdateCaptureModes_Params_Data::Validate,
     nullptr /* no response */},
};

bool NetLogProxySourceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::NetLogProxySource::Name_,
    kNetLogProxySourceValidationInfo);
}

// The declaration includes the definition on other builds.

NetLogProxySink::IPCStableHashFunction NetLogProxySink::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetLogProxySink>(message.name())) {
    case messages::NetLogProxySink::kAddEntry: {
      return &NetLogProxySink::AddEntry_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetLogProxySink::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetLogProxySink>(message.name())) {
      case messages::NetLogProxySink::kAddEntry:
            return "Receive network::mojom::NetLogProxySink::AddEntry";
    }
  } else {
    switch (static_cast<messages::NetLogProxySink>(message.name())) {
      case messages::NetLogProxySink::kAddEntry:
            return "Receive reply network::mojom::NetLogProxySink::AddEntry";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetLogProxySink::AddEntry_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x25ed6544;  // IPCStableHash for network::mojom::NetLogProxySink::AddEntry
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NetLogProxySinkProxy::NetLogProxySinkProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetLogProxySinkProxy::AddEntry(
    uint32_t in_type, const ::net::NetLogSource& in_net_log_source, ::net::NetLogEventPhase in_phase, ::base::TimeTicks in_time, ::base::Value::Dict in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::NetLogProxySink::AddEntry", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("net_log_source"), in_net_log_source,
                        "<value of type const ::net::NetLogSource&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("phase"), in_phase,
                        "<value of type ::net::NetLogEventPhase>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type ::base::TimeTicks>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::base::Value::Dict>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetLogProxySink::kAddEntry), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::NetLogProxySink_AddEntry_Params_Data> params(
          message);
  params.Allocate();

  params->type = in_type;
  mojo::internal::MessageFragment<
      typename decltype(params->net_log_source)::BaseType> net_log_source_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::NetLogSourceDataView>(
    in_net_log_source,
    net_log_source_fragment);

  params->net_log_source.Set(
      net_log_source_fragment.is_null() ? nullptr : net_log_source_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->net_log_source.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null net_log_source in NetLogProxySink.AddEntry request");

  
  mojo::internal::Serialize<::network::mojom::NetLogEventPhase>(
    in_phase,
    &params->phase);
  mojo::internal::MessageFragment<
      typename decltype(params->time)::BaseType> time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
    in_time,
    time_fragment);

  params->time.Set(
      time_fragment.is_null() ? nullptr : time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null time in NetLogProxySink.AddEntry request");
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in NetLogProxySink.AddEntry request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetLogProxySink::Name_);
  message.set_method_name("AddEntry");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NetLogProxySinkStubDispatch::Accept(
    NetLogProxySink* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetLogProxySink>(message->header()->name)) {
    case messages::NetLogProxySink::kAddEntry: {
      DCHECK(message->is_serialized());
      internal::NetLogProxySink_AddEntry_Params_Data* params =
          reinterpret_cast<internal::NetLogProxySink_AddEntry_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NetLogProxySink.0
      bool success = true;
      uint32_t p_type{};
      ::net::NetLogSource p_net_log_source{};
      ::net::NetLogEventPhase p_phase{};
      ::base::TimeTicks p_time{};
      ::base::Value::Dict p_params{};
      NetLogProxySink_AddEntry_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_type = input_data_view.type();
      if (success && !input_data_view.ReadNetLogSource(&p_net_log_source))
        success = false;
      if (success && !input_data_view.ReadPhase(&p_phase))
        success = false;
      if (success && !input_data_view.ReadTime(&p_time))
        success = false;
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetLogProxySink::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddEntry(        
        std::move(p_type), 
        std::move(p_net_log_source), 
        std::move(p_phase), 
        std::move(p_time), 
        std::move(p_params));
      return true;
    }
  }
  return false;
}

// static
bool NetLogProxySinkStubDispatch::AcceptWithResponder(
    NetLogProxySink* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetLogProxySink>(message->header()->name)) {
    case messages::NetLogProxySink::kAddEntry: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNetLogProxySinkValidationInfo[] = {
    { &internal::NetLogProxySink_AddEntry_Params_Data::Validate,
     nullptr /* no response */},
};

bool NetLogProxySinkRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::network::mojom::NetLogProxySink::Name_,
    kNetLogProxySinkValidationInfo);
}



}  // network::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void NetLogExporterInterceptorForTesting::Start(::base::File destination, ::base::Value::Dict extra_constants, ::net::NetLogCaptureMode capture_mode, uint64_t max_file_size, StartCallback callback) {
  GetForwardingInterface()->Start(
    std::move(destination)
    , 
    std::move(extra_constants)
    , 
    std::move(capture_mode)
    , 
    std::move(max_file_size)
    , std::move(callback));
}
void NetLogExporterInterceptorForTesting::Stop(::base::Value::Dict polled_values, StopCallback callback) {
  GetForwardingInterface()->Stop(
    std::move(polled_values)
    , std::move(callback));
}
NetLogExporterAsyncWaiter::NetLogExporterAsyncWaiter(
    NetLogExporter* proxy) : proxy_(proxy) {}

NetLogExporterAsyncWaiter::~NetLogExporterAsyncWaiter() = default;


void NetLogExporterAsyncWaiter::Start(
    ::base::File destination, ::base::Value::Dict extra_constants, ::net::NetLogCaptureMode capture_mode, uint64_t max_file_size, int32_t* out_net_error) {
  base::RunLoop loop;
  proxy_->Start(
      std::move(destination),
      std::move(extra_constants),
      std::move(capture_mode),
      std::move(max_file_size),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             int32_t net_error) {*out_net_error = std::move(net_error);
            loop->Quit();
          },
          &loop,
          out_net_error));
  loop.Run();
}

int32_t NetLogExporterAsyncWaiter::Start(
    ::base::File destination, ::base::Value::Dict extra_constants, ::net::NetLogCaptureMode capture_mode, uint64_t max_file_size) {
  int32_t async_wait_result;
  Start(std::move(destination),std::move(extra_constants),std::move(capture_mode),std::move(max_file_size),&async_wait_result);
  return async_wait_result;
}

void NetLogExporterAsyncWaiter::Stop(
    ::base::Value::Dict polled_values, int32_t* out_net_error) {
  base::RunLoop loop;
  proxy_->Stop(
      std::move(polled_values),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_net_error
,
             int32_t net_error) {*out_net_error = std::move(net_error);
            loop->Quit();
          },
          &loop,
          out_net_error));
  loop.Run();
}

int32_t NetLogExporterAsyncWaiter::Stop(
    ::base::Value::Dict polled_values) {
  int32_t async_wait_result;
  Stop(std::move(polled_values),&async_wait_result);
  return async_wait_result;
}




void NetLogProxySourceInterceptorForTesting::UpdateCaptureModes(uint8_t modes) {
  GetForwardingInterface()->UpdateCaptureModes(
    std::move(modes)
    );
}
NetLogProxySourceAsyncWaiter::NetLogProxySourceAsyncWaiter(
    NetLogProxySource* proxy) : proxy_(proxy) {}

NetLogProxySourceAsyncWaiter::~NetLogProxySourceAsyncWaiter() = default;





void NetLogProxySinkInterceptorForTesting::AddEntry(uint32_t type, const ::net::NetLogSource& net_log_source, ::net::NetLogEventPhase phase, ::base::TimeTicks time, ::base::Value::Dict params) {
  GetForwardingInterface()->AddEntry(
    std::move(type)
    , 
    std::move(net_log_source)
    , 
    std::move(phase)
    , 
    std::move(time)
    , 
    std::move(params)
    );
}
NetLogProxySinkAsyncWaiter::NetLogProxySinkAsyncWaiter(
    NetLogProxySink* proxy) : proxy_(proxy) {}

NetLogProxySinkAsyncWaiter::~NetLogProxySinkAsyncWaiter() = default;







}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif