// services/network/public/mojom/integrity_policy.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/integrity_policy.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/integrity_policy.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* IntegrityPolicy_DestinationToStringHelper(IntegrityPolicy_Destination value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IntegrityPolicy_Destination::kScript:
      return "kScript";
    default:
      return nullptr;
  }
}

std::string IntegrityPolicy_DestinationToString(IntegrityPolicy_Destination value) {
  const char *str = IntegrityPolicy_DestinationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IntegrityPolicy_Destination value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IntegrityPolicy_Destination value) {
  return os << IntegrityPolicy_DestinationToString(value);
}

NOINLINE static const char* IntegrityPolicy_SourceToStringHelper(IntegrityPolicy_Source value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IntegrityPolicy_Source::kInline:
      return "kInline";
    default:
      return nullptr;
  }
}

std::string IntegrityPolicy_SourceToString(IntegrityPolicy_Source value) {
  const char *str = IntegrityPolicy_SourceToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IntegrityPolicy_Source value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IntegrityPolicy_Source value) {
  return os << IntegrityPolicy_SourceToString(value);
}

namespace internal {


// static
bool IntegrityPolicy_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const IntegrityPolicy_Data* object =
      static_cast<const IntegrityPolicy_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->blocked_destinations, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& blocked_destinations_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::IntegrityPolicy_Destination_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->blocked_destinations, validation_context,
                                         &blocked_destinations_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sources, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::IntegrityPolicy_Source_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->sources, validation_context,
                                         &sources_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->endpoints, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->endpoints, validation_context,
                                         &endpoints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parsing_errors, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& parsing_errors_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->parsing_errors, validation_context,
                                         &parsing_errors_validate_params)) {
    return false;
  }

  return true;
}

IntegrityPolicy_Data::IntegrityPolicy_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::IntegrityPolicy_Destination>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::IntegrityPolicy_Destination value) {
  return std::move(context).WriteString(::network::mojom::IntegrityPolicy_DestinationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::IntegrityPolicy_Source>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::IntegrityPolicy_Source value) {
  return std::move(context).WriteString(::network::mojom::IntegrityPolicy_SourceToString(value));
}

} // namespace perfetto