// services/network/public/mojom/fetch_retry_options.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/fetch_retry_options.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/fetch_retry_options.mojom-params-data.h"
#include "services/network/public/mojom/fetch_retry_options.mojom-shared-message-ids.h"

#include "services/network/public/mojom/fetch_retry_options.mojom-blink-import-headers.h"
#include "services/network/public/mojom/fetch_retry_options.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
FetchRetryOptions::FetchRetryOptions()
    : max_attempts(),
      initial_delay(),
      backoff_factor(),
      max_age(),
      retry_after_unload(false),
      retry_non_idempotent(false),
      retry_only_if_server_unreached(false) {}

FetchRetryOptions::FetchRetryOptions(
    uint32_t max_attempts_in,
    std::optional<::base::TimeDelta> initial_delay_in,
    std::optional<double> backoff_factor_in,
    std::optional<::base::TimeDelta> max_age_in,
    bool retry_after_unload_in,
    bool retry_non_idempotent_in,
    bool retry_only_if_server_unreached_in)
    : max_attempts(std::move(max_attempts_in)),
      initial_delay(std::move(initial_delay_in)),
      backoff_factor(std::move(backoff_factor_in)),
      max_age(std::move(max_age_in)),
      retry_after_unload(std::move(retry_after_unload_in)),
      retry_non_idempotent(std::move(retry_non_idempotent_in)),
      retry_only_if_server_unreached(std::move(retry_only_if_server_unreached_in)) {}

FetchRetryOptions::~FetchRetryOptions() = default;

void FetchRetryOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_attempts"), this->max_attempts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "initial_delay"), this->initial_delay,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "backoff_factor"), this->backoff_factor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<double>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_age"), this->max_age,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "retry_after_unload"), this->retry_after_unload,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "retry_non_idempotent"), this->retry_non_idempotent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "retry_only_if_server_unreached"), this->retry_only_if_server_unreached,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FetchRetryOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::FetchRetryOptions::DataView, ::network::mojom::blink::FetchRetryOptionsPtr>::Read(
    ::network::mojom::blink::FetchRetryOptions::DataView input,
    ::network::mojom::blink::FetchRetryOptionsPtr* output) {
  bool success = true;
  ::network::mojom::blink::FetchRetryOptionsPtr result(::network::mojom::blink::FetchRetryOptions::New());
  
      if (success)
        result->max_attempts = input.max_attempts();
      if (success && !input.ReadInitialDelay(&result->initial_delay))
        success = false;
      if (success) {
        result->backoff_factor = input.backoff_factor();
      }
      if (success && !input.ReadMaxAge(&result->max_age))
        success = false;
      if (success)
        result->retry_after_unload = input.retry_after_unload();
      if (success)
        result->retry_non_idempotent = input.retry_non_idempotent();
      if (success)
        result->retry_only_if_server_unreached = input.retry_only_if_server_unreached();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {




}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif