// services/network/public/mojom/device_bound_sessions.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  ClearDataFilter as network_mojom_ClearDataFilter,
  ClearDataFilterSpec as network_mojom_ClearDataFilterSpec
} from './clear_data_filter.mojom.m.js';

import {
  SchemefulSite as network_mojom_SchemefulSite,
  SchemefulSiteSpec as network_mojom_SchemefulSiteSpec
} from './schemeful_site.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DeviceBoundSessionAccessTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DeviceBoundSessionAccessType = {
  
  kCreation: 0,
  kUpdate: 1,
  kTermination: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DeviceBoundSessionUsageSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DeviceBoundSessionUsage = {
  
  kUnknown: 0,
  kNoUsage: 1,
  kInScopeNotDeferred: 2,
  kDeferred: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DeviceBoundSessionDeletionReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DeviceBoundSessionDeletionReason = {
  
  kExpired: 0,
  kFailedToRestoreKey: 1,
  kFailedToUnwrapKey: 2,
  kStoragePartitionCleared: 3,
  kClearBrowsingData: 4,
  kServerRequested: 5,
  kInvalidSessionParams: 6,
  kRefreshFatalError: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DeviceBoundSessionManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.DeviceBoundSessionManager', scope);
  }
}

/** @interface */
export class DeviceBoundSessionManagerInterface {
  
  /**
   * @return {!Promise<{
        sessions: !Array<!DeviceBoundSessionKey>,
   *  }>}
   */

  getAllSessions() {}
  
  /**
   * @param { !DeviceBoundSessionDeletionReason } reason
   * @param { !DeviceBoundSessionKey } session
   */

  deleteSession(reason, session) {}
  
  /**
   * @param { !DeviceBoundSessionDeletionReason } reason
   * @param { ?mojoBase_mojom_Time } createdAfterTime
   * @param { ?mojoBase_mojom_Time } createdBeforeTime
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  deleteAllSessions(reason, createdAfterTime, createdBeforeTime, filter) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !DeviceBoundSessionAccessObserverRemote } observer
   */

  addObserver(url, observer) {}
}

/**
 * @implements { DeviceBoundSessionManagerInterface }
 */
export class DeviceBoundSessionManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DeviceBoundSessionManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DeviceBoundSessionManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DeviceBoundSessionManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        sessions: !Array<!DeviceBoundSessionKey>,
   *  }>}
   */

  getAllSessions() {
    return this.proxy.sendMessage(
        0,
        DeviceBoundSessionManager_GetAllSessions_ParamsSpec.$,
        DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !DeviceBoundSessionDeletionReason } reason
   * @param { !DeviceBoundSessionKey } session
   */

  deleteSession(
      reason,
      session) {
    this.proxy.sendMessage(
        1,
        DeviceBoundSessionManager_DeleteSession_ParamsSpec.$,
        null,
        [
          reason,
          session
        ],
        false);
  }

  
  /**
   * @param { !DeviceBoundSessionDeletionReason } reason
   * @param { ?mojoBase_mojom_Time } createdAfterTime
   * @param { ?mojoBase_mojom_Time } createdBeforeTime
   * @param { ?network_mojom_ClearDataFilter } filter
   * @return {!Promise}
   */

  deleteAllSessions(
      reason,
      createdAfterTime,
      createdBeforeTime,
      filter) {
    return this.proxy.sendMessage(
        2,
        DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec.$,
        DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec.$,
        [
          reason,
          createdAfterTime,
          createdBeforeTime,
          filter
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !DeviceBoundSessionAccessObserverRemote } observer
   */

  addObserver(
      url,
      observer) {
    this.proxy.sendMessage(
        3,
        DeviceBoundSessionManager_AddObserver_ParamsSpec.$,
        null,
        [
          url,
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DeviceBoundSessionManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DeviceBoundSessionManagerReceiver {
  /**
   * @param {!DeviceBoundSessionManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DeviceBoundSessionManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DeviceBoundSessionManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DeviceBoundSessionManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DeviceBoundSessionManager_GetAllSessions_ParamsSpec.$,
        DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec.$,
        impl.getAllSessions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DeviceBoundSessionManager_DeleteSession_ParamsSpec.$,
        null,
        impl.deleteSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec.$,
        DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec.$,
        impl.deleteAllSessions.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        DeviceBoundSessionManager_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DeviceBoundSessionManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DeviceBoundSessionManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DeviceBoundSessionManagerRemote}
   */
  static getRemote() {
    let remote = new DeviceBoundSessionManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DeviceBoundSessionManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DeviceBoundSessionManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DeviceBoundSessionManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DeviceBoundSessionManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllSessions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DeviceBoundSessionManager_GetAllSessions_ParamsSpec.$,
        DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec.$,
        this.getAllSessions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DeviceBoundSessionManager_DeleteSession_ParamsSpec.$,
        null,
        this.deleteSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteAllSessions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec.$,
        DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec.$,
        this.deleteAllSessions.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        DeviceBoundSessionManager_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DeviceBoundSessionAccessObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.DeviceBoundSessionAccessObserver', scope);
  }
}

/** @interface */
export class DeviceBoundSessionAccessObserverInterface {
  
  /**
   * @param { !DeviceBoundSessionAccess } access
   */

  onDeviceBoundSessionAccessed(access) {}
  
  /**
   * @param { !DeviceBoundSessionAccessObserverPendingReceiver } observer
   */

  clone(observer) {}
}

/**
 * @implements { DeviceBoundSessionAccessObserverInterface }
 */
export class DeviceBoundSessionAccessObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DeviceBoundSessionAccessObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DeviceBoundSessionAccessObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DeviceBoundSessionAccessObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !DeviceBoundSessionAccess } access
   */

  onDeviceBoundSessionAccessed(
      access) {
    this.proxy.sendMessage(
        0,
        DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec.$,
        null,
        [
          access
        ],
        false);
  }

  
  /**
   * @param { !DeviceBoundSessionAccessObserverPendingReceiver } observer
   */

  clone(
      observer) {
    this.proxy.sendMessage(
        1,
        DeviceBoundSessionAccessObserver_Clone_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DeviceBoundSessionAccessObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DeviceBoundSessionAccessObserverReceiver {
  /**
   * @param {!DeviceBoundSessionAccessObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DeviceBoundSessionAccessObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DeviceBoundSessionAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DeviceBoundSessionAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec.$,
        null,
        impl.onDeviceBoundSessionAccessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DeviceBoundSessionAccessObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DeviceBoundSessionAccessObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DeviceBoundSessionAccessObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DeviceBoundSessionAccessObserverRemote}
   */
  static getRemote() {
    let remote = new DeviceBoundSessionAccessObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DeviceBoundSessionAccessObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DeviceBoundSessionAccessObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DeviceBoundSessionAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DeviceBoundSessionAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceBoundSessionAccessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec.$,
        null,
        this.onDeviceBoundSessionAccessed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DeviceBoundSessionAccessObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeviceBoundSessionKeySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeviceBoundSessionAccessSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeviceBoundSessionManager_GetAllSessions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeviceBoundSessionManager_DeleteSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeviceBoundSessionManager_AddObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DeviceBoundSessionAccessObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DeviceBoundSessionKeySpec.$,
    'DeviceBoundSessionKey',
    [
      mojo.internal.StructField(
        'site', 0,
        0,
        network_mojom_SchemefulSiteSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DeviceBoundSessionKey {
  constructor() {
    /** @type { !network_mojom_SchemefulSite } */
    this.site;
    /** @type { !string } */
    this.id;
  }
}



mojo.internal.Struct(
    DeviceBoundSessionAccessSpec.$,
    'DeviceBoundSessionAccess',
    [
      mojo.internal.StructField(
        'accessType', 0,
        0,
        DeviceBoundSessionAccessTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionKey', 8,
        0,
        DeviceBoundSessionKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookies', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class DeviceBoundSessionAccess {
  constructor() {
    /** @type { !DeviceBoundSessionAccessType } */
    this.accessType;
    /** @type { !DeviceBoundSessionKey } */
    this.sessionKey;
    /** @type { !Array<!string> } */
    this.cookies;
  }
}



mojo.internal.Struct(
    DeviceBoundSessionManager_GetAllSessions_ParamsSpec.$,
    'DeviceBoundSessionManager_GetAllSessions_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DeviceBoundSessionManager_GetAllSessions_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DeviceBoundSessionManager_GetAllSessions_ResponseParamsSpec.$,
    'DeviceBoundSessionManager_GetAllSessions_ResponseParams',
    [
      mojo.internal.StructField(
        'sessions', 0,
        0,
        mojo.internal.Array(DeviceBoundSessionKeySpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DeviceBoundSessionManager_GetAllSessions_ResponseParams {
  constructor() {
    /** @type { !Array<!DeviceBoundSessionKey> } */
    this.sessions;
  }
}



mojo.internal.Struct(
    DeviceBoundSessionManager_DeleteSession_ParamsSpec.$,
    'DeviceBoundSessionManager_DeleteSession_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        DeviceBoundSessionDeletionReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'session', 8,
        0,
        DeviceBoundSessionKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DeviceBoundSessionManager_DeleteSession_Params {
  constructor() {
    /** @type { !DeviceBoundSessionDeletionReason } */
    this.reason;
    /** @type { !DeviceBoundSessionKey } */
    this.session;
  }
}



mojo.internal.Struct(
    DeviceBoundSessionManager_DeleteAllSessions_ParamsSpec.$,
    'DeviceBoundSessionManager_DeleteAllSessions_Params',
    [
      mojo.internal.StructField(
        'reason', 0,
        0,
        DeviceBoundSessionDeletionReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'createdAfterTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'createdBeforeTime', 16,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'filter', 24,
        0,
        network_mojom_ClearDataFilterSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class DeviceBoundSessionManager_DeleteAllSessions_Params {
  constructor() {
    /** @type { !DeviceBoundSessionDeletionReason } */
    this.reason;
    /** @type { (mojoBase_mojom_Time|undefined) } */
    this.createdAfterTime;
    /** @type { (mojoBase_mojom_Time|undefined) } */
    this.createdBeforeTime;
    /** @type { (network_mojom_ClearDataFilter|undefined) } */
    this.filter;
  }
}



mojo.internal.Struct(
    DeviceBoundSessionManager_DeleteAllSessions_ResponseParamsSpec.$,
    'DeviceBoundSessionManager_DeleteAllSessions_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DeviceBoundSessionManager_DeleteAllSessions_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    DeviceBoundSessionManager_AddObserver_ParamsSpec.$,
    'DeviceBoundSessionManager_AddObserver_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 8,
        0,
        mojo.internal.InterfaceProxy(DeviceBoundSessionAccessObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DeviceBoundSessionManager_AddObserver_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !DeviceBoundSessionAccessObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_ParamsSpec.$,
    'DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params',
    [
      mojo.internal.StructField(
        'access', 0,
        0,
        DeviceBoundSessionAccessSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params {
  constructor() {
    /** @type { !DeviceBoundSessionAccess } */
    this.access;
  }
}



mojo.internal.Struct(
    DeviceBoundSessionAccessObserver_Clone_ParamsSpec.$,
    'DeviceBoundSessionAccessObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceRequest(DeviceBoundSessionAccessObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DeviceBoundSessionAccessObserver_Clone_Params {
  constructor() {
    /** @type { !DeviceBoundSessionAccessObserverPendingReceiver } */
    this.observer;
  }
}

