// services/network/public/mojom/device_bound_sessions.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/device_bound_sessions.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/device_bound_sessions.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* DeviceBoundSessionAccessTypeToStringHelper(DeviceBoundSessionAccessType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeviceBoundSessionAccessType::kCreation:
      return "kCreation";
    case DeviceBoundSessionAccessType::kUpdate:
      return "kUpdate";
    case DeviceBoundSessionAccessType::kTermination:
      return "kTermination";
    default:
      return nullptr;
  }
}

std::string DeviceBoundSessionAccessTypeToString(DeviceBoundSessionAccessType value) {
  const char *str = DeviceBoundSessionAccessTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeviceBoundSessionAccessType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeviceBoundSessionAccessType value) {
  return os << DeviceBoundSessionAccessTypeToString(value);
}

NOINLINE static const char* DeviceBoundSessionUsageToStringHelper(DeviceBoundSessionUsage value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeviceBoundSessionUsage::kUnknown:
      return "kUnknown";
    case DeviceBoundSessionUsage::kNoUsage:
      return "kNoUsage";
    case DeviceBoundSessionUsage::kInScopeNotDeferred:
      return "kInScopeNotDeferred";
    case DeviceBoundSessionUsage::kDeferred:
      return "kDeferred";
    default:
      return nullptr;
  }
}

std::string DeviceBoundSessionUsageToString(DeviceBoundSessionUsage value) {
  const char *str = DeviceBoundSessionUsageToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeviceBoundSessionUsage value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeviceBoundSessionUsage value) {
  return os << DeviceBoundSessionUsageToString(value);
}

NOINLINE static const char* DeviceBoundSessionDeletionReasonToStringHelper(DeviceBoundSessionDeletionReason value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DeviceBoundSessionDeletionReason::kExpired:
      return "kExpired";
    case DeviceBoundSessionDeletionReason::kFailedToRestoreKey:
      return "kFailedToRestoreKey";
    case DeviceBoundSessionDeletionReason::kFailedToUnwrapKey:
      return "kFailedToUnwrapKey";
    case DeviceBoundSessionDeletionReason::kStoragePartitionCleared:
      return "kStoragePartitionCleared";
    case DeviceBoundSessionDeletionReason::kClearBrowsingData:
      return "kClearBrowsingData";
    case DeviceBoundSessionDeletionReason::kServerRequested:
      return "kServerRequested";
    case DeviceBoundSessionDeletionReason::kInvalidSessionParams:
      return "kInvalidSessionParams";
    case DeviceBoundSessionDeletionReason::kRefreshFatalError:
      return "kRefreshFatalError";
    default:
      return nullptr;
  }
}

std::string DeviceBoundSessionDeletionReasonToString(DeviceBoundSessionDeletionReason value) {
  const char *str = DeviceBoundSessionDeletionReasonToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DeviceBoundSessionDeletionReason value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DeviceBoundSessionDeletionReason value) {
  return os << DeviceBoundSessionDeletionReasonToString(value);
}

namespace internal {


// static
bool DeviceBoundSessionKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionKey_Data* object =
      static_cast<const DeviceBoundSessionKey_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->site, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->site, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

DeviceBoundSessionKey_Data::DeviceBoundSessionKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionAccess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionAccess_Data* object =
      static_cast<const DeviceBoundSessionAccess_Data*>(data);


  if (!::network::mojom::internal::DeviceBoundSessionAccessType_Data
        ::Validate(object->access_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookies_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->cookies, validation_context,
                                         &cookies_validate_params)) {
    return false;
  }

  return true;
}

DeviceBoundSessionAccess_Data::DeviceBoundSessionAccess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_GetAllSessions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_GetAllSessions_Params_Data* object =
      static_cast<const DeviceBoundSessionManager_GetAllSessions_Params_Data*>(data);

  return true;
}

DeviceBoundSessionManager_GetAllSessions_Params_Data::DeviceBoundSessionManager_GetAllSessions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data* object =
      static_cast<const DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sessions, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sessions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sessions, validation_context,
                                         &sessions_validate_params)) {
    return false;
  }

  return true;
}

DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data::DeviceBoundSessionManager_GetAllSessions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_DeleteSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_DeleteSession_Params_Data* object =
      static_cast<const DeviceBoundSessionManager_DeleteSession_Params_Data*>(data);


  if (!::network::mojom::internal::DeviceBoundSessionDeletionReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session, validation_context))
    return false;

  return true;
}

DeviceBoundSessionManager_DeleteSession_Params_Data::DeviceBoundSessionManager_DeleteSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_DeleteAllSessions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_DeleteAllSessions_Params_Data* object =
      static_cast<const DeviceBoundSessionManager_DeleteAllSessions_Params_Data*>(data);


  if (!::network::mojom::internal::DeviceBoundSessionDeletionReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->created_after_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->created_before_time, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->filter, validation_context))
    return false;

  return true;
}

DeviceBoundSessionManager_DeleteAllSessions_Params_Data::DeviceBoundSessionManager_DeleteAllSessions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data* object =
      static_cast<const DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data*>(data);

  return true;
}

DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data::DeviceBoundSessionManager_DeleteAllSessions_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionManager_AddObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionManager_AddObserver_Params_Data* object =
      static_cast<const DeviceBoundSessionManager_AddObserver_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DeviceBoundSessionManager_AddObserver_Params_Data::DeviceBoundSessionManager_AddObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data* object =
      static_cast<const DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->access, validation_context))
    return false;

  return true;
}

DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data::DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceBoundSessionAccessObserver_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceBoundSessionAccessObserver_Clone_Params_Data* object =
      static_cast<const DeviceBoundSessionAccessObserver_Clone_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DeviceBoundSessionAccessObserver_Clone_Params_Data::DeviceBoundSessionAccessObserver_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::DeviceBoundSessionAccessType>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionAccessType value) {
  return std::move(context).WriteString(::network::mojom::DeviceBoundSessionAccessTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::DeviceBoundSessionUsage>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionUsage value) {
  return std::move(context).WriteString(::network::mojom::DeviceBoundSessionUsageToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::DeviceBoundSessionDeletionReason>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionDeletionReason value) {
  return std::move(context).WriteString(::network::mojom::DeviceBoundSessionDeletionReasonToString(value));
}

} // namespace perfetto