// services/network/public/mojom/cookie_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ContentSettingPatternSource as contentSettings_mojom_ContentSettingPatternSource,
  ContentSettingPatternSourceSpec as contentSettings_mojom_ContentSettingPatternSourceSpec
} from '../../../../components/content_settings/core/common/content_settings.mojom.m.js';

import {
  ContentSettingsType as contentSettings_mojom_ContentSettingsType,
  ContentSettingsTypeSpec as contentSettings_mojom_ContentSettingsTypeSpec
} from '../../../../components/content_settings/core/common/content_settings_types.mojom.m.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec,
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  CookiePartitionKey as network_mojom_CookiePartitionKey,
  CookiePartitionKeySpec as network_mojom_CookiePartitionKeySpec,
  CookiePartitionKeyCollection as network_mojom_CookiePartitionKeyCollection,
  CookiePartitionKeyCollectionSpec as network_mojom_CookiePartitionKeyCollectionSpec
} from './cookie_partition_key.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieAccessDelegateTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieAccessDelegateType = {
  
  USE_CONTENT_SETTINGS: 0,
  ALWAYS_LEGACY: 1,
  ALWAYS_NONLEGACY: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookiePrioritySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookiePriority = {
  
  LOW: 0,
  MEDIUM: 1,
  HIGH: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieSourceSchemeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieSourceScheme = {
  
  kUnset: 0,
  kNonSecure: 1,
  kSecure: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieSameSiteSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieSameSite = {
  
  UNSPECIFIED: -1,
  NO_RESTRICTION: 0,
  LAX_MODE: 1,
  STRICT_MODE: 2,
  MIN_VALUE: -1,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieEffectiveSameSiteSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieEffectiveSameSite = {
  
  kNoRestriction: 0,
  kLaxMode: 1,
  kStrictMode: 2,
  kLaxModeAllowUnsafe: 3,
  kUndefined: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieExemptionReasonSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieExemptionReason = {
  
  kNone: 0,
  kUserSetting: 1,
  k3PCDMetadata: 2,
  k3PCDDeprecationTrial: 3,
  kTopLevel3PCDDeprecationTrial: 4,
  k3PCDHeuristics: 5,
  kEnterprisePolicy: 6,
  kStorageAccess: 7,
  kTopLevelStorageAccess: 8,
  kScheme: 9,
  kSameSiteNoneCookiesInSandbox: 10,
  MIN_VALUE: 0,
  MAX_VALUE: 10,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ContextTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ContextType = {
  
  CROSS_SITE: 0,
  SAME_SITE_LAX_METHOD_UNSAFE: 1,
  SAME_SITE_LAX: 2,
  SAME_SITE_STRICT: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieSameSiteContextMetadataDowngradeTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieSameSiteContextMetadataDowngradeType = {
  
  kNoDowngrade: 0,
  kStrictToLax: 1,
  kStrictToCross: 2,
  kLaxToCross: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieSourceTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieSourceType = {
  
  kUnknown: 0,
  kHTTP: 1,
  kScript: 2,
  kOther: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ContextRedirectTypeBug1221316Spec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ContextRedirectTypeBug1221316 = {
  
  kUnset: 0,
  kNoRedirect: 1,
  kCrossSiteRedirect: 2,
  kPartialSameSiteRedirect: 3,
  kAllSameSiteRedirect: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const HttpMethodSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const HttpMethod = {
  
  kUnset: 0,
  kUnknown: 1,
  kGet: 2,
  kHead: 3,
  kPost: 4,
  KPut: 5,
  kDelete: 6,
  kConnect: 7,
  kOptions: 8,
  kTrace: 9,
  kPatch: 10,
  MIN_VALUE: 0,
  MAX_VALUE: 10,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieAccessSemanticsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieAccessSemantics = {
  
  UNKNOWN: -1,
  NONLEGACY: 0,
  LEGACY: 1,
  MIN_VALUE: -1,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieScopeSemanticsSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieScopeSemantics = {
  
  UNKNOWN: -1,
  NONLEGACY: 0,
  LEGACY: 1,
  MIN_VALUE: -1,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieChangeCauseSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieChangeCause = {
  
  INSERTED: 0,
  EXPLICIT: 1,
  UNKNOWN_DELETION: 2,
  OVERWRITE: 3,
  EXPIRED: 4,
  EVICTED: 5,
  EXPIRED_OVERWRITE: 6,
  INSERTED_NO_CHANGE_OVERWRITE: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieDeletionSessionControlSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieDeletionSessionControl = {
  
  IGNORE_CONTROL: 0,
  SESSION_COOKIES: 1,
  PERSISTENT_COOKIES: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CookieChangeListenerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.CookieChangeListener', scope);
  }
}

/** @interface */
export class CookieChangeListenerInterface {
  
  /**
   * @param { !CookieChangeInfo } change
   */

  onCookieChange(change) {}
}

/**
 * @implements { CookieChangeListenerInterface }
 */
export class CookieChangeListenerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CookieChangeListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CookieChangeListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CookieChangeListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !CookieChangeInfo } change
   */

  onCookieChange(
      change) {
    this.proxy.sendMessage(
        0,
        CookieChangeListener_OnCookieChange_ParamsSpec.$,
        null,
        [
          change
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CookieChangeListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CookieChangeListenerReceiver {
  /**
   * @param {!CookieChangeListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CookieChangeListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CookieChangeListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CookieChangeListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CookieChangeListener_OnCookieChange_ParamsSpec.$,
        null,
        impl.onCookieChange.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CookieChangeListener {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CookieChangeListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CookieChangeListenerRemote}
   */
  static getRemote() {
    let remote = new CookieChangeListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CookieChangeListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CookieChangeListenerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CookieChangeListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CookieChangeListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCookieChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CookieChangeListener_OnCookieChange_ParamsSpec.$,
        null,
        this.onCookieChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CookieManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.CookieManager', scope);
  }
}

/** @interface */
export class CookieManagerInterface {
  
  /**
   * @return {!Promise<{
        cookies: !Array<!CanonicalCookie>,
   *  }>}
   */

  getAllCookies() {}
  
  /**
   * @return {!Promise<{
        cookies: !Array<!CanonicalCookie>,
        accessSemanticsList: !Array<!CookieAccessSemantics>,
   *  }>}
   */

  getAllCookiesWithAccessSemantics() {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !CookieOptions } cookieOptions
   * @param { !network_mojom_CookiePartitionKeyCollection } cookiePartitionKeyCollection
   * @return {!Promise<{
        cookies: !Array<!CookieWithAccessResult>,
        excludedCookies: !Array<!CookieWithAccessResult>,
   *  }>}
   */

  getCookieList(url, cookieOptions, cookiePartitionKeyCollection) {}
  
  /**
   * @param { !CanonicalCookie } cookie
   * @param { !url_mojom_Url } sourceUrl
   * @param { !CookieOptions } cookieOptions
   * @return {!Promise<{
        accessResult: !CookieAccessResult,
   *  }>}
   */

  setCanonicalCookie(cookie, sourceUrl, cookieOptions) {}
  
  /**
   * @param { !CanonicalCookie } cookie
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteCanonicalCookie(cookie) {}
  
  /**
   * @param { !CookieDeletionFilter } filter
   * @return {!Promise<{
        numDeleted: !number,
   *  }>}
   */

  deleteCookies(filter) {}
  
  /**
   * @return {!Promise<{
        numDeleted: !number,
   *  }>}
   */

  deleteSessionOnlyCookies() {}
  
  /**
   * @return {!Promise<{
        numDeleted: !number,
   *  }>}
   */

  deleteStaleSessionOnlyCookies() {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { ?string } name
   * @param { !CookieChangeListenerRemote } listener
   */

  addCookieChangeListener(url, name, listener) {}
  
  /**
   * @param { !CookieChangeListenerRemote } notificationPointer
   */

  addGlobalChangeListener(notificationPointer) {}
  
  /**
   * @param { !CookieManagerPendingReceiver } newInterface
   */

  cloneInterface(newInterface) {}
  
  /**
   * @return {!Promise}
   */

  flushCookieStore() {}
  
  /**
   * @param { !boolean } allow
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  allowFileSchemeCookies(allow) {}
  
  /**
   * @param { !contentSettings_mojom_ContentSettingsType } contentSettingsType
   * @param { !Array<!contentSettings_mojom_ContentSettingPatternSource> } settings
   * @return {!Promise}
   */

  setContentSettings(contentSettingsType, settings) {}
  
  /**
   */

  setForceKeepSessionState() {}
  
  /**
   * @param { !boolean } block
   */

  blockThirdPartyCookies(block) {}
  
  /**
   * @param { !boolean } enable
   */

  setMitigationsEnabledFor3pcd(enable) {}
  
  /**
   * @param { !boolean } enable
   */

  setTrackingProtectionEnabledFor3pcd(enable) {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } delay
   */

  setPreCommitCallbackDelayForTesting(delay) {}
}

/**
 * @implements { CookieManagerInterface }
 */
export class CookieManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CookieManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CookieManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CookieManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        cookies: !Array<!CanonicalCookie>,
   *  }>}
   */

  getAllCookies() {
    return this.proxy.sendMessage(
        0,
        CookieManager_GetAllCookies_ParamsSpec.$,
        CookieManager_GetAllCookies_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        cookies: !Array<!CanonicalCookie>,
        accessSemanticsList: !Array<!CookieAccessSemantics>,
   *  }>}
   */

  getAllCookiesWithAccessSemantics() {
    return this.proxy.sendMessage(
        1,
        CookieManager_GetAllCookiesWithAccessSemantics_ParamsSpec.$,
        CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !CookieOptions } cookieOptions
   * @param { !network_mojom_CookiePartitionKeyCollection } cookiePartitionKeyCollection
   * @return {!Promise<{
        cookies: !Array<!CookieWithAccessResult>,
        excludedCookies: !Array<!CookieWithAccessResult>,
   *  }>}
   */

  getCookieList(
      url,
      cookieOptions,
      cookiePartitionKeyCollection) {
    return this.proxy.sendMessage(
        2,
        CookieManager_GetCookieList_ParamsSpec.$,
        CookieManager_GetCookieList_ResponseParamsSpec.$,
        [
          url,
          cookieOptions,
          cookiePartitionKeyCollection
        ],
        false);
  }

  
  /**
   * @param { !CanonicalCookie } cookie
   * @param { !url_mojom_Url } sourceUrl
   * @param { !CookieOptions } cookieOptions
   * @return {!Promise<{
        accessResult: !CookieAccessResult,
   *  }>}
   */

  setCanonicalCookie(
      cookie,
      sourceUrl,
      cookieOptions) {
    return this.proxy.sendMessage(
        3,
        CookieManager_SetCanonicalCookie_ParamsSpec.$,
        CookieManager_SetCanonicalCookie_ResponseParamsSpec.$,
        [
          cookie,
          sourceUrl,
          cookieOptions
        ],
        false);
  }

  
  /**
   * @param { !CanonicalCookie } cookie
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  deleteCanonicalCookie(
      cookie) {
    return this.proxy.sendMessage(
        4,
        CookieManager_DeleteCanonicalCookie_ParamsSpec.$,
        CookieManager_DeleteCanonicalCookie_ResponseParamsSpec.$,
        [
          cookie
        ],
        false);
  }

  
  /**
   * @param { !CookieDeletionFilter } filter
   * @return {!Promise<{
        numDeleted: !number,
   *  }>}
   */

  deleteCookies(
      filter) {
    return this.proxy.sendMessage(
        5,
        CookieManager_DeleteCookies_ParamsSpec.$,
        CookieManager_DeleteCookies_ResponseParamsSpec.$,
        [
          filter
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        numDeleted: !number,
   *  }>}
   */

  deleteSessionOnlyCookies() {
    return this.proxy.sendMessage(
        6,
        CookieManager_DeleteSessionOnlyCookies_ParamsSpec.$,
        CookieManager_DeleteSessionOnlyCookies_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        numDeleted: !number,
   *  }>}
   */

  deleteStaleSessionOnlyCookies() {
    return this.proxy.sendMessage(
        7,
        CookieManager_DeleteStaleSessionOnlyCookies_ParamsSpec.$,
        CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { ?string } name
   * @param { !CookieChangeListenerRemote } listener
   */

  addCookieChangeListener(
      url,
      name,
      listener) {
    this.proxy.sendMessage(
        8,
        CookieManager_AddCookieChangeListener_ParamsSpec.$,
        null,
        [
          url,
          name,
          listener
        ],
        false);
  }

  
  /**
   * @param { !CookieChangeListenerRemote } notificationPointer
   */

  addGlobalChangeListener(
      notificationPointer) {
    this.proxy.sendMessage(
        9,
        CookieManager_AddGlobalChangeListener_ParamsSpec.$,
        null,
        [
          notificationPointer
        ],
        false);
  }

  
  /**
   * @param { !CookieManagerPendingReceiver } newInterface
   */

  cloneInterface(
      newInterface) {
    this.proxy.sendMessage(
        10,
        CookieManager_CloneInterface_ParamsSpec.$,
        null,
        [
          newInterface
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  flushCookieStore() {
    return this.proxy.sendMessage(
        11,
        CookieManager_FlushCookieStore_ParamsSpec.$,
        CookieManager_FlushCookieStore_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } allow
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  allowFileSchemeCookies(
      allow) {
    return this.proxy.sendMessage(
        12,
        CookieManager_AllowFileSchemeCookies_ParamsSpec.$,
        CookieManager_AllowFileSchemeCookies_ResponseParamsSpec.$,
        [
          allow
        ],
        false);
  }

  
  /**
   * @param { !contentSettings_mojom_ContentSettingsType } contentSettingsType
   * @param { !Array<!contentSettings_mojom_ContentSettingPatternSource> } settings
   * @return {!Promise}
   */

  setContentSettings(
      contentSettingsType,
      settings) {
    return this.proxy.sendMessage(
        13,
        CookieManager_SetContentSettings_ParamsSpec.$,
        CookieManager_SetContentSettings_ResponseParamsSpec.$,
        [
          contentSettingsType,
          settings
        ],
        false);
  }

  
  /**
   */

  setForceKeepSessionState() {
    this.proxy.sendMessage(
        14,
        CookieManager_SetForceKeepSessionState_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } block
   */

  blockThirdPartyCookies(
      block) {
    this.proxy.sendMessage(
        15,
        CookieManager_BlockThirdPartyCookies_ParamsSpec.$,
        null,
        [
          block
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   */

  setMitigationsEnabledFor3pcd(
      enable) {
    this.proxy.sendMessage(
        16,
        CookieManager_SetMitigationsEnabledFor3pcd_ParamsSpec.$,
        null,
        [
          enable
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   */

  setTrackingProtectionEnabledFor3pcd(
      enable) {
    this.proxy.sendMessage(
        17,
        CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsSpec.$,
        null,
        [
          enable
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } delay
   */

  setPreCommitCallbackDelayForTesting(
      delay) {
    this.proxy.sendMessage(
        18,
        CookieManager_SetPreCommitCallbackDelayForTesting_ParamsSpec.$,
        null,
        [
          delay
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CookieManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CookieManagerReceiver {
  /**
   * @param {!CookieManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CookieManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CookieManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CookieManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CookieManager_GetAllCookies_ParamsSpec.$,
        CookieManager_GetAllCookies_ResponseParamsSpec.$,
        impl.getAllCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CookieManager_GetAllCookiesWithAccessSemantics_ParamsSpec.$,
        CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsSpec.$,
        impl.getAllCookiesWithAccessSemantics.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CookieManager_GetCookieList_ParamsSpec.$,
        CookieManager_GetCookieList_ResponseParamsSpec.$,
        impl.getCookieList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CookieManager_SetCanonicalCookie_ParamsSpec.$,
        CookieManager_SetCanonicalCookie_ResponseParamsSpec.$,
        impl.setCanonicalCookie.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        CookieManager_DeleteCanonicalCookie_ParamsSpec.$,
        CookieManager_DeleteCanonicalCookie_ResponseParamsSpec.$,
        impl.deleteCanonicalCookie.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        CookieManager_DeleteCookies_ParamsSpec.$,
        CookieManager_DeleteCookies_ResponseParamsSpec.$,
        impl.deleteCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        CookieManager_DeleteSessionOnlyCookies_ParamsSpec.$,
        CookieManager_DeleteSessionOnlyCookies_ResponseParamsSpec.$,
        impl.deleteSessionOnlyCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        CookieManager_DeleteStaleSessionOnlyCookies_ParamsSpec.$,
        CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsSpec.$,
        impl.deleteStaleSessionOnlyCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        CookieManager_AddCookieChangeListener_ParamsSpec.$,
        null,
        impl.addCookieChangeListener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        CookieManager_AddGlobalChangeListener_ParamsSpec.$,
        null,
        impl.addGlobalChangeListener.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        CookieManager_CloneInterface_ParamsSpec.$,
        null,
        impl.cloneInterface.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        CookieManager_FlushCookieStore_ParamsSpec.$,
        CookieManager_FlushCookieStore_ResponseParamsSpec.$,
        impl.flushCookieStore.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        CookieManager_AllowFileSchemeCookies_ParamsSpec.$,
        CookieManager_AllowFileSchemeCookies_ResponseParamsSpec.$,
        impl.allowFileSchemeCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        CookieManager_SetContentSettings_ParamsSpec.$,
        CookieManager_SetContentSettings_ResponseParamsSpec.$,
        impl.setContentSettings.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        CookieManager_SetForceKeepSessionState_ParamsSpec.$,
        null,
        impl.setForceKeepSessionState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        CookieManager_BlockThirdPartyCookies_ParamsSpec.$,
        null,
        impl.blockThirdPartyCookies.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        CookieManager_SetMitigationsEnabledFor3pcd_ParamsSpec.$,
        null,
        impl.setMitigationsEnabledFor3pcd.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsSpec.$,
        null,
        impl.setTrackingProtectionEnabledFor3pcd.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        CookieManager_SetPreCommitCallbackDelayForTesting_ParamsSpec.$,
        null,
        impl.setPreCommitCallbackDelayForTesting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CookieManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CookieManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CookieManagerRemote}
   */
  static getRemote() {
    let remote = new CookieManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CookieManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CookieManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CookieManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CookieManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CookieManager_GetAllCookies_ParamsSpec.$,
        CookieManager_GetAllCookies_ResponseParamsSpec.$,
        this.getAllCookies.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getAllCookiesWithAccessSemantics =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CookieManager_GetAllCookiesWithAccessSemantics_ParamsSpec.$,
        CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsSpec.$,
        this.getAllCookiesWithAccessSemantics.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getCookieList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CookieManager_GetCookieList_ParamsSpec.$,
        CookieManager_GetCookieList_ResponseParamsSpec.$,
        this.getCookieList.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCanonicalCookie =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CookieManager_SetCanonicalCookie_ParamsSpec.$,
        CookieManager_SetCanonicalCookie_ResponseParamsSpec.$,
        this.setCanonicalCookie.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteCanonicalCookie =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        CookieManager_DeleteCanonicalCookie_ParamsSpec.$,
        CookieManager_DeleteCanonicalCookie_ResponseParamsSpec.$,
        this.deleteCanonicalCookie.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        CookieManager_DeleteCookies_ParamsSpec.$,
        CookieManager_DeleteCookies_ResponseParamsSpec.$,
        this.deleteCookies.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteSessionOnlyCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        CookieManager_DeleteSessionOnlyCookies_ParamsSpec.$,
        CookieManager_DeleteSessionOnlyCookies_ResponseParamsSpec.$,
        this.deleteSessionOnlyCookies.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deleteStaleSessionOnlyCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        CookieManager_DeleteStaleSessionOnlyCookies_ParamsSpec.$,
        CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsSpec.$,
        this.deleteStaleSessionOnlyCookies.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addCookieChangeListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        CookieManager_AddCookieChangeListener_ParamsSpec.$,
        null,
        this.addCookieChangeListener.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addGlobalChangeListener =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        CookieManager_AddGlobalChangeListener_ParamsSpec.$,
        null,
        this.addGlobalChangeListener.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cloneInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        CookieManager_CloneInterface_ParamsSpec.$,
        null,
        this.cloneInterface.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flushCookieStore =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        CookieManager_FlushCookieStore_ParamsSpec.$,
        CookieManager_FlushCookieStore_ResponseParamsSpec.$,
        this.flushCookieStore.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.allowFileSchemeCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        CookieManager_AllowFileSchemeCookies_ParamsSpec.$,
        CookieManager_AllowFileSchemeCookies_ResponseParamsSpec.$,
        this.allowFileSchemeCookies.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setContentSettings =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        CookieManager_SetContentSettings_ParamsSpec.$,
        CookieManager_SetContentSettings_ResponseParamsSpec.$,
        this.setContentSettings.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setForceKeepSessionState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        CookieManager_SetForceKeepSessionState_ParamsSpec.$,
        null,
        this.setForceKeepSessionState.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.blockThirdPartyCookies =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        CookieManager_BlockThirdPartyCookies_ParamsSpec.$,
        null,
        this.blockThirdPartyCookies.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMitigationsEnabledFor3pcd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        CookieManager_SetMitigationsEnabledFor3pcd_ParamsSpec.$,
        null,
        this.setMitigationsEnabledFor3pcd.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTrackingProtectionEnabledFor3pcd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsSpec.$,
        null,
        this.setTrackingProtectionEnabledFor3pcd.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setPreCommitCallbackDelayForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        CookieManager_SetPreCommitCallbackDelayForTesting_ParamsSpec.$,
        null,
        this.setPreCommitCallbackDelayForTesting.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManagerParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieSameSiteContextMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieSameSiteContextSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CanonicalCookieSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ExclusionReasonsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WarningReasonsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieInclusionStatusSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieAndLineWithAccessResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieOrLineWithAccessResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieAccessResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieWithAccessResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieChangeInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieDeletionFilterSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieChangeListener_OnCookieChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_GetAllCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_GetAllCookies_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_GetAllCookiesWithAccessSemantics_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_GetCookieList_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_GetCookieList_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_SetCanonicalCookie_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_SetCanonicalCookie_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_DeleteCanonicalCookie_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_DeleteCanonicalCookie_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_DeleteCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_DeleteCookies_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_DeleteSessionOnlyCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_DeleteSessionOnlyCookies_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_DeleteStaleSessionOnlyCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_AddCookieChangeListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_AddGlobalChangeListener_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_CloneInterface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_FlushCookieStore_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_FlushCookieStore_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_AllowFileSchemeCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_AllowFileSchemeCookies_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_SetContentSettings_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_SetContentSettings_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_SetForceKeepSessionState_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_BlockThirdPartyCookies_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_SetMitigationsEnabledFor3pcd_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieManager_SetPreCommitCallbackDelayForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const CookieOrLineSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CookieManagerParamsSpec.$,
    'CookieManagerParams',
    [
      mojo.internal.StructField(
        'blockThirdPartyCookies', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trackingProtectionEnabledFor3pcd', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mitigationsEnabledFor3pcd', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'contentSettings', 8,
        0,
        mojo.internal.Map(contentSettings_mojom_ContentSettingsTypeSpec.$, mojo.internal.Array(contentSettings_mojom_ContentSettingPatternSourceSpec.$, false), false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'secureOriginCookiesAllowedSchemes', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'matchingSchemeCookiesAllowedSchemes', 24,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'thirdPartyCookiesAllowedSchemes', 32,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowFileSchemeCookies', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieAccessDelegateType', 4,
        0,
        CookieAccessDelegateTypeSpec.$,
        CookieAccessDelegateType.USE_CONTENT_SETTINGS,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class CookieManagerParams {
  constructor() {
    /** @type { !boolean } */
    this.blockThirdPartyCookies;
    /** @type { !boolean } */
    this.trackingProtectionEnabledFor3pcd;
    /** @type { !boolean } */
    this.mitigationsEnabledFor3pcd;
    /** @type { !Object<!contentSettings_mojom_ContentSettingsType, !Array<!contentSettings_mojom_ContentSettingPatternSource>> } */
    this.contentSettings;
    /** @type { !Array<!string> } */
    this.secureOriginCookiesAllowedSchemes;
    /** @type { !Array<!string> } */
    this.matchingSchemeCookiesAllowedSchemes;
    /** @type { !Array<!string> } */
    this.thirdPartyCookiesAllowedSchemes;
    /** @type { !boolean } */
    this.allowFileSchemeCookies;
    /** @type { !CookieAccessDelegateType } */
    this.cookieAccessDelegateType;
  }
}



mojo.internal.Struct(
    CookieSameSiteContextMetadataSpec.$,
    'CookieSameSiteContextMetadata',
    [
      mojo.internal.StructField(
        'crossSiteRedirectDowngrade', 0,
        0,
        CookieSameSiteContextMetadataDowngradeTypeSpec.$,
        CookieSameSiteContextMetadataDowngradeType.kNoDowngrade,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'redirectTypeBug1221316', 4,
        0,
        ContextRedirectTypeBug1221316Spec.$,
        ContextRedirectTypeBug1221316.kUnset,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieSameSiteContextMetadata {
  constructor() {
    /** @type { !CookieSameSiteContextMetadataDowngradeType } */
    this.crossSiteRedirectDowngrade;
    /** @type { !ContextRedirectTypeBug1221316 } */
    this.redirectTypeBug1221316;
  }
}



mojo.internal.Struct(
    CookieSameSiteContextSpec.$,
    'CookieSameSiteContext',
    [
      mojo.internal.StructField(
        'context', 0,
        0,
        ContextTypeSpec.$,
        ContextType.CROSS_SITE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'schemefulContext', 4,
        0,
        ContextTypeSpec.$,
        ContextType.CROSS_SITE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metadata', 8,
        0,
        CookieSameSiteContextMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'schemefulMetadata', 16,
        0,
        CookieSameSiteContextMetadataSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CookieSameSiteContext {
  constructor() {
    /** @type { !ContextType } */
    this.context;
    /** @type { !ContextType } */
    this.schemefulContext;
    /** @type { !CookieSameSiteContextMetadata } */
    this.metadata;
    /** @type { !CookieSameSiteContextMetadata } */
    this.schemefulMetadata;
  }
}



mojo.internal.Struct(
    CookieOptionsSpec.$,
    'CookieOptions',
    [
      mojo.internal.StructField(
        'excludeHttponly', 0,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sameSiteCookieContext', 8,
        0,
        CookieSameSiteContextSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'updateAccessTime', 0,
        1,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'returnExcludedCookies', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CookieOptions {
  constructor() {
    /** @type { !boolean } */
    this.excludeHttponly;
    /** @type { !CookieSameSiteContext } */
    this.sameSiteCookieContext;
    /** @type { !boolean } */
    this.updateAccessTime;
    /** @type { !boolean } */
    this.returnExcludedCookies;
  }
}



mojo.internal.Struct(
    CanonicalCookieSpec.$,
    'CanonicalCookie',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'domain', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'path', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'creation', 32,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'expiry', 40,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastAccess', 48,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastUpdate', 56,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'secure', 64,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'httponly', 64,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'siteRestrictions', 68,
        0,
        CookieSameSiteSpec.$,
        CookieSameSite.NO_RESTRICTION,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'priority', 72,
        0,
        CookiePrioritySpec.$,
        CookiePriority.MEDIUM,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceScheme', 76,
        0,
        CookieSourceSchemeSpec.$,
        CookieSourceScheme.kUnset,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'partitionKey', 80,
        0,
        network_mojom_CookiePartitionKeySpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourcePort', 88,
        0,
        mojo.internal.Int32,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceType', 92,
        0,
        CookieSourceTypeSpec.$,
        CookieSourceType.kUnknown,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 104],]);



/**
 * @record
 */
export class CanonicalCookie {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.value;
    /** @type { !string } */
    this.domain;
    /** @type { !string } */
    this.path;
    /** @type { !mojoBase_mojom_Time } */
    this.creation;
    /** @type { !mojoBase_mojom_Time } */
    this.expiry;
    /** @type { !mojoBase_mojom_Time } */
    this.lastAccess;
    /** @type { !mojoBase_mojom_Time } */
    this.lastUpdate;
    /** @type { !boolean } */
    this.secure;
    /** @type { !boolean } */
    this.httponly;
    /** @type { !CookieSameSite } */
    this.siteRestrictions;
    /** @type { !CookiePriority } */
    this.priority;
    /** @type { !CookieSourceScheme } */
    this.sourceScheme;
    /** @type { (network_mojom_CookiePartitionKey|undefined) } */
    this.partitionKey;
    /** @type { !number } */
    this.sourcePort;
    /** @type { !CookieSourceType } */
    this.sourceType;
  }
}



mojo.internal.Struct(
    ExclusionReasonsSpec.$,
    'ExclusionReasons',
    [
      mojo.internal.StructField(
        'exclusionsBitmask', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ExclusionReasons {
  constructor() {
    /** @type { !bigint } */
    this.exclusionsBitmask;
  }
}



mojo.internal.Struct(
    WarningReasonsSpec.$,
    'WarningReasons',
    [
      mojo.internal.StructField(
        'warningsBitmask', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WarningReasons {
  constructor() {
    /** @type { !bigint } */
    this.warningsBitmask;
  }
}



mojo.internal.Struct(
    CookieInclusionStatusSpec.$,
    'CookieInclusionStatus',
    [
      mojo.internal.StructField(
        'exclusionReasons', 0,
        0,
        ExclusionReasonsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'warningReasons', 8,
        0,
        WarningReasonsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'exemptionReason', 16,
        0,
        CookieExemptionReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CookieInclusionStatus {
  constructor() {
    /** @type { !ExclusionReasons } */
    this.exclusionReasons;
    /** @type { !WarningReasons } */
    this.warningReasons;
    /** @type { !CookieExemptionReason } */
    this.exemptionReason;
  }
}



mojo.internal.Struct(
    CookieAndLineWithAccessResultSpec.$,
    'CookieAndLineWithAccessResult',
    [
      mojo.internal.StructField(
        'cookie', 0,
        0,
        CanonicalCookieSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieString', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'accessResult', 16,
        0,
        CookieAccessResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CookieAndLineWithAccessResult {
  constructor() {
    /** @type { (CanonicalCookie|undefined) } */
    this.cookie;
    /** @type { !string } */
    this.cookieString;
    /** @type { !CookieAccessResult } */
    this.accessResult;
  }
}



mojo.internal.Struct(
    CookieOrLineWithAccessResultSpec.$,
    'CookieOrLineWithAccessResult',
    [
      mojo.internal.StructField(
        'cookieOrLine', 0,
        0,
        CookieOrLineSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'accessResult', 16,
        0,
        CookieAccessResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CookieOrLineWithAccessResult {
  constructor() {
    /** @type { !CookieOrLine } */
    this.cookieOrLine;
    /** @type { !CookieAccessResult } */
    this.accessResult;
  }
}



mojo.internal.Struct(
    CookieAccessResultSpec.$,
    'CookieAccessResult',
    [
      mojo.internal.StructField(
        'effectiveSameSite', 0,
        0,
        CookieEffectiveSameSiteSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'accessSemantics', 4,
        0,
        CookieAccessSemanticsSpec.$,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'scopeSemantics', 8,
        0,
        CookieScopeSemanticsSpec.$,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'status', 16,
        0,
        CookieInclusionStatusSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isAllowedToAccessSecureCookies', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CookieAccessResult {
  constructor() {
    /** @type { !CookieEffectiveSameSite } */
    this.effectiveSameSite;
    /** @type { !CookieAccessSemantics } */
    this.accessSemantics;
    /** @type { !CookieScopeSemantics } */
    this.scopeSemantics;
    /** @type { !CookieInclusionStatus } */
    this.status;
    /** @type { !boolean } */
    this.isAllowedToAccessSecureCookies;
  }
}



mojo.internal.Struct(
    CookieWithAccessResultSpec.$,
    'CookieWithAccessResult',
    [
      mojo.internal.StructField(
        'cookie', 0,
        0,
        CanonicalCookieSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'accessResult', 8,
        0,
        CookieAccessResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CookieWithAccessResult {
  constructor() {
    /** @type { !CanonicalCookie } */
    this.cookie;
    /** @type { !CookieAccessResult } */
    this.accessResult;
  }
}



mojo.internal.Struct(
    CookieChangeInfoSpec.$,
    'CookieChangeInfo',
    [
      mojo.internal.StructField(
        'cookie', 0,
        0,
        CanonicalCookieSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'accessResult', 8,
        0,
        CookieAccessResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cause', 16,
        0,
        CookieChangeCauseSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CookieChangeInfo {
  constructor() {
    /** @type { !CanonicalCookie } */
    this.cookie;
    /** @type { !CookieAccessResult } */
    this.accessResult;
    /** @type { !CookieChangeCause } */
    this.cause;
  }
}



mojo.internal.Struct(
    CookieDeletionFilterSpec.$,
    'CookieDeletionFilter',
    [
      mojo.internal.StructField(
        'createdAfterTime', 0,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'createdBeforeTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'excludingDomains', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includingDomains', 24,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieName', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostName', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 48,
        0,
        url_mojom_UrlSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionControl', 56,
        0,
        CookieDeletionSessionControlSpec.$,
        CookieDeletionSessionControl.IGNORE_CONTROL,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookiePartitionKeyCollection', 64,
        0,
        network_mojom_CookiePartitionKeyCollectionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'partitionedStateOnly', 60,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class CookieDeletionFilter {
  constructor() {
    /** @type { (mojoBase_mojom_Time|undefined) } */
    this.createdAfterTime;
    /** @type { (mojoBase_mojom_Time|undefined) } */
    this.createdBeforeTime;
    /** @type { (Array<!string>|undefined) } */
    this.excludingDomains;
    /** @type { (Array<!string>|undefined) } */
    this.includingDomains;
    /** @type { (string|undefined) } */
    this.cookieName;
    /** @type { (string|undefined) } */
    this.hostName;
    /** @type { (url_mojom_Url|undefined) } */
    this.url;
    /** @type { !CookieDeletionSessionControl } */
    this.sessionControl;
    /** @type { (network_mojom_CookiePartitionKeyCollection|undefined) } */
    this.cookiePartitionKeyCollection;
    /** @type { !boolean } */
    this.partitionedStateOnly;
  }
}



mojo.internal.Struct(
    CookieChangeListener_OnCookieChange_ParamsSpec.$,
    'CookieChangeListener_OnCookieChange_Params',
    [
      mojo.internal.StructField(
        'change', 0,
        0,
        CookieChangeInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieChangeListener_OnCookieChange_Params {
  constructor() {
    /** @type { !CookieChangeInfo } */
    this.change;
  }
}



mojo.internal.Struct(
    CookieManager_GetAllCookies_ParamsSpec.$,
    'CookieManager_GetAllCookies_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CookieManager_GetAllCookies_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CookieManager_GetAllCookies_ResponseParamsSpec.$,
    'CookieManager_GetAllCookies_ResponseParams',
    [
      mojo.internal.StructField(
        'cookies', 0,
        0,
        mojo.internal.Array(CanonicalCookieSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_GetAllCookies_ResponseParams {
  constructor() {
    /** @type { !Array<!CanonicalCookie> } */
    this.cookies;
  }
}



mojo.internal.Struct(
    CookieManager_GetAllCookiesWithAccessSemantics_ParamsSpec.$,
    'CookieManager_GetAllCookiesWithAccessSemantics_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CookieManager_GetAllCookiesWithAccessSemantics_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsSpec.$,
    'CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams',
    [
      mojo.internal.StructField(
        'cookies', 0,
        0,
        mojo.internal.Array(CanonicalCookieSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'accessSemanticsList', 8,
        0,
        mojo.internal.Array(CookieAccessSemanticsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams {
  constructor() {
    /** @type { !Array<!CanonicalCookie> } */
    this.cookies;
    /** @type { !Array<!CookieAccessSemantics> } */
    this.accessSemanticsList;
  }
}



mojo.internal.Struct(
    CookieManager_GetCookieList_ParamsSpec.$,
    'CookieManager_GetCookieList_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieOptions', 8,
        0,
        CookieOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookiePartitionKeyCollection', 16,
        0,
        network_mojom_CookiePartitionKeyCollectionSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CookieManager_GetCookieList_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !CookieOptions } */
    this.cookieOptions;
    /** @type { !network_mojom_CookiePartitionKeyCollection } */
    this.cookiePartitionKeyCollection;
  }
}



mojo.internal.Struct(
    CookieManager_GetCookieList_ResponseParamsSpec.$,
    'CookieManager_GetCookieList_ResponseParams',
    [
      mojo.internal.StructField(
        'cookies', 0,
        0,
        mojo.internal.Array(CookieWithAccessResultSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'excludedCookies', 8,
        0,
        mojo.internal.Array(CookieWithAccessResultSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CookieManager_GetCookieList_ResponseParams {
  constructor() {
    /** @type { !Array<!CookieWithAccessResult> } */
    this.cookies;
    /** @type { !Array<!CookieWithAccessResult> } */
    this.excludedCookies;
  }
}



mojo.internal.Struct(
    CookieManager_SetCanonicalCookie_ParamsSpec.$,
    'CookieManager_SetCanonicalCookie_Params',
    [
      mojo.internal.StructField(
        'cookie', 0,
        0,
        CanonicalCookieSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieOptions', 16,
        0,
        CookieOptionsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CookieManager_SetCanonicalCookie_Params {
  constructor() {
    /** @type { !CanonicalCookie } */
    this.cookie;
    /** @type { !url_mojom_Url } */
    this.sourceUrl;
    /** @type { !CookieOptions } */
    this.cookieOptions;
  }
}



mojo.internal.Struct(
    CookieManager_SetCanonicalCookie_ResponseParamsSpec.$,
    'CookieManager_SetCanonicalCookie_ResponseParams',
    [
      mojo.internal.StructField(
        'accessResult', 0,
        0,
        CookieAccessResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_SetCanonicalCookie_ResponseParams {
  constructor() {
    /** @type { !CookieAccessResult } */
    this.accessResult;
  }
}



mojo.internal.Struct(
    CookieManager_DeleteCanonicalCookie_ParamsSpec.$,
    'CookieManager_DeleteCanonicalCookie_Params',
    [
      mojo.internal.StructField(
        'cookie', 0,
        0,
        CanonicalCookieSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_DeleteCanonicalCookie_Params {
  constructor() {
    /** @type { !CanonicalCookie } */
    this.cookie;
  }
}



mojo.internal.Struct(
    CookieManager_DeleteCanonicalCookie_ResponseParamsSpec.$,
    'CookieManager_DeleteCanonicalCookie_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_DeleteCanonicalCookie_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    CookieManager_DeleteCookies_ParamsSpec.$,
    'CookieManager_DeleteCookies_Params',
    [
      mojo.internal.StructField(
        'filter', 0,
        0,
        CookieDeletionFilterSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_DeleteCookies_Params {
  constructor() {
    /** @type { !CookieDeletionFilter } */
    this.filter;
  }
}



mojo.internal.Struct(
    CookieManager_DeleteCookies_ResponseParamsSpec.$,
    'CookieManager_DeleteCookies_ResponseParams',
    [
      mojo.internal.StructField(
        'numDeleted', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_DeleteCookies_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.numDeleted;
  }
}



mojo.internal.Struct(
    CookieManager_DeleteSessionOnlyCookies_ParamsSpec.$,
    'CookieManager_DeleteSessionOnlyCookies_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CookieManager_DeleteSessionOnlyCookies_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CookieManager_DeleteSessionOnlyCookies_ResponseParamsSpec.$,
    'CookieManager_DeleteSessionOnlyCookies_ResponseParams',
    [
      mojo.internal.StructField(
        'numDeleted', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_DeleteSessionOnlyCookies_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.numDeleted;
  }
}



mojo.internal.Struct(
    CookieManager_DeleteStaleSessionOnlyCookies_ParamsSpec.$,
    'CookieManager_DeleteStaleSessionOnlyCookies_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CookieManager_DeleteStaleSessionOnlyCookies_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsSpec.$,
    'CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams',
    [
      mojo.internal.StructField(
        'numDeleted', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.numDeleted;
  }
}



mojo.internal.Struct(
    CookieManager_AddCookieChangeListener_ParamsSpec.$,
    'CookieManager_AddCookieChangeListener_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'listener', 16,
        0,
        mojo.internal.InterfaceProxy(CookieChangeListenerRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CookieManager_AddCookieChangeListener_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { (string|undefined) } */
    this.name;
    /** @type { !CookieChangeListenerRemote } */
    this.listener;
  }
}



mojo.internal.Struct(
    CookieManager_AddGlobalChangeListener_ParamsSpec.$,
    'CookieManager_AddGlobalChangeListener_Params',
    [
      mojo.internal.StructField(
        'notificationPointer', 0,
        0,
        mojo.internal.InterfaceProxy(CookieChangeListenerRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_AddGlobalChangeListener_Params {
  constructor() {
    /** @type { !CookieChangeListenerRemote } */
    this.notificationPointer;
  }
}



mojo.internal.Struct(
    CookieManager_CloneInterface_ParamsSpec.$,
    'CookieManager_CloneInterface_Params',
    [
      mojo.internal.StructField(
        'newInterface', 0,
        0,
        mojo.internal.InterfaceRequest(CookieManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_CloneInterface_Params {
  constructor() {
    /** @type { !CookieManagerPendingReceiver } */
    this.newInterface;
  }
}



mojo.internal.Struct(
    CookieManager_FlushCookieStore_ParamsSpec.$,
    'CookieManager_FlushCookieStore_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CookieManager_FlushCookieStore_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CookieManager_FlushCookieStore_ResponseParamsSpec.$,
    'CookieManager_FlushCookieStore_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CookieManager_FlushCookieStore_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    CookieManager_AllowFileSchemeCookies_ParamsSpec.$,
    'CookieManager_AllowFileSchemeCookies_Params',
    [
      mojo.internal.StructField(
        'allow', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_AllowFileSchemeCookies_Params {
  constructor() {
    /** @type { !boolean } */
    this.allow;
  }
}



mojo.internal.Struct(
    CookieManager_AllowFileSchemeCookies_ResponseParamsSpec.$,
    'CookieManager_AllowFileSchemeCookies_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_AllowFileSchemeCookies_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    CookieManager_SetContentSettings_ParamsSpec.$,
    'CookieManager_SetContentSettings_Params',
    [
      mojo.internal.StructField(
        'contentSettingsType', 0,
        0,
        contentSettings_mojom_ContentSettingsTypeSpec.$,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'settings', 8,
        0,
        mojo.internal.Array(contentSettings_mojom_ContentSettingPatternSourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CookieManager_SetContentSettings_Params {
  constructor() {
    /** @type { !contentSettings_mojom_ContentSettingsType } */
    this.contentSettingsType;
    /** @type { !Array<!contentSettings_mojom_ContentSettingPatternSource> } */
    this.settings;
  }
}



mojo.internal.Struct(
    CookieManager_SetContentSettings_ResponseParamsSpec.$,
    'CookieManager_SetContentSettings_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CookieManager_SetContentSettings_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    CookieManager_SetForceKeepSessionState_ParamsSpec.$,
    'CookieManager_SetForceKeepSessionState_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CookieManager_SetForceKeepSessionState_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CookieManager_BlockThirdPartyCookies_ParamsSpec.$,
    'CookieManager_BlockThirdPartyCookies_Params',
    [
      mojo.internal.StructField(
        'block', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_BlockThirdPartyCookies_Params {
  constructor() {
    /** @type { !boolean } */
    this.block;
  }
}



mojo.internal.Struct(
    CookieManager_SetMitigationsEnabledFor3pcd_ParamsSpec.$,
    'CookieManager_SetMitigationsEnabledFor3pcd_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_SetMitigationsEnabledFor3pcd_Params {
  constructor() {
    /** @type { !boolean } */
    this.enable;
  }
}



mojo.internal.Struct(
    CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsSpec.$,
    'CookieManager_SetTrackingProtectionEnabledFor3pcd_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_SetTrackingProtectionEnabledFor3pcd_Params {
  constructor() {
    /** @type { !boolean } */
    this.enable;
  }
}



mojo.internal.Struct(
    CookieManager_SetPreCommitCallbackDelayForTesting_ParamsSpec.$,
    'CookieManager_SetPreCommitCallbackDelayForTesting_Params',
    [
      mojo.internal.StructField(
        'delay', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieManager_SetPreCommitCallbackDelayForTesting_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.delay;
  }
}

mojo.internal.Union(
    CookieOrLineSpec.$, 'CookieOrLine',
    {
      'cookie': {
        'ordinal': 0,
        'type': CanonicalCookieSpec.$,
      },
      'cookieString': {
        'ordinal': 1,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   cookie: (!CanonicalCookie|undefined),
 *   cookieString: (!string|undefined),
 * } }
 */
export const CookieOrLine = {};
