// services/network/public/mojom/content_security_policy.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  IntegrityAlgorithm as network_mojom_IntegrityAlgorithm,
  IntegrityAlgorithmSpec as network_mojom_IntegrityAlgorithmSpec
} from './integrity_algorithm.mojom.m.js';

import {
  IntegrityMetadata as network_mojom_IntegrityMetadata,
  IntegrityMetadataSpec as network_mojom_IntegrityMetadataSpec
} from './integrity_metadata.mojom.m.js';

import {
  SourceLocation as network_mojom_SourceLocation,
  SourceLocationSpec as network_mojom_SourceLocationSpec
} from './source_location.mojom.m.js';

import {
  WebSandboxFlags as network_mojom_WebSandboxFlags,
  WebSandboxFlagsSpec as network_mojom_WebSandboxFlagsSpec
} from './web_sandbox_flags.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ContentSecurityPolicyTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ContentSecurityPolicyType = {
  
  kReport: 0,
  kEnforce: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ContentSecurityPolicySourceSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ContentSecurityPolicySource = {
  
  kHTTP: 0,
  kMeta: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CSPDispositionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CSPDisposition = {
  
  CHECK: 0,
  DO_NOT_CHECK: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CSPDirectiveNameSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CSPDirectiveName = {
  
  Unknown: 0,
  BaseURI: 1,
  BlockAllMixedContent: 2,
  ChildSrc: 3,
  ConnectSrc: 4,
  DefaultSrc: 5,
  FencedFrameSrc: 6,
  FontSrc: 7,
  FormAction: 8,
  FrameAncestors: 9,
  FrameSrc: 10,
  ImgSrc: 11,
  ManifestSrc: 12,
  MediaSrc: 13,
  ObjectSrc: 14,
  ReportTo: 15,
  ReportURI: 16,
  RequireTrustedTypesFor: 17,
  Sandbox: 18,
  ScriptSrc: 19,
  ScriptSrcV2: 20,
  ScriptSrcAttr: 21,
  ScriptSrcElem: 22,
  StyleSrc: 23,
  StyleSrcAttr: 24,
  StyleSrcElem: 25,
  TreatAsPublicAddress: 26,
  TrustedTypes: 27,
  UpgradeInsecureRequests: 28,
  WorkerSrc: 29,
  MIN_VALUE: 0,
  MAX_VALUE: 29,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CSPRequireTrustedTypesForSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CSPRequireTrustedTypesFor = {
  
  None: 0,
  Script: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentSecurityPolicyHeaderSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CSPSourceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CSPSourceListSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CSPTrustedTypesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ContentSecurityPolicySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CSPViolationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const AllowCSPFromHeaderValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ContentSecurityPolicyHeaderSpec.$,
    'ContentSecurityPolicyHeader',
    [
      mojo.internal.StructField(
        'headerValue', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        ContentSecurityPolicyTypeSpec.$,
        ContentSecurityPolicyType.kEnforce,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 12,
        0,
        ContentSecurityPolicySourceSpec.$,
        ContentSecurityPolicySource.kHTTP,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ContentSecurityPolicyHeader {
  constructor() {
    /** @type { !string } */
    this.headerValue;
    /** @type { !ContentSecurityPolicyType } */
    this.type;
    /** @type { !ContentSecurityPolicySource } */
    this.source;
  }
}



mojo.internal.Struct(
    CSPSourceSpec.$,
    'CSPSource',
    [
      mojo.internal.StructField(
        'scheme', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'host', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'port', 16,
        0,
        mojo.internal.Int32,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'path', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isHostWildcard', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isPortWildcard', 20,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class CSPSource {
  constructor() {
    /** @type { !string } */
    this.scheme;
    /** @type { !string } */
    this.host;
    /** @type { !number } */
    this.port;
    /** @type { !string } */
    this.path;
    /** @type { !boolean } */
    this.isHostWildcard;
    /** @type { !boolean } */
    this.isPortWildcard;
  }
}



mojo.internal.Struct(
    CSPSourceListSpec.$,
    'CSPSourceList',
    [
      mojo.internal.StructField(
        'sources', 0,
        0,
        mojo.internal.Array(CSPSourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'nonces', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hashes', 16,
        0,
        mojo.internal.Array(network_mojom_IntegrityMetadataSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'urlHashes', 24,
        0,
        mojo.internal.Array(network_mojom_IntegrityMetadataSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'evalHashes', 32,
        0,
        mojo.internal.Array(network_mojom_IntegrityMetadataSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowSelf', 40,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowStar', 40,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowInline', 40,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowInlineSpeculationRules', 40,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowEval', 40,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowWasmEval', 40,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowWasmUnsafeEval', 40,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowDynamic', 40,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowDynamicUrl', 41,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowUnsafeHashes', 41,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportSample', 41,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'report_hash_algorithm_$flag', 41,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "report_hash_algorithm_$value",
          originalFieldName: "reportHashAlgorithm",
        }
      ),
      mojo.internal.StructField(
        'report_hash_algorithm_$value', 44,
        0,
        network_mojom_IntegrityAlgorithmSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "reportHashAlgorithm",
        }
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class CSPSourceList {
  constructor() {
    /** @type { !Array<!CSPSource> } */
    this.sources;
    /** @type { !Array<!string> } */
    this.nonces;
    /** @type { !Array<!network_mojom_IntegrityMetadata> } */
    this.hashes;
    /** @type { !Array<!network_mojom_IntegrityMetadata> } */
    this.urlHashes;
    /** @type { !Array<!network_mojom_IntegrityMetadata> } */
    this.evalHashes;
    /** @type { !boolean } */
    this.allowSelf;
    /** @type { !boolean } */
    this.allowStar;
    /** @type { !boolean } */
    this.allowInline;
    /** @type { !boolean } */
    this.allowInlineSpeculationRules;
    /** @type { !boolean } */
    this.allowEval;
    /** @type { !boolean } */
    this.allowWasmEval;
    /** @type { !boolean } */
    this.allowWasmUnsafeEval;
    /** @type { !boolean } */
    this.allowDynamic;
    /** @type { !boolean } */
    this.allowDynamicUrl;
    /** @type { !boolean } */
    this.allowUnsafeHashes;
    /** @type { !boolean } */
    this.reportSample;
    /** @type { (network_mojom_IntegrityAlgorithm|undefined) } */
    this.reportHashAlgorithm;
  }
}



mojo.internal.Struct(
    CSPTrustedTypesSpec.$,
    'CSPTrustedTypes',
    [
      mojo.internal.StructField(
        'list', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowAny', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowDuplicates', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CSPTrustedTypes {
  constructor() {
    /** @type { !Array<!string> } */
    this.list;
    /** @type { !boolean } */
    this.allowAny;
    /** @type { !boolean } */
    this.allowDuplicates;
  }
}



mojo.internal.Struct(
    ContentSecurityPolicySpec.$,
    'ContentSecurityPolicy',
    [
      mojo.internal.StructField(
        'selfOrigin', 0,
        0,
        CSPSourceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rawDirectives', 8,
        0,
        mojo.internal.Map(CSPDirectiveNameSpec.$, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'directives', 16,
        0,
        mojo.internal.Map(CSPDirectiveNameSpec.$, CSPSourceListSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'upgradeInsecureRequests', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'treatAsPublicAddress', 24,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blockAllMixedContent', 24,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sandbox', 28,
        0,
        network_mojom_WebSandboxFlagsSpec.$,
        network_mojom_WebSandboxFlags.kNone,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'header', 32,
        0,
        ContentSecurityPolicyHeaderSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'useReportingApi', 24,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportEndpoints', 40,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requireTrustedTypesFor', 48,
        0,
        CSPRequireTrustedTypesForSpec.$,
        CSPRequireTrustedTypesFor.None,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustedTypes', 56,
        0,
        CSPTrustedTypesSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'parsingErrors', 64,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class ContentSecurityPolicy {
  constructor() {
    /** @type { !CSPSource } */
    this.selfOrigin;
    /** @type { !Object<!CSPDirectiveName, !string> } */
    this.rawDirectives;
    /** @type { !Object<!CSPDirectiveName, !CSPSourceList> } */
    this.directives;
    /** @type { !boolean } */
    this.upgradeInsecureRequests;
    /** @type { !boolean } */
    this.treatAsPublicAddress;
    /** @type { !boolean } */
    this.blockAllMixedContent;
    /** @type { !network_mojom_WebSandboxFlags } */
    this.sandbox;
    /** @type { !ContentSecurityPolicyHeader } */
    this.header;
    /** @type { !boolean } */
    this.useReportingApi;
    /** @type { !Array<!string> } */
    this.reportEndpoints;
    /** @type { !CSPRequireTrustedTypesFor } */
    this.requireTrustedTypesFor;
    /** @type { (CSPTrustedTypes|undefined) } */
    this.trustedTypes;
    /** @type { !Array<!string> } */
    this.parsingErrors;
  }
}



mojo.internal.Struct(
    CSPViolationSpec.$,
    'CSPViolation',
    [
      mojo.internal.StructField(
        'directive', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'effectiveDirective', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'consoleMessage', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blockedUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportEndpoints', 32,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'useReportingApi', 40,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'header', 48,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 44,
        0,
        ContentSecurityPolicyTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceLocation', 56,
        0,
        network_mojom_SourceLocationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class CSPViolation {
  constructor() {
    /** @type { !string } */
    this.directive;
    /** @type { !string } */
    this.effectiveDirective;
    /** @type { !string } */
    this.consoleMessage;
    /** @type { !url_mojom_Url } */
    this.blockedUrl;
    /** @type { !Array<!string> } */
    this.reportEndpoints;
    /** @type { !boolean } */
    this.useReportingApi;
    /** @type { !string } */
    this.header;
    /** @type { !ContentSecurityPolicyType } */
    this.type;
    /** @type { !network_mojom_SourceLocation } */
    this.sourceLocation;
  }
}

mojo.internal.Union(
    AllowCSPFromHeaderValueSpec.$, 'AllowCSPFromHeaderValue',
    {
      'allowStar': {
        'ordinal': 0,
        'type': mojo.internal.Bool,
      },
      'origin': {
        'ordinal': 1,
        'type': url_mojom_OriginSpec.$,
      },
      'errorMessage': {
        'ordinal': 2,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   allowStar: (!boolean|undefined),
 *   origin: (!url_mojom_Origin|undefined),
 *   errorMessage: (!string|undefined),
 * } }
 */
export const AllowCSPFromHeaderValue = {};
