// services/network/public/mojom/cert_verifier_service_updater.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  IPAddress as network_mojom_IPAddress,
  IPAddressSpec as network_mojom_IPAddressSpec
} from './ip_address.mojom.m.js';

import {
  CTPolicy as network_mojom_CTPolicy,
  CTPolicySpec as network_mojom_CTPolicySpec
} from './network_context.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CertVerifierServiceUpdaterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'cert_verifier.mojom.CertVerifierServiceUpdater', scope);
  }
}

/** @interface */
export class CertVerifierServiceUpdaterInterface {
  
  /**
   * @param { !AdditionalCertificates } certificates
   */

  updateAdditionalCertificates(certificates) {}
  
  /**
   * @return {!Promise}
   */

  waitUntilNextUpdateForTesting() {}
  
  /**
   * @param { !network_mojom_CTPolicy } ctPolicy
   */

  setCTPolicy(ctPolicy) {}
}

/**
 * @implements { CertVerifierServiceUpdaterInterface }
 */
export class CertVerifierServiceUpdaterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CertVerifierServiceUpdaterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CertVerifierServiceUpdaterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CertVerifierServiceUpdaterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AdditionalCertificates } certificates
   */

  updateAdditionalCertificates(
      certificates) {
    this.proxy.sendMessage(
        0,
        CertVerifierServiceUpdater_UpdateAdditionalCertificates_ParamsSpec.$,
        null,
        [
          certificates
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  waitUntilNextUpdateForTesting() {
    return this.proxy.sendMessage(
        1,
        CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ParamsSpec.$,
        CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_CTPolicy } ctPolicy
   */

  setCTPolicy(
      ctPolicy) {
    this.proxy.sendMessage(
        2,
        CertVerifierServiceUpdater_SetCTPolicy_ParamsSpec.$,
        null,
        [
          ctPolicy
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CertVerifierServiceUpdater
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CertVerifierServiceUpdaterReceiver {
  /**
   * @param {!CertVerifierServiceUpdaterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CertVerifierServiceUpdaterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CertVerifierServiceUpdaterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CertVerifierServiceUpdaterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CertVerifierServiceUpdater_UpdateAdditionalCertificates_ParamsSpec.$,
        null,
        impl.updateAdditionalCertificates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ParamsSpec.$,
        CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParamsSpec.$,
        impl.waitUntilNextUpdateForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CertVerifierServiceUpdater_SetCTPolicy_ParamsSpec.$,
        null,
        impl.setCTPolicy.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CertVerifierServiceUpdater {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "cert_verifier.mojom.CertVerifierServiceUpdater";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CertVerifierServiceUpdaterRemote}
   */
  static getRemote() {
    let remote = new CertVerifierServiceUpdaterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CertVerifierServiceUpdater
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CertVerifierServiceUpdaterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CertVerifierServiceUpdaterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CertVerifierServiceUpdaterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateAdditionalCertificates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CertVerifierServiceUpdater_UpdateAdditionalCertificates_ParamsSpec.$,
        null,
        this.updateAdditionalCertificates.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.waitUntilNextUpdateForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ParamsSpec.$,
        CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParamsSpec.$,
        this.waitUntilNextUpdateForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCTPolicy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CertVerifierServiceUpdater_SetCTPolicy_ParamsSpec.$,
        null,
        this.setCTPolicy.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CIDRSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertWithConstraintsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AdditionalCertificatesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertVerifierServiceUpdater_UpdateAdditionalCertificates_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertVerifierServiceUpdater_SetCTPolicy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CIDRSpec.$,
    'CIDR',
    [
      mojo.internal.StructField(
        'ip', 0,
        0,
        network_mojom_IPAddressSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mask', 8,
        0,
        network_mojom_IPAddressSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CIDR {
  constructor() {
    /** @type { !network_mojom_IPAddress } */
    this.ip;
    /** @type { !network_mojom_IPAddress } */
    this.mask;
  }
}



mojo.internal.Struct(
    CertWithConstraintsSpec.$,
    'CertWithConstraints',
    [
      mojo.internal.StructField(
        'certificate', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'permittedDnsNames', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'permittedCidrs', 16,
        0,
        mojo.internal.Array(CIDRSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CertWithConstraints {
  constructor() {
    /** @type { !Array<!number> } */
    this.certificate;
    /** @type { !Array<!string> } */
    this.permittedDnsNames;
    /** @type { !Array<!CIDR> } */
    this.permittedCidrs;
  }
}



mojo.internal.Struct(
    AdditionalCertificatesSpec.$,
    'AdditionalCertificates',
    [
      mojo.internal.StructField(
        'allCertificates', 0,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustAnchors', 8,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustAnchorsWithEnforcedConstraints', 16,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustAnchorsWithAdditionalConstraints', 24,
        0,
        mojo.internal.Array(CertWithConstraintsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustAnchorsAndLeafs', 32,
        0,
        mojo.internal.Array(CertWithConstraintsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trustLeafs', 40,
        0,
        mojo.internal.Array(CertWithConstraintsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'distrustedSpkis', 48,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeSystemTrustStore', 56,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class AdditionalCertificates {
  constructor() {
    /** @type { !Array<!Array<!number>> } */
    this.allCertificates;
    /** @type { !Array<!Array<!number>> } */
    this.trustAnchors;
    /** @type { !Array<!Array<!number>> } */
    this.trustAnchorsWithEnforcedConstraints;
    /** @type { !Array<!CertWithConstraints> } */
    this.trustAnchorsWithAdditionalConstraints;
    /** @type { !Array<!CertWithConstraints> } */
    this.trustAnchorsAndLeafs;
    /** @type { !Array<!CertWithConstraints> } */
    this.trustLeafs;
    /** @type { !Array<!Array<!number>> } */
    this.distrustedSpkis;
    /** @type { !boolean } */
    this.includeSystemTrustStore;
  }
}



mojo.internal.Struct(
    CertVerifierServiceUpdater_UpdateAdditionalCertificates_ParamsSpec.$,
    'CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params',
    [
      mojo.internal.StructField(
        'certificates', 0,
        0,
        AdditionalCertificatesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params {
  constructor() {
    /** @type { !AdditionalCertificates } */
    this.certificates;
  }
}



mojo.internal.Struct(
    CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ParamsSpec.$,
    'CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParamsSpec.$,
    'CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    CertVerifierServiceUpdater_SetCTPolicy_ParamsSpec.$,
    'CertVerifierServiceUpdater_SetCTPolicy_Params',
    [
      mojo.internal.StructField(
        'ctPolicy', 0,
        0,
        network_mojom_CTPolicySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CertVerifierServiceUpdater_SetCTPolicy_Params {
  constructor() {
    /** @type { !network_mojom_CTPolicy } */
    this.ctPolicy;
  }
}

