// services/network/public/mojom/cert_verifier_service_updater.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cert_verifier_service_updater.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cert_verifier_service_updater.mojom-params-data.h"
#include "services/network/public/mojom/cert_verifier_service_updater.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cert_verifier_service_updater.mojom-import-headers.h"
#include "services/network/public/mojom/cert_verifier_service_updater.mojom-test-utils.h"


namespace cert_verifier::mojom {
CIDR::CIDR()
    : ip(),
      mask() {}

CIDR::CIDR(
    const ::net::IPAddress& ip_in,
    const ::net::IPAddress& mask_in)
    : ip(std::move(ip_in)),
      mask(std::move(mask_in)) {}

CIDR::~CIDR() = default;

void CIDR::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ip"), this->ip,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IPAddress&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mask"), this->mask,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::IPAddress&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CIDR::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CertWithConstraints::CertWithConstraints()
    : certificate(),
      permitted_dns_names(),
      permitted_cidrs() {}

CertWithConstraints::CertWithConstraints(
    std::vector<uint8_t> certificate_in,
    std::vector<std::string> permitted_dns_names_in,
    std::vector<CIDRPtr> permitted_cidrs_in)
    : certificate(std::move(certificate_in)),
      permitted_dns_names(std::move(permitted_dns_names_in)),
      permitted_cidrs(std::move(permitted_cidrs_in)) {}

CertWithConstraints::~CertWithConstraints() = default;

void CertWithConstraints::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "certificate"), this->certificate,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permitted_dns_names"), this->permitted_dns_names,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permitted_cidrs"), this->permitted_cidrs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<CIDRPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CertWithConstraints::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AdditionalCertificates::AdditionalCertificates()
    : all_certificates(),
      trust_anchors(),
      trust_anchors_with_enforced_constraints(),
      trust_anchors_with_additional_constraints(),
      trust_anchors_and_leafs(),
      trust_leafs(),
      distrusted_spkis(),
      include_system_trust_store(true) {}

AdditionalCertificates::AdditionalCertificates(
    std::vector<std::vector<uint8_t>> all_certificates_in,
    std::vector<std::vector<uint8_t>> trust_anchors_in,
    std::vector<std::vector<uint8_t>> trust_anchors_with_enforced_constraints_in,
    std::vector<CertWithConstraintsPtr> trust_anchors_with_additional_constraints_in,
    std::vector<CertWithConstraintsPtr> trust_anchors_and_leafs_in,
    std::vector<CertWithConstraintsPtr> trust_leafs_in,
    std::vector<std::vector<uint8_t>> distrusted_spkis_in,
    bool include_system_trust_store_in)
    : all_certificates(std::move(all_certificates_in)),
      trust_anchors(std::move(trust_anchors_in)),
      trust_anchors_with_enforced_constraints(std::move(trust_anchors_with_enforced_constraints_in)),
      trust_anchors_with_additional_constraints(std::move(trust_anchors_with_additional_constraints_in)),
      trust_anchors_and_leafs(std::move(trust_anchors_and_leafs_in)),
      trust_leafs(std::move(trust_leafs_in)),
      distrusted_spkis(std::move(distrusted_spkis_in)),
      include_system_trust_store(std::move(include_system_trust_store_in)) {}

AdditionalCertificates::~AdditionalCertificates() = default;

void AdditionalCertificates::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_certificates"), this->all_certificates,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_anchors"), this->trust_anchors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_anchors_with_enforced_constraints"), this->trust_anchors_with_enforced_constraints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_anchors_with_additional_constraints"), this->trust_anchors_with_additional_constraints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<CertWithConstraintsPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_anchors_and_leafs"), this->trust_anchors_and_leafs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<CertWithConstraintsPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "trust_leafs"), this->trust_leafs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<CertWithConstraintsPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "distrusted_spkis"), this->distrusted_spkis,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "include_system_trust_store"), this->include_system_trust_store,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AdditionalCertificates::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

CertVerifierServiceUpdater::IPCStableHashFunction CertVerifierServiceUpdater::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CertVerifierServiceUpdater>(message.name())) {
    case messages::CertVerifierServiceUpdater::kUpdateAdditionalCertificates: {
      return &CertVerifierServiceUpdater::UpdateAdditionalCertificates_Sym::IPCStableHash;
    }
    case messages::CertVerifierServiceUpdater::kWaitUntilNextUpdateForTesting: {
      return &CertVerifierServiceUpdater::WaitUntilNextUpdateForTesting_Sym::IPCStableHash;
    }
    case messages::CertVerifierServiceUpdater::kSetCTPolicy: {
      return &CertVerifierServiceUpdater::SetCTPolicy_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CertVerifierServiceUpdater::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CertVerifierServiceUpdater>(message.name())) {
      case messages::CertVerifierServiceUpdater::kUpdateAdditionalCertificates:
            return "Receive cert_verifier::mojom::CertVerifierServiceUpdater::UpdateAdditionalCertificates";
      case messages::CertVerifierServiceUpdater::kWaitUntilNextUpdateForTesting:
            return "Receive cert_verifier::mojom::CertVerifierServiceUpdater::WaitUntilNextUpdateForTesting";
      case messages::CertVerifierServiceUpdater::kSetCTPolicy:
            return "Receive cert_verifier::mojom::CertVerifierServiceUpdater::SetCTPolicy";
    }
  } else {
    switch (static_cast<messages::CertVerifierServiceUpdater>(message.name())) {
      case messages::CertVerifierServiceUpdater::kUpdateAdditionalCertificates:
            return "Receive reply cert_verifier::mojom::CertVerifierServiceUpdater::UpdateAdditionalCertificates";
      case messages::CertVerifierServiceUpdater::kWaitUntilNextUpdateForTesting:
            return "Receive reply cert_verifier::mojom::CertVerifierServiceUpdater::WaitUntilNextUpdateForTesting";
      case messages::CertVerifierServiceUpdater::kSetCTPolicy:
            return "Receive reply cert_verifier::mojom::CertVerifierServiceUpdater::SetCTPolicy";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CertVerifierServiceUpdater::UpdateAdditionalCertificates_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3dde092f;  // IPCStableHash for cert_verifier::mojom::CertVerifierServiceUpdater::UpdateAdditionalCertificates
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertVerifierServiceUpdater::WaitUntilNextUpdateForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x87b2b862;  // IPCStableHash for cert_verifier::mojom::CertVerifierServiceUpdater::WaitUntilNextUpdateForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CertVerifierServiceUpdater::SetCTPolicy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe1fbf659;  // IPCStableHash for cert_verifier::mojom::CertVerifierServiceUpdater::SetCTPolicy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ForwardToCallback(
      CertVerifierServiceUpdater::WaitUntilNextUpdateForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ForwardToCallback(const CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ForwardToCallback&) = delete;
  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ForwardToCallback& operator=(const CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  CertVerifierServiceUpdater::WaitUntilNextUpdateForTestingCallback callback_;
};

CertVerifierServiceUpdaterProxy::CertVerifierServiceUpdaterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CertVerifierServiceUpdaterProxy::UpdateAdditionalCertificates(
    AdditionalCertificatesPtr in_certificates) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cert_verifier::mojom::CertVerifierServiceUpdater::UpdateAdditionalCertificates", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("certificates"), in_certificates,
                        "<value of type AdditionalCertificatesPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceUpdater::kUpdateAdditionalCertificates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->certificates)::BaseType> certificates_fragment(
          params.message());
  
  mojo::internal::Serialize<::cert_verifier::mojom::AdditionalCertificatesDataView>(
    in_certificates,
    certificates_fragment);

  params->certificates.Set(
      certificates_fragment.is_null() ? nullptr : certificates_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->certificates.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null certificates in CertVerifierServiceUpdater.UpdateAdditionalCertificates request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceUpdater::Name_);
  message.set_method_name("UpdateAdditionalCertificates");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CertVerifierServiceUpdaterProxy::WaitUntilNextUpdateForTesting(
    WaitUntilNextUpdateForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send cert_verifier::mojom::CertVerifierServiceUpdater::WaitUntilNextUpdateForTesting");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceUpdater::kWaitUntilNextUpdateForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceUpdater::Name_);
  message.set_method_name("WaitUntilNextUpdateForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void CertVerifierServiceUpdaterProxy::SetCTPolicy(
    ::network::mojom::CTPolicyPtr in_ct_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send cert_verifier::mojom::CertVerifierServiceUpdater::SetCTPolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ct_policy"), in_ct_policy,
                        "<value of type ::network::mojom::CTPolicyPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceUpdater::kSetCTPolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceUpdater_SetCTPolicy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ct_policy)::BaseType> ct_policy_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::CTPolicyDataView>(
    in_ct_policy,
    ct_policy_fragment);

  params->ct_policy.Set(
      ct_policy_fragment.is_null() ? nullptr : ct_policy_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ct_policy.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ct_policy in CertVerifierServiceUpdater.SetCTPolicy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceUpdater::Name_);
  message.set_method_name("SetCTPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static CertVerifierServiceUpdater::WaitUntilNextUpdateForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ProxyToResponder> proxy(
        new CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "CertVerifierServiceUpdater::WaitUntilNextUpdateForTestingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for CertVerifierServiceUpdater.1
  bool success = true;
  CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CertVerifierServiceUpdater::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply cert_verifier::mojom::CertVerifierServiceUpdater::WaitUntilNextUpdateForTesting");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CertVerifierServiceUpdater::kWaitUntilNextUpdateForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::cert_verifier::mojom::internal::CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CertVerifierServiceUpdater::Name_);
  message.set_method_name("WaitUntilNextUpdateForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CertVerifierServiceUpdaterStubDispatch::Accept(
    CertVerifierServiceUpdater* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CertVerifierServiceUpdater>(message->header()->name)) {
    case messages::CertVerifierServiceUpdater::kUpdateAdditionalCertificates: {
      DCHECK(message->is_serialized());
      internal::CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params_Data* params =
          reinterpret_cast<internal::CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertVerifierServiceUpdater.0
      bool success = true;
      AdditionalCertificatesPtr p_certificates{};
      CertVerifierServiceUpdater_UpdateAdditionalCertificates_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCertificates(&p_certificates))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierServiceUpdater::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateAdditionalCertificates(        
        std::move(p_certificates));
      return true;
    }
    case messages::CertVerifierServiceUpdater::kWaitUntilNextUpdateForTesting: {
      break;
    }
    case messages::CertVerifierServiceUpdater::kSetCTPolicy: {
      DCHECK(message->is_serialized());
      internal::CertVerifierServiceUpdater_SetCTPolicy_Params_Data* params =
          reinterpret_cast<internal::CertVerifierServiceUpdater_SetCTPolicy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CertVerifierServiceUpdater.2
      bool success = true;
      ::network::mojom::CTPolicyPtr p_ct_policy{};
      CertVerifierServiceUpdater_SetCTPolicy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCtPolicy(&p_ct_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierServiceUpdater::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCTPolicy(        
        std::move(p_ct_policy));
      return true;
    }
  }
  return false;
}

// static
bool CertVerifierServiceUpdaterStubDispatch::AcceptWithResponder(
    CertVerifierServiceUpdater* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CertVerifierServiceUpdater>(message->header()->name)) {
    case messages::CertVerifierServiceUpdater::kUpdateAdditionalCertificates: {
      break;
    }
    case messages::CertVerifierServiceUpdater::kWaitUntilNextUpdateForTesting: {
      internal::CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params_Data* params =
          reinterpret_cast<
              internal::CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for CertVerifierServiceUpdater.1
      bool success = true;
      CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CertVerifierServiceUpdater::Name_, 1, false);
        return false;
      }
      auto callback =
          CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WaitUntilNextUpdateForTesting(std::move(callback));
      return true;
    }
    case messages::CertVerifierServiceUpdater::kSetCTPolicy: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCertVerifierServiceUpdaterValidationInfo[] = {
    { &internal::CertVerifierServiceUpdater_UpdateAdditionalCertificates_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_Params_Data::Validate,
     &internal::CertVerifierServiceUpdater_WaitUntilNextUpdateForTesting_ResponseParams_Data::Validate},
    { &internal::CertVerifierServiceUpdater_SetCTPolicy_Params_Data::Validate,
     nullptr /* no response */},
};

bool CertVerifierServiceUpdaterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::cert_verifier::mojom::CertVerifierServiceUpdater::Name_,
    kCertVerifierServiceUpdaterValidationInfo);
}

bool CertVerifierServiceUpdaterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::cert_verifier::mojom::CertVerifierServiceUpdater::Name_,
    kCertVerifierServiceUpdaterValidationInfo);
}


}  // cert_verifier::mojom


namespace mojo {


// static
bool StructTraits<::cert_verifier::mojom::CIDR::DataView, ::cert_verifier::mojom::CIDRPtr>::Read(
    ::cert_verifier::mojom::CIDR::DataView input,
    ::cert_verifier::mojom::CIDRPtr* output) {
  bool success = true;
  ::cert_verifier::mojom::CIDRPtr result(::cert_verifier::mojom::CIDR::New());
  
      if (success && !input.ReadIp(&result->ip))
        success = false;
      if (success && !input.ReadMask(&result->mask))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::cert_verifier::mojom::CertWithConstraints::DataView, ::cert_verifier::mojom::CertWithConstraintsPtr>::Read(
    ::cert_verifier::mojom::CertWithConstraints::DataView input,
    ::cert_verifier::mojom::CertWithConstraintsPtr* output) {
  bool success = true;
  ::cert_verifier::mojom::CertWithConstraintsPtr result(::cert_verifier::mojom::CertWithConstraints::New());
  
      if (success && !input.ReadCertificate(&result->certificate))
        success = false;
      if (success && !input.ReadPermittedDnsNames(&result->permitted_dns_names))
        success = false;
      if (success && !input.ReadPermittedCidrs(&result->permitted_cidrs))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::cert_verifier::mojom::AdditionalCertificates::DataView, ::cert_verifier::mojom::AdditionalCertificatesPtr>::Read(
    ::cert_verifier::mojom::AdditionalCertificates::DataView input,
    ::cert_verifier::mojom::AdditionalCertificatesPtr* output) {
  bool success = true;
  ::cert_verifier::mojom::AdditionalCertificatesPtr result(::cert_verifier::mojom::AdditionalCertificates::New());
  
      if (success && !input.ReadAllCertificates(&result->all_certificates))
        success = false;
      if (success && !input.ReadTrustAnchors(&result->trust_anchors))
        success = false;
      if (success && !input.ReadTrustAnchorsWithEnforcedConstraints(&result->trust_anchors_with_enforced_constraints))
        success = false;
      if (success && !input.ReadTrustAnchorsWithAdditionalConstraints(&result->trust_anchors_with_additional_constraints))
        success = false;
      if (success && !input.ReadTrustAnchorsAndLeafs(&result->trust_anchors_and_leafs))
        success = false;
      if (success && !input.ReadTrustLeafs(&result->trust_leafs))
        success = false;
      if (success && !input.ReadDistrustedSpkis(&result->distrusted_spkis))
        success = false;
      if (success)
        result->include_system_trust_store = input.include_system_trust_store();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace cert_verifier::mojom {


void CertVerifierServiceUpdaterInterceptorForTesting::UpdateAdditionalCertificates(AdditionalCertificatesPtr certificates) {
  GetForwardingInterface()->UpdateAdditionalCertificates(
    std::move(certificates)
    );
}
void CertVerifierServiceUpdaterInterceptorForTesting::WaitUntilNextUpdateForTesting(WaitUntilNextUpdateForTestingCallback callback) {
  GetForwardingInterface()->WaitUntilNextUpdateForTesting(std::move(callback));
}
void CertVerifierServiceUpdaterInterceptorForTesting::SetCTPolicy(::network::mojom::CTPolicyPtr ct_policy) {
  GetForwardingInterface()->SetCTPolicy(
    std::move(ct_policy)
    );
}
CertVerifierServiceUpdaterAsyncWaiter::CertVerifierServiceUpdaterAsyncWaiter(
    CertVerifierServiceUpdater* proxy) : proxy_(proxy) {}

CertVerifierServiceUpdaterAsyncWaiter::~CertVerifierServiceUpdaterAsyncWaiter() = default;


void CertVerifierServiceUpdaterAsyncWaiter::WaitUntilNextUpdateForTesting(
    ) {
  base::RunLoop loop;
  proxy_->WaitUntilNextUpdateForTesting(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // cert_verifier::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif