// services/network/public/mojom/cert_verifier_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ByteString as mojoBase_mojom_ByteString,
  ByteStringSpec as mojoBase_mojom_ByteStringSpec
} from '../../../../mojo/public/mojom/base/byte_string.mojom.m.js';

import {
  CertVerifyResult as network_mojom_CertVerifyResult,
  CertVerifyResultSpec as network_mojom_CertVerifyResultSpec,
  NetLogSource as network_mojom_NetLogSource,
  NetLogSourceSpec as network_mojom_NetLogSourceSpec,
  X509Certificate as network_mojom_X509Certificate,
  X509CertificateSpec as network_mojom_X509CertificateSpec
} from './network_param.mojom.m.js';

import {
  URLLoaderFactoryRemote as network_mojom_URLLoaderFactoryRemote,
  URLLoaderFactoryPendingReceiver as network_mojom_URLLoaderFactoryPendingReceiver
} from './url_loader_factory.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class URLLoaderFactoryConnectorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'cert_verifier.mojom.URLLoaderFactoryConnector', scope);
  }
}

/** @interface */
export class URLLoaderFactoryConnectorInterface {
  
  /**
   * @param { !network_mojom_URLLoaderFactoryPendingReceiver } urlLoaderFactory
   */

  createURLLoaderFactory(urlLoaderFactory) {}
}

/**
 * @implements { URLLoaderFactoryConnectorInterface }
 */
export class URLLoaderFactoryConnectorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!URLLoaderFactoryConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          URLLoaderFactoryConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!URLLoaderFactoryConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_URLLoaderFactoryPendingReceiver } urlLoaderFactory
   */

  createURLLoaderFactory(
      urlLoaderFactory) {
    this.proxy.sendMessage(
        0,
        URLLoaderFactoryConnector_CreateURLLoaderFactory_ParamsSpec.$,
        null,
        [
          urlLoaderFactory
        ],
        false);
  }
}

/**
 * An object which receives request messages for the URLLoaderFactoryConnector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class URLLoaderFactoryConnectorReceiver {
  /**
   * @param {!URLLoaderFactoryConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!URLLoaderFactoryConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        URLLoaderFactoryConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!URLLoaderFactoryConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        URLLoaderFactoryConnector_CreateURLLoaderFactory_ParamsSpec.$,
        null,
        impl.createURLLoaderFactory.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class URLLoaderFactoryConnector {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "cert_verifier.mojom.URLLoaderFactoryConnector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!URLLoaderFactoryConnectorRemote}
   */
  static getRemote() {
    let remote = new URLLoaderFactoryConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the URLLoaderFactoryConnector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class URLLoaderFactoryConnectorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      URLLoaderFactoryConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!URLLoaderFactoryConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createURLLoaderFactory =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        URLLoaderFactoryConnector_CreateURLLoaderFactory_ParamsSpec.$,
        null,
        this.createURLLoaderFactory.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CertVerifierServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'cert_verifier.mojom.CertVerifierService', scope);
  }
}

/** @interface */
export class CertVerifierServiceInterface {
  
  /**
   * @param { !network_mojom_URLLoaderFactoryRemote } urlLoaderFactory
   * @param { ?URLLoaderFactoryConnectorRemote } reconnector
   */

  enableNetworkAccess(urlLoaderFactory, reconnector) {}
  
  /**
   * @param { !RequestParams } params
   * @param { !network_mojom_NetLogSource } netLogSource
   * @param { !CertVerifierRequestRemote } certVerifierRequest
   */

  verify(params, netLogSource, certVerifierRequest) {}
  
  /**
   * @param { !string } binding
   * @param { !string } hostname
   * @param { !network_mojom_X509Certificate } tlsCertificate
   * @param { !network_mojom_NetLogSource } netLogSource
   * @return {!Promise<{
        verifiedCert: !network_mojom_X509Certificate,
   *  }>}
   */

  verify2QwacBinding(binding, hostname, tlsCertificate, netLogSource) {}
  
  /**
   * @param { !CertVerifierConfig } config
   */

  setConfig(config) {}
}

/**
 * @implements { CertVerifierServiceInterface }
 */
export class CertVerifierServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CertVerifierServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CertVerifierServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CertVerifierServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_URLLoaderFactoryRemote } urlLoaderFactory
   * @param { ?URLLoaderFactoryConnectorRemote } reconnector
   */

  enableNetworkAccess(
      urlLoaderFactory,
      reconnector) {
    this.proxy.sendMessage(
        0,
        CertVerifierService_EnableNetworkAccess_ParamsSpec.$,
        null,
        [
          urlLoaderFactory,
          reconnector
        ],
        false);
  }

  
  /**
   * @param { !RequestParams } params
   * @param { !network_mojom_NetLogSource } netLogSource
   * @param { !CertVerifierRequestRemote } certVerifierRequest
   */

  verify(
      params,
      netLogSource,
      certVerifierRequest) {
    this.proxy.sendMessage(
        1,
        CertVerifierService_Verify_ParamsSpec.$,
        null,
        [
          params,
          netLogSource,
          certVerifierRequest
        ],
        false);
  }

  
  /**
   * @param { !string } binding
   * @param { !string } hostname
   * @param { !network_mojom_X509Certificate } tlsCertificate
   * @param { !network_mojom_NetLogSource } netLogSource
   * @return {!Promise<{
        verifiedCert: !network_mojom_X509Certificate,
   *  }>}
   */

  verify2QwacBinding(
      binding,
      hostname,
      tlsCertificate,
      netLogSource) {
    return this.proxy.sendMessage(
        2,
        CertVerifierService_Verify2QwacBinding_ParamsSpec.$,
        CertVerifierService_Verify2QwacBinding_ResponseParamsSpec.$,
        [
          binding,
          hostname,
          tlsCertificate,
          netLogSource
        ],
        false);
  }

  
  /**
   * @param { !CertVerifierConfig } config
   */

  setConfig(
      config) {
    this.proxy.sendMessage(
        3,
        CertVerifierService_SetConfig_ParamsSpec.$,
        null,
        [
          config
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CertVerifierService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CertVerifierServiceReceiver {
  /**
   * @param {!CertVerifierServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CertVerifierServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CertVerifierServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CertVerifierServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CertVerifierService_EnableNetworkAccess_ParamsSpec.$,
        null,
        impl.enableNetworkAccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CertVerifierService_Verify_ParamsSpec.$,
        null,
        impl.verify.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        CertVerifierService_Verify2QwacBinding_ParamsSpec.$,
        CertVerifierService_Verify2QwacBinding_ResponseParamsSpec.$,
        impl.verify2QwacBinding.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        CertVerifierService_SetConfig_ParamsSpec.$,
        null,
        impl.setConfig.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CertVerifierService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "cert_verifier.mojom.CertVerifierService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CertVerifierServiceRemote}
   */
  static getRemote() {
    let remote = new CertVerifierServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CertVerifierService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CertVerifierServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CertVerifierServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CertVerifierServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableNetworkAccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CertVerifierService_EnableNetworkAccess_ParamsSpec.$,
        null,
        this.enableNetworkAccess.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verify =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CertVerifierService_Verify_ParamsSpec.$,
        null,
        this.verify.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.verify2QwacBinding =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        CertVerifierService_Verify2QwacBinding_ParamsSpec.$,
        CertVerifierService_Verify2QwacBinding_ResponseParamsSpec.$,
        this.verify2QwacBinding.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        CertVerifierService_SetConfig_ParamsSpec.$,
        null,
        this.setConfig.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CertVerifierServiceClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'cert_verifier.mojom.CertVerifierServiceClient', scope);
  }
}

/** @interface */
export class CertVerifierServiceClientInterface {
  
  /**
   */

  onCertVerifierChanged() {}
}

/**
 * @implements { CertVerifierServiceClientInterface }
 */
export class CertVerifierServiceClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CertVerifierServiceClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CertVerifierServiceClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CertVerifierServiceClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onCertVerifierChanged() {
    this.proxy.sendMessage(
        0,
        CertVerifierServiceClient_OnCertVerifierChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CertVerifierServiceClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CertVerifierServiceClientReceiver {
  /**
   * @param {!CertVerifierServiceClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CertVerifierServiceClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CertVerifierServiceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CertVerifierServiceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CertVerifierServiceClient_OnCertVerifierChanged_ParamsSpec.$,
        null,
        impl.onCertVerifierChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CertVerifierServiceClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "cert_verifier.mojom.CertVerifierServiceClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CertVerifierServiceClientRemote}
   */
  static getRemote() {
    let remote = new CertVerifierServiceClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CertVerifierServiceClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CertVerifierServiceClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CertVerifierServiceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CertVerifierServiceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCertVerifierChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CertVerifierServiceClient_OnCertVerifierChanged_ParamsSpec.$,
        null,
        this.onCertVerifierChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CertVerifierRequestPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'cert_verifier.mojom.CertVerifierRequest', scope);
  }
}

/** @interface */
export class CertVerifierRequestInterface {
  
  /**
   * @param { !network_mojom_CertVerifyResult } result
   * @param { !number } netError
   */

  complete(result, netError) {}
}

/**
 * @implements { CertVerifierRequestInterface }
 */
export class CertVerifierRequestRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CertVerifierRequestPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CertVerifierRequestPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CertVerifierRequestPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !network_mojom_CertVerifyResult } result
   * @param { !number } netError
   */

  complete(
      result,
      netError) {
    this.proxy.sendMessage(
        0,
        CertVerifierRequest_Complete_ParamsSpec.$,
        null,
        [
          result,
          netError
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CertVerifierRequest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CertVerifierRequestReceiver {
  /**
   * @param {!CertVerifierRequestInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CertVerifierRequestRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CertVerifierRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CertVerifierRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CertVerifierRequest_Complete_ParamsSpec.$,
        null,
        impl.complete.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CertVerifierRequest {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "cert_verifier.mojom.CertVerifierRequest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CertVerifierRequestRemote}
   */
  static getRemote() {
    let remote = new CertVerifierRequestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CertVerifierRequest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CertVerifierRequestCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CertVerifierRequestRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CertVerifierRequestRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.complete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CertVerifierRequest_Complete_ParamsSpec.$,
        null,
        this.complete.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RequestParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertVerifierConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const URLLoaderFactoryConnector_CreateURLLoaderFactory_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertVerifierService_EnableNetworkAccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertVerifierService_Verify_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertVerifierService_Verify2QwacBinding_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertVerifierService_Verify2QwacBinding_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertVerifierService_SetConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertVerifierServiceClient_OnCertVerifierChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CertVerifierRequest_Complete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    RequestParamsSpec.$,
    'RequestParams',
    [
      mojo.internal.StructField(
        'certificate', 0,
        0,
        network_mojom_X509CertificateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostname', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'flags', 16,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ocspResponse', 24,
        0,
        mojoBase_mojom_ByteStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sctList', 32,
        0,
        mojoBase_mojom_ByteStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class RequestParams {
  constructor() {
    /** @type { !network_mojom_X509Certificate } */
    this.certificate;
    /** @type { !string } */
    this.hostname;
    /** @type { !number } */
    this.flags;
    /** @type { !mojoBase_mojom_ByteString } */
    this.ocspResponse;
    /** @type { !mojoBase_mojom_ByteString } */
    this.sctList;
  }
}



mojo.internal.Struct(
    CertVerifierConfigSpec.$,
    'CertVerifierConfig',
    [
      mojo.internal.StructField(
        'enableRevChecking', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requireRevCheckingLocalAnchors', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableSha1LocalAnchors', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CertVerifierConfig {
  constructor() {
    /** @type { !boolean } */
    this.enableRevChecking;
    /** @type { !boolean } */
    this.requireRevCheckingLocalAnchors;
    /** @type { !boolean } */
    this.enableSha1LocalAnchors;
  }
}



mojo.internal.Struct(
    URLLoaderFactoryConnector_CreateURLLoaderFactory_ParamsSpec.$,
    'URLLoaderFactoryConnector_CreateURLLoaderFactory_Params',
    [
      mojo.internal.StructField(
        'urlLoaderFactory', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_URLLoaderFactoryPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class URLLoaderFactoryConnector_CreateURLLoaderFactory_Params {
  constructor() {
    /** @type { !network_mojom_URLLoaderFactoryPendingReceiver } */
    this.urlLoaderFactory;
  }
}



mojo.internal.Struct(
    CertVerifierService_EnableNetworkAccess_ParamsSpec.$,
    'CertVerifierService_EnableNetworkAccess_Params',
    [
      mojo.internal.StructField(
        'urlLoaderFactory', 0,
        0,
        mojo.internal.InterfaceProxy(network_mojom_URLLoaderFactoryRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reconnector', 8,
        0,
        mojo.internal.InterfaceProxy(URLLoaderFactoryConnectorRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CertVerifierService_EnableNetworkAccess_Params {
  constructor() {
    /** @type { !network_mojom_URLLoaderFactoryRemote } */
    this.urlLoaderFactory;
    /** @type { (URLLoaderFactoryConnectorRemote|undefined) } */
    this.reconnector;
  }
}



mojo.internal.Struct(
    CertVerifierService_Verify_ParamsSpec.$,
    'CertVerifierService_Verify_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        RequestParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'netLogSource', 8,
        0,
        network_mojom_NetLogSourceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'certVerifierRequest', 16,
        0,
        mojo.internal.InterfaceProxy(CertVerifierRequestRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CertVerifierService_Verify_Params {
  constructor() {
    /** @type { !RequestParams } */
    this.params;
    /** @type { !network_mojom_NetLogSource } */
    this.netLogSource;
    /** @type { !CertVerifierRequestRemote } */
    this.certVerifierRequest;
  }
}



mojo.internal.Struct(
    CertVerifierService_Verify2QwacBinding_ParamsSpec.$,
    'CertVerifierService_Verify2QwacBinding_Params',
    [
      mojo.internal.StructField(
        'binding', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hostname', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'tlsCertificate', 16,
        0,
        network_mojom_X509CertificateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'netLogSource', 24,
        0,
        network_mojom_NetLogSourceSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class CertVerifierService_Verify2QwacBinding_Params {
  constructor() {
    /** @type { !string } */
    this.binding;
    /** @type { !string } */
    this.hostname;
    /** @type { !network_mojom_X509Certificate } */
    this.tlsCertificate;
    /** @type { !network_mojom_NetLogSource } */
    this.netLogSource;
  }
}



mojo.internal.Struct(
    CertVerifierService_Verify2QwacBinding_ResponseParamsSpec.$,
    'CertVerifierService_Verify2QwacBinding_ResponseParams',
    [
      mojo.internal.StructField(
        'verifiedCert', 0,
        0,
        network_mojom_X509CertificateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CertVerifierService_Verify2QwacBinding_ResponseParams {
  constructor() {
    /** @type { !network_mojom_X509Certificate } */
    this.verifiedCert;
  }
}



mojo.internal.Struct(
    CertVerifierService_SetConfig_ParamsSpec.$,
    'CertVerifierService_SetConfig_Params',
    [
      mojo.internal.StructField(
        'config', 0,
        0,
        CertVerifierConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CertVerifierService_SetConfig_Params {
  constructor() {
    /** @type { !CertVerifierConfig } */
    this.config;
  }
}



mojo.internal.Struct(
    CertVerifierServiceClient_OnCertVerifierChanged_ParamsSpec.$,
    'CertVerifierServiceClient_OnCertVerifierChanged_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CertVerifierServiceClient_OnCertVerifierChanged_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CertVerifierRequest_Complete_ParamsSpec.$,
    'CertVerifierRequest_Complete_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        network_mojom_CertVerifyResultSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'netError', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CertVerifierRequest_Complete_Params {
  constructor() {
    /** @type { !network_mojom_CertVerifyResult } */
    this.result;
    /** @type { !number } */
    this.netError;
  }
}

