// services/network/public/mojom/address_list.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ADDRESS_LIST_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ADDRESS_LIST_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/address_list.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"

#include "services/network/public/mojom/address_list.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::AddressListDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::AddressListDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::AddressList_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::addresses(input)) in_addresses = Traits::addresses(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->addresses)::BaseType>
          addresses_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& addresses_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IPEndPointDataView>, send_validation>(
        in_addresses,
        addresses_fragment,
        &addresses_validate_params);

      fragment->addresses.Set(
          addresses_fragment.is_null() ? nullptr : addresses_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->addresses.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null addresses in AddressList struct");

      decltype(Traits::dns_aliases(input)) in_dns_aliases = Traits::dns_aliases(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dns_aliases)::BaseType>
          dns_aliases_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& dns_aliases_validate_params =
          mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>, send_validation>(
        in_dns_aliases,
        dns_aliases_fragment,
        &dns_aliases_validate_params);

      fragment->dns_aliases.Set(
          dns_aliases_fragment.is_null() ? nullptr : dns_aliases_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->dns_aliases.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dns_aliases in AddressList struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_ADDRESS_LIST_MOJOM_SEND_VALIDATION_H_