// services/metrics/public/mojom/ukm_interface.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/metrics/public/mojom/ukm_interface.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ukm.mojom');



  function UkmEntry(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UkmEntry.prototype.initDefaults_ = function() {
    this.sourceId = 0;
    this.eventHash = 0;
    this.metrics = null;
  };
  UkmEntry.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UkmEntry.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate UkmEntry.metrics
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 16, false, codec.Uint64, codec.Int64, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UkmEntry.encodedSize = codec.kStructHeaderSize + 24;

  UkmEntry.decode = function(decoder) {
    var packed;
    var val = new UkmEntry();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sourceId =
        decoder.decodeStruct(codec.Int64);
    val.eventHash =
        decoder.decodeStruct(codec.Uint64);
    val.metrics =
        decoder.decodeMapPointer(codec.Uint64, codec.Int64);
    return val;
  };

  UkmEntry.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UkmEntry.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.sourceId);
    encoder.encodeStruct(codec.Uint64, val.eventHash);
    encoder.encodeMapPointer(codec.Uint64, codec.Int64, val.metrics);
  };
  function UkmRecorderParameters(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UkmRecorderParameters.prototype.initDefaults_ = function() {
    this.isEnabled = false;
    this.eventHashBypassList = null;
  };
  UkmRecorderParameters.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UkmRecorderParameters.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate UkmRecorderParameters.eventHashBypassList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.Uint64, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UkmRecorderParameters.encodedSize = codec.kStructHeaderSize + 16;

  UkmRecorderParameters.decode = function(decoder) {
    var packed;
    var val = new UkmRecorderParameters();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isEnabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.eventHashBypassList =
        decoder.decodeArrayPointer(codec.Uint64);
    return val;
  };

  UkmRecorderParameters.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UkmRecorderParameters.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isEnabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.Uint64, val.eventHashBypassList);
  };
  function SingularUkmInterface_Submit_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SingularUkmInterface_Submit_Params.prototype.initDefaults_ = function() {
    this.entry = null;
  };
  SingularUkmInterface_Submit_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SingularUkmInterface_Submit_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SingularUkmInterface_Submit_Params.entry
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, UkmEntry, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SingularUkmInterface_Submit_Params.encodedSize = codec.kStructHeaderSize + 8;

  SingularUkmInterface_Submit_Params.decode = function(decoder) {
    var packed;
    var val = new SingularUkmInterface_Submit_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.entry =
        decoder.decodeStructPointer(UkmEntry);
    return val;
  };

  SingularUkmInterface_Submit_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SingularUkmInterface_Submit_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(UkmEntry, val.entry);
  };
  function UkmRecorderClientInterface_SetParameters_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UkmRecorderClientInterface_SetParameters_Params.prototype.initDefaults_ = function() {
    this.params = null;
  };
  UkmRecorderClientInterface_SetParameters_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UkmRecorderClientInterface_SetParameters_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UkmRecorderClientInterface_SetParameters_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, UkmRecorderParameters, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UkmRecorderClientInterface_SetParameters_Params.encodedSize = codec.kStructHeaderSize + 8;

  UkmRecorderClientInterface_SetParameters_Params.decode = function(decoder) {
    var packed;
    var val = new UkmRecorderClientInterface_SetParameters_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(UkmRecorderParameters);
    return val;
  };

  UkmRecorderClientInterface_SetParameters_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UkmRecorderClientInterface_SetParameters_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(UkmRecorderParameters, val.params);
  };
  function UkmRecorderInterface_AddEntry_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UkmRecorderInterface_AddEntry_Params.prototype.initDefaults_ = function() {
    this.entry = null;
  };
  UkmRecorderInterface_AddEntry_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UkmRecorderInterface_AddEntry_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UkmRecorderInterface_AddEntry_Params.entry
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, UkmEntry, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UkmRecorderInterface_AddEntry_Params.encodedSize = codec.kStructHeaderSize + 8;

  UkmRecorderInterface_AddEntry_Params.decode = function(decoder) {
    var packed;
    var val = new UkmRecorderInterface_AddEntry_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.entry =
        decoder.decodeStructPointer(UkmEntry);
    return val;
  };

  UkmRecorderInterface_AddEntry_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UkmRecorderInterface_AddEntry_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(UkmEntry, val.entry);
  };
  function UkmRecorderInterface_UpdateSourceURL_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UkmRecorderInterface_UpdateSourceURL_Params.prototype.initDefaults_ = function() {
    this.sourceId = 0;
    this.url = null;
  };
  UkmRecorderInterface_UpdateSourceURL_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UkmRecorderInterface_UpdateSourceURL_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate UkmRecorderInterface_UpdateSourceURL_Params.url
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UkmRecorderInterface_UpdateSourceURL_Params.encodedSize = codec.kStructHeaderSize + 16;

  UkmRecorderInterface_UpdateSourceURL_Params.decode = function(decoder) {
    var packed;
    var val = new UkmRecorderInterface_UpdateSourceURL_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sourceId =
        decoder.decodeStruct(codec.Int64);
    val.url =
        decoder.decodeStruct(codec.String);
    return val;
  };

  UkmRecorderInterface_UpdateSourceURL_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UkmRecorderInterface_UpdateSourceURL_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int64, val.sourceId);
    encoder.encodeStruct(codec.String, val.url);
  };
  function UkmRecorderFactory_CreateUkmRecorder_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  UkmRecorderFactory_CreateUkmRecorder_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
    this.clientRemote = new UkmRecorderClientInterfacePtr();
  };
  UkmRecorderFactory_CreateUkmRecorder_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  UkmRecorderFactory_CreateUkmRecorder_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate UkmRecorderFactory_CreateUkmRecorder_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate UkmRecorderFactory_CreateUkmRecorder_Params.clientRemote
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  UkmRecorderFactory_CreateUkmRecorder_Params.encodedSize = codec.kStructHeaderSize + 16;

  UkmRecorderFactory_CreateUkmRecorder_Params.decode = function(decoder) {
    var packed;
    var val = new UkmRecorderFactory_CreateUkmRecorder_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.clientRemote =
        decoder.decodeStruct(new codec.NullableInterface(UkmRecorderClientInterfacePtr));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  UkmRecorderFactory_CreateUkmRecorder_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(UkmRecorderFactory_CreateUkmRecorder_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.encodeStruct(new codec.NullableInterface(UkmRecorderClientInterfacePtr), val.clientRemote);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kSingularUkmInterface_Submit_Name = 0;

  function SingularUkmInterfacePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SingularUkmInterface,
                                                   handleOrPtrInfo);
  }

  function SingularUkmInterfaceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SingularUkmInterface, associatedInterfacePtrInfo);
  }

  SingularUkmInterfaceAssociatedPtr.prototype =
      Object.create(SingularUkmInterfacePtr.prototype);
  SingularUkmInterfaceAssociatedPtr.prototype.constructor =
      SingularUkmInterfaceAssociatedPtr;

  function SingularUkmInterfaceProxy(receiver) {
    this.receiver_ = receiver;
  }
  SingularUkmInterfacePtr.prototype.submit = function() {
    return SingularUkmInterfaceProxy.prototype.submit
        .apply(this.ptr.getProxy(), arguments);
  };

  SingularUkmInterfaceProxy.prototype.submit = function(entry) {
    var params_ = new SingularUkmInterface_Submit_Params();
    params_.entry = entry;
    var builder = new codec.MessageV0Builder(
        kSingularUkmInterface_Submit_Name,
        codec.align(SingularUkmInterface_Submit_Params.encodedSize));
    builder.encodeStruct(SingularUkmInterface_Submit_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SingularUkmInterfaceStub(delegate) {
    this.delegate_ = delegate;
  }
  SingularUkmInterfaceStub.prototype.submit = function(entry) {
    return this.delegate_ && this.delegate_.submit && this.delegate_.submit(entry);
  }

  SingularUkmInterfaceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSingularUkmInterface_Submit_Name:
      var params = reader.decodeStruct(SingularUkmInterface_Submit_Params);
      this.submit(params.entry);
      return true;
    default:
      return false;
    }
  };

  SingularUkmInterfaceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSingularUkmInterfaceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSingularUkmInterface_Submit_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SingularUkmInterface_Submit_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSingularUkmInterfaceResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SingularUkmInterface = {
    name: 'ukm.mojom.SingularUkmInterface',
    kVersion: 0,
    ptrClass: SingularUkmInterfacePtr,
    proxyClass: SingularUkmInterfaceProxy,
    stubClass: SingularUkmInterfaceStub,
    validateRequest: validateSingularUkmInterfaceRequest,
    validateResponse: null,
  };
  SingularUkmInterfaceStub.prototype.validator = validateSingularUkmInterfaceRequest;
  SingularUkmInterfaceProxy.prototype.validator = null;
  var kUkmRecorderClientInterface_SetParameters_Name = 0;

  function UkmRecorderClientInterfacePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(UkmRecorderClientInterface,
                                                   handleOrPtrInfo);
  }

  function UkmRecorderClientInterfaceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        UkmRecorderClientInterface, associatedInterfacePtrInfo);
  }

  UkmRecorderClientInterfaceAssociatedPtr.prototype =
      Object.create(UkmRecorderClientInterfacePtr.prototype);
  UkmRecorderClientInterfaceAssociatedPtr.prototype.constructor =
      UkmRecorderClientInterfaceAssociatedPtr;

  function UkmRecorderClientInterfaceProxy(receiver) {
    this.receiver_ = receiver;
  }
  UkmRecorderClientInterfacePtr.prototype.setParameters = function() {
    return UkmRecorderClientInterfaceProxy.prototype.setParameters
        .apply(this.ptr.getProxy(), arguments);
  };

  UkmRecorderClientInterfaceProxy.prototype.setParameters = function(params) {
    var params_ = new UkmRecorderClientInterface_SetParameters_Params();
    params_.params = params;
    var builder = new codec.MessageV0Builder(
        kUkmRecorderClientInterface_SetParameters_Name,
        codec.align(UkmRecorderClientInterface_SetParameters_Params.encodedSize));
    builder.encodeStruct(UkmRecorderClientInterface_SetParameters_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function UkmRecorderClientInterfaceStub(delegate) {
    this.delegate_ = delegate;
  }
  UkmRecorderClientInterfaceStub.prototype.setParameters = function(params) {
    return this.delegate_ && this.delegate_.setParameters && this.delegate_.setParameters(params);
  }

  UkmRecorderClientInterfaceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kUkmRecorderClientInterface_SetParameters_Name:
      var params = reader.decodeStruct(UkmRecorderClientInterface_SetParameters_Params);
      this.setParameters(params.params);
      return true;
    default:
      return false;
    }
  };

  UkmRecorderClientInterfaceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateUkmRecorderClientInterfaceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kUkmRecorderClientInterface_SetParameters_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = UkmRecorderClientInterface_SetParameters_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateUkmRecorderClientInterfaceResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var UkmRecorderClientInterface = {
    name: 'ukm.mojom.UkmRecorderClientInterface',
    kVersion: 0,
    ptrClass: UkmRecorderClientInterfacePtr,
    proxyClass: UkmRecorderClientInterfaceProxy,
    stubClass: UkmRecorderClientInterfaceStub,
    validateRequest: validateUkmRecorderClientInterfaceRequest,
    validateResponse: null,
  };
  UkmRecorderClientInterfaceStub.prototype.validator = validateUkmRecorderClientInterfaceRequest;
  UkmRecorderClientInterfaceProxy.prototype.validator = null;
  var kUkmRecorderInterface_AddEntry_Name = 0;
  var kUkmRecorderInterface_UpdateSourceURL_Name = 1;

  function UkmRecorderInterfacePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(UkmRecorderInterface,
                                                   handleOrPtrInfo);
  }

  function UkmRecorderInterfaceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        UkmRecorderInterface, associatedInterfacePtrInfo);
  }

  UkmRecorderInterfaceAssociatedPtr.prototype =
      Object.create(UkmRecorderInterfacePtr.prototype);
  UkmRecorderInterfaceAssociatedPtr.prototype.constructor =
      UkmRecorderInterfaceAssociatedPtr;

  function UkmRecorderInterfaceProxy(receiver) {
    this.receiver_ = receiver;
  }
  UkmRecorderInterfacePtr.prototype.addEntry = function() {
    return UkmRecorderInterfaceProxy.prototype.addEntry
        .apply(this.ptr.getProxy(), arguments);
  };

  UkmRecorderInterfaceProxy.prototype.addEntry = function(entry) {
    var params_ = new UkmRecorderInterface_AddEntry_Params();
    params_.entry = entry;
    var builder = new codec.MessageV0Builder(
        kUkmRecorderInterface_AddEntry_Name,
        codec.align(UkmRecorderInterface_AddEntry_Params.encodedSize));
    builder.encodeStruct(UkmRecorderInterface_AddEntry_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  UkmRecorderInterfacePtr.prototype.updateSourceURL = function() {
    return UkmRecorderInterfaceProxy.prototype.updateSourceURL
        .apply(this.ptr.getProxy(), arguments);
  };

  UkmRecorderInterfaceProxy.prototype.updateSourceURL = function(sourceId, url) {
    var params_ = new UkmRecorderInterface_UpdateSourceURL_Params();
    params_.sourceId = sourceId;
    params_.url = url;
    var builder = new codec.MessageV0Builder(
        kUkmRecorderInterface_UpdateSourceURL_Name,
        codec.align(UkmRecorderInterface_UpdateSourceURL_Params.encodedSize));
    builder.encodeStruct(UkmRecorderInterface_UpdateSourceURL_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function UkmRecorderInterfaceStub(delegate) {
    this.delegate_ = delegate;
  }
  UkmRecorderInterfaceStub.prototype.addEntry = function(entry) {
    return this.delegate_ && this.delegate_.addEntry && this.delegate_.addEntry(entry);
  }
  UkmRecorderInterfaceStub.prototype.updateSourceURL = function(sourceId, url) {
    return this.delegate_ && this.delegate_.updateSourceURL && this.delegate_.updateSourceURL(sourceId, url);
  }

  UkmRecorderInterfaceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kUkmRecorderInterface_AddEntry_Name:
      var params = reader.decodeStruct(UkmRecorderInterface_AddEntry_Params);
      this.addEntry(params.entry);
      return true;
    case kUkmRecorderInterface_UpdateSourceURL_Name:
      var params = reader.decodeStruct(UkmRecorderInterface_UpdateSourceURL_Params);
      this.updateSourceURL(params.sourceId, params.url);
      return true;
    default:
      return false;
    }
  };

  UkmRecorderInterfaceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateUkmRecorderInterfaceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kUkmRecorderInterface_AddEntry_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = UkmRecorderInterface_AddEntry_Params;
      break;
      case kUkmRecorderInterface_UpdateSourceURL_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = UkmRecorderInterface_UpdateSourceURL_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateUkmRecorderInterfaceResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var UkmRecorderInterface = {
    name: 'ukm.mojom.UkmRecorderInterface',
    kVersion: 0,
    ptrClass: UkmRecorderInterfacePtr,
    proxyClass: UkmRecorderInterfaceProxy,
    stubClass: UkmRecorderInterfaceStub,
    validateRequest: validateUkmRecorderInterfaceRequest,
    validateResponse: null,
  };
  UkmRecorderInterfaceStub.prototype.validator = validateUkmRecorderInterfaceRequest;
  UkmRecorderInterfaceProxy.prototype.validator = null;
  var kUkmRecorderFactory_CreateUkmRecorder_Name = 0;

  function UkmRecorderFactoryPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(UkmRecorderFactory,
                                                   handleOrPtrInfo);
  }

  function UkmRecorderFactoryAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        UkmRecorderFactory, associatedInterfacePtrInfo);
  }

  UkmRecorderFactoryAssociatedPtr.prototype =
      Object.create(UkmRecorderFactoryPtr.prototype);
  UkmRecorderFactoryAssociatedPtr.prototype.constructor =
      UkmRecorderFactoryAssociatedPtr;

  function UkmRecorderFactoryProxy(receiver) {
    this.receiver_ = receiver;
  }
  UkmRecorderFactoryPtr.prototype.createUkmRecorder = function() {
    return UkmRecorderFactoryProxy.prototype.createUkmRecorder
        .apply(this.ptr.getProxy(), arguments);
  };

  UkmRecorderFactoryProxy.prototype.createUkmRecorder = function(receiver, clientRemote) {
    var params_ = new UkmRecorderFactory_CreateUkmRecorder_Params();
    params_.receiver = receiver;
    params_.clientRemote = clientRemote;
    var builder = new codec.MessageV0Builder(
        kUkmRecorderFactory_CreateUkmRecorder_Name,
        codec.align(UkmRecorderFactory_CreateUkmRecorder_Params.encodedSize));
    builder.encodeStruct(UkmRecorderFactory_CreateUkmRecorder_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function UkmRecorderFactoryStub(delegate) {
    this.delegate_ = delegate;
  }
  UkmRecorderFactoryStub.prototype.createUkmRecorder = function(receiver, clientRemote) {
    return this.delegate_ && this.delegate_.createUkmRecorder && this.delegate_.createUkmRecorder(receiver, clientRemote);
  }

  UkmRecorderFactoryStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kUkmRecorderFactory_CreateUkmRecorder_Name:
      var params = reader.decodeStruct(UkmRecorderFactory_CreateUkmRecorder_Params);
      this.createUkmRecorder(params.receiver, params.clientRemote);
      return true;
    default:
      return false;
    }
  };

  UkmRecorderFactoryStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateUkmRecorderFactoryRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kUkmRecorderFactory_CreateUkmRecorder_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = UkmRecorderFactory_CreateUkmRecorder_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateUkmRecorderFactoryResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var UkmRecorderFactory = {
    name: 'ukm.mojom.UkmRecorderFactory',
    kVersion: 0,
    ptrClass: UkmRecorderFactoryPtr,
    proxyClass: UkmRecorderFactoryProxy,
    stubClass: UkmRecorderFactoryStub,
    validateRequest: validateUkmRecorderFactoryRequest,
    validateResponse: null,
  };
  UkmRecorderFactoryStub.prototype.validator = validateUkmRecorderFactoryRequest;
  UkmRecorderFactoryProxy.prototype.validator = null;
  exports.UkmEntry = UkmEntry;
  exports.UkmRecorderParameters = UkmRecorderParameters;
  exports.SingularUkmInterface = SingularUkmInterface;
  exports.SingularUkmInterfacePtr = SingularUkmInterfacePtr;
  exports.SingularUkmInterfaceAssociatedPtr = SingularUkmInterfaceAssociatedPtr;
  exports.UkmRecorderClientInterface = UkmRecorderClientInterface;
  exports.UkmRecorderClientInterfacePtr = UkmRecorderClientInterfacePtr;
  exports.UkmRecorderClientInterfaceAssociatedPtr = UkmRecorderClientInterfaceAssociatedPtr;
  exports.UkmRecorderInterface = UkmRecorderInterface;
  exports.UkmRecorderInterfacePtr = UkmRecorderInterfacePtr;
  exports.UkmRecorderInterfaceAssociatedPtr = UkmRecorderInterfaceAssociatedPtr;
  exports.UkmRecorderFactory = UkmRecorderFactory;
  exports.UkmRecorderFactoryPtr = UkmRecorderFactoryPtr;
  exports.UkmRecorderFactoryAssociatedPtr = UkmRecorderFactoryAssociatedPtr;
})();