// services/media_session/public/mojom/media_session.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/media_session/public/mojom/media_session.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/media_session/public/mojom/media_session.mojom-params-data.h"
namespace media_session {
namespace mojom {

NOINLINE static const char* MediaPlaybackStateToStringHelper(MediaPlaybackState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaPlaybackState::kPaused:
      return "kPaused";
    case MediaPlaybackState::kPlaying:
      return "kPlaying";
    default:
      return nullptr;
  }
}

std::string MediaPlaybackStateToString(MediaPlaybackState value) {
  const char *str = MediaPlaybackStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaPlaybackState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaPlaybackState value) {
  return os << MediaPlaybackStateToString(value);
}

NOINLINE static const char* MediaSessionActionToStringHelper(MediaSessionAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaSessionAction::kPlay:
      return "kPlay";
    case MediaSessionAction::kPause:
      return "kPause";
    case MediaSessionAction::kPreviousTrack:
      return "kPreviousTrack";
    case MediaSessionAction::kNextTrack:
      return "kNextTrack";
    case MediaSessionAction::kSeekBackward:
      return "kSeekBackward";
    case MediaSessionAction::kSeekForward:
      return "kSeekForward";
    case MediaSessionAction::kSkipAd:
      return "kSkipAd";
    case MediaSessionAction::kStop:
      return "kStop";
    case MediaSessionAction::kSeekTo:
      return "kSeekTo";
    case MediaSessionAction::kScrubTo:
      return "kScrubTo";
    case MediaSessionAction::kEnterPictureInPicture:
      return "kEnterPictureInPicture";
    case MediaSessionAction::kExitPictureInPicture:
      return "kExitPictureInPicture";
    case MediaSessionAction::kSwitchAudioDevice:
      return "kSwitchAudioDevice";
    case MediaSessionAction::kToggleMicrophone:
      return "kToggleMicrophone";
    case MediaSessionAction::kToggleCamera:
      return "kToggleCamera";
    case MediaSessionAction::kHangUp:
      return "kHangUp";
    case MediaSessionAction::kRaise:
      return "kRaise";
    case MediaSessionAction::kSetMute:
      return "kSetMute";
    case MediaSessionAction::kPreviousSlide:
      return "kPreviousSlide";
    case MediaSessionAction::kNextSlide:
      return "kNextSlide";
    case MediaSessionAction::kEnterAutoPictureInPicture:
      return "kEnterAutoPictureInPicture";
    default:
      return nullptr;
  }
}

std::string MediaSessionActionToString(MediaSessionAction value) {
  const char *str = MediaSessionActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaSessionAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaSessionAction value) {
  return os << MediaSessionActionToString(value);
}

NOINLINE static const char* MediaSessionImageTypeToStringHelper(MediaSessionImageType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaSessionImageType::kArtwork:
      return "kArtwork";
    case MediaSessionImageType::kSourceIcon:
      return "kSourceIcon";
    case MediaSessionImageType::kChapter:
      return "kChapter";
    default:
      return nullptr;
  }
}

std::string MediaSessionImageTypeToString(MediaSessionImageType value) {
  const char *str = MediaSessionImageTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaSessionImageType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaSessionImageType value) {
  return os << MediaSessionImageTypeToString(value);
}

NOINLINE static const char* MediaPictureInPictureStateToStringHelper(MediaPictureInPictureState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaPictureInPictureState::kNotInPictureInPicture:
      return "kNotInPictureInPicture";
    case MediaPictureInPictureState::kInPictureInPicture:
      return "kInPictureInPicture";
    default:
      return nullptr;
  }
}

std::string MediaPictureInPictureStateToString(MediaPictureInPictureState value) {
  const char *str = MediaPictureInPictureStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaPictureInPictureState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaPictureInPictureState value) {
  return os << MediaPictureInPictureStateToString(value);
}

NOINLINE static const char* MediaAudioVideoStateToStringHelper(MediaAudioVideoState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaAudioVideoState::kDeprecatedUnknown:
      return "kDeprecatedUnknown";
    case MediaAudioVideoState::kAudioOnly:
      return "kAudioOnly";
    case MediaAudioVideoState::kAudioVideo:
      return "kAudioVideo";
    case MediaAudioVideoState::kVideoOnly:
      return "kVideoOnly";
    default:
      return nullptr;
  }
}

std::string MediaAudioVideoStateToString(MediaAudioVideoState value) {
  const char *str = MediaAudioVideoStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaAudioVideoState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaAudioVideoState value) {
  return os << MediaAudioVideoStateToString(value);
}

NOINLINE static const char* MediaImageBitmapColorTypeToStringHelper(MediaImageBitmapColorType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaImageBitmapColorType::kRGBA_8888:
      return "kRGBA_8888";
    case MediaImageBitmapColorType::kBGRA_8888:
      return "kBGRA_8888";
    default:
      return nullptr;
  }
}

std::string MediaImageBitmapColorTypeToString(MediaImageBitmapColorType value) {
  const char *str = MediaImageBitmapColorTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaImageBitmapColorType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaImageBitmapColorType value) {
  return os << MediaImageBitmapColorTypeToString(value);
}

NOINLINE static const char* MicrophoneStateToStringHelper(MicrophoneState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MicrophoneState::kUnknown:
      return "kUnknown";
    case MicrophoneState::kMuted:
      return "kMuted";
    case MicrophoneState::kUnmuted:
      return "kUnmuted";
    default:
      return nullptr;
  }
}

std::string MicrophoneStateToString(MicrophoneState value) {
  const char *str = MicrophoneStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MicrophoneState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MicrophoneState value) {
  return os << MicrophoneStateToString(value);
}

NOINLINE static const char* CameraStateToStringHelper(CameraState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CameraState::kUnknown:
      return "kUnknown";
    case CameraState::kTurnedOn:
      return "kTurnedOn";
    case CameraState::kTurnedOff:
      return "kTurnedOff";
    default:
      return nullptr;
  }
}

std::string CameraStateToString(CameraState value) {
  const char *str = CameraStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CameraState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CameraState value) {
  return os << CameraStateToString(value);
}

NOINLINE static const char* MediaSessionInfo_SessionStateToStringHelper(MediaSessionInfo_SessionState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaSessionInfo_SessionState::kActive:
      return "kActive";
    case MediaSessionInfo_SessionState::kDucking:
      return "kDucking";
    case MediaSessionInfo_SessionState::kSuspended:
      return "kSuspended";
    case MediaSessionInfo_SessionState::kInactive:
      return "kInactive";
    default:
      return nullptr;
  }
}

std::string MediaSessionInfo_SessionStateToString(MediaSessionInfo_SessionState value) {
  const char *str = MediaSessionInfo_SessionStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaSessionInfo_SessionState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaSessionInfo_SessionState value) {
  return os << MediaSessionInfo_SessionStateToString(value);
}

NOINLINE static const char* MediaSession_SuspendTypeToStringHelper(MediaSession_SuspendType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaSession_SuspendType::kSystem:
      return "kSystem";
    case MediaSession_SuspendType::kUI:
      return "kUI";
    case MediaSession_SuspendType::kContent:
      return "kContent";
    default:
      return nullptr;
  }
}

std::string MediaSession_SuspendTypeToString(MediaSession_SuspendType value) {
  const char *str = MediaSession_SuspendTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaSession_SuspendType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaSession_SuspendType value) {
  return os << MediaSession_SuspendTypeToString(value);
}

namespace internal {


// static
bool MediaImage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaImage_Data* object =
      static_cast<const MediaImage_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->src, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->src, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->type, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sizes, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sizes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sizes, validation_context,
                                         &sizes_validate_params)) {
    return false;
  }

  return true;
}

MediaImage_Data::MediaImage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChapterInformation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChapterInformation_Data* object =
      static_cast<const ChapterInformation_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->startTime, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->startTime, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->artwork, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& artwork_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->artwork, validation_context,
                                         &artwork_validate_params)) {
    return false;
  }

  return true;
}

ChapterInformation_Data::ChapterInformation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 40 },
    { 21, 48 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaMetadata_Data* object =
      static_cast<const MediaMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->artist, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->artist, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->album, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->album, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_title, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_title, validation_context))
    return false;
  if (object->header_.version < 21)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& chapters_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->chapters, validation_context,
                                         &chapters_validate_params)) {
    return false;
  }

  return true;
}

MediaMetadata_Data::MediaMetadata_Data()
    : header_({sizeof(*this), 21}) {}


// static
bool MediaImageBitmap_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 24 },
    { 5, 32 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaImageBitmap_Data* object =
      static_cast<const MediaImageBitmap_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pixel_data, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pixel_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pixel_data, validation_context,
                                         &pixel_data_validate_params)) {
    return false;
  }
  if (object->header_.version < 5)
    return true;


  if (!::media_session::mojom::internal::MediaImageBitmapColorType_Data
        ::Validate(object->color_type, validation_context))
    return false;

  return true;
}

MediaImageBitmap_Data::MediaImageBitmap_Data()
    : header_({sizeof(*this), 5}) {}


// static
bool MediaPosition_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 40 },
    { 13, 48 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaPosition_Data* object =
      static_cast<const MediaPosition_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->position, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_updated_time, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_updated_time, validation_context))
    return false;

  return true;
}

MediaPosition_Data::MediaPosition_Data()
    : header_({sizeof(*this), 13}) {}


// static
bool RemotePlaybackMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 32 },
    { 17, 40 },
    { 18, 40 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RemotePlaybackMetadata_Data* object =
      static_cast<const RemotePlaybackMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->video_codec, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& video_codec_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->video_codec, validation_context,
                                         &video_codec_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->audio_codec, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& audio_codec_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->audio_codec, validation_context,
                                         &audio_codec_validate_params)) {
    return false;
  }
  if (object->header_.version < 17)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& unused_field_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->unused_field, validation_context,
                                         &unused_field_validate_params)) {
    return false;
  }

  return true;
}

RemotePlaybackMetadata_Data::RemotePlaybackMetadata_Data()
    : header_({sizeof(*this), 18}) {}


// static
bool MediaSessionInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  static constexpr mojo::internal::StructVersionSize kVersionSizes[] = {
    { 0, 16 },
    { 1, 24 },
    { 2, 24 },
    { 4, 24 },
    { 6, 24 },
    { 7, 24 },
    { 8, 32 },
    { 9, 40 },
    { 10, 48 },
    { 11, 56 },
    { 12, 56 },
    { 14, 56 },
    { 15, 64 },
    { 16, 64 },
    { 20, 64 },
    { 21, 64 },
    { 24, 64 },
  };
  if (!ValidateStructHeaderAndVersionSizeAndClaimMemory(
          data, kVersionSizes, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionInfo_Data* object =
      static_cast<const MediaSessionInfo_Data*>(data);


  if (!::media_session::mojom::internal::MediaSessionInfo_SessionState_Data
        ::Validate(object->state, validation_context))
    return false;
  if (object->header_.version < 1)
    return true;


  if (!::media_session::mojom::internal::MediaPlaybackState_Data
        ::Validate(object->playback_state, validation_context))
    return false;
  if (object->header_.version < 7)
    return true;


  if (!::media_session::mojom::internal::MediaPictureInPictureState_Data
        ::Validate(object->picture_in_picture_state, validation_context))
    return false;
  if (object->header_.version < 8)
    return true;


  if (!::media_session::mojom::internal::MediaAudioVideoState_Data
        ::Validate(object->deprecated_audio_video_state, validation_context))
    return false;
  if (object->header_.version < 9)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& audio_sink_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->audio_sink_id, validation_context,
                                         &audio_sink_id_validate_params)) {
    return false;
  }
  if (object->header_.version < 10)
    return true;

  constexpr const mojo::internal::ContainerValidateParams& audio_video_states_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::media_session::mojom::internal::MediaAudioVideoState_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->audio_video_states, validation_context,
                                         &audio_video_states_validate_params)) {
    return false;
  }
  if (object->header_.version < 11)
    return true;


  if (!::media_session::mojom::internal::MicrophoneState_Data
        ::Validate(object->microphone_state, validation_context))
    return false;


  if (!::media_session::mojom::internal::CameraState_Data
        ::Validate(object->camera_state, validation_context))
    return false;
  if (object->header_.version < 15)
    return true;

  if (!mojo::internal::ValidateStruct(object->remote_playback_metadata, validation_context))
    return false;

  return true;
}

MediaSessionInfo_Data::MediaSessionInfo_Data()
    : header_({sizeof(*this), 24}) {}


// static
bool MediaSessionDebugInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionDebugInfo_Data* object =
      static_cast<const MediaSessionDebugInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->owner, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& owner_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->owner, validation_context,
                                         &owner_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->state, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& state_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->state, validation_context,
                                         &state_validate_params)) {
    return false;
  }

  return true;
}

MediaSessionDebugInfo_Data::MediaSessionDebugInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionObserver_MediaSessionInfoChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionObserver_MediaSessionInfoChanged_Params_Data* object =
      static_cast<const MediaSessionObserver_MediaSessionInfoChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

MediaSessionObserver_MediaSessionInfoChanged_Params_Data::MediaSessionObserver_MediaSessionInfoChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionObserver_MediaSessionMetadataChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionObserver_MediaSessionMetadataChanged_Params_Data* object =
      static_cast<const MediaSessionObserver_MediaSessionMetadataChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

MediaSessionObserver_MediaSessionMetadataChanged_Params_Data::MediaSessionObserver_MediaSessionMetadataChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionObserver_MediaSessionActionsChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionObserver_MediaSessionActionsChanged_Params_Data* object =
      static_cast<const MediaSessionObserver_MediaSessionActionsChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->action, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& action_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::media_session::mojom::internal::MediaSessionAction_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->action, validation_context,
                                         &action_validate_params)) {
    return false;
  }

  return true;
}

MediaSessionObserver_MediaSessionActionsChanged_Params_Data::MediaSessionObserver_MediaSessionActionsChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionObserver_MediaSessionImagesChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionObserver_MediaSessionImagesChanged_Params_Data* object =
      static_cast<const MediaSessionObserver_MediaSessionImagesChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->images, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& images_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::media_session::mojom::internal::MediaSessionImageType_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->images, validation_context,
                                         &images_validate_params)) {
    return false;
  }

  return true;
}

MediaSessionObserver_MediaSessionImagesChanged_Params_Data::MediaSessionObserver_MediaSessionImagesChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSessionObserver_MediaSessionPositionChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSessionObserver_MediaSessionPositionChanged_Params_Data* object =
      static_cast<const MediaSessionObserver_MediaSessionPositionChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

MediaSessionObserver_MediaSessionPositionChanged_Params_Data::MediaSessionObserver_MediaSessionPositionChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetMediaSessionInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_GetMediaSessionInfo_Params_Data* object =
      static_cast<const MediaSession_GetMediaSessionInfo_Params_Data*>(data);

  return true;
}

MediaSession_GetMediaSessionInfo_Params_Data::MediaSession_GetMediaSessionInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetMediaSessionInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_GetMediaSessionInfo_ResponseParams_Data* object =
      static_cast<const MediaSession_GetMediaSessionInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

MediaSession_GetMediaSessionInfo_ResponseParams_Data::MediaSession_GetMediaSessionInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetDebugInfo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_GetDebugInfo_Params_Data* object =
      static_cast<const MediaSession_GetDebugInfo_Params_Data*>(data);

  return true;
}

MediaSession_GetDebugInfo_Params_Data::MediaSession_GetDebugInfo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetDebugInfo_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_GetDebugInfo_ResponseParams_Data* object =
      static_cast<const MediaSession_GetDebugInfo_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

MediaSession_GetDebugInfo_ResponseParams_Data::MediaSession_GetDebugInfo_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_StartDucking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_StartDucking_Params_Data* object =
      static_cast<const MediaSession_StartDucking_Params_Data*>(data);

  return true;
}

MediaSession_StartDucking_Params_Data::MediaSession_StartDucking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_StopDucking_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_StopDucking_Params_Data* object =
      static_cast<const MediaSession_StopDucking_Params_Data*>(data);

  return true;
}

MediaSession_StopDucking_Params_Data::MediaSession_StopDucking_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_Suspend_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_Suspend_Params_Data* object =
      static_cast<const MediaSession_Suspend_Params_Data*>(data);


  if (!::media_session::mojom::internal::MediaSession_SuspendType_Data
        ::Validate(object->suspend_type, validation_context))
    return false;

  return true;
}

MediaSession_Suspend_Params_Data::MediaSession_Suspend_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_Resume_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_Resume_Params_Data* object =
      static_cast<const MediaSession_Resume_Params_Data*>(data);


  if (!::media_session::mojom::internal::MediaSession_SuspendType_Data
        ::Validate(object->suspend_type, validation_context))
    return false;

  return true;
}

MediaSession_Resume_Params_Data::MediaSession_Resume_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_AddObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_AddObserver_Params_Data* object =
      static_cast<const MediaSession_AddObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaSession_AddObserver_Params_Data::MediaSession_AddObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_PreviousTrack_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_PreviousTrack_Params_Data* object =
      static_cast<const MediaSession_PreviousTrack_Params_Data*>(data);

  return true;
}

MediaSession_PreviousTrack_Params_Data::MediaSession_PreviousTrack_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_NextTrack_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_NextTrack_Params_Data* object =
      static_cast<const MediaSession_NextTrack_Params_Data*>(data);

  return true;
}

MediaSession_NextTrack_Params_Data::MediaSession_NextTrack_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_Seek_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_Seek_Params_Data* object =
      static_cast<const MediaSession_Seek_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seek_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seek_time, validation_context))
    return false;

  return true;
}

MediaSession_Seek_Params_Data::MediaSession_Seek_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_Stop_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_Stop_Params_Data* object =
      static_cast<const MediaSession_Stop_Params_Data*>(data);


  if (!::media_session::mojom::internal::MediaSession_SuspendType_Data
        ::Validate(object->suspend_type, validation_context))
    return false;

  return true;
}

MediaSession_Stop_Params_Data::MediaSession_Stop_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_SkipAd_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_SkipAd_Params_Data* object =
      static_cast<const MediaSession_SkipAd_Params_Data*>(data);

  return true;
}

MediaSession_SkipAd_Params_Data::MediaSession_SkipAd_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetMediaImageBitmap_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_GetMediaImageBitmap_Params_Data* object =
      static_cast<const MediaSession_GetMediaImageBitmap_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  return true;
}

MediaSession_GetMediaImageBitmap_Params_Data::MediaSession_GetMediaImageBitmap_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetMediaImageBitmap_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_GetMediaImageBitmap_ResponseParams_Data* object =
      static_cast<const MediaSession_GetMediaImageBitmap_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->image, validation_context))
    return false;

  return true;
}

MediaSession_GetMediaImageBitmap_ResponseParams_Data::MediaSession_GetMediaImageBitmap_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_SeekTo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_SeekTo_Params_Data* object =
      static_cast<const MediaSession_SeekTo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seek_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seek_time, validation_context))
    return false;

  return true;
}

MediaSession_SeekTo_Params_Data::MediaSession_SeekTo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_ScrubTo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_ScrubTo_Params_Data* object =
      static_cast<const MediaSession_ScrubTo_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->seek_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->seek_time, validation_context))
    return false;

  return true;
}

MediaSession_ScrubTo_Params_Data::MediaSession_ScrubTo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_EnterPictureInPicture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_EnterPictureInPicture_Params_Data* object =
      static_cast<const MediaSession_EnterPictureInPicture_Params_Data*>(data);

  return true;
}

MediaSession_EnterPictureInPicture_Params_Data::MediaSession_EnterPictureInPicture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_ExitPictureInPicture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_ExitPictureInPicture_Params_Data* object =
      static_cast<const MediaSession_ExitPictureInPicture_Params_Data*>(data);

  return true;
}

MediaSession_ExitPictureInPicture_Params_Data::MediaSession_ExitPictureInPicture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_SetAudioSinkId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_SetAudioSinkId_Params_Data* object =
      static_cast<const MediaSession_SetAudioSinkId_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

MediaSession_SetAudioSinkId_Params_Data::MediaSession_SetAudioSinkId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_ToggleMicrophone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_ToggleMicrophone_Params_Data* object =
      static_cast<const MediaSession_ToggleMicrophone_Params_Data*>(data);

  return true;
}

MediaSession_ToggleMicrophone_Params_Data::MediaSession_ToggleMicrophone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_ToggleCamera_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_ToggleCamera_Params_Data* object =
      static_cast<const MediaSession_ToggleCamera_Params_Data*>(data);

  return true;
}

MediaSession_ToggleCamera_Params_Data::MediaSession_ToggleCamera_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_HangUp_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_HangUp_Params_Data* object =
      static_cast<const MediaSession_HangUp_Params_Data*>(data);

  return true;
}

MediaSession_HangUp_Params_Data::MediaSession_HangUp_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_Raise_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_Raise_Params_Data* object =
      static_cast<const MediaSession_Raise_Params_Data*>(data);

  return true;
}

MediaSession_Raise_Params_Data::MediaSession_Raise_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_SetMute_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_SetMute_Params_Data* object =
      static_cast<const MediaSession_SetMute_Params_Data*>(data);

  return true;
}

MediaSession_SetMute_Params_Data::MediaSession_SetMute_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_RequestMediaRemoting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_RequestMediaRemoting_Params_Data* object =
      static_cast<const MediaSession_RequestMediaRemoting_Params_Data*>(data);

  return true;
}

MediaSession_RequestMediaRemoting_Params_Data::MediaSession_RequestMediaRemoting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_PreviousSlide_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_PreviousSlide_Params_Data* object =
      static_cast<const MediaSession_PreviousSlide_Params_Data*>(data);

  return true;
}

MediaSession_PreviousSlide_Params_Data::MediaSession_PreviousSlide_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_NextSlide_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_NextSlide_Params_Data* object =
      static_cast<const MediaSession_NextSlide_Params_Data*>(data);

  return true;
}

MediaSession_NextSlide_Params_Data::MediaSession_NextSlide_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_EnterAutoPictureInPicture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_EnterAutoPictureInPicture_Params_Data* object =
      static_cast<const MediaSession_EnterAutoPictureInPicture_Params_Data*>(data);

  return true;
}

MediaSession_EnterAutoPictureInPicture_Params_Data::MediaSession_EnterAutoPictureInPicture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetVisibility_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_GetVisibility_Params_Data* object =
      static_cast<const MediaSession_GetVisibility_Params_Data*>(data);

  return true;
}

MediaSession_GetVisibility_Params_Data::MediaSession_GetVisibility_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaSession_GetVisibility_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSession_GetVisibility_ResponseParams_Data* object =
      static_cast<const MediaSession_GetVisibility_ResponseParams_Data*>(data);

  return true;
}

MediaSession_GetVisibility_ResponseParams_Data::MediaSession_GetVisibility_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media_session

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaPlaybackState>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_session::mojom::MediaPlaybackState value) {
  return std::move(context).WriteString(::media_session::mojom::MediaPlaybackStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaSessionAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_session::mojom::MediaSessionAction value) {
  return std::move(context).WriteString(::media_session::mojom::MediaSessionActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaSessionImageType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_session::mojom::MediaSessionImageType value) {
  return std::move(context).WriteString(::media_session::mojom::MediaSessionImageTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaPictureInPictureState>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_session::mojom::MediaPictureInPictureState value) {
  return std::move(context).WriteString(::media_session::mojom::MediaPictureInPictureStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaAudioVideoState>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_session::mojom::MediaAudioVideoState value) {
  return std::move(context).WriteString(::media_session::mojom::MediaAudioVideoStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaImageBitmapColorType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_session::mojom::MediaImageBitmapColorType value) {
  return std::move(context).WriteString(::media_session::mojom::MediaImageBitmapColorTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MicrophoneState>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_session::mojom::MicrophoneState value) {
  return std::move(context).WriteString(::media_session::mojom::MicrophoneStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::CameraState>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_session::mojom::CameraState value) {
  return std::move(context).WriteString(::media_session::mojom::CameraStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaSessionInfo_SessionState>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_session::mojom::MediaSessionInfo_SessionState value) {
  return std::move(context).WriteString(::media_session::mojom::MediaSessionInfo_SessionStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_session::mojom::MediaSession_SuspendType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_session::mojom::MediaSession_SuspendType value) {
  return std::move(context).WriteString(::media_session::mojom::MediaSession_SuspendTypeToString(value));
}

} // namespace perfetto