// services/image_annotation/public/mojom/image_annotation.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/image_annotation/public/mojom/image_annotation.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/image_annotation/public/mojom/image_annotation.mojom-params-data.h"
#include "services/image_annotation/public/mojom/image_annotation.mojom-shared-message-ids.h"

#include "services/image_annotation/public/mojom/image_annotation.mojom-import-headers.h"
#include "services/image_annotation/public/mojom/image_annotation.mojom-test-utils.h"


namespace image_annotation::mojom {
Annotation::Annotation()
    : type(),
      score(),
      text() {}

Annotation::Annotation(
    AnnotationType type_in,
    double score_in,
    const std::string& text_in)
    : type(std::move(type_in)),
      score(std::move(score_in)),
      text(std::move(text_in)) {}

Annotation::~Annotation() = default;
size_t Annotation::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->type);
  seed = mojo::internal::Hash(seed, this->score);
  seed = mojo::internal::Hash(seed, this->text);
  return seed;
}

void Annotation::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AnnotationType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "score"), this->score,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text"), this->text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Annotation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AnnotateImageResultPtr
AnnotateImageResult::NewErrorCode(
    AnnotateImageError value) {
  return AnnotateImageResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorCode)>,
      std::move(value));
}

AnnotateImageResultPtr
AnnotateImageResult::NewAnnotations(
    std::vector<AnnotationPtr> value) {
  return AnnotateImageResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kAnnotations)>,
      std::move(value));
}

AnnotateImageResult::AnnotateImageResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
    AnnotateImageError value)
    : tag_(Tag::kErrorCode),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorCode)>,
            std::move(value)) {}

AnnotateImageResult::AnnotateImageResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kAnnotations)>,
    std::vector<AnnotationPtr> value)
    : tag_(Tag::kAnnotations),
      data_(std::in_place_index<static_cast<size_t>(Tag::kAnnotations)>,
            std::move(value)) {}
AnnotateImageResult::~AnnotateImageResult() {
  DestroyActive();
}

void AnnotateImageResult::set_error_code(AnnotateImageError error_code) {
  if (tag_ != Tag::kErrorCode) {
    DestroyActive();
    tag_ = Tag::kErrorCode;
  }
  data_.error_code = error_code;
}

void AnnotateImageResult::set_annotations(std::vector<AnnotationPtr> annotations) {
  if (tag_ == Tag::kAnnotations) {
    data_.annotations = std::move(annotations);
  } else {
    DestroyActive();
    tag_ = Tag::kAnnotations;
    new (&data_.annotations) std::vector<AnnotationPtr>(
        std::move(annotations));
  }
}


AnnotateImageResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorCode)>,
    AnnotateImageError value)
    : error_code(std::move(value)) {}

AnnotateImageResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kAnnotations)>,
    std::vector<AnnotationPtr> value)
    : annotations(std::move(value)) {}

void AnnotateImageResult::DestroyActive() {
  switch (tag_) {

    case Tag::kErrorCode:
      std::destroy_at(&data_.error_code);
      break;
    case Tag::kAnnotations:
      std::destroy_at(&data_.annotations);
      break;
  }
}

bool AnnotateImageResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

ImageProcessor::IPCStableHashFunction ImageProcessor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ImageProcessor>(message.name())) {
    case messages::ImageProcessor::kGetJpgImageData: {
      return &ImageProcessor::GetJpgImageData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ImageProcessor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ImageProcessor>(message.name())) {
      case messages::ImageProcessor::kGetJpgImageData:
            return "Receive image_annotation::mojom::ImageProcessor::GetJpgImageData";
    }
  } else {
    switch (static_cast<messages::ImageProcessor>(message.name())) {
      case messages::ImageProcessor::kGetJpgImageData:
            return "Receive reply image_annotation::mojom::ImageProcessor::GetJpgImageData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ImageProcessor::GetJpgImageData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xaff31177;  // IPCStableHash for image_annotation::mojom::ImageProcessor::GetJpgImageData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ImageProcessor_GetJpgImageData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ImageProcessor_GetJpgImageData_ForwardToCallback(
      ImageProcessor::GetJpgImageDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  ImageProcessor_GetJpgImageData_ForwardToCallback(const ImageProcessor_GetJpgImageData_ForwardToCallback&) = delete;
  ImageProcessor_GetJpgImageData_ForwardToCallback& operator=(const ImageProcessor_GetJpgImageData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ImageProcessor::GetJpgImageDataCallback callback_;
};

ImageProcessorProxy::ImageProcessorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ImageProcessorProxy::GetJpgImageData(
    GetJpgImageDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send image_annotation::mojom::ImageProcessor::GetJpgImageData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageProcessor::kGetJpgImageData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::image_annotation::mojom::internal::ImageProcessor_GetJpgImageData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageProcessor::Name_);
  message.set_method_name("GetJpgImageData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ImageProcessor_GetJpgImageData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class ImageProcessor_GetJpgImageData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ImageProcessor::GetJpgImageDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ImageProcessor_GetJpgImageData_ProxyToResponder> proxy(
        new ImageProcessor_GetJpgImageData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ImageProcessor_GetJpgImageData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ImageProcessor_GetJpgImageData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ImageProcessor_GetJpgImageData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ImageProcessor::GetJpgImageDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<uint8_t>& in_bytes, int32_t in_width, int32_t in_height);
};

bool ImageProcessor_GetJpgImageData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ImageProcessor_GetJpgImageData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ImageProcessor_GetJpgImageData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ImageProcessor.0
  bool success = true;
  std::vector<uint8_t> p_bytes{};
  int32_t p_width{};
  int32_t p_height{};
  ImageProcessor_GetJpgImageData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadBytes(&p_bytes))
    success = false;
  if (success)
    p_width = input_data_view.width();
  if (success)
    p_height = input_data_view.height();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ImageProcessor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_bytes), 
std::move(p_width), 
std::move(p_height));
  }
  return true;
}

void ImageProcessor_GetJpgImageData_ProxyToResponder::Run(
    const std::vector<uint8_t>& in_bytes, int32_t in_width, int32_t in_height) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply image_annotation::mojom::ImageProcessor::GetJpgImageData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("bytes"), in_bytes,
                        "<value of type const std::vector<uint8_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("width"), in_width,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("height"), in_height,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageProcessor::kGetJpgImageData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::image_annotation::mojom::internal::ImageProcessor_GetJpgImageData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->bytes)::BaseType>
      bytes_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_bytes,
    bytes_fragment,
    &bytes_validate_params);

  params->bytes.Set(
      bytes_fragment.is_null() ? nullptr : bytes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->bytes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null bytes in ");

  params->width = in_width;

  params->height = in_height;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageProcessor::Name_);
  message.set_method_name("GetJpgImageData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ImageProcessorStubDispatch::Accept(
    ImageProcessor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ImageProcessor>(message->header()->name)) {
    case messages::ImageProcessor::kGetJpgImageData: {
      break;
    }
  }
  return false;
}

// static
bool ImageProcessorStubDispatch::AcceptWithResponder(
    ImageProcessor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ImageProcessor>(message->header()->name)) {
    case messages::ImageProcessor::kGetJpgImageData: {
      internal::ImageProcessor_GetJpgImageData_Params_Data* params =
          reinterpret_cast<
              internal::ImageProcessor_GetJpgImageData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ImageProcessor.0
      bool success = true;
      ImageProcessor_GetJpgImageData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImageProcessor::Name_, 0, false);
        return false;
      }
      auto callback =
          ImageProcessor_GetJpgImageData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetJpgImageData(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kImageProcessorValidationInfo[] = {
    { &internal::ImageProcessor_GetJpgImageData_Params_Data::Validate,
     &internal::ImageProcessor_GetJpgImageData_ResponseParams_Data::Validate},
};

bool ImageProcessorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::image_annotation::mojom::ImageProcessor::Name_,
    kImageProcessorValidationInfo);
}

bool ImageProcessorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::image_annotation::mojom::ImageProcessor::Name_,
    kImageProcessorValidationInfo);
}
// The declaration includes the definition on other builds.

Annotator::IPCStableHashFunction Annotator::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Annotator>(message.name())) {
    case messages::Annotator::kAnnotateImage: {
      return &Annotator::AnnotateImage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Annotator::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Annotator>(message.name())) {
      case messages::Annotator::kAnnotateImage:
            return "Receive image_annotation::mojom::Annotator::AnnotateImage";
    }
  } else {
    switch (static_cast<messages::Annotator>(message.name())) {
      case messages::Annotator::kAnnotateImage:
            return "Receive reply image_annotation::mojom::Annotator::AnnotateImage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Annotator::AnnotateImage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4951a12a;  // IPCStableHash for image_annotation::mojom::Annotator::AnnotateImage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Annotator_AnnotateImage_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Annotator_AnnotateImage_ForwardToCallback(
      Annotator::AnnotateImageCallback callback
      ) : callback_(std::move(callback)) {
  }

  Annotator_AnnotateImage_ForwardToCallback(const Annotator_AnnotateImage_ForwardToCallback&) = delete;
  Annotator_AnnotateImage_ForwardToCallback& operator=(const Annotator_AnnotateImage_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Annotator::AnnotateImageCallback callback_;
};

AnnotatorProxy::AnnotatorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AnnotatorProxy::AnnotateImage(
    const std::string& in_source_id, const std::string& in_description_language_tag, ::mojo::PendingRemote<ImageProcessor> in_image_processor, AnnotateImageCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send image_annotation::mojom::Annotator::AnnotateImage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_id"), in_source_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("description_language_tag"), in_description_language_tag,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image_processor"), in_image_processor,
                        "<value of type ::mojo::PendingRemote<ImageProcessor>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Annotator::kAnnotateImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::image_annotation::mojom::internal::Annotator_AnnotateImage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_id)::BaseType> source_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_source_id,
    source_id_fragment);

  params->source_id.Set(
      source_id_fragment.is_null() ? nullptr : source_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_id in Annotator.AnnotateImage request");
  mojo::internal::MessageFragment<
      typename decltype(params->description_language_tag)::BaseType> description_language_tag_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_description_language_tag,
    description_language_tag_fragment);

  params->description_language_tag.Set(
      description_language_tag_fragment.is_null() ? nullptr : description_language_tag_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->description_language_tag.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null description_language_tag in Annotator.AnnotateImage request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::image_annotation::mojom::ImageProcessorInterfaceBase>>(
    in_image_processor,
    &params->image_processor,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->image_processor)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid image_processor in Annotator.AnnotateImage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Annotator::Name_);
  message.set_method_name("AnnotateImage");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Annotator_AnnotateImage_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Annotator_AnnotateImage_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Annotator::AnnotateImageCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Annotator_AnnotateImage_ProxyToResponder> proxy(
        new Annotator_AnnotateImage_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Annotator_AnnotateImage_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Annotator_AnnotateImage_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Annotator_AnnotateImage_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Annotator::AnnotateImageCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      AnnotateImageResultPtr in_result);
};

bool Annotator_AnnotateImage_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Annotator_AnnotateImage_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Annotator_AnnotateImage_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Annotator.0
  bool success = true;
  AnnotateImageResultPtr p_result{};
  Annotator_AnnotateImage_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Annotator::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Annotator_AnnotateImage_ProxyToResponder::Run(
    AnnotateImageResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply image_annotation::mojom::Annotator::AnnotateImage", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type AnnotateImageResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Annotator::kAnnotateImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::image_annotation::mojom::internal::Annotator_AnnotateImage_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::image_annotation::mojom::AnnotateImageResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Annotator::Name_);
  message.set_method_name("AnnotateImage");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AnnotatorStubDispatch::Accept(
    Annotator* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Annotator>(message->header()->name)) {
    case messages::Annotator::kAnnotateImage: {
      break;
    }
  }
  return false;
}

// static
bool AnnotatorStubDispatch::AcceptWithResponder(
    Annotator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Annotator>(message->header()->name)) {
    case messages::Annotator::kAnnotateImage: {
      internal::Annotator_AnnotateImage_Params_Data* params =
          reinterpret_cast<
              internal::Annotator_AnnotateImage_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Annotator.0
      bool success = true;
      std::string p_source_id{};
      std::string p_description_language_tag{};
      ::mojo::PendingRemote<ImageProcessor> p_image_processor{};
      Annotator_AnnotateImage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceId(&p_source_id))
        success = false;
      if (success && !input_data_view.ReadDescriptionLanguageTag(&p_description_language_tag))
        success = false;
      if (success) {
        p_image_processor =
            input_data_view.TakeImageProcessor<decltype(p_image_processor)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Annotator::Name_, 0, false);
        return false;
      }
      auto callback =
          Annotator_AnnotateImage_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AnnotateImage(        
        std::move(p_source_id), 
        std::move(p_description_language_tag), 
        std::move(p_image_processor), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAnnotatorValidationInfo[] = {
    { &internal::Annotator_AnnotateImage_Params_Data::Validate,
     &internal::Annotator_AnnotateImage_ResponseParams_Data::Validate},
};

bool AnnotatorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::image_annotation::mojom::Annotator::Name_,
    kAnnotatorValidationInfo);
}

bool AnnotatorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::image_annotation::mojom::Annotator::Name_,
    kAnnotatorValidationInfo);
}
// The declaration includes the definition on other builds.

ImageAnnotationService::IPCStableHashFunction ImageAnnotationService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ImageAnnotationService>(message.name())) {
    case messages::ImageAnnotationService::kBindAnnotator: {
      return &ImageAnnotationService::BindAnnotator_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ImageAnnotationService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ImageAnnotationService>(message.name())) {
      case messages::ImageAnnotationService::kBindAnnotator:
            return "Receive image_annotation::mojom::ImageAnnotationService::BindAnnotator";
    }
  } else {
    switch (static_cast<messages::ImageAnnotationService>(message.name())) {
      case messages::ImageAnnotationService::kBindAnnotator:
            return "Receive reply image_annotation::mojom::ImageAnnotationService::BindAnnotator";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ImageAnnotationService::BindAnnotator_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa49fb744;  // IPCStableHash for image_annotation::mojom::ImageAnnotationService::BindAnnotator
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ImageAnnotationServiceProxy::ImageAnnotationServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ImageAnnotationServiceProxy::BindAnnotator(
    ::mojo::PendingReceiver<Annotator> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send image_annotation::mojom::ImageAnnotationService::BindAnnotator", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<Annotator>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ImageAnnotationService::kBindAnnotator), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::image_annotation::mojom::internal::ImageAnnotationService_BindAnnotator_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::image_annotation::mojom::AnnotatorInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in ImageAnnotationService.BindAnnotator request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ImageAnnotationService::Name_);
  message.set_method_name("BindAnnotator");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ImageAnnotationServiceStubDispatch::Accept(
    ImageAnnotationService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ImageAnnotationService>(message->header()->name)) {
    case messages::ImageAnnotationService::kBindAnnotator: {
      DCHECK(message->is_serialized());
      internal::ImageAnnotationService_BindAnnotator_Params_Data* params =
          reinterpret_cast<internal::ImageAnnotationService_BindAnnotator_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ImageAnnotationService.0
      bool success = true;
      ::mojo::PendingReceiver<Annotator> p_receiver{};
      ImageAnnotationService_BindAnnotator_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ImageAnnotationService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindAnnotator(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool ImageAnnotationServiceStubDispatch::AcceptWithResponder(
    ImageAnnotationService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ImageAnnotationService>(message->header()->name)) {
    case messages::ImageAnnotationService::kBindAnnotator: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kImageAnnotationServiceValidationInfo[] = {
    { &internal::ImageAnnotationService_BindAnnotator_Params_Data::Validate,
     nullptr /* no response */},
};

bool ImageAnnotationServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::image_annotation::mojom::ImageAnnotationService::Name_,
    kImageAnnotationServiceValidationInfo);
}



}  // image_annotation::mojom


namespace mojo {


// static
bool StructTraits<::image_annotation::mojom::Annotation::DataView, ::image_annotation::mojom::AnnotationPtr>::Read(
    ::image_annotation::mojom::Annotation::DataView input,
    ::image_annotation::mojom::AnnotationPtr* output) {
  bool success = true;
  ::image_annotation::mojom::AnnotationPtr result(::image_annotation::mojom::Annotation::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->score = input.score();
      if (success && !input.ReadText(&result->text))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::image_annotation::mojom::AnnotateImageResult::DataView, ::image_annotation::mojom::AnnotateImageResultPtr>::Read(
    ::image_annotation::mojom::AnnotateImageResult::DataView input,
    ::image_annotation::mojom::AnnotateImageResultPtr* output) {
  using UnionType = ::image_annotation::mojom::AnnotateImageResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kErrorCode: {
      ::image_annotation::mojom::AnnotateImageError result_error_code;
      if (!input.ReadErrorCode(&result_error_code))
        return false;

      *output = UnionType::NewErrorCode(result_error_code);
      break;
    }
    case Tag::kAnnotations: {
      std::vector<::image_annotation::mojom::AnnotationPtr> result_annotations{};
      if (!input.ReadAnnotations(&result_annotations))
        return false;

      *output = UnionType::NewAnnotations(
          std::move(result_annotations));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace image_annotation::mojom {


void ImageProcessorInterceptorForTesting::GetJpgImageData(GetJpgImageDataCallback callback) {
  GetForwardingInterface()->GetJpgImageData(std::move(callback));
}
ImageProcessorAsyncWaiter::ImageProcessorAsyncWaiter(
    ImageProcessor* proxy) : proxy_(proxy) {}

ImageProcessorAsyncWaiter::~ImageProcessorAsyncWaiter() = default;


void ImageProcessorAsyncWaiter::GetJpgImageData(
    std::vector<uint8_t>* out_bytes, int32_t* out_width, int32_t* out_height) {
  base::RunLoop loop;
  proxy_->GetJpgImageData(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<uint8_t>* out_bytes
,
             int32_t* out_width
,
             int32_t* out_height
,
             const std::vector<uint8_t>& bytes,
             int32_t width,
             int32_t height) {*out_bytes = std::move(bytes);*out_width = std::move(width);*out_height = std::move(height);
            loop->Quit();
          },
          &loop,
          out_bytes,
          out_width,
          out_height));
  loop.Run();
}






void AnnotatorInterceptorForTesting::AnnotateImage(const std::string& source_id, const std::string& description_language_tag, ::mojo::PendingRemote<ImageProcessor> image_processor, AnnotateImageCallback callback) {
  GetForwardingInterface()->AnnotateImage(
    std::move(source_id)
    , 
    std::move(description_language_tag)
    , 
    std::move(image_processor)
    , std::move(callback));
}
AnnotatorAsyncWaiter::AnnotatorAsyncWaiter(
    Annotator* proxy) : proxy_(proxy) {}

AnnotatorAsyncWaiter::~AnnotatorAsyncWaiter() = default;


void AnnotatorAsyncWaiter::AnnotateImage(
    const std::string& source_id, const std::string& description_language_tag, ::mojo::PendingRemote<ImageProcessor> image_processor, AnnotateImageResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->AnnotateImage(
      std::move(source_id),
      std::move(description_language_tag),
      std::move(image_processor),
      base::BindOnce(
          [](base::RunLoop* loop,
             AnnotateImageResultPtr* out_result
,
             AnnotateImageResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

AnnotateImageResultPtr AnnotatorAsyncWaiter::AnnotateImage(
    const std::string& source_id, const std::string& description_language_tag, ::mojo::PendingRemote<ImageProcessor> image_processor) {
  AnnotateImageResultPtr async_wait_result;
  AnnotateImage(std::move(source_id),std::move(description_language_tag),std::move(image_processor),&async_wait_result);
  return async_wait_result;
}




void ImageAnnotationServiceInterceptorForTesting::BindAnnotator(::mojo::PendingReceiver<Annotator> receiver) {
  GetForwardingInterface()->BindAnnotator(
    std::move(receiver)
    );
}
ImageAnnotationServiceAsyncWaiter::ImageAnnotationServiceAsyncWaiter(
    ImageAnnotationService* proxy) : proxy_(proxy) {}

ImageAnnotationServiceAsyncWaiter::~ImageAnnotationServiceAsyncWaiter() = default;







}  // image_annotation::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif