// services/device/public/mojom/wake_lock_provider.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/wake_lock_provider.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/wake_lock_provider.mojom-params-data.h"
#include "services/device/public/mojom/wake_lock_provider.mojom-shared-message-ids.h"

#include "services/device/public/mojom/wake_lock_provider.mojom-import-headers.h"
#include "services/device/public/mojom/wake_lock_provider.mojom-test-utils.h"


namespace device::mojom {
// The declaration includes the definition on other builds.

WakeLockProvider::IPCStableHashFunction WakeLockProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WakeLockProvider>(message.name())) {
    case messages::WakeLockProvider::kGetWakeLockContextForID: {
      return &WakeLockProvider::GetWakeLockContextForID_Sym::IPCStableHash;
    }
    case messages::WakeLockProvider::kGetWakeLockWithoutContext: {
      return &WakeLockProvider::GetWakeLockWithoutContext_Sym::IPCStableHash;
    }
    case messages::WakeLockProvider::kNotifyOnWakeLockDeactivation: {
      return &WakeLockProvider::NotifyOnWakeLockDeactivation_Sym::IPCStableHash;
    }
    case messages::WakeLockProvider::kGetActiveWakeLocksForTests: {
      return &WakeLockProvider::GetActiveWakeLocksForTests_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WakeLockProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WakeLockProvider>(message.name())) {
      case messages::WakeLockProvider::kGetWakeLockContextForID:
            return "Receive device::mojom::WakeLockProvider::GetWakeLockContextForID";
      case messages::WakeLockProvider::kGetWakeLockWithoutContext:
            return "Receive device::mojom::WakeLockProvider::GetWakeLockWithoutContext";
      case messages::WakeLockProvider::kNotifyOnWakeLockDeactivation:
            return "Receive device::mojom::WakeLockProvider::NotifyOnWakeLockDeactivation";
      case messages::WakeLockProvider::kGetActiveWakeLocksForTests:
            return "Receive device::mojom::WakeLockProvider::GetActiveWakeLocksForTests";
    }
  } else {
    switch (static_cast<messages::WakeLockProvider>(message.name())) {
      case messages::WakeLockProvider::kGetWakeLockContextForID:
            return "Receive reply device::mojom::WakeLockProvider::GetWakeLockContextForID";
      case messages::WakeLockProvider::kGetWakeLockWithoutContext:
            return "Receive reply device::mojom::WakeLockProvider::GetWakeLockWithoutContext";
      case messages::WakeLockProvider::kNotifyOnWakeLockDeactivation:
            return "Receive reply device::mojom::WakeLockProvider::NotifyOnWakeLockDeactivation";
      case messages::WakeLockProvider::kGetActiveWakeLocksForTests:
            return "Receive reply device::mojom::WakeLockProvider::GetActiveWakeLocksForTests";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WakeLockProvider::GetWakeLockContextForID_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe0684d27;  // IPCStableHash for device::mojom::WakeLockProvider::GetWakeLockContextForID
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WakeLockProvider::GetWakeLockWithoutContext_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x281fe802;  // IPCStableHash for device::mojom::WakeLockProvider::GetWakeLockWithoutContext
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WakeLockProvider::NotifyOnWakeLockDeactivation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xedd514f1;  // IPCStableHash for device::mojom::WakeLockProvider::NotifyOnWakeLockDeactivation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WakeLockProvider::GetActiveWakeLocksForTests_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa79e836a;  // IPCStableHash for device::mojom::WakeLockProvider::GetActiveWakeLocksForTests
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WakeLockProvider_GetActiveWakeLocksForTests_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WakeLockProvider_GetActiveWakeLocksForTests_ForwardToCallback(
      WakeLockProvider::GetActiveWakeLocksForTestsCallback callback
      ) : callback_(std::move(callback)) {
  }

  WakeLockProvider_GetActiveWakeLocksForTests_ForwardToCallback(const WakeLockProvider_GetActiveWakeLocksForTests_ForwardToCallback&) = delete;
  WakeLockProvider_GetActiveWakeLocksForTests_ForwardToCallback& operator=(const WakeLockProvider_GetActiveWakeLocksForTests_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WakeLockProvider::GetActiveWakeLocksForTestsCallback callback_;
};

WakeLockProviderProxy::WakeLockProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WakeLockProviderProxy::GetWakeLockContextForID(
    int32_t in_context_id, ::mojo::PendingReceiver<::device::mojom::WakeLockContext> in_context) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::WakeLockProvider::GetWakeLockContextForID", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context_id"), in_context_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("context"), in_context,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::WakeLockContext>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WakeLockProvider::kGetWakeLockContextForID), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLockProvider_GetWakeLockContextForID_Params_Data> params(
          message);
  params.Allocate();

  params->context_id = in_context_id;

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::WakeLockContextInterfaceBase>>(
    in_context,
    &params->context,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->context)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid context in WakeLockProvider.GetWakeLockContextForID request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockProvider::Name_);
  message.set_method_name("GetWakeLockContextForID");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WakeLockProviderProxy::GetWakeLockWithoutContext(
    ::device::mojom::WakeLockType in_type, ::device::mojom::WakeLockReason in_reason, const std::string& in_description, ::mojo::PendingReceiver<::device::mojom::WakeLock> in_wake_lock) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::WakeLockProvider::GetWakeLockWithoutContext", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::device::mojom::WakeLockType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reason"), in_reason,
                        "<value of type ::device::mojom::WakeLockReason>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("description"), in_description,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("wake_lock"), in_wake_lock,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::WakeLock>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WakeLockProvider::kGetWakeLockWithoutContext), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLockProvider_GetWakeLockWithoutContext_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::WakeLockType>(
    in_type,
    &params->type);

  
  mojo::internal::Serialize<::device::mojom::WakeLockReason>(
    in_reason,
    &params->reason);
  mojo::internal::MessageFragment<
      typename decltype(params->description)::BaseType> description_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_description,
    description_fragment);

  params->description.Set(
      description_fragment.is_null() ? nullptr : description_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->description.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null description in WakeLockProvider.GetWakeLockWithoutContext request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::WakeLockInterfaceBase>>(
    in_wake_lock,
    &params->wake_lock,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->wake_lock)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid wake_lock in WakeLockProvider.GetWakeLockWithoutContext request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockProvider::Name_);
  message.set_method_name("GetWakeLockWithoutContext");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WakeLockProviderProxy::NotifyOnWakeLockDeactivation(
    ::device::mojom::WakeLockType in_type, ::mojo::PendingRemote<WakeLockObserver> in_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::WakeLockProvider::NotifyOnWakeLockDeactivation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::device::mojom::WakeLockType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("observer"), in_observer,
                        "<value of type ::mojo::PendingRemote<WakeLockObserver>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WakeLockProvider::kNotifyOnWakeLockDeactivation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLockProvider_NotifyOnWakeLockDeactivation_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::WakeLockType>(
    in_type,
    &params->type);

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::WakeLockObserverInterfaceBase>>(
    in_observer,
    &params->observer,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->observer)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid observer in WakeLockProvider.NotifyOnWakeLockDeactivation request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockProvider::Name_);
  message.set_method_name("NotifyOnWakeLockDeactivation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WakeLockProviderProxy::GetActiveWakeLocksForTests(
    ::device::mojom::WakeLockType in_type, GetActiveWakeLocksForTestsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::WakeLockProvider::GetActiveWakeLocksForTests", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::device::mojom::WakeLockType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WakeLockProvider::kGetActiveWakeLocksForTests), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLockProvider_GetActiveWakeLocksForTests_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::WakeLockType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockProvider::Name_);
  message.set_method_name("GetActiveWakeLocksForTests");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WakeLockProvider_GetActiveWakeLocksForTests_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WakeLockProvider::GetActiveWakeLocksForTestsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder> proxy(
        new WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WakeLockProvider::GetActiveWakeLocksForTestsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_count);
};

bool WakeLockProvider_GetActiveWakeLocksForTests_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WakeLockProvider_GetActiveWakeLocksForTests_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WakeLockProvider_GetActiveWakeLocksForTests_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WakeLockProvider.3
  bool success = true;
  int32_t p_count{};
  WakeLockProvider_GetActiveWakeLocksForTests_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_count = input_data_view.count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WakeLockProvider::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_count));
  }
  return true;
}

void WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder::Run(
    int32_t in_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::WakeLockProvider::GetActiveWakeLocksForTests", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("count"), in_count,
                        "<value of type int32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WakeLockProvider::kGetActiveWakeLocksForTests), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLockProvider_GetActiveWakeLocksForTests_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->count = in_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockProvider::Name_);
  message.set_method_name("GetActiveWakeLocksForTests");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WakeLockProviderStubDispatch::Accept(
    WakeLockProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WakeLockProvider>(message->header()->name)) {
    case messages::WakeLockProvider::kGetWakeLockContextForID: {
      DCHECK(message->is_serialized());
      internal::WakeLockProvider_GetWakeLockContextForID_Params_Data* params =
          reinterpret_cast<internal::WakeLockProvider_GetWakeLockContextForID_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WakeLockProvider.0
      bool success = true;
      int32_t p_context_id{};
      ::mojo::PendingReceiver<::device::mojom::WakeLockContext> p_context{};
      WakeLockProvider_GetWakeLockContextForID_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_context_id = input_data_view.context_id();
      if (success) {
        p_context =
            input_data_view.TakeContext<decltype(p_context)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLockProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWakeLockContextForID(        
        std::move(p_context_id), 
        std::move(p_context));
      return true;
    }
    case messages::WakeLockProvider::kGetWakeLockWithoutContext: {
      DCHECK(message->is_serialized());
      internal::WakeLockProvider_GetWakeLockWithoutContext_Params_Data* params =
          reinterpret_cast<internal::WakeLockProvider_GetWakeLockWithoutContext_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WakeLockProvider.1
      bool success = true;
      ::device::mojom::WakeLockType p_type{};
      ::device::mojom::WakeLockReason p_reason{};
      std::string p_description{};
      ::mojo::PendingReceiver<::device::mojom::WakeLock> p_wake_lock{};
      WakeLockProvider_GetWakeLockWithoutContext_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadReason(&p_reason))
        success = false;
      if (success && !input_data_view.ReadDescription(&p_description))
        success = false;
      if (success) {
        p_wake_lock =
            input_data_view.TakeWakeLock<decltype(p_wake_lock)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLockProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWakeLockWithoutContext(        
        std::move(p_type), 
        std::move(p_reason), 
        std::move(p_description), 
        std::move(p_wake_lock));
      return true;
    }
    case messages::WakeLockProvider::kNotifyOnWakeLockDeactivation: {
      DCHECK(message->is_serialized());
      internal::WakeLockProvider_NotifyOnWakeLockDeactivation_Params_Data* params =
          reinterpret_cast<internal::WakeLockProvider_NotifyOnWakeLockDeactivation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WakeLockProvider.2
      bool success = true;
      ::device::mojom::WakeLockType p_type{};
      ::mojo::PendingRemote<WakeLockObserver> p_observer{};
      WakeLockProvider_NotifyOnWakeLockDeactivation_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLockProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyOnWakeLockDeactivation(        
        std::move(p_type), 
        std::move(p_observer));
      return true;
    }
    case messages::WakeLockProvider::kGetActiveWakeLocksForTests: {
      break;
    }
  }
  return false;
}

// static
bool WakeLockProviderStubDispatch::AcceptWithResponder(
    WakeLockProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WakeLockProvider>(message->header()->name)) {
    case messages::WakeLockProvider::kGetWakeLockContextForID: {
      break;
    }
    case messages::WakeLockProvider::kGetWakeLockWithoutContext: {
      break;
    }
    case messages::WakeLockProvider::kNotifyOnWakeLockDeactivation: {
      break;
    }
    case messages::WakeLockProvider::kGetActiveWakeLocksForTests: {
      internal::WakeLockProvider_GetActiveWakeLocksForTests_Params_Data* params =
          reinterpret_cast<
              internal::WakeLockProvider_GetActiveWakeLocksForTests_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WakeLockProvider.3
      bool success = true;
      ::device::mojom::WakeLockType p_type{};
      WakeLockProvider_GetActiveWakeLocksForTests_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLockProvider::Name_, 3, false);
        return false;
      }
      auto callback =
          WakeLockProvider_GetActiveWakeLocksForTests_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetActiveWakeLocksForTests(        
        std::move(p_type), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWakeLockProviderValidationInfo[] = {
    { &internal::WakeLockProvider_GetWakeLockContextForID_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WakeLockProvider_GetWakeLockWithoutContext_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WakeLockProvider_NotifyOnWakeLockDeactivation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WakeLockProvider_GetActiveWakeLocksForTests_Params_Data::Validate,
     &internal::WakeLockProvider_GetActiveWakeLocksForTests_ResponseParams_Data::Validate},
};

bool WakeLockProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::WakeLockProvider::Name_,
    kWakeLockProviderValidationInfo);
}

bool WakeLockProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::WakeLockProvider::Name_,
    kWakeLockProviderValidationInfo);
}
// The declaration includes the definition on other builds.

WakeLockObserver::IPCStableHashFunction WakeLockObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WakeLockObserver>(message.name())) {
    case messages::WakeLockObserver::kOnWakeLockDeactivated: {
      return &WakeLockObserver::OnWakeLockDeactivated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WakeLockObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WakeLockObserver>(message.name())) {
      case messages::WakeLockObserver::kOnWakeLockDeactivated:
            return "Receive device::mojom::WakeLockObserver::OnWakeLockDeactivated";
    }
  } else {
    switch (static_cast<messages::WakeLockObserver>(message.name())) {
      case messages::WakeLockObserver::kOnWakeLockDeactivated:
            return "Receive reply device::mojom::WakeLockObserver::OnWakeLockDeactivated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WakeLockObserver::OnWakeLockDeactivated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x53759dfa;  // IPCStableHash for device::mojom::WakeLockObserver::OnWakeLockDeactivated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WakeLockObserverProxy::WakeLockObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WakeLockObserverProxy::OnWakeLockDeactivated(
    ::device::mojom::WakeLockType in_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::WakeLockObserver::OnWakeLockDeactivated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::device::mojom::WakeLockType>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WakeLockObserver::kOnWakeLockDeactivated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::WakeLockObserver_OnWakeLockDeactivated_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::WakeLockType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WakeLockObserver::Name_);
  message.set_method_name("OnWakeLockDeactivated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WakeLockObserverStubDispatch::Accept(
    WakeLockObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WakeLockObserver>(message->header()->name)) {
    case messages::WakeLockObserver::kOnWakeLockDeactivated: {
      DCHECK(message->is_serialized());
      internal::WakeLockObserver_OnWakeLockDeactivated_Params_Data* params =
          reinterpret_cast<internal::WakeLockObserver_OnWakeLockDeactivated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WakeLockObserver.0
      bool success = true;
      ::device::mojom::WakeLockType p_type{};
      WakeLockObserver_OnWakeLockDeactivated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WakeLockObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWakeLockDeactivated(        
        std::move(p_type));
      return true;
    }
  }
  return false;
}

// static
bool WakeLockObserverStubDispatch::AcceptWithResponder(
    WakeLockObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WakeLockObserver>(message->header()->name)) {
    case messages::WakeLockObserver::kOnWakeLockDeactivated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWakeLockObserverValidationInfo[] = {
    { &internal::WakeLockObserver_OnWakeLockDeactivated_Params_Data::Validate,
     nullptr /* no response */},
};

bool WakeLockObserverRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::WakeLockObserver::Name_,
    kWakeLockObserverValidationInfo);
}



}  // device::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void WakeLockProviderInterceptorForTesting::GetWakeLockContextForID(int32_t context_id, ::mojo::PendingReceiver<::device::mojom::WakeLockContext> context) {
  GetForwardingInterface()->GetWakeLockContextForID(
    std::move(context_id)
    , 
    std::move(context)
    );
}
void WakeLockProviderInterceptorForTesting::GetWakeLockWithoutContext(::device::mojom::WakeLockType type, ::device::mojom::WakeLockReason reason, const std::string& description, ::mojo::PendingReceiver<::device::mojom::WakeLock> wake_lock) {
  GetForwardingInterface()->GetWakeLockWithoutContext(
    std::move(type)
    , 
    std::move(reason)
    , 
    std::move(description)
    , 
    std::move(wake_lock)
    );
}
void WakeLockProviderInterceptorForTesting::NotifyOnWakeLockDeactivation(::device::mojom::WakeLockType type, ::mojo::PendingRemote<WakeLockObserver> observer) {
  GetForwardingInterface()->NotifyOnWakeLockDeactivation(
    std::move(type)
    , 
    std::move(observer)
    );
}
void WakeLockProviderInterceptorForTesting::GetActiveWakeLocksForTests(::device::mojom::WakeLockType type, GetActiveWakeLocksForTestsCallback callback) {
  GetForwardingInterface()->GetActiveWakeLocksForTests(
    std::move(type)
    , std::move(callback));
}
WakeLockProviderAsyncWaiter::WakeLockProviderAsyncWaiter(
    WakeLockProvider* proxy) : proxy_(proxy) {}

WakeLockProviderAsyncWaiter::~WakeLockProviderAsyncWaiter() = default;


void WakeLockProviderAsyncWaiter::GetActiveWakeLocksForTests(
    ::device::mojom::WakeLockType type, int32_t* out_count) {
  base::RunLoop loop;
  proxy_->GetActiveWakeLocksForTests(
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             int32_t* out_count
,
             int32_t count) {*out_count = std::move(count);
            loop->Quit();
          },
          &loop,
          out_count));
  loop.Run();
}

int32_t WakeLockProviderAsyncWaiter::GetActiveWakeLocksForTests(
    ::device::mojom::WakeLockType type) {
  int32_t async_wait_result;
  GetActiveWakeLocksForTests(std::move(type),&async_wait_result);
  return async_wait_result;
}




void WakeLockObserverInterceptorForTesting::OnWakeLockDeactivated(::device::mojom::WakeLockType type) {
  GetForwardingInterface()->OnWakeLockDeactivated(
    std::move(type)
    );
}
WakeLockObserverAsyncWaiter::WakeLockObserverAsyncWaiter(
    WakeLockObserver* proxy) : proxy_(proxy) {}

WakeLockObserverAsyncWaiter::~WakeLockObserverAsyncWaiter() = default;







}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif