// services/device/public/mojom/usb_manager_client.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  UsbDeviceInfo as device_mojom_UsbDeviceInfo,
  UsbDeviceInfoSpec as device_mojom_UsbDeviceInfoSpec
} from './usb_device.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class UsbDeviceManagerClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.UsbDeviceManagerClient', scope);
  }
}

/** @interface */
export class UsbDeviceManagerClientInterface {
  
  /**
   * @param { !device_mojom_UsbDeviceInfo } deviceInfo
   */

  onDeviceAdded(deviceInfo) {}
  
  /**
   * @param { !device_mojom_UsbDeviceInfo } deviceInfo
   */

  onDeviceRemoved(deviceInfo) {}
}

/**
 * @implements { UsbDeviceManagerClientInterface }
 */
export class UsbDeviceManagerClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!UsbDeviceManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UsbDeviceManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!UsbDeviceManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device_mojom_UsbDeviceInfo } deviceInfo
   */

  onDeviceAdded(
      deviceInfo) {
    this.proxy.sendMessage(
        0,
        UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec.$,
        null,
        [
          deviceInfo
        ],
        false);
  }

  
  /**
   * @param { !device_mojom_UsbDeviceInfo } deviceInfo
   */

  onDeviceRemoved(
      deviceInfo) {
    this.proxy.sendMessage(
        1,
        UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec.$,
        null,
        [
          deviceInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the UsbDeviceManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UsbDeviceManagerClientReceiver {
  /**
   * @param {!UsbDeviceManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!UsbDeviceManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UsbDeviceManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UsbDeviceManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec.$,
        null,
        impl.onDeviceAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec.$,
        null,
        impl.onDeviceRemoved.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UsbDeviceManagerClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.UsbDeviceManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!UsbDeviceManagerClientRemote}
   */
  static getRemote() {
    let remote = new UsbDeviceManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the UsbDeviceManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UsbDeviceManagerClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UsbDeviceManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UsbDeviceManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec.$,
        null,
        this.onDeviceAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec.$,
        null,
        this.onDeviceRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    UsbDeviceManagerClient_OnDeviceAdded_ParamsSpec.$,
    'UsbDeviceManagerClient_OnDeviceAdded_Params',
    [
      mojo.internal.StructField(
        'deviceInfo', 0,
        0,
        device_mojom_UsbDeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDeviceManagerClient_OnDeviceAdded_Params {
  constructor() {
    /** @type { !device_mojom_UsbDeviceInfo } */
    this.deviceInfo;
  }
}



mojo.internal.Struct(
    UsbDeviceManagerClient_OnDeviceRemoved_ParamsSpec.$,
    'UsbDeviceManagerClient_OnDeviceRemoved_Params',
    [
      mojo.internal.StructField(
        'deviceInfo', 0,
        0,
        device_mojom_UsbDeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UsbDeviceManagerClient_OnDeviceRemoved_Params {
  constructor() {
    /** @type { !device_mojom_UsbDeviceInfo } */
    this.deviceInfo;
  }
}

