// services/device/public/mojom/usb_device.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_TEST_UTILS_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_TEST_UTILS_H_

#include "services/device/public/mojom/usb_device.mojom.h"


namespace device::mojom {


class  UsbDeviceInterceptorForTesting : public UsbDevice {
  virtual UsbDevice* GetForwardingInterface() = 0;
  void Open(OpenCallback callback) override;
  void Close(CloseCallback callback) override;
  void SetConfiguration(uint8_t value, SetConfigurationCallback callback) override;
  void ClaimInterface(uint8_t interface_number, ClaimInterfaceCallback callback) override;
  void ReleaseInterface(uint8_t interface_number, ReleaseInterfaceCallback callback) override;
  void SetInterfaceAlternateSetting(uint8_t interface_number, uint8_t alternate_setting, SetInterfaceAlternateSettingCallback callback) override;
  void Reset(ResetCallback callback) override;
  void ClearHalt(UsbTransferDirection direction, uint8_t endpoint_number, ClearHaltCallback callback) override;
  void ControlTransferIn(UsbControlTransferParamsPtr params, uint32_t length, uint32_t timeout, ControlTransferInCallback callback) override;
  void ControlTransferOut(UsbControlTransferParamsPtr params, ::base::span<const ::uint8_t> data, uint32_t timeout, ControlTransferOutCallback callback) override;
  void GenericTransferIn(uint8_t endpoint_number, uint32_t length, uint32_t timeout, GenericTransferInCallback callback) override;
  void GenericTransferOut(uint8_t endpoint_number, ::base::span<const ::uint8_t> data, uint32_t timeout, GenericTransferOutCallback callback) override;
  void IsochronousTransferIn(uint8_t endpoint_number, const std::vector<uint32_t>& packet_lengths, uint32_t timeout, IsochronousTransferInCallback callback) override;
  void IsochronousTransferOut(uint8_t endpoint_number, ::base::span<const ::uint8_t> data, const std::vector<uint32_t>& packet_lengths, uint32_t timeout, IsochronousTransferOutCallback callback) override;
};
class  UsbDeviceAsyncWaiter {
 public:
  explicit UsbDeviceAsyncWaiter(UsbDevice* proxy);

  UsbDeviceAsyncWaiter(const UsbDeviceAsyncWaiter&) = delete;
  UsbDeviceAsyncWaiter& operator=(const UsbDeviceAsyncWaiter&) = delete;

  ~UsbDeviceAsyncWaiter();
  void Open(
      UsbOpenDeviceResultPtr* out_result);
  UsbOpenDeviceResultPtr Open();
  void Close(
      );
  
  void SetConfiguration(
      uint8_t value, bool* out_success);
  bool SetConfiguration(uint8_t value);
  void ClaimInterface(
      uint8_t interface_number, UsbClaimInterfaceResult* out_result);
  UsbClaimInterfaceResult ClaimInterface(uint8_t interface_number);
  void ReleaseInterface(
      uint8_t interface_number, bool* out_success);
  bool ReleaseInterface(uint8_t interface_number);
  void SetInterfaceAlternateSetting(
      uint8_t interface_number, uint8_t alternate_setting, bool* out_success);
  bool SetInterfaceAlternateSetting(uint8_t interface_number, uint8_t alternate_setting);
  void Reset(
      bool* out_success);
  bool Reset();
  void ClearHalt(
      UsbTransferDirection direction, uint8_t endpoint_number, bool* out_success);
  bool ClearHalt(UsbTransferDirection direction, uint8_t endpoint_number);
  void ControlTransferIn(
      UsbControlTransferParamsPtr params, uint32_t length, uint32_t timeout, UsbTransferStatus* out_status, ::base::span<const ::uint8_t>* out_data);
  
  void ControlTransferOut(
      UsbControlTransferParamsPtr params, ::base::span<const ::uint8_t> data, uint32_t timeout, UsbTransferStatus* out_status);
  UsbTransferStatus ControlTransferOut(UsbControlTransferParamsPtr params, ::base::span<const ::uint8_t> data, uint32_t timeout);
  void GenericTransferIn(
      uint8_t endpoint_number, uint32_t length, uint32_t timeout, UsbTransferStatus* out_status, ::base::span<const ::uint8_t>* out_data);
  
  void GenericTransferOut(
      uint8_t endpoint_number, ::base::span<const ::uint8_t> data, uint32_t timeout, UsbTransferStatus* out_status);
  UsbTransferStatus GenericTransferOut(uint8_t endpoint_number, ::base::span<const ::uint8_t> data, uint32_t timeout);
  void IsochronousTransferIn(
      uint8_t endpoint_number, const std::vector<uint32_t>& packet_lengths, uint32_t timeout, ::base::span<const ::uint8_t>* out_data, std::vector<UsbIsochronousPacketPtr>* out_packets);
  
  void IsochronousTransferOut(
      uint8_t endpoint_number, ::base::span<const ::uint8_t> data, const std::vector<uint32_t>& packet_lengths, uint32_t timeout, std::vector<UsbIsochronousPacketPtr>* out_packets);
  std::vector<UsbIsochronousPacketPtr> IsochronousTransferOut(uint8_t endpoint_number, ::base::span<const ::uint8_t> data, const std::vector<uint32_t>& packet_lengths, uint32_t timeout);

 private:
  UsbDevice* const proxy_;
};


class  UsbDeviceClientInterceptorForTesting : public UsbDeviceClient {
  virtual UsbDeviceClient* GetForwardingInterface() = 0;
  void OnDeviceOpened() override;
  void OnDeviceClosed() override;
};
class  UsbDeviceClientAsyncWaiter {
 public:
  explicit UsbDeviceClientAsyncWaiter(UsbDeviceClient* proxy);

  UsbDeviceClientAsyncWaiter(const UsbDeviceClientAsyncWaiter&) = delete;
  UsbDeviceClientAsyncWaiter& operator=(const UsbDeviceClientAsyncWaiter&) = delete;

  ~UsbDeviceClientAsyncWaiter();

 private:
  UsbDeviceClient* const proxy_;
};




}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_USB_DEVICE_MOJOM_TEST_UTILS_H_