// services/device/public/mojom/serial.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_TEST_UTILS_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_TEST_UTILS_H_

#include "services/device/public/mojom/serial.mojom.h"


namespace device::mojom {


class  SerialPortManagerInterceptorForTesting : public SerialPortManager {
  virtual SerialPortManager* GetForwardingInterface() = 0;
  void SetClient(::mojo::PendingRemote<SerialPortManagerClient> client) override;
  void GetDevices(GetDevicesCallback callback) override;
  void OpenPort(const ::base::UnguessableToken& token, bool use_alternate_path, SerialConnectionOptionsPtr options, ::mojo::PendingRemote<SerialPortClient> client, ::mojo::PendingRemote<SerialPortConnectionWatcher> watcher, OpenPortCallback callback) override;
};
class  SerialPortManagerAsyncWaiter {
 public:
  explicit SerialPortManagerAsyncWaiter(SerialPortManager* proxy);

  SerialPortManagerAsyncWaiter(const SerialPortManagerAsyncWaiter&) = delete;
  SerialPortManagerAsyncWaiter& operator=(const SerialPortManagerAsyncWaiter&) = delete;

  ~SerialPortManagerAsyncWaiter();
  void GetDevices(
      std::vector<SerialPortInfoPtr>* out_devices);
  std::vector<SerialPortInfoPtr> GetDevices();
  void OpenPort(
      const ::base::UnguessableToken& token, bool use_alternate_path, SerialConnectionOptionsPtr options, ::mojo::PendingRemote<SerialPortClient> client, ::mojo::PendingRemote<SerialPortConnectionWatcher> watcher, ::mojo::PendingRemote<SerialPort>* out_port);
  ::mojo::PendingRemote<SerialPort> OpenPort(const ::base::UnguessableToken& token, bool use_alternate_path, SerialConnectionOptionsPtr options, ::mojo::PendingRemote<SerialPortClient> client, ::mojo::PendingRemote<SerialPortConnectionWatcher> watcher);

 private:
  SerialPortManager* const proxy_;
};


class  SerialPortManagerClientInterceptorForTesting : public SerialPortManagerClient {
  virtual SerialPortManagerClient* GetForwardingInterface() = 0;
  void OnPortAdded(SerialPortInfoPtr port_info) override;
  void OnPortRemoved(SerialPortInfoPtr port_info) override;
  void OnPortConnectedStateChanged(SerialPortInfoPtr port_info) override;
};
class  SerialPortManagerClientAsyncWaiter {
 public:
  explicit SerialPortManagerClientAsyncWaiter(SerialPortManagerClient* proxy);

  SerialPortManagerClientAsyncWaiter(const SerialPortManagerClientAsyncWaiter&) = delete;
  SerialPortManagerClientAsyncWaiter& operator=(const SerialPortManagerClientAsyncWaiter&) = delete;

  ~SerialPortManagerClientAsyncWaiter();

 private:
  SerialPortManagerClient* const proxy_;
};


class  SerialPortInterceptorForTesting : public SerialPort {
  virtual SerialPort* GetForwardingInterface() = 0;
  void StartWriting(::mojo::ScopedDataPipeConsumerHandle consumer) override;
  void StartReading(::mojo::ScopedDataPipeProducerHandle producer) override;
  void Flush(SerialPortFlushMode mode, FlushCallback callback) override;
  void Drain(DrainCallback callback) override;
  void GetControlSignals(GetControlSignalsCallback callback) override;
  void SetControlSignals(SerialHostControlSignalsPtr signals, SetControlSignalsCallback callback) override;
  void ConfigurePort(SerialConnectionOptionsPtr options, ConfigurePortCallback callback) override;
  void GetPortInfo(GetPortInfoCallback callback) override;
  void Close(bool flush, CloseCallback callback) override;
};
class  SerialPortAsyncWaiter {
 public:
  explicit SerialPortAsyncWaiter(SerialPort* proxy);

  SerialPortAsyncWaiter(const SerialPortAsyncWaiter&) = delete;
  SerialPortAsyncWaiter& operator=(const SerialPortAsyncWaiter&) = delete;

  ~SerialPortAsyncWaiter();
  void Flush(
      SerialPortFlushMode mode);
  
  void Drain(
      );
  
  void GetControlSignals(
      SerialPortControlSignalsPtr* out_signals);
  SerialPortControlSignalsPtr GetControlSignals();
  void SetControlSignals(
      SerialHostControlSignalsPtr signals, bool* out_success);
  bool SetControlSignals(SerialHostControlSignalsPtr signals);
  void ConfigurePort(
      SerialConnectionOptionsPtr options, bool* out_success);
  bool ConfigurePort(SerialConnectionOptionsPtr options);
  void GetPortInfo(
      SerialConnectionInfoPtr* out_info);
  SerialConnectionInfoPtr GetPortInfo();
  void Close(
      bool flush);
  

 private:
  SerialPort* const proxy_;
};


class  SerialPortClientInterceptorForTesting : public SerialPortClient {
  virtual SerialPortClient* GetForwardingInterface() = 0;
  void OnReadError(SerialReceiveError error) override;
  void OnSendError(SerialSendError error) override;
};
class  SerialPortClientAsyncWaiter {
 public:
  explicit SerialPortClientAsyncWaiter(SerialPortClient* proxy);

  SerialPortClientAsyncWaiter(const SerialPortClientAsyncWaiter&) = delete;
  SerialPortClientAsyncWaiter& operator=(const SerialPortClientAsyncWaiter&) = delete;

  ~SerialPortClientAsyncWaiter();

 private:
  SerialPortClient* const proxy_;
};


class  SerialPortConnectionWatcherInterceptorForTesting : public SerialPortConnectionWatcher {
  virtual SerialPortConnectionWatcher* GetForwardingInterface() = 0;
};
class  SerialPortConnectionWatcherAsyncWaiter {
 public:
  explicit SerialPortConnectionWatcherAsyncWaiter(SerialPortConnectionWatcher* proxy);

  SerialPortConnectionWatcherAsyncWaiter(const SerialPortConnectionWatcherAsyncWaiter&) = delete;
  SerialPortConnectionWatcherAsyncWaiter& operator=(const SerialPortConnectionWatcherAsyncWaiter&) = delete;

  ~SerialPortConnectionWatcherAsyncWaiter();

 private:
  SerialPortConnectionWatcher* const proxy_;
};




}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_TEST_UTILS_H_