// services/device/public/mojom/serial.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_DATA_VIEW_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/device/public/mojom/serial.mojom-shared-internal.h"
#include "device/bluetooth/public/mojom/uuid.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"


namespace device::mojom {
class SerialPortInfoDataView;

class SerialConnectionOptionsDataView;

class SerialConnectionInfoDataView;

class SerialHostControlSignalsDataView;

class SerialPortControlSignalsDataView;



}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::SerialPortInfoDataView> {
  using Data = ::device::mojom::internal::SerialPortInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SerialConnectionOptionsDataView> {
  using Data = ::device::mojom::internal::SerialConnectionOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SerialConnectionInfoDataView> {
  using Data = ::device::mojom::internal::SerialConnectionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SerialHostControlSignalsDataView> {
  using Data = ::device::mojom::internal::SerialHostControlSignals_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::SerialPortControlSignalsDataView> {
  using Data = ::device::mojom::internal::SerialPortControlSignals_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class SerialSendError : int32_t {
  
  NONE = 0,
  
  DISCONNECTED = 1,
  
  SYSTEM_ERROR = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SerialSendError value);
inline bool IsKnownEnumValue(SerialSendError value) {
  return internal::SerialSendError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SerialReceiveError : int32_t {
  
  NONE = 0,
  
  DISCONNECTED = 1,
  
  DEVICE_LOST = 2,
  
  BREAK = 3,
  
  FRAME_ERROR = 4,
  
  OVERRUN = 5,
  
  BUFFER_OVERFLOW = 6,
  
  PARITY_ERROR = 7,
  
  SYSTEM_ERROR = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

 std::ostream& operator<<(std::ostream& os, SerialReceiveError value);
inline bool IsKnownEnumValue(SerialReceiveError value) {
  return internal::SerialReceiveError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SerialDataBits : int32_t {
  
  NONE = 0,
  
  SEVEN = 1,
  
  EIGHT = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SerialDataBits value);
inline bool IsKnownEnumValue(SerialDataBits value) {
  return internal::SerialDataBits_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SerialParityBit : int32_t {
  
  NONE = 0,
  
  NO_PARITY = 1,
  
  ODD = 2,
  
  EVEN = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, SerialParityBit value);
inline bool IsKnownEnumValue(SerialParityBit value) {
  return internal::SerialParityBit_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SerialStopBits : int32_t {
  
  NONE = 0,
  
  ONE = 1,
  
  TWO = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SerialStopBits value);
inline bool IsKnownEnumValue(SerialStopBits value) {
  return internal::SerialStopBits_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SerialPortFlushMode : int32_t {
  
  kReceiveAndTransmit = 0,
  
  kReceive = 1,
  
  kTransmit = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, SerialPortFlushMode value);
inline bool IsKnownEnumValue(SerialPortFlushMode value) {
  return internal::SerialPortFlushMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SerialPortType : int32_t {
  
  PLATFORM_SERIAL = 0,
  
  BLUETOOTH_CLASSIC_RFCOMM = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, SerialPortType value);
inline bool IsKnownEnumValue(SerialPortType value) {
  return internal::SerialPortType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class SerialPortManagerInterfaceBase {};

using SerialPortManagerPtrDataView =
    mojo::InterfacePtrDataView<SerialPortManagerInterfaceBase>;
using SerialPortManagerRequestDataView =
    mojo::InterfaceRequestDataView<SerialPortManagerInterfaceBase>;
using SerialPortManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SerialPortManagerInterfaceBase>;
using SerialPortManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SerialPortManagerInterfaceBase>;
class SerialPortManagerClientInterfaceBase {};

using SerialPortManagerClientPtrDataView =
    mojo::InterfacePtrDataView<SerialPortManagerClientInterfaceBase>;
using SerialPortManagerClientRequestDataView =
    mojo::InterfaceRequestDataView<SerialPortManagerClientInterfaceBase>;
using SerialPortManagerClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SerialPortManagerClientInterfaceBase>;
using SerialPortManagerClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SerialPortManagerClientInterfaceBase>;
class SerialPortInterfaceBase {};

using SerialPortPtrDataView =
    mojo::InterfacePtrDataView<SerialPortInterfaceBase>;
using SerialPortRequestDataView =
    mojo::InterfaceRequestDataView<SerialPortInterfaceBase>;
using SerialPortAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SerialPortInterfaceBase>;
using SerialPortAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SerialPortInterfaceBase>;
class SerialPortClientInterfaceBase {};

using SerialPortClientPtrDataView =
    mojo::InterfacePtrDataView<SerialPortClientInterfaceBase>;
using SerialPortClientRequestDataView =
    mojo::InterfaceRequestDataView<SerialPortClientInterfaceBase>;
using SerialPortClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SerialPortClientInterfaceBase>;
using SerialPortClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SerialPortClientInterfaceBase>;
class SerialPortConnectionWatcherInterfaceBase {};

using SerialPortConnectionWatcherPtrDataView =
    mojo::InterfacePtrDataView<SerialPortConnectionWatcherInterfaceBase>;
using SerialPortConnectionWatcherRequestDataView =
    mojo::InterfaceRequestDataView<SerialPortConnectionWatcherInterfaceBase>;
using SerialPortConnectionWatcherAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SerialPortConnectionWatcherInterfaceBase>;
using SerialPortConnectionWatcherAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SerialPortConnectionWatcherInterfaceBase>;


class SerialPortInfoDataView {
 public:
  SerialPortInfoDataView() = default;

  SerialPortInfoDataView(
      internal::SerialPortInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetPathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPath(UserType* output) {
    
    auto* pointer = data_->path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::device::mojom::SerialPortType>(
        data_value, output);
  }
  SerialPortType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::SerialPortType>(data_->type));
  }
  inline void GetAlternatePathDataView(
      ::mojo_base::mojom::FilePathDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlternatePath(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::FilePathDataView, UserType>(),
    "Attempting to read the optional `alternate_path` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadAlternatePath` instead "
    "of `ReadAlternatePath if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->alternate_path.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FilePathDataView>(
        pointer, output, message_);
  }
  inline void GetUsbDriverNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUsbDriverName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `usb_driver_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUsbDriverName` instead "
    "of `ReadUsbDriverName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->usb_driver_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint16_t vendor_id() const {
    return data_->vendor_id;
  }
  bool has_vendor_id() const {
    return data_->has_vendor_id;
  }
  uint16_t product_id() const {
    return data_->product_id;
  }
  bool has_product_id() const {
    return data_->has_product_id;
  }
  inline void GetBluetoothServiceClassIdDataView(
      ::bluetooth::mojom::UUIDDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBluetoothServiceClassId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::bluetooth::mojom::UUIDDataView, UserType>(),
    "Attempting to read the optional `bluetooth_service_class_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBluetoothServiceClassId` instead "
    "of `ReadBluetoothServiceClassId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bluetooth_service_class_id.Get();
    return mojo::internal::Deserialize<::bluetooth::mojom::UUIDDataView>(
        pointer, output, message_);
  }
  inline void GetDisplayNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `display_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDisplayName` instead "
    "of `ReadDisplayName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->display_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSerialNumberDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerialNumber(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `serial_number` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSerialNumber` instead "
    "of `ReadSerialNumber if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->serial_number.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool connected() const {
    return data_->connected;
  }
 private:
  internal::SerialPortInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SerialConnectionOptionsDataView {
 public:
  SerialConnectionOptionsDataView() = default;

  SerialConnectionOptionsDataView(
      internal::SerialConnectionOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t bitrate() const {
    return data_->bitrate;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDataBits(UserType* output) const {
    auto data_value = data_->data_bits;
    return mojo::internal::Deserialize<::device::mojom::SerialDataBits>(
        data_value, output);
  }
  SerialDataBits data_bits() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::SerialDataBits>(data_->data_bits));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadParityBit(UserType* output) const {
    auto data_value = data_->parity_bit;
    return mojo::internal::Deserialize<::device::mojom::SerialParityBit>(
        data_value, output);
  }
  SerialParityBit parity_bit() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::SerialParityBit>(data_->parity_bit));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStopBits(UserType* output) const {
    auto data_value = data_->stop_bits;
    return mojo::internal::Deserialize<::device::mojom::SerialStopBits>(
        data_value, output);
  }
  SerialStopBits stop_bits() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::SerialStopBits>(data_->stop_bits));
  }
  bool cts_flow_control() const {
    return data_->cts_flow_control;
  }
  bool has_cts_flow_control() const {
    return data_->has_cts_flow_control;
  }
 private:
  internal::SerialConnectionOptions_Data* data_ = nullptr;
};


class SerialConnectionInfoDataView {
 public:
  SerialConnectionInfoDataView() = default;

  SerialConnectionInfoDataView(
      internal::SerialConnectionInfo_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t bitrate() const {
    return data_->bitrate;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDataBits(UserType* output) const {
    auto data_value = data_->data_bits;
    return mojo::internal::Deserialize<::device::mojom::SerialDataBits>(
        data_value, output);
  }
  SerialDataBits data_bits() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::SerialDataBits>(data_->data_bits));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadParityBit(UserType* output) const {
    auto data_value = data_->parity_bit;
    return mojo::internal::Deserialize<::device::mojom::SerialParityBit>(
        data_value, output);
  }
  SerialParityBit parity_bit() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::SerialParityBit>(data_->parity_bit));
  }
  template <typename UserType>
  [[nodiscard]] bool ReadStopBits(UserType* output) const {
    auto data_value = data_->stop_bits;
    return mojo::internal::Deserialize<::device::mojom::SerialStopBits>(
        data_value, output);
  }
  SerialStopBits stop_bits() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::SerialStopBits>(data_->stop_bits));
  }
  bool cts_flow_control() const {
    return data_->cts_flow_control;
  }
 private:
  internal::SerialConnectionInfo_Data* data_ = nullptr;
};


class SerialHostControlSignalsDataView {
 public:
  SerialHostControlSignalsDataView() = default;

  SerialHostControlSignalsDataView(
      internal::SerialHostControlSignals_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool dtr() const {
    return data_->dtr;
  }
  bool has_dtr() const {
    return data_->has_dtr;
  }
  bool rts() const {
    return data_->rts;
  }
  bool has_rts() const {
    return data_->has_rts;
  }
  bool brk() const {
    return data_->brk;
  }
  bool has_brk() const {
    return data_->has_brk;
  }
 private:
  internal::SerialHostControlSignals_Data* data_ = nullptr;
};


class SerialPortControlSignalsDataView {
 public:
  SerialPortControlSignalsDataView() = default;

  SerialPortControlSignalsDataView(
      internal::SerialPortControlSignals_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool dcd() const {
    return data_->dcd;
  }
  bool cts() const {
    return data_->cts;
  }
  bool ri() const {
    return data_->ri;
  }
  bool dsr() const {
    return data_->dsr;
  }
 private:
  internal::SerialPortControlSignals_Data* data_ = nullptr;
};


}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SERIAL_MOJOM_DATA_VIEW_H_