// services/device/public/mojom/nfc.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const NDEFErrorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const NDEFErrorType = {
  
  NOT_ALLOWED: 0,
  NOT_SUPPORTED: 1,
  NOT_READABLE: 2,
  INVALID_MESSAGE: 3,
  OPERATION_CANCELLED: 4,
  IO_ERROR: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const NDEFRecordTypeCategorySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const NDEFRecordTypeCategory = {
  
  kStandardized: 0,
  kExternal: 1,
  kLocal: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NFCPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.NFC', scope);
  }
}

/** @interface */
export class NFCInterface {
  
  /**
   * @param { !NFCClientRemote } client
   */

  setClient(client) {}
  
  /**
   * @param { !NDEFMessage } message
   * @param { ?NDEFWriteOptions } options
   * @return {!Promise<{
        error: ?NDEFError,
   *  }>}
   */

  push(message, options) {}
  
  /**
   */

  cancelPush() {}
  
  /**
   * @return {!Promise<{
        error: ?NDEFError,
   *  }>}
   */

  makeReadOnly() {}
  
  /**
   */

  cancelMakeReadOnly() {}
  
  /**
   * @param { !number } id
   * @return {!Promise<{
        error: ?NDEFError,
   *  }>}
   */

  watch(id) {}
  
  /**
   * @param { !number } id
   */

  cancelWatch(id) {}
}

/**
 * @implements { NFCInterface }
 */
export class NFCRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NFCPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NFCPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NFCPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !NFCClientRemote } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        0,
        NFC_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @param { !NDEFMessage } message
   * @param { ?NDEFWriteOptions } options
   * @return {!Promise<{
        error: ?NDEFError,
   *  }>}
   */

  push(
      message,
      options) {
    return this.proxy.sendMessage(
        1,
        NFC_Push_ParamsSpec.$,
        NFC_Push_ResponseParamsSpec.$,
        [
          message,
          options
        ],
        false);
  }

  
  /**
   */

  cancelPush() {
    this.proxy.sendMessage(
        2,
        NFC_CancelPush_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        error: ?NDEFError,
   *  }>}
   */

  makeReadOnly() {
    return this.proxy.sendMessage(
        3,
        NFC_MakeReadOnly_ParamsSpec.$,
        NFC_MakeReadOnly_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   */

  cancelMakeReadOnly() {
    this.proxy.sendMessage(
        4,
        NFC_CancelMakeReadOnly_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } id
   * @return {!Promise<{
        error: ?NDEFError,
   *  }>}
   */

  watch(
      id) {
    return this.proxy.sendMessage(
        5,
        NFC_Watch_ParamsSpec.$,
        NFC_Watch_ResponseParamsSpec.$,
        [
          id
        ],
        false);
  }

  
  /**
   * @param { !number } id
   */

  cancelWatch(
      id) {
    this.proxy.sendMessage(
        6,
        NFC_CancelWatch_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NFC
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NFCReceiver {
  /**
   * @param {!NFCInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NFCRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NFCRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NFCRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NFC_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NFC_Push_ParamsSpec.$,
        NFC_Push_ResponseParamsSpec.$,
        impl.push.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        NFC_CancelPush_ParamsSpec.$,
        null,
        impl.cancelPush.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        NFC_MakeReadOnly_ParamsSpec.$,
        NFC_MakeReadOnly_ResponseParamsSpec.$,
        impl.makeReadOnly.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        NFC_CancelMakeReadOnly_ParamsSpec.$,
        null,
        impl.cancelMakeReadOnly.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        NFC_Watch_ParamsSpec.$,
        NFC_Watch_ResponseParamsSpec.$,
        impl.watch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        NFC_CancelWatch_ParamsSpec.$,
        null,
        impl.cancelWatch.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NFC {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.NFC";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NFCRemote}
   */
  static getRemote() {
    let remote = new NFCRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NFC
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NFCCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NFCRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NFCRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NFC_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.push =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NFC_Push_ParamsSpec.$,
        NFC_Push_ResponseParamsSpec.$,
        this.push.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelPush =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        NFC_CancelPush_ParamsSpec.$,
        null,
        this.cancelPush.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.makeReadOnly =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        NFC_MakeReadOnly_ParamsSpec.$,
        NFC_MakeReadOnly_ResponseParamsSpec.$,
        this.makeReadOnly.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelMakeReadOnly =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        NFC_CancelMakeReadOnly_ParamsSpec.$,
        null,
        this.cancelMakeReadOnly.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.watch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        NFC_Watch_ParamsSpec.$,
        NFC_Watch_ResponseParamsSpec.$,
        this.watch.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelWatch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        NFC_CancelWatch_ParamsSpec.$,
        null,
        this.cancelWatch.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NFCClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.NFCClient', scope);
  }
}

/** @interface */
export class NFCClientInterface {
  
  /**
   * @param { !Array<!number> } watchIds
   * @param { ?string } serialNumber
   * @param { !NDEFMessage } message
   */

  onWatch(watchIds, serialNumber, message) {}
  
  /**
   * @param { !NDEFError } error
   */

  onError(error) {}
}

/**
 * @implements { NFCClientInterface }
 */
export class NFCClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NFCClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NFCClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NFCClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!number> } watchIds
   * @param { ?string } serialNumber
   * @param { !NDEFMessage } message
   */

  onWatch(
      watchIds,
      serialNumber,
      message) {
    this.proxy.sendMessage(
        0,
        NFCClient_OnWatch_ParamsSpec.$,
        null,
        [
          watchIds,
          serialNumber,
          message
        ],
        false);
  }

  
  /**
   * @param { !NDEFError } error
   */

  onError(
      error) {
    this.proxy.sendMessage(
        1,
        NFCClient_OnError_ParamsSpec.$,
        null,
        [
          error
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NFCClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NFCClientReceiver {
  /**
   * @param {!NFCClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NFCClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NFCClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NFCClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NFCClient_OnWatch_ParamsSpec.$,
        null,
        impl.onWatch.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NFCClient_OnError_ParamsSpec.$,
        null,
        impl.onError.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NFCClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.NFCClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NFCClientRemote}
   */
  static getRemote() {
    let remote = new NFCClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NFCClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NFCClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NFCClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NFCClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWatch =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NFCClient_OnWatch_ParamsSpec.$,
        null,
        this.onWatch.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onError =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NFCClient_OnError_ParamsSpec.$,
        null,
        this.onError.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NDEFErrorSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NDEFRecordSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NDEFMessageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NDEFWriteOptionsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFC_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFC_Push_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFC_Push_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFC_CancelPush_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFC_MakeReadOnly_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFC_MakeReadOnly_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFC_CancelMakeReadOnly_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFC_Watch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFC_Watch_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFC_CancelWatch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFCClient_OnWatch_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFCClient_OnError_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    NDEFErrorSpec.$,
    'NDEFError',
    [
      mojo.internal.StructField(
        'errorType', 0,
        0,
        NDEFErrorTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NDEFError {
  constructor() {
    /** @type { !NDEFErrorType } */
    this.errorType;
    /** @type { !string } */
    this.errorMessage;
  }
}



mojo.internal.Struct(
    NDEFRecordSpec.$,
    'NDEFRecord',
    [
      mojo.internal.StructField(
        'category', 0,
        0,
        NDEFRecordTypeCategorySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'recordType', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'mediaType', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'id', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'encoding', 32,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lang', 40,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'data', 48,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'payloadMessage', 56,
        0,
        NDEFMessageSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class NDEFRecord {
  constructor() {
    /** @type { !NDEFRecordTypeCategory } */
    this.category;
    /** @type { !string } */
    this.recordType;
    /** @type { (string|undefined) } */
    this.mediaType;
    /** @type { (string|undefined) } */
    this.id;
    /** @type { (string|undefined) } */
    this.encoding;
    /** @type { (string|undefined) } */
    this.lang;
    /** @type { !Array<!number> } */
    this.data;
    /** @type { (NDEFMessage|undefined) } */
    this.payloadMessage;
  }
}



mojo.internal.Struct(
    NDEFMessageSpec.$,
    'NDEFMessage',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojo.internal.Array(NDEFRecordSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NDEFMessage {
  constructor() {
    /** @type { !Array<!NDEFRecord> } */
    this.data;
  }
}



mojo.internal.Struct(
    NDEFWriteOptionsSpec.$,
    'NDEFWriteOptions',
    [
      mojo.internal.StructField(
        'overwrite', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NDEFWriteOptions {
  constructor() {
    /** @type { !boolean } */
    this.overwrite;
  }
}



mojo.internal.Struct(
    NFC_SetClient_ParamsSpec.$,
    'NFC_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(NFCClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NFC_SetClient_Params {
  constructor() {
    /** @type { !NFCClientRemote } */
    this.client;
  }
}



mojo.internal.Struct(
    NFC_Push_ParamsSpec.$,
    'NFC_Push_Params',
    [
      mojo.internal.StructField(
        'message', 0,
        0,
        NDEFMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        NDEFWriteOptionsSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NFC_Push_Params {
  constructor() {
    /** @type { !NDEFMessage } */
    this.message;
    /** @type { (NDEFWriteOptions|undefined) } */
    this.options;
  }
}



mojo.internal.Struct(
    NFC_Push_ResponseParamsSpec.$,
    'NFC_Push_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        NDEFErrorSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NFC_Push_ResponseParams {
  constructor() {
    /** @type { (NDEFError|undefined) } */
    this.error;
  }
}



mojo.internal.Struct(
    NFC_CancelPush_ParamsSpec.$,
    'NFC_CancelPush_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NFC_CancelPush_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NFC_MakeReadOnly_ParamsSpec.$,
    'NFC_MakeReadOnly_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NFC_MakeReadOnly_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NFC_MakeReadOnly_ResponseParamsSpec.$,
    'NFC_MakeReadOnly_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        NDEFErrorSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NFC_MakeReadOnly_ResponseParams {
  constructor() {
    /** @type { (NDEFError|undefined) } */
    this.error;
  }
}



mojo.internal.Struct(
    NFC_CancelMakeReadOnly_ParamsSpec.$,
    'NFC_CancelMakeReadOnly_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NFC_CancelMakeReadOnly_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NFC_Watch_ParamsSpec.$,
    'NFC_Watch_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NFC_Watch_Params {
  constructor() {
    /** @type { !number } */
    this.id;
  }
}



mojo.internal.Struct(
    NFC_Watch_ResponseParamsSpec.$,
    'NFC_Watch_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        NDEFErrorSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NFC_Watch_ResponseParams {
  constructor() {
    /** @type { (NDEFError|undefined) } */
    this.error;
  }
}



mojo.internal.Struct(
    NFC_CancelWatch_ParamsSpec.$,
    'NFC_CancelWatch_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NFC_CancelWatch_Params {
  constructor() {
    /** @type { !number } */
    this.id;
  }
}



mojo.internal.Struct(
    NFCClient_OnWatch_ParamsSpec.$,
    'NFCClient_OnWatch_Params',
    [
      mojo.internal.StructField(
        'watchIds', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serialNumber', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'message', 16,
        0,
        NDEFMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class NFCClient_OnWatch_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.watchIds;
    /** @type { (string|undefined) } */
    this.serialNumber;
    /** @type { !NDEFMessage } */
    this.message;
  }
}



mojo.internal.Struct(
    NFCClient_OnError_ParamsSpec.$,
    'NFCClient_OnError_Params',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        NDEFErrorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NFCClient_OnError_Params {
  constructor() {
    /** @type { !NDEFError } */
    this.error;
  }
}

