// services/device/public/mojom/nfc.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/nfc.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/nfc.mojom-params-data.h"
#include "services/device/public/mojom/nfc.mojom-shared-message-ids.h"

#include "services/device/public/mojom/nfc.mojom-import-headers.h"
#include "services/device/public/mojom/nfc.mojom-test-utils.h"


namespace device::mojom {
NDEFError::NDEFError()
    : error_type(),
      error_message() {}

NDEFError::NDEFError(
    NDEFErrorType error_type_in,
    const std::string& error_message_in)
    : error_type(std::move(error_type_in)),
      error_message(std::move(error_message_in)) {}

NDEFError::~NDEFError() = default;
size_t NDEFError::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->error_type);
  seed = mojo::internal::Hash(seed, this->error_message);
  return seed;
}

void NDEFError::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_type"), this->error_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NDEFErrorType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_message"), this->error_message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NDEFError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NDEFRecord::NDEFRecord()
    : category(),
      record_type(),
      media_type(),
      id(),
      encoding(),
      lang(),
      data(),
      payload_message() {}

NDEFRecord::NDEFRecord(
    NDEFRecordTypeCategory category_in,
    const std::string& record_type_in,
    const std::optional<std::string>& media_type_in,
    const std::optional<std::string>& id_in,
    const std::optional<std::string>& encoding_in,
    const std::optional<std::string>& lang_in,
    std::vector<uint8_t> data_in,
    NDEFMessagePtr payload_message_in)
    : category(std::move(category_in)),
      record_type(std::move(record_type_in)),
      media_type(std::move(media_type_in)),
      id(std::move(id_in)),
      encoding(std::move(encoding_in)),
      lang(std::move(lang_in)),
      data(std::move(data_in)),
      payload_message(std::move(payload_message_in)) {}

NDEFRecord::~NDEFRecord() = default;

void NDEFRecord::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "category"), this->category,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NDEFRecordTypeCategory>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "record_type"), this->record_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "media_type"), this->media_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "encoding"), this->encoding,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lang"), this->lang,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payload_message"), this->payload_message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NDEFMessagePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NDEFRecord::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NDEFMessage::NDEFMessage()
    : data() {}

NDEFMessage::NDEFMessage(
    std::vector<NDEFRecordPtr> data_in)
    : data(std::move(data_in)) {}

NDEFMessage::~NDEFMessage() = default;

void NDEFMessage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<NDEFRecordPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NDEFMessage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NDEFWriteOptions::NDEFWriteOptions()
    : overwrite() {}

NDEFWriteOptions::NDEFWriteOptions(
    bool overwrite_in)
    : overwrite(std::move(overwrite_in)) {}

NDEFWriteOptions::~NDEFWriteOptions() = default;
size_t NDEFWriteOptions::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->overwrite);
  return seed;
}

void NDEFWriteOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "overwrite"), this->overwrite,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NDEFWriteOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

NFC::IPCStableHashFunction NFC::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NFC>(message.name())) {
    case messages::NFC::kSetClient: {
      return &NFC::SetClient_Sym::IPCStableHash;
    }
    case messages::NFC::kPush: {
      return &NFC::Push_Sym::IPCStableHash;
    }
    case messages::NFC::kCancelPush: {
      return &NFC::CancelPush_Sym::IPCStableHash;
    }
    case messages::NFC::kMakeReadOnly: {
      return &NFC::MakeReadOnly_Sym::IPCStableHash;
    }
    case messages::NFC::kCancelMakeReadOnly: {
      return &NFC::CancelMakeReadOnly_Sym::IPCStableHash;
    }
    case messages::NFC::kWatch: {
      return &NFC::Watch_Sym::IPCStableHash;
    }
    case messages::NFC::kCancelWatch: {
      return &NFC::CancelWatch_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NFC::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NFC>(message.name())) {
      case messages::NFC::kSetClient:
            return "Receive device::mojom::NFC::SetClient";
      case messages::NFC::kPush:
            return "Receive device::mojom::NFC::Push";
      case messages::NFC::kCancelPush:
            return "Receive device::mojom::NFC::CancelPush";
      case messages::NFC::kMakeReadOnly:
            return "Receive device::mojom::NFC::MakeReadOnly";
      case messages::NFC::kCancelMakeReadOnly:
            return "Receive device::mojom::NFC::CancelMakeReadOnly";
      case messages::NFC::kWatch:
            return "Receive device::mojom::NFC::Watch";
      case messages::NFC::kCancelWatch:
            return "Receive device::mojom::NFC::CancelWatch";
    }
  } else {
    switch (static_cast<messages::NFC>(message.name())) {
      case messages::NFC::kSetClient:
            return "Receive reply device::mojom::NFC::SetClient";
      case messages::NFC::kPush:
            return "Receive reply device::mojom::NFC::Push";
      case messages::NFC::kCancelPush:
            return "Receive reply device::mojom::NFC::CancelPush";
      case messages::NFC::kMakeReadOnly:
            return "Receive reply device::mojom::NFC::MakeReadOnly";
      case messages::NFC::kCancelMakeReadOnly:
            return "Receive reply device::mojom::NFC::CancelMakeReadOnly";
      case messages::NFC::kWatch:
            return "Receive reply device::mojom::NFC::Watch";
      case messages::NFC::kCancelWatch:
            return "Receive reply device::mojom::NFC::CancelWatch";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NFC::SetClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd62710b2;  // IPCStableHash for device::mojom::NFC::SetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NFC::Push_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x50632fd6;  // IPCStableHash for device::mojom::NFC::Push
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NFC::CancelPush_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe89cd8ea;  // IPCStableHash for device::mojom::NFC::CancelPush
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NFC::MakeReadOnly_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa6d4fa54;  // IPCStableHash for device::mojom::NFC::MakeReadOnly
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NFC::CancelMakeReadOnly_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x646c839d;  // IPCStableHash for device::mojom::NFC::CancelMakeReadOnly
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NFC::Watch_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x76bec0b8;  // IPCStableHash for device::mojom::NFC::Watch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NFC::CancelWatch_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9499aff1;  // IPCStableHash for device::mojom::NFC::CancelWatch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class NFC_Push_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NFC_Push_ForwardToCallback(
      NFC::PushCallback callback
      ) : callback_(std::move(callback)) {
  }

  NFC_Push_ForwardToCallback(const NFC_Push_ForwardToCallback&) = delete;
  NFC_Push_ForwardToCallback& operator=(const NFC_Push_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NFC::PushCallback callback_;
};

class NFC_MakeReadOnly_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NFC_MakeReadOnly_ForwardToCallback(
      NFC::MakeReadOnlyCallback callback
      ) : callback_(std::move(callback)) {
  }

  NFC_MakeReadOnly_ForwardToCallback(const NFC_MakeReadOnly_ForwardToCallback&) = delete;
  NFC_MakeReadOnly_ForwardToCallback& operator=(const NFC_MakeReadOnly_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NFC::MakeReadOnlyCallback callback_;
};

class NFC_Watch_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NFC_Watch_ForwardToCallback(
      NFC::WatchCallback callback
      ) : callback_(std::move(callback)) {
  }

  NFC_Watch_ForwardToCallback(const NFC_Watch_ForwardToCallback&) = delete;
  NFC_Watch_ForwardToCallback& operator=(const NFC_Watch_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NFC::WatchCallback callback_;
};

NFCProxy::NFCProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NFCProxy::SetClient(
    ::mojo::PendingRemote<NFCClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::NFC::SetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<NFCClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFC::kSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_SetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::NFCClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in NFC.SetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NFCProxy::Push(
    NDEFMessagePtr in_message, NDEFWriteOptionsPtr in_options, PushCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::NFC::Push", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type NDEFMessagePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type NDEFWriteOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFC::kPush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_Push_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::NDEFMessageDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in NFC.Push request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::NDEFWriteOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("Push");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NFC_Push_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NFCProxy::CancelPush(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::NFC::CancelPush");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFC::kCancelPush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_CancelPush_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("CancelPush");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NFCProxy::MakeReadOnly(
    MakeReadOnlyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::NFC::MakeReadOnly");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFC::kMakeReadOnly), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_MakeReadOnly_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("MakeReadOnly");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NFC_MakeReadOnly_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NFCProxy::CancelMakeReadOnly(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::NFC::CancelMakeReadOnly");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFC::kCancelMakeReadOnly), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_CancelMakeReadOnly_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("CancelMakeReadOnly");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NFCProxy::Watch(
    uint32_t in_id, WatchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::NFC::Watch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFC::kWatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_Watch_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("Watch");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NFC_Watch_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void NFCProxy::CancelWatch(
    uint32_t in_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::NFC::CancelWatch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("id"), in_id,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFC::kCancelWatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_CancelWatch_Params_Data> params(
          message);
  params.Allocate();

  params->id = in_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("CancelWatch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class NFC_Push_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NFC::PushCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NFC_Push_ProxyToResponder> proxy(
        new NFC_Push_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NFC_Push_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NFC_Push_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NFC_Push_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NFC::PushCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      NDEFErrorPtr in_error);
};

bool NFC_Push_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NFC_Push_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NFC_Push_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NFC.1
  bool success = true;
  NDEFErrorPtr p_error{};
  NFC_Push_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NFC::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void NFC_Push_ProxyToResponder::Run(
    NDEFErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::NFC::Push", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type NDEFErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFC::kPush), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_Push_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::NDEFErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("Push");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NFC_MakeReadOnly_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NFC::MakeReadOnlyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NFC_MakeReadOnly_ProxyToResponder> proxy(
        new NFC_MakeReadOnly_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NFC_MakeReadOnly_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NFC_MakeReadOnly_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NFC_MakeReadOnly_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NFC::MakeReadOnlyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      NDEFErrorPtr in_error);
};

bool NFC_MakeReadOnly_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NFC_MakeReadOnly_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NFC_MakeReadOnly_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NFC.3
  bool success = true;
  NDEFErrorPtr p_error{};
  NFC_MakeReadOnly_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NFC::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void NFC_MakeReadOnly_ProxyToResponder::Run(
    NDEFErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::NFC::MakeReadOnly", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type NDEFErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFC::kMakeReadOnly), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_MakeReadOnly_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::NDEFErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("MakeReadOnly");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NFC_Watch_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NFC::WatchCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NFC_Watch_ProxyToResponder> proxy(
        new NFC_Watch_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NFC_Watch_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NFC_Watch_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NFC_Watch_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NFC::WatchCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      NDEFErrorPtr in_error);
};

bool NFC_Watch_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NFC_Watch_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NFC_Watch_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NFC.5
  bool success = true;
  NDEFErrorPtr p_error{};
  NFC_Watch_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadError(&p_error))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NFC::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error));
  }
  return true;
}

void NFC_Watch_ProxyToResponder::Run(
    NDEFErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::NFC::Watch", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type NDEFErrorPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFC::kWatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFC_Watch_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::NDEFErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFC::Name_);
  message.set_method_name("Watch");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NFCStubDispatch::Accept(
    NFC* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NFC>(message->header()->name)) {
    case messages::NFC::kSetClient: {
      DCHECK(message->is_serialized());
      internal::NFC_SetClient_Params_Data* params =
          reinterpret_cast<internal::NFC_SetClient_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NFC.0
      bool success = true;
      ::mojo::PendingRemote<NFCClient> p_client{};
      NFC_SetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFC::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(        
        std::move(p_client));
      return true;
    }
    case messages::NFC::kPush: {
      break;
    }
    case messages::NFC::kCancelPush: {
      DCHECK(message->is_serialized());
      internal::NFC_CancelPush_Params_Data* params =
          reinterpret_cast<internal::NFC_CancelPush_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NFC.2
      bool success = true;
      NFC_CancelPush_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFC::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelPush(        );
      return true;
    }
    case messages::NFC::kMakeReadOnly: {
      break;
    }
    case messages::NFC::kCancelMakeReadOnly: {
      DCHECK(message->is_serialized());
      internal::NFC_CancelMakeReadOnly_Params_Data* params =
          reinterpret_cast<internal::NFC_CancelMakeReadOnly_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NFC.4
      bool success = true;
      NFC_CancelMakeReadOnly_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFC::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelMakeReadOnly(        );
      return true;
    }
    case messages::NFC::kWatch: {
      break;
    }
    case messages::NFC::kCancelWatch: {
      DCHECK(message->is_serialized());
      internal::NFC_CancelWatch_Params_Data* params =
          reinterpret_cast<internal::NFC_CancelWatch_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NFC.6
      bool success = true;
      uint32_t p_id{};
      NFC_CancelWatch_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFC::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelWatch(        
        std::move(p_id));
      return true;
    }
  }
  return false;
}

// static
bool NFCStubDispatch::AcceptWithResponder(
    NFC* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NFC>(message->header()->name)) {
    case messages::NFC::kSetClient: {
      break;
    }
    case messages::NFC::kPush: {
      internal::NFC_Push_Params_Data* params =
          reinterpret_cast<
              internal::NFC_Push_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NFC.1
      bool success = true;
      NDEFMessagePtr p_message{};
      NDEFWriteOptionsPtr p_options{};
      NFC_Push_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFC::Name_, 1, false);
        return false;
      }
      auto callback =
          NFC_Push_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Push(        
        std::move(p_message), 
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::NFC::kCancelPush: {
      break;
    }
    case messages::NFC::kMakeReadOnly: {
      internal::NFC_MakeReadOnly_Params_Data* params =
          reinterpret_cast<
              internal::NFC_MakeReadOnly_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NFC.3
      bool success = true;
      NFC_MakeReadOnly_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFC::Name_, 3, false);
        return false;
      }
      auto callback =
          NFC_MakeReadOnly_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeReadOnly(std::move(callback));
      return true;
    }
    case messages::NFC::kCancelMakeReadOnly: {
      break;
    }
    case messages::NFC::kWatch: {
      internal::NFC_Watch_Params_Data* params =
          reinterpret_cast<
              internal::NFC_Watch_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NFC.5
      bool success = true;
      uint32_t p_id{};
      NFC_Watch_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_id = input_data_view.id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFC::Name_, 5, false);
        return false;
      }
      auto callback =
          NFC_Watch_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Watch(        
        std::move(p_id), std::move(callback));
      return true;
    }
    case messages::NFC::kCancelWatch: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNFCValidationInfo[] = {
    { &internal::NFC_SetClient_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NFC_Push_Params_Data::Validate,
     &internal::NFC_Push_ResponseParams_Data::Validate},
    { &internal::NFC_CancelPush_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NFC_MakeReadOnly_Params_Data::Validate,
     &internal::NFC_MakeReadOnly_ResponseParams_Data::Validate},
    { &internal::NFC_CancelMakeReadOnly_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NFC_Watch_Params_Data::Validate,
     &internal::NFC_Watch_ResponseParams_Data::Validate},
    { &internal::NFC_CancelWatch_Params_Data::Validate,
     nullptr /* no response */},
};

bool NFCRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::NFC::Name_,
    kNFCValidationInfo);
}

bool NFCResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::NFC::Name_,
    kNFCValidationInfo);
}
// The declaration includes the definition on other builds.

NFCClient::IPCStableHashFunction NFCClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NFCClient>(message.name())) {
    case messages::NFCClient::kOnWatch: {
      return &NFCClient::OnWatch_Sym::IPCStableHash;
    }
    case messages::NFCClient::kOnError: {
      return &NFCClient::OnError_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NFCClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NFCClient>(message.name())) {
      case messages::NFCClient::kOnWatch:
            return "Receive device::mojom::NFCClient::OnWatch";
      case messages::NFCClient::kOnError:
            return "Receive device::mojom::NFCClient::OnError";
    }
  } else {
    switch (static_cast<messages::NFCClient>(message.name())) {
      case messages::NFCClient::kOnWatch:
            return "Receive reply device::mojom::NFCClient::OnWatch";
      case messages::NFCClient::kOnError:
            return "Receive reply device::mojom::NFCClient::OnError";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NFCClient::OnWatch_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6bda0ad5;  // IPCStableHash for device::mojom::NFCClient::OnWatch
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NFCClient::OnError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbdba61af;  // IPCStableHash for device::mojom::NFCClient::OnError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NFCClientProxy::NFCClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NFCClientProxy::OnWatch(
    const std::vector<uint32_t>& in_watch_ids, const std::optional<std::string>& in_serial_number, NDEFMessagePtr in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::NFCClient::OnWatch", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("watch_ids"), in_watch_ids,
                        "<value of type const std::vector<uint32_t>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("serial_number"), in_serial_number,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type NDEFMessagePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFCClient::kOnWatch), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFCClient_OnWatch_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->watch_ids)::BaseType>
      watch_ids_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& watch_ids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint32_t>>(
    in_watch_ids,
    watch_ids_fragment,
    &watch_ids_validate_params);

  params->watch_ids.Set(
      watch_ids_fragment.is_null() ? nullptr : watch_ids_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->watch_ids.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null watch_ids in NFCClient.OnWatch request");
  mojo::internal::MessageFragment<
      typename decltype(params->serial_number)::BaseType> serial_number_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_serial_number,
    serial_number_fragment);

  params->serial_number.Set(
      serial_number_fragment.is_null() ? nullptr : serial_number_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::NDEFMessageDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in NFCClient.OnWatch request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFCClient::Name_);
  message.set_method_name("OnWatch");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NFCClientProxy::OnError(
    NDEFErrorPtr in_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::NFCClient::OnError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error"), in_error,
                        "<value of type NDEFErrorPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFCClient::kOnError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFCClient_OnError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error)::BaseType> error_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::NDEFErrorDataView>(
    in_error,
    error_fragment);

  params->error.Set(
      error_fragment.is_null() ? nullptr : error_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error in NFCClient.OnError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFCClient::Name_);
  message.set_method_name("OnError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NFCClientStubDispatch::Accept(
    NFCClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NFCClient>(message->header()->name)) {
    case messages::NFCClient::kOnWatch: {
      DCHECK(message->is_serialized());
      internal::NFCClient_OnWatch_Params_Data* params =
          reinterpret_cast<internal::NFCClient_OnWatch_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NFCClient.0
      bool success = true;
      std::vector<uint32_t> p_watch_ids{};
      std::optional<std::string> p_serial_number{};
      NDEFMessagePtr p_message{};
      NFCClient_OnWatch_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWatchIds(&p_watch_ids))
        success = false;
      if (success && !input_data_view.ReadSerialNumber(&p_serial_number))
        success = false;
      if (success && !input_data_view.ReadMessage(&p_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFCClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnWatch(        
        std::move(p_watch_ids), 
        std::move(p_serial_number), 
        std::move(p_message));
      return true;
    }
    case messages::NFCClient::kOnError: {
      DCHECK(message->is_serialized());
      internal::NFCClient_OnError_Params_Data* params =
          reinterpret_cast<internal::NFCClient_OnError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NFCClient.1
      bool success = true;
      NDEFErrorPtr p_error{};
      NFCClient_OnError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadError(&p_error))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFCClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnError(        
        std::move(p_error));
      return true;
    }
  }
  return false;
}

// static
bool NFCClientStubDispatch::AcceptWithResponder(
    NFCClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NFCClient>(message->header()->name)) {
    case messages::NFCClient::kOnWatch: {
      break;
    }
    case messages::NFCClient::kOnError: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNFCClientValidationInfo[] = {
    { &internal::NFCClient_OnWatch_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NFCClient_OnError_Params_Data::Validate,
     nullptr /* no response */},
};

bool NFCClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::NFCClient::Name_,
    kNFCClientValidationInfo);
}



}  // device::mojom


namespace mojo {


// static
bool StructTraits<::device::mojom::NDEFError::DataView, ::device::mojom::NDEFErrorPtr>::Read(
    ::device::mojom::NDEFError::DataView input,
    ::device::mojom::NDEFErrorPtr* output) {
  bool success = true;
  ::device::mojom::NDEFErrorPtr result(::device::mojom::NDEFError::New());
  
      if (success && !input.ReadErrorType(&result->error_type))
        success = false;
      if (success && !input.ReadErrorMessage(&result->error_message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::NDEFRecord::DataView, ::device::mojom::NDEFRecordPtr>::Read(
    ::device::mojom::NDEFRecord::DataView input,
    ::device::mojom::NDEFRecordPtr* output) {
  bool success = true;
  ::device::mojom::NDEFRecordPtr result(::device::mojom::NDEFRecord::New());
  
      if (success && !input.ReadCategory(&result->category))
        success = false;
      if (success && !input.ReadRecordType(&result->record_type))
        success = false;
      if (success && !input.ReadMediaType(&result->media_type))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadEncoding(&result->encoding))
        success = false;
      if (success && !input.ReadLang(&result->lang))
        success = false;
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadPayloadMessage(&result->payload_message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::NDEFMessage::DataView, ::device::mojom::NDEFMessagePtr>::Read(
    ::device::mojom::NDEFMessage::DataView input,
    ::device::mojom::NDEFMessagePtr* output) {
  bool success = true;
  ::device::mojom::NDEFMessagePtr result(::device::mojom::NDEFMessage::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::NDEFWriteOptions::DataView, ::device::mojom::NDEFWriteOptionsPtr>::Read(
    ::device::mojom::NDEFWriteOptions::DataView input,
    ::device::mojom::NDEFWriteOptionsPtr* output) {
  bool success = true;
  ::device::mojom::NDEFWriteOptionsPtr result(::device::mojom::NDEFWriteOptions::New());
  
      if (success)
        result->overwrite = input.overwrite();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void NFCInterceptorForTesting::SetClient(::mojo::PendingRemote<NFCClient> client) {
  GetForwardingInterface()->SetClient(
    std::move(client)
    );
}
void NFCInterceptorForTesting::Push(NDEFMessagePtr message, NDEFWriteOptionsPtr options, PushCallback callback) {
  GetForwardingInterface()->Push(
    std::move(message)
    , 
    std::move(options)
    , std::move(callback));
}
void NFCInterceptorForTesting::CancelPush() {
  GetForwardingInterface()->CancelPush();
}
void NFCInterceptorForTesting::MakeReadOnly(MakeReadOnlyCallback callback) {
  GetForwardingInterface()->MakeReadOnly(std::move(callback));
}
void NFCInterceptorForTesting::CancelMakeReadOnly() {
  GetForwardingInterface()->CancelMakeReadOnly();
}
void NFCInterceptorForTesting::Watch(uint32_t id, WatchCallback callback) {
  GetForwardingInterface()->Watch(
    std::move(id)
    , std::move(callback));
}
void NFCInterceptorForTesting::CancelWatch(uint32_t id) {
  GetForwardingInterface()->CancelWatch(
    std::move(id)
    );
}
NFCAsyncWaiter::NFCAsyncWaiter(
    NFC* proxy) : proxy_(proxy) {}

NFCAsyncWaiter::~NFCAsyncWaiter() = default;


void NFCAsyncWaiter::Push(
    NDEFMessagePtr message, NDEFWriteOptionsPtr options, NDEFErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->Push(
      std::move(message),
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             NDEFErrorPtr* out_error
,
             NDEFErrorPtr error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

NDEFErrorPtr NFCAsyncWaiter::Push(
    NDEFMessagePtr message, NDEFWriteOptionsPtr options) {
  NDEFErrorPtr async_wait_result;
  Push(std::move(message),std::move(options),&async_wait_result);
  return async_wait_result;
}

void NFCAsyncWaiter::MakeReadOnly(
    NDEFErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->MakeReadOnly(
      base::BindOnce(
          [](base::RunLoop* loop,
             NDEFErrorPtr* out_error
,
             NDEFErrorPtr error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

NDEFErrorPtr NFCAsyncWaiter::MakeReadOnly(
    ) {
  NDEFErrorPtr async_wait_result;
  MakeReadOnly(&async_wait_result);
  return async_wait_result;
}

void NFCAsyncWaiter::Watch(
    uint32_t id, NDEFErrorPtr* out_error) {
  base::RunLoop loop;
  proxy_->Watch(
      std::move(id),
      base::BindOnce(
          [](base::RunLoop* loop,
             NDEFErrorPtr* out_error
,
             NDEFErrorPtr error) {*out_error = std::move(error);
            loop->Quit();
          },
          &loop,
          out_error));
  loop.Run();
}

NDEFErrorPtr NFCAsyncWaiter::Watch(
    uint32_t id) {
  NDEFErrorPtr async_wait_result;
  Watch(std::move(id),&async_wait_result);
  return async_wait_result;
}




void NFCClientInterceptorForTesting::OnWatch(const std::vector<uint32_t>& watch_ids, const std::optional<std::string>& serial_number, NDEFMessagePtr message) {
  GetForwardingInterface()->OnWatch(
    std::move(watch_ids)
    , 
    std::move(serial_number)
    , 
    std::move(message)
    );
}
void NFCClientInterceptorForTesting::OnError(NDEFErrorPtr error) {
  GetForwardingInterface()->OnError(
    std::move(error)
    );
}
NFCClientAsyncWaiter::NFCClientAsyncWaiter(
    NFCClient* proxy) : proxy_(proxy) {}

NFCClientAsyncWaiter::~NFCClientAsyncWaiter() = default;







}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif