// services/device/public/mojom/hid.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_SEND_VALIDATION_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_SEND_VALIDATION_H_

#include "services/device/public/mojom/hid.mojom-shared-internal.h"

#include "services/device/public/mojom/hid.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::HidBusType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::HidUsageAndPageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::HidUsageAndPageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::HidUsageAndPage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->usage = Traits::usage(input);

      fragment->usage_page = Traits::usage_page(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::HidReportItemDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::HidReportItemDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::HidReportItem_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->is_range = Traits::is_range(input);

      fragment->is_constant = Traits::is_constant(input);

      fragment->is_variable = Traits::is_variable(input);

      fragment->is_relative = Traits::is_relative(input);

      fragment->wrap = Traits::wrap(input);

      fragment->is_non_linear = Traits::is_non_linear(input);

      fragment->no_preferred_state = Traits::no_preferred_state(input);

      fragment->has_null_position = Traits::has_null_position(input);

      fragment->is_volatile = Traits::is_volatile(input);

      fragment->is_buffered_bytes = Traits::is_buffered_bytes(input);

      decltype(Traits::usages(input)) in_usages = Traits::usages(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->usages)::BaseType>
          usages_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& usages_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidUsageAndPageDataView>, send_validation>(
        in_usages,
        usages_fragment,
        &usages_validate_params);

      fragment->usages.Set(
          usages_fragment.is_null() ? nullptr : usages_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->usages.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null usages in HidReportItem struct");

      decltype(Traits::usage_minimum(input)) in_usage_minimum = Traits::usage_minimum(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->usage_minimum)::BaseType> usage_minimum_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::HidUsageAndPageDataView, send_validation>(
        in_usage_minimum,
        usage_minimum_fragment);

      fragment->usage_minimum.Set(
          usage_minimum_fragment.is_null() ? nullptr : usage_minimum_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->usage_minimum.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null usage_minimum in HidReportItem struct");

      decltype(Traits::usage_maximum(input)) in_usage_maximum = Traits::usage_maximum(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->usage_maximum)::BaseType> usage_maximum_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::HidUsageAndPageDataView, send_validation>(
        in_usage_maximum,
        usage_maximum_fragment);

      fragment->usage_maximum.Set(
          usage_maximum_fragment.is_null() ? nullptr : usage_maximum_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->usage_maximum.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null usage_maximum in HidReportItem struct");

      fragment->designator_minimum = Traits::designator_minimum(input);

      fragment->designator_maximum = Traits::designator_maximum(input);

      fragment->string_minimum = Traits::string_minimum(input);

      fragment->string_maximum = Traits::string_maximum(input);

      fragment->logical_minimum = Traits::logical_minimum(input);

      fragment->logical_maximum = Traits::logical_maximum(input);

      fragment->physical_minimum = Traits::physical_minimum(input);

      fragment->physical_maximum = Traits::physical_maximum(input);

      fragment->unit_exponent = Traits::unit_exponent(input);

      fragment->unit = Traits::unit(input);

      fragment->report_size = Traits::report_size(input);

      fragment->report_count = Traits::report_count(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::HidReportDescriptionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::HidReportDescriptionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::HidReportDescription_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->report_id = Traits::report_id(input);

      decltype(Traits::items(input)) in_items = Traits::items(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->items)::BaseType>
          items_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidReportItemDataView>, send_validation>(
        in_items,
        items_fragment,
        &items_validate_params);

      fragment->items.Set(
          items_fragment.is_null() ? nullptr : items_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->items.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null items in HidReportDescription struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::HidCollectionInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::HidCollectionInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::HidCollectionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::usage(input)) in_usage = Traits::usage(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->usage)::BaseType> usage_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::HidUsageAndPageDataView, send_validation>(
        in_usage,
        usage_fragment);

      fragment->usage.Set(
          usage_fragment.is_null() ? nullptr : usage_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->usage.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null usage in HidCollectionInfo struct");

      decltype(Traits::report_ids(input)) in_report_ids = Traits::report_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->report_ids)::BaseType>
          report_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& report_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_report_ids,
        report_ids_fragment,
        &report_ids_validate_params);

      fragment->report_ids.Set(
          report_ids_fragment.is_null() ? nullptr : report_ids_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->report_ids.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null report_ids in HidCollectionInfo struct");

      fragment->collection_type = Traits::collection_type(input);

      decltype(Traits::input_reports(input)) in_input_reports = Traits::input_reports(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->input_reports)::BaseType>
          input_reports_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& input_reports_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidReportDescriptionDataView>, send_validation>(
        in_input_reports,
        input_reports_fragment,
        &input_reports_validate_params);

      fragment->input_reports.Set(
          input_reports_fragment.is_null() ? nullptr : input_reports_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->input_reports.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input_reports in HidCollectionInfo struct");

      decltype(Traits::output_reports(input)) in_output_reports = Traits::output_reports(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->output_reports)::BaseType>
          output_reports_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& output_reports_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidReportDescriptionDataView>, send_validation>(
        in_output_reports,
        output_reports_fragment,
        &output_reports_validate_params);

      fragment->output_reports.Set(
          output_reports_fragment.is_null() ? nullptr : output_reports_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->output_reports.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null output_reports in HidCollectionInfo struct");

      decltype(Traits::feature_reports(input)) in_feature_reports = Traits::feature_reports(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->feature_reports)::BaseType>
          feature_reports_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& feature_reports_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidReportDescriptionDataView>, send_validation>(
        in_feature_reports,
        feature_reports_fragment,
        &feature_reports_validate_params);

      fragment->feature_reports.Set(
          feature_reports_fragment.is_null() ? nullptr : feature_reports_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->feature_reports.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null feature_reports in HidCollectionInfo struct");

      decltype(Traits::children(input)) in_children = Traits::children(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->children)::BaseType>
          children_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidCollectionInfoDataView>, send_validation>(
        in_children,
        children_fragment,
        &children_validate_params);

      fragment->children.Set(
          children_fragment.is_null() ? nullptr : children_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->children.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null children in HidCollectionInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::HidDeviceInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::HidDeviceInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::HidDeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::guid(input)) in_guid = Traits::guid(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->guid)::BaseType> guid_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_guid,
        guid_fragment);

      fragment->guid.Set(
          guid_fragment.is_null() ? nullptr : guid_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->guid.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null guid in HidDeviceInfo struct");

      decltype(Traits::physical_device_id(input)) in_physical_device_id = Traits::physical_device_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->physical_device_id)::BaseType> physical_device_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_physical_device_id,
        physical_device_id_fragment);

      fragment->physical_device_id.Set(
          physical_device_id_fragment.is_null() ? nullptr : physical_device_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->physical_device_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null physical_device_id in HidDeviceInfo struct");

      fragment->vendor_id = Traits::vendor_id(input);

      fragment->product_id = Traits::product_id(input);

      decltype(Traits::product_name(input)) in_product_name = Traits::product_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->product_name)::BaseType> product_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_product_name,
        product_name_fragment);

      fragment->product_name.Set(
          product_name_fragment.is_null() ? nullptr : product_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->product_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null product_name in HidDeviceInfo struct");

      decltype(Traits::serial_number(input)) in_serial_number = Traits::serial_number(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->serial_number)::BaseType> serial_number_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_serial_number,
        serial_number_fragment);

      fragment->serial_number.Set(
          serial_number_fragment.is_null() ? nullptr : serial_number_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->serial_number.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null serial_number in HidDeviceInfo struct");

      
      mojo::internal::Serialize<::device::mojom::HidBusType>(
        Traits::bus_type(input),
        &fragment->bus_type);

      decltype(Traits::report_descriptor(input)) in_report_descriptor = Traits::report_descriptor(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->report_descriptor)::BaseType>
          report_descriptor_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& report_descriptor_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_report_descriptor,
        report_descriptor_fragment,
        &report_descriptor_validate_params);

      fragment->report_descriptor.Set(
          report_descriptor_fragment.is_null() ? nullptr : report_descriptor_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->report_descriptor.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null report_descriptor in HidDeviceInfo struct");

      decltype(Traits::collections(input)) in_collections = Traits::collections(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->collections)::BaseType>
          collections_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& collections_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidCollectionInfoDataView>, send_validation>(
        in_collections,
        collections_fragment,
        &collections_validate_params);

      fragment->collections.Set(
          collections_fragment.is_null() ? nullptr : collections_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->collections.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null collections in HidDeviceInfo struct");

      fragment->has_report_id = Traits::has_report_id(input);

      fragment->max_input_report_size = Traits::max_input_report_size(input);

      fragment->max_output_report_size = Traits::max_output_report_size(input);

      fragment->max_feature_report_size = Traits::max_feature_report_size(input);

      decltype(Traits::device_node(input)) in_device_node = Traits::device_node(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->device_node)::BaseType> device_node_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_device_node,
        device_node_fragment);

      fragment->device_node.Set(
          device_node_fragment.is_null() ? nullptr : device_node_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->device_node.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null device_node in HidDeviceInfo struct");

      decltype(Traits::protected_input_report_ids(input)) in_protected_input_report_ids = Traits::protected_input_report_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->protected_input_report_ids)::BaseType>
          protected_input_report_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& protected_input_report_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_protected_input_report_ids,
        protected_input_report_ids_fragment,
        &protected_input_report_ids_validate_params);

      fragment->protected_input_report_ids.Set(
          protected_input_report_ids_fragment.is_null() ? nullptr : protected_input_report_ids_fragment.data());

      decltype(Traits::protected_output_report_ids(input)) in_protected_output_report_ids = Traits::protected_output_report_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->protected_output_report_ids)::BaseType>
          protected_output_report_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& protected_output_report_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_protected_output_report_ids,
        protected_output_report_ids_fragment,
        &protected_output_report_ids_validate_params);

      fragment->protected_output_report_ids.Set(
          protected_output_report_ids_fragment.is_null() ? nullptr : protected_output_report_ids_fragment.data());

      decltype(Traits::protected_feature_report_ids(input)) in_protected_feature_report_ids = Traits::protected_feature_report_ids(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->protected_feature_report_ids)::BaseType>
          protected_feature_report_ids_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& protected_feature_report_ids_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_protected_feature_report_ids,
        protected_feature_report_ids_fragment,
        &protected_feature_report_ids_validate_params);

      fragment->protected_feature_report_ids.Set(
          protected_feature_report_ids_fragment.is_null() ? nullptr : protected_feature_report_ids_fragment.data());

      fragment->is_excluded_by_blocklist = Traits::is_excluded_by_blocklist(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_HID_MOJOM_SEND_VALIDATION_H_