// services/device/public/mojom/geoposition.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/device/public/mojom/geoposition.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('device.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }


  var BAD_LATITUDE_LONGITUDE = 200;
  var BAD_ALTITUDE = -10000;
  var BAD_ACCURACY = -1;
  var BAD_HEADING = -1;
  var BAD_SPEED = -1;
  var GEO_PERMISSION_DENIED_ERROR_MESSAGE = "User denied geolocation permission";
  var GEO_POSITION_UNAVAILABLE_ERROR_MESSAGE = "Position update is unavailable";
  var GeopositionErrorCode = {};
  GeopositionErrorCode.kPermissionDenied = 1;
  GeopositionErrorCode.kPositionUnavailable = 2;
  GeopositionErrorCode.kWifiDisabled = 3;
  GeopositionErrorCode.MIN_VALUE = 1;
  GeopositionErrorCode.MAX_VALUE = 3;

  GeopositionErrorCode.isKnownEnumValue = function(value) {
    switch (value) {
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  GeopositionErrorCode.toKnownEnumValue = function(value) {
    return value;
  };

  GeopositionErrorCode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function Geoposition(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  Geoposition.prototype.initDefaults_ = function() {
    this.latitude = BAD_LATITUDE_LONGITUDE;
    this.longitude = BAD_LATITUDE_LONGITUDE;
    this.altitude = BAD_ALTITUDE;
    this.accuracy = BAD_ACCURACY;
    this.altitudeAccuracy = BAD_ACCURACY;
    this.heading = BAD_HEADING;
    this.speed = BAD_SPEED;
    this.timestamp = null;
  };
  Geoposition.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  Geoposition.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 72}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;









    // validate Geoposition.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  Geoposition.encodedSize = codec.kStructHeaderSize + 64;

  Geoposition.decode = function(decoder) {
    var packed;
    var val = new Geoposition();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.latitude =
        decoder.decodeStruct(codec.Double);
    val.longitude =
        decoder.decodeStruct(codec.Double);
    val.altitude =
        decoder.decodeStruct(codec.Double);
    val.accuracy =
        decoder.decodeStruct(codec.Double);
    val.altitudeAccuracy =
        decoder.decodeStruct(codec.Double);
    val.heading =
        decoder.decodeStruct(codec.Double);
    val.speed =
        decoder.decodeStruct(codec.Double);
    val.timestamp =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  Geoposition.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(Geoposition.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.latitude);
    encoder.encodeStruct(codec.Double, val.longitude);
    encoder.encodeStruct(codec.Double, val.altitude);
    encoder.encodeStruct(codec.Double, val.accuracy);
    encoder.encodeStruct(codec.Double, val.altitudeAccuracy);
    encoder.encodeStruct(codec.Double, val.heading);
    encoder.encodeStruct(codec.Double, val.speed);
    encoder.encodeStructPointer(time$.Time, val.timestamp);
  };
  function GeopositionError(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GeopositionError.prototype.initDefaults_ = function() {
    this.errorCode = 0;
    this.errorMessage = null;
    this.errorTechnical = null;
  };
  GeopositionError.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GeopositionError.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GeopositionError.errorCode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, GeopositionErrorCode);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GeopositionError.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate GeopositionError.errorTechnical
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GeopositionError.encodedSize = codec.kStructHeaderSize + 24;

  GeopositionError.decode = function(decoder) {
    var packed;
    var val = new GeopositionError();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorCode =
        decoder.decodeStruct(new codec.Enum(GeopositionErrorCode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    val.errorTechnical =
        decoder.decodeStruct(codec.String);
    return val;
  };

  GeopositionError.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GeopositionError.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.errorCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.errorMessage);
    encoder.encodeStruct(codec.String, val.errorTechnical);
  };

  function GeopositionResult(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  GeopositionResult.Tags = {
    position: 0,
    error: 1,
  };

  GeopositionResult.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  GeopositionResult.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "position",
        "error",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a GeopositionResult member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(GeopositionResult.prototype, "position", {
    get: function() {
      if (this.$tag != GeopositionResult.Tags.position) {
        throw new ReferenceError(
            "GeopositionResult.position is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GeopositionResult.Tags.position;
      this.$data = value;
    }
  });
  Object.defineProperty(GeopositionResult.prototype, "error", {
    get: function() {
      if (this.$tag != GeopositionResult.Tags.error) {
        throw new ReferenceError(
            "GeopositionResult.error is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = GeopositionResult.Tags.error;
      this.$data = value;
    }
  });


    GeopositionResult.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case GeopositionResult.Tags.position:
          encoder.encodeStructPointer(Geoposition, val.position);
          break;
        case GeopositionResult.Tags.error:
          encoder.encodeStructPointer(GeopositionError, val.error);
          break;
      }
      encoder.align();
    };


    GeopositionResult.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new GeopositionResult();
      var tag = decoder.readUint32();
      switch (tag) {
        case GeopositionResult.Tags.position:
          result.position = decoder.decodeStructPointer(Geoposition);
          break;
        case GeopositionResult.Tags.error:
          result.error = decoder.decodeStructPointer(GeopositionError);
          break;
      }
      decoder.align();

      return result;
    };


    GeopositionResult.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case GeopositionResult.Tags.position:
          

    // validate GeopositionResult.position
    err = messageValidator.validateStructPointer(data_offset, Geoposition, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case GeopositionResult.Tags.error:
          

    // validate GeopositionResult.error
    err = messageValidator.validateStructPointer(data_offset, GeopositionError, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  GeopositionResult.encodedSize = 16;
  exports.BAD_LATITUDE_LONGITUDE = BAD_LATITUDE_LONGITUDE;
  exports.BAD_ALTITUDE = BAD_ALTITUDE;
  exports.BAD_ACCURACY = BAD_ACCURACY;
  exports.BAD_HEADING = BAD_HEADING;
  exports.BAD_SPEED = BAD_SPEED;
  exports.GEO_PERMISSION_DENIED_ERROR_MESSAGE = GEO_PERMISSION_DENIED_ERROR_MESSAGE;
  exports.GEO_POSITION_UNAVAILABLE_ERROR_MESSAGE = GEO_POSITION_UNAVAILABLE_ERROR_MESSAGE;
  exports.GeopositionErrorCode = GeopositionErrorCode;
  exports.Geoposition = Geoposition;
  exports.GeopositionError = GeopositionError;
  exports.GeopositionResult = GeopositionResult;
})();