// services/device/public/mojom/geoposition.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  TimeSpec as mojoBase_mojom_TimeSpec,
  Time as mojoBase_mojom_Time
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';





export const BAD_LATITUDE_LONGITUDE: number = 200;


export const BAD_ALTITUDE: number = -10000;


export const BAD_ACCURACY: number = -1;


export const BAD_HEADING: number = -1;


export const BAD_SPEED: number = -1;


export const GEO_PERMISSION_DENIED_ERROR_MESSAGE: string = "User denied geolocation permission";


export const GEO_POSITION_UNAVAILABLE_ERROR_MESSAGE: string = "Position update is unavailable";


export const GeopositionErrorCodeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum GeopositionErrorCode {

  MIN_VALUE = 1,
  MAX_VALUE = 3,
  kPermissionDenied = 1,
  kPositionUnavailable = 2,
  kWifiDisabled = 3,
}


export const GeopositionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GeopositionErrorSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const GeopositionResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface GeopositionMojoType {
  latitude: number;
  longitude: number;
  altitude: number;
  accuracy: number;
  altitudeAccuracy: number;
  heading: number;
  speed: number;
  timestamp: mojoBase_mojom_Time;
}


export type Geoposition = GeopositionMojoType;
mojo.internal.Struct<GeopositionMojoType>(
    GeopositionSpec.$,
    'Geoposition',
    [
      mojo.internal.StructField<GeopositionMojoType, number>(
        'latitude', 0,
        0,
        mojo.internal.Double,
        BAD_LATITUDE_LONGITUDE,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GeopositionMojoType, number>(
        'longitude', 8,
        0,
        mojo.internal.Double,
        BAD_LATITUDE_LONGITUDE,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GeopositionMojoType, number>(
        'altitude', 16,
        0,
        mojo.internal.Double,
        BAD_ALTITUDE,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GeopositionMojoType, number>(
        'accuracy', 24,
        0,
        mojo.internal.Double,
        BAD_ACCURACY,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GeopositionMojoType, number>(
        'altitudeAccuracy', 32,
        0,
        mojo.internal.Double,
        BAD_ACCURACY,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GeopositionMojoType, number>(
        'heading', 40,
        0,
        mojo.internal.Double,
        BAD_HEADING,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GeopositionMojoType, number>(
        'speed', 48,
        0,
        mojo.internal.Double,
        BAD_SPEED,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GeopositionMojoType, mojoBase_mojom_Time>(
        'timestamp', 56,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 72],]);





export interface GeopositionErrorMojoType {
  errorCode: GeopositionErrorCode;
  errorMessage: string;
  errorTechnical: string;
}


export type GeopositionError = GeopositionErrorMojoType;
mojo.internal.Struct<GeopositionErrorMojoType>(
    GeopositionErrorSpec.$,
    'GeopositionError',
    [
      mojo.internal.StructField<GeopositionErrorMojoType, GeopositionErrorCode>(
        'errorCode', 0,
        0,
        GeopositionErrorCodeSpec.$,
        1,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GeopositionErrorMojoType, string>(
        'errorMessage', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<GeopositionErrorMojoType, string>(
        'errorTechnical', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);



mojo.internal.Union(
    GeopositionResultSpec.$, 'GeopositionResult',
    {
      'position': {
        'ordinal': 0,
        'type': GeopositionSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': GeopositionErrorSpec.$,
      },
    });

export interface GeopositionResult {
  position?: Geoposition,
  error?: GeopositionError,
}

export enum GeopositionResultFieldTags {
  POSITION,
  ERROR,
}

export function whichGeopositionResult(u: GeopositionResult): GeopositionResultFieldTags {
  if (u.position !== null && u.position !== undefined) {
    return GeopositionResultFieldTags.POSITION;
  }
  if (u.error !== null && u.error !== undefined) {
    return GeopositionResultFieldTags.ERROR;
  }
  throw new Error("no union field has been set, this is an illegal state");
}
