// services/device/public/mojom/geolocation_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_INTERNALS_MOJOM_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/geolocation_internals.mojom-features.h"  // IWYU pragma: export
#include "services/device/public/mojom/geolocation_internals.mojom-shared.h"  // IWYU pragma: export
#include "services/device/public/mojom/geolocation_internals.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/device/public/mojom/geoposition.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace device::mojom {

class GeolocationInternalsObserverProxy;

template <typename ImplRefTraits>
class GeolocationInternalsObserverStub;

class GeolocationInternalsObserverRequestValidator;


class GeolocationInternalsObserver
    : public GeolocationInternalsObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.GeolocationInternalsObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GeolocationInternalsObserverInterfaceBase;
  using Proxy_ = GeolocationInternalsObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = GeolocationInternalsObserverStub<ImplRefTraits>;

  using RequestValidator_ = GeolocationInternalsObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDiagnosticsChangedMinVersion = 0,
    kOnNetworkLocationRequestedMinVersion = 0,
    kOnNetworkLocationReceivedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDiagnosticsChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNetworkLocationRequested_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnNetworkLocationReceived_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GeolocationInternalsObserver() = default;

  virtual void OnDiagnosticsChanged(GeolocationDiagnosticsPtr diagnostics) = 0;

  virtual void OnNetworkLocationRequested(std::vector<AccessPointDataPtr> access_point_data) = 0;

  virtual void OnNetworkLocationReceived(NetworkLocationResponsePtr response) = 0;
};

class GeolocationInternalsProxy;

template <typename ImplRefTraits>
class GeolocationInternalsStub;

class GeolocationInternalsRequestValidator;
class GeolocationInternalsResponseValidator;


class GeolocationInternals
    : public GeolocationInternalsInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "device.mojom.GeolocationInternals";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GeolocationInternalsInterfaceBase;
  using Proxy_ = GeolocationInternalsProxy;

  template <typename ImplRefTraits>
  using Stub_ = GeolocationInternalsStub<ImplRefTraits>;

  using RequestValidator_ = GeolocationInternalsRequestValidator;
  using ResponseValidator_ = GeolocationInternalsResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAddInternalsObserverMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddInternalsObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~GeolocationInternals() = default;

  using AddInternalsObserverCallback = base::OnceCallback<void(GeolocationDiagnosticsPtr)>;
  using AddInternalsObserverMojoCallback = base::OnceCallback<void(GeolocationDiagnosticsPtr)>;

  virtual void AddInternalsObserver(::mojo::PendingRemote<GeolocationInternalsObserver> observer, AddInternalsObserverCallback callback) = 0;
};



class  GeolocationInternalsObserverProxy
    : public GeolocationInternalsObserver {
 public:
  using InterfaceType = GeolocationInternalsObserver;

  explicit GeolocationInternalsObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDiagnosticsChanged(GeolocationDiagnosticsPtr diagnostics) final;
  
  void OnNetworkLocationRequested(std::vector<AccessPointDataPtr> access_point_data) final;
  
  void OnNetworkLocationReceived(NetworkLocationResponsePtr response) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  GeolocationInternalsProxy
    : public GeolocationInternals {
 public:
  using InterfaceType = GeolocationInternals;

  explicit GeolocationInternalsProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddInternalsObserver(::mojo::PendingRemote<GeolocationInternalsObserver> observer, AddInternalsObserverCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  GeolocationInternalsObserverStubDispatch {
 public:
  static bool Accept(GeolocationInternalsObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GeolocationInternalsObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GeolocationInternalsObserver>>
class GeolocationInternalsObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GeolocationInternalsObserverStub() = default;
  ~GeolocationInternalsObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GeolocationInternalsObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GeolocationInternalsObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GeolocationInternalsStubDispatch {
 public:
  static bool Accept(GeolocationInternals* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      GeolocationInternals* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<GeolocationInternals>>
class GeolocationInternalsStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GeolocationInternalsStub() = default;
  ~GeolocationInternalsStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GeolocationInternalsStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GeolocationInternalsStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GeolocationInternalsObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GeolocationInternalsRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GeolocationInternalsResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  NetworkLocationResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkLocationResponse, T>::value>;
  using DataView = NetworkLocationResponseDataView;
  using Data_ = internal::NetworkLocationResponse_Data;

  template <typename... Args>
  static NetworkLocationResponsePtr New(Args&&... args) {
    return NetworkLocationResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkLocationResponsePtr From(const U& u) {
    return mojo::TypeConverter<NetworkLocationResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkLocationResponse>::Convert(*this);
  }


  NetworkLocationResponse();

  NetworkLocationResponse(
      double latitude,
      double longitude,
      std::optional<double> accuracy);


  ~NetworkLocationResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkLocationResponsePtr>
  NetworkLocationResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkLocationResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NetworkLocationResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NetworkLocationResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkLocationResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkLocationResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkLocationResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkLocationResponse_UnserializedMessageContext<
            UserType, NetworkLocationResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NetworkLocationResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NetworkLocationResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkLocationResponse_UnserializedMessageContext<
            UserType, NetworkLocationResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkLocationResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double latitude;
  
  double longitude;
  
  std::optional<double> accuracy;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkLocationResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkLocationResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkLocationResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkLocationResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  AccessPointData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AccessPointData, T>::value>;
  using DataView = AccessPointDataDataView;
  using Data_ = internal::AccessPointData_Data;

  template <typename... Args>
  static AccessPointDataPtr New(Args&&... args) {
    return AccessPointDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AccessPointDataPtr From(const U& u) {
    return mojo::TypeConverter<AccessPointDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AccessPointData>::Convert(*this);
  }


  AccessPointData();

  AccessPointData(
      const std::string& mac_address,
      int32_t radio_signal_strength,
      int32_t channel,
      int32_t signal_to_noise,
      std::optional<::base::Time> timestamp);


  ~AccessPointData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AccessPointDataPtr>
  AccessPointDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AccessPointData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AccessPointData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AccessPointData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AccessPointData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AccessPointData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AccessPointData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AccessPointData_UnserializedMessageContext<
            UserType, AccessPointData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AccessPointData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AccessPointData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AccessPointData_UnserializedMessageContext<
            UserType, AccessPointData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AccessPointData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string mac_address;
  
  int32_t radio_signal_strength;
  
  int32_t channel;
  
  int32_t signal_to_noise;
  
  std::optional<::base::Time> timestamp;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AccessPointData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AccessPointData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AccessPointData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AccessPointData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NetworkLocationDiagnostics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkLocationDiagnostics, T>::value>;
  using DataView = NetworkLocationDiagnosticsDataView;
  using Data_ = internal::NetworkLocationDiagnostics_Data;

  template <typename... Args>
  static NetworkLocationDiagnosticsPtr New(Args&&... args) {
    return NetworkLocationDiagnosticsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkLocationDiagnosticsPtr From(const U& u) {
    return mojo::TypeConverter<NetworkLocationDiagnosticsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkLocationDiagnostics>::Convert(*this);
  }


  NetworkLocationDiagnostics();

  NetworkLocationDiagnostics(
      std::vector<AccessPointDataPtr> access_point_data,
      std::optional<::base::Time> wifi_timestamp);

NetworkLocationDiagnostics(const NetworkLocationDiagnostics&) = delete;
NetworkLocationDiagnostics& operator=(const NetworkLocationDiagnostics&) = delete;

  ~NetworkLocationDiagnostics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkLocationDiagnosticsPtr>
  NetworkLocationDiagnosticsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkLocationDiagnostics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NetworkLocationDiagnostics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NetworkLocationDiagnostics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkLocationDiagnostics::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkLocationDiagnostics::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkLocationDiagnostics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkLocationDiagnostics_UnserializedMessageContext<
            UserType, NetworkLocationDiagnostics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NetworkLocationDiagnostics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NetworkLocationDiagnostics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkLocationDiagnostics_UnserializedMessageContext<
            UserType, NetworkLocationDiagnostics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkLocationDiagnostics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<AccessPointDataPtr> access_point_data;
  
  std::optional<::base::Time> wifi_timestamp;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkLocationDiagnostics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkLocationDiagnostics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkLocationDiagnostics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkLocationDiagnostics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PositionCacheDiagnostics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PositionCacheDiagnostics, T>::value>;
  using DataView = PositionCacheDiagnosticsDataView;
  using Data_ = internal::PositionCacheDiagnostics_Data;

  template <typename... Args>
  static PositionCacheDiagnosticsPtr New(Args&&... args) {
    return PositionCacheDiagnosticsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PositionCacheDiagnosticsPtr From(const U& u) {
    return mojo::TypeConverter<PositionCacheDiagnosticsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PositionCacheDiagnostics>::Convert(*this);
  }


  PositionCacheDiagnostics();

  PositionCacheDiagnostics(
      uint32_t cache_size,
      std::optional<::base::Time> last_hit,
      std::optional<::base::Time> last_miss,
      std::optional<double> hit_rate,
      ::device::mojom::GeopositionResultPtr last_network_result);

PositionCacheDiagnostics(const PositionCacheDiagnostics&) = delete;
PositionCacheDiagnostics& operator=(const PositionCacheDiagnostics&) = delete;

  ~PositionCacheDiagnostics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PositionCacheDiagnosticsPtr>
  PositionCacheDiagnosticsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PositionCacheDiagnostics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PositionCacheDiagnostics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PositionCacheDiagnostics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PositionCacheDiagnostics::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PositionCacheDiagnostics::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PositionCacheDiagnostics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PositionCacheDiagnostics_UnserializedMessageContext<
            UserType, PositionCacheDiagnostics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PositionCacheDiagnostics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PositionCacheDiagnostics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PositionCacheDiagnostics_UnserializedMessageContext<
            UserType, PositionCacheDiagnostics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PositionCacheDiagnostics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t cache_size;
  
  std::optional<::base::Time> last_hit;
  
  std::optional<::base::Time> last_miss;
  
  std::optional<double> hit_rate;
  
  ::device::mojom::GeopositionResultPtr last_network_result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PositionCacheDiagnostics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PositionCacheDiagnostics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PositionCacheDiagnostics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PositionCacheDiagnostics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  WifiPollingPolicyDiagnostics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WifiPollingPolicyDiagnostics, T>::value>;
  using DataView = WifiPollingPolicyDiagnosticsDataView;
  using Data_ = internal::WifiPollingPolicyDiagnostics_Data;

  template <typename... Args>
  static WifiPollingPolicyDiagnosticsPtr New(Args&&... args) {
    return WifiPollingPolicyDiagnosticsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WifiPollingPolicyDiagnosticsPtr From(const U& u) {
    return mojo::TypeConverter<WifiPollingPolicyDiagnosticsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WifiPollingPolicyDiagnostics>::Convert(*this);
  }


  WifiPollingPolicyDiagnostics();

  WifiPollingPolicyDiagnostics(
      std::optional<::base::Time> interval_start,
      ::base::TimeDelta interval_duration,
      ::base::TimeDelta polling_interval,
      ::base::TimeDelta default_interval,
      ::base::TimeDelta no_change_interval,
      ::base::TimeDelta two_no_change_interval,
      ::base::TimeDelta no_wifi_interval);


  ~WifiPollingPolicyDiagnostics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WifiPollingPolicyDiagnosticsPtr>
  WifiPollingPolicyDiagnosticsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WifiPollingPolicyDiagnostics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WifiPollingPolicyDiagnostics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WifiPollingPolicyDiagnostics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WifiPollingPolicyDiagnostics::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WifiPollingPolicyDiagnostics::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WifiPollingPolicyDiagnostics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WifiPollingPolicyDiagnostics_UnserializedMessageContext<
            UserType, WifiPollingPolicyDiagnostics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WifiPollingPolicyDiagnostics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WifiPollingPolicyDiagnostics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WifiPollingPolicyDiagnostics_UnserializedMessageContext<
            UserType, WifiPollingPolicyDiagnostics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WifiPollingPolicyDiagnostics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::base::Time> interval_start;
  
  ::base::TimeDelta interval_duration;
  
  ::base::TimeDelta polling_interval;
  
  ::base::TimeDelta default_interval;
  
  ::base::TimeDelta no_change_interval;
  
  ::base::TimeDelta two_no_change_interval;
  
  ::base::TimeDelta no_wifi_interval;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WifiPollingPolicyDiagnostics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WifiPollingPolicyDiagnostics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WifiPollingPolicyDiagnostics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WifiPollingPolicyDiagnostics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GeolocationDiagnostics {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GeolocationDiagnostics, T>::value>;
  using DataView = GeolocationDiagnosticsDataView;
  using Data_ = internal::GeolocationDiagnostics_Data;
  using ProviderState = GeolocationDiagnostics_ProviderState;

  template <typename... Args>
  static GeolocationDiagnosticsPtr New(Args&&... args) {
    return GeolocationDiagnosticsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GeolocationDiagnosticsPtr From(const U& u) {
    return mojo::TypeConverter<GeolocationDiagnosticsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GeolocationDiagnostics>::Convert(*this);
  }


  GeolocationDiagnostics();

  GeolocationDiagnostics(
      GeolocationDiagnostics::ProviderState provider_state,
      NetworkLocationDiagnosticsPtr network_location_diagnostics,
      PositionCacheDiagnosticsPtr position_cache_diagnostics,
      WifiPollingPolicyDiagnosticsPtr wifi_polling_policy_diagnostics,
      std::optional<LocationProviderManagerMode> location_provider_manager_mode);

GeolocationDiagnostics(const GeolocationDiagnostics&) = delete;
GeolocationDiagnostics& operator=(const GeolocationDiagnostics&) = delete;

  ~GeolocationDiagnostics();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GeolocationDiagnosticsPtr>
  GeolocationDiagnosticsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GeolocationDiagnostics::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GeolocationDiagnostics::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GeolocationDiagnostics::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GeolocationDiagnostics::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GeolocationDiagnostics::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GeolocationDiagnostics::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GeolocationDiagnostics_UnserializedMessageContext<
            UserType, GeolocationDiagnostics::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GeolocationDiagnostics::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GeolocationDiagnostics::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GeolocationDiagnostics_UnserializedMessageContext<
            UserType, GeolocationDiagnostics::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GeolocationDiagnostics::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  GeolocationDiagnostics::ProviderState provider_state;
  
  NetworkLocationDiagnosticsPtr network_location_diagnostics;
  
  PositionCacheDiagnosticsPtr position_cache_diagnostics;
  
  WifiPollingPolicyDiagnosticsPtr wifi_polling_policy_diagnostics;
  
  std::optional<LocationProviderManagerMode> location_provider_manager_mode;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GeolocationDiagnostics::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GeolocationDiagnostics::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GeolocationDiagnostics::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GeolocationDiagnostics::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
AccessPointDataPtr AccessPointData::Clone() const {
  return New(
      mojo::Clone(mac_address),
      mojo::Clone(radio_signal_strength),
      mojo::Clone(channel),
      mojo::Clone(signal_to_noise),
      mojo::Clone(timestamp)
  );
}

template <typename T, AccessPointData::EnableIfSame<T>*>
bool AccessPointData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->mac_address, other_struct.mac_address))
    return false;
  if (!mojo::Equals(this->radio_signal_strength, other_struct.radio_signal_strength))
    return false;
  if (!mojo::Equals(this->channel, other_struct.channel))
    return false;
  if (!mojo::Equals(this->signal_to_noise, other_struct.signal_to_noise))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  return true;
}

template <typename T, AccessPointData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.mac_address < rhs.mac_address)
    return true;
  if (rhs.mac_address < lhs.mac_address)
    return false;
  if (lhs.radio_signal_strength < rhs.radio_signal_strength)
    return true;
  if (rhs.radio_signal_strength < lhs.radio_signal_strength)
    return false;
  if (lhs.channel < rhs.channel)
    return true;
  if (rhs.channel < lhs.channel)
    return false;
  if (lhs.signal_to_noise < rhs.signal_to_noise)
    return true;
  if (rhs.signal_to_noise < lhs.signal_to_noise)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  return false;
}
template <typename StructPtrType>
NetworkLocationDiagnosticsPtr NetworkLocationDiagnostics::Clone() const {
  return New(
      mojo::Clone(access_point_data),
      mojo::Clone(wifi_timestamp)
  );
}

template <typename T, NetworkLocationDiagnostics::EnableIfSame<T>*>
bool NetworkLocationDiagnostics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->access_point_data, other_struct.access_point_data))
    return false;
  if (!mojo::Equals(this->wifi_timestamp, other_struct.wifi_timestamp))
    return false;
  return true;
}

template <typename T, NetworkLocationDiagnostics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.access_point_data < rhs.access_point_data)
    return true;
  if (rhs.access_point_data < lhs.access_point_data)
    return false;
  if (lhs.wifi_timestamp < rhs.wifi_timestamp)
    return true;
  if (rhs.wifi_timestamp < lhs.wifi_timestamp)
    return false;
  return false;
}
template <typename StructPtrType>
PositionCacheDiagnosticsPtr PositionCacheDiagnostics::Clone() const {
  return New(
      mojo::Clone(cache_size),
      mojo::Clone(last_hit),
      mojo::Clone(last_miss),
      mojo::Clone(hit_rate),
      mojo::Clone(last_network_result)
  );
}

template <typename T, PositionCacheDiagnostics::EnableIfSame<T>*>
bool PositionCacheDiagnostics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cache_size, other_struct.cache_size))
    return false;
  if (!mojo::Equals(this->last_hit, other_struct.last_hit))
    return false;
  if (!mojo::Equals(this->last_miss, other_struct.last_miss))
    return false;
  if (!mojo::Equals(this->hit_rate, other_struct.hit_rate))
    return false;
  if (!mojo::Equals(this->last_network_result, other_struct.last_network_result))
    return false;
  return true;
}

template <typename T, PositionCacheDiagnostics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cache_size < rhs.cache_size)
    return true;
  if (rhs.cache_size < lhs.cache_size)
    return false;
  if (lhs.last_hit < rhs.last_hit)
    return true;
  if (rhs.last_hit < lhs.last_hit)
    return false;
  if (lhs.last_miss < rhs.last_miss)
    return true;
  if (rhs.last_miss < lhs.last_miss)
    return false;
  if (lhs.hit_rate < rhs.hit_rate)
    return true;
  if (rhs.hit_rate < lhs.hit_rate)
    return false;
  if (lhs.last_network_result < rhs.last_network_result)
    return true;
  if (rhs.last_network_result < lhs.last_network_result)
    return false;
  return false;
}
template <typename StructPtrType>
WifiPollingPolicyDiagnosticsPtr WifiPollingPolicyDiagnostics::Clone() const {
  return New(
      mojo::Clone(interval_start),
      mojo::Clone(interval_duration),
      mojo::Clone(polling_interval),
      mojo::Clone(default_interval),
      mojo::Clone(no_change_interval),
      mojo::Clone(two_no_change_interval),
      mojo::Clone(no_wifi_interval)
  );
}

template <typename T, WifiPollingPolicyDiagnostics::EnableIfSame<T>*>
bool WifiPollingPolicyDiagnostics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->interval_start, other_struct.interval_start))
    return false;
  if (!mojo::Equals(this->interval_duration, other_struct.interval_duration))
    return false;
  if (!mojo::Equals(this->polling_interval, other_struct.polling_interval))
    return false;
  if (!mojo::Equals(this->default_interval, other_struct.default_interval))
    return false;
  if (!mojo::Equals(this->no_change_interval, other_struct.no_change_interval))
    return false;
  if (!mojo::Equals(this->two_no_change_interval, other_struct.two_no_change_interval))
    return false;
  if (!mojo::Equals(this->no_wifi_interval, other_struct.no_wifi_interval))
    return false;
  return true;
}

template <typename T, WifiPollingPolicyDiagnostics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.interval_start < rhs.interval_start)
    return true;
  if (rhs.interval_start < lhs.interval_start)
    return false;
  if (lhs.interval_duration < rhs.interval_duration)
    return true;
  if (rhs.interval_duration < lhs.interval_duration)
    return false;
  if (lhs.polling_interval < rhs.polling_interval)
    return true;
  if (rhs.polling_interval < lhs.polling_interval)
    return false;
  if (lhs.default_interval < rhs.default_interval)
    return true;
  if (rhs.default_interval < lhs.default_interval)
    return false;
  if (lhs.no_change_interval < rhs.no_change_interval)
    return true;
  if (rhs.no_change_interval < lhs.no_change_interval)
    return false;
  if (lhs.two_no_change_interval < rhs.two_no_change_interval)
    return true;
  if (rhs.two_no_change_interval < lhs.two_no_change_interval)
    return false;
  if (lhs.no_wifi_interval < rhs.no_wifi_interval)
    return true;
  if (rhs.no_wifi_interval < lhs.no_wifi_interval)
    return false;
  return false;
}
template <typename StructPtrType>
GeolocationDiagnosticsPtr GeolocationDiagnostics::Clone() const {
  return New(
      mojo::Clone(provider_state),
      mojo::Clone(network_location_diagnostics),
      mojo::Clone(position_cache_diagnostics),
      mojo::Clone(wifi_polling_policy_diagnostics),
      mojo::Clone(location_provider_manager_mode)
  );
}

template <typename T, GeolocationDiagnostics::EnableIfSame<T>*>
bool GeolocationDiagnostics::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->provider_state, other_struct.provider_state))
    return false;
  if (!mojo::Equals(this->network_location_diagnostics, other_struct.network_location_diagnostics))
    return false;
  if (!mojo::Equals(this->position_cache_diagnostics, other_struct.position_cache_diagnostics))
    return false;
  if (!mojo::Equals(this->wifi_polling_policy_diagnostics, other_struct.wifi_polling_policy_diagnostics))
    return false;
  if (!mojo::Equals(this->location_provider_manager_mode, other_struct.location_provider_manager_mode))
    return false;
  return true;
}

template <typename T, GeolocationDiagnostics::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.provider_state < rhs.provider_state)
    return true;
  if (rhs.provider_state < lhs.provider_state)
    return false;
  if (lhs.network_location_diagnostics < rhs.network_location_diagnostics)
    return true;
  if (rhs.network_location_diagnostics < lhs.network_location_diagnostics)
    return false;
  if (lhs.position_cache_diagnostics < rhs.position_cache_diagnostics)
    return true;
  if (rhs.position_cache_diagnostics < lhs.position_cache_diagnostics)
    return false;
  if (lhs.wifi_polling_policy_diagnostics < rhs.wifi_polling_policy_diagnostics)
    return true;
  if (rhs.wifi_polling_policy_diagnostics < lhs.wifi_polling_policy_diagnostics)
    return false;
  if (lhs.location_provider_manager_mode < rhs.location_provider_manager_mode)
    return true;
  if (rhs.location_provider_manager_mode < lhs.location_provider_manager_mode)
    return false;
  return false;
}
template <typename StructPtrType>
NetworkLocationResponsePtr NetworkLocationResponse::Clone() const {
  return New(
      mojo::Clone(latitude),
      mojo::Clone(longitude),
      mojo::Clone(accuracy)
  );
}

template <typename T, NetworkLocationResponse::EnableIfSame<T>*>
bool NetworkLocationResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->latitude, other_struct.latitude))
    return false;
  if (!mojo::Equals(this->longitude, other_struct.longitude))
    return false;
  if (!mojo::Equals(this->accuracy, other_struct.accuracy))
    return false;
  return true;
}

template <typename T, NetworkLocationResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.latitude < rhs.latitude)
    return true;
  if (rhs.latitude < lhs.latitude)
    return false;
  if (lhs.longitude < rhs.longitude)
    return true;
  if (rhs.longitude < lhs.longitude)
    return false;
  if (lhs.accuracy < rhs.accuracy)
    return true;
  if (rhs.accuracy < lhs.accuracy)
    return false;
  return false;
}


}  // device::mojom

namespace mojo {


template <>
struct  StructTraits<::device::mojom::AccessPointData::DataView,
                                         ::device::mojom::AccessPointDataPtr> {
  static bool IsNull(const ::device::mojom::AccessPointDataPtr& input) { return !input; }
  static void SetToNull(::device::mojom::AccessPointDataPtr* output) { output->reset(); }

  static const decltype(::device::mojom::AccessPointData::mac_address)& mac_address(
      const ::device::mojom::AccessPointDataPtr& input) {
    return input->mac_address;
  }

  static decltype(::device::mojom::AccessPointData::radio_signal_strength) radio_signal_strength(
      const ::device::mojom::AccessPointDataPtr& input) {
    return input->radio_signal_strength;
  }

  static decltype(::device::mojom::AccessPointData::channel) channel(
      const ::device::mojom::AccessPointDataPtr& input) {
    return input->channel;
  }

  static decltype(::device::mojom::AccessPointData::signal_to_noise) signal_to_noise(
      const ::device::mojom::AccessPointDataPtr& input) {
    return input->signal_to_noise;
  }

  static const decltype(::device::mojom::AccessPointData::timestamp)& timestamp(
      const ::device::mojom::AccessPointDataPtr& input) {
    return input->timestamp;
  }

  static bool Read(::device::mojom::AccessPointData::DataView input, ::device::mojom::AccessPointDataPtr* output);
};


template <>
struct  StructTraits<::device::mojom::NetworkLocationDiagnostics::DataView,
                                         ::device::mojom::NetworkLocationDiagnosticsPtr> {
  static bool IsNull(const ::device::mojom::NetworkLocationDiagnosticsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::NetworkLocationDiagnosticsPtr* output) { output->reset(); }

  static const decltype(::device::mojom::NetworkLocationDiagnostics::access_point_data)& access_point_data(
      const ::device::mojom::NetworkLocationDiagnosticsPtr& input) {
    return input->access_point_data;
  }

  static const decltype(::device::mojom::NetworkLocationDiagnostics::wifi_timestamp)& wifi_timestamp(
      const ::device::mojom::NetworkLocationDiagnosticsPtr& input) {
    return input->wifi_timestamp;
  }

  static bool Read(::device::mojom::NetworkLocationDiagnostics::DataView input, ::device::mojom::NetworkLocationDiagnosticsPtr* output);
};


template <>
struct  StructTraits<::device::mojom::PositionCacheDiagnostics::DataView,
                                         ::device::mojom::PositionCacheDiagnosticsPtr> {
  static bool IsNull(const ::device::mojom::PositionCacheDiagnosticsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::PositionCacheDiagnosticsPtr* output) { output->reset(); }

  static decltype(::device::mojom::PositionCacheDiagnostics::cache_size) cache_size(
      const ::device::mojom::PositionCacheDiagnosticsPtr& input) {
    return input->cache_size;
  }

  static const decltype(::device::mojom::PositionCacheDiagnostics::last_hit)& last_hit(
      const ::device::mojom::PositionCacheDiagnosticsPtr& input) {
    return input->last_hit;
  }

  static const decltype(::device::mojom::PositionCacheDiagnostics::last_miss)& last_miss(
      const ::device::mojom::PositionCacheDiagnosticsPtr& input) {
    return input->last_miss;
  }

  static decltype(::device::mojom::PositionCacheDiagnostics::hit_rate) hit_rate(
      const ::device::mojom::PositionCacheDiagnosticsPtr& input) {
    return input->hit_rate;
  }

  static const decltype(::device::mojom::PositionCacheDiagnostics::last_network_result)& last_network_result(
      const ::device::mojom::PositionCacheDiagnosticsPtr& input) {
    return input->last_network_result;
  }

  static bool Read(::device::mojom::PositionCacheDiagnostics::DataView input, ::device::mojom::PositionCacheDiagnosticsPtr* output);
};


template <>
struct  StructTraits<::device::mojom::WifiPollingPolicyDiagnostics::DataView,
                                         ::device::mojom::WifiPollingPolicyDiagnosticsPtr> {
  static bool IsNull(const ::device::mojom::WifiPollingPolicyDiagnosticsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::WifiPollingPolicyDiagnosticsPtr* output) { output->reset(); }

  static const decltype(::device::mojom::WifiPollingPolicyDiagnostics::interval_start)& interval_start(
      const ::device::mojom::WifiPollingPolicyDiagnosticsPtr& input) {
    return input->interval_start;
  }

  static const decltype(::device::mojom::WifiPollingPolicyDiagnostics::interval_duration)& interval_duration(
      const ::device::mojom::WifiPollingPolicyDiagnosticsPtr& input) {
    return input->interval_duration;
  }

  static const decltype(::device::mojom::WifiPollingPolicyDiagnostics::polling_interval)& polling_interval(
      const ::device::mojom::WifiPollingPolicyDiagnosticsPtr& input) {
    return input->polling_interval;
  }

  static const decltype(::device::mojom::WifiPollingPolicyDiagnostics::default_interval)& default_interval(
      const ::device::mojom::WifiPollingPolicyDiagnosticsPtr& input) {
    return input->default_interval;
  }

  static const decltype(::device::mojom::WifiPollingPolicyDiagnostics::no_change_interval)& no_change_interval(
      const ::device::mojom::WifiPollingPolicyDiagnosticsPtr& input) {
    return input->no_change_interval;
  }

  static const decltype(::device::mojom::WifiPollingPolicyDiagnostics::two_no_change_interval)& two_no_change_interval(
      const ::device::mojom::WifiPollingPolicyDiagnosticsPtr& input) {
    return input->two_no_change_interval;
  }

  static const decltype(::device::mojom::WifiPollingPolicyDiagnostics::no_wifi_interval)& no_wifi_interval(
      const ::device::mojom::WifiPollingPolicyDiagnosticsPtr& input) {
    return input->no_wifi_interval;
  }

  static bool Read(::device::mojom::WifiPollingPolicyDiagnostics::DataView input, ::device::mojom::WifiPollingPolicyDiagnosticsPtr* output);
};


template <>
struct  StructTraits<::device::mojom::GeolocationDiagnostics::DataView,
                                         ::device::mojom::GeolocationDiagnosticsPtr> {
  static bool IsNull(const ::device::mojom::GeolocationDiagnosticsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::GeolocationDiagnosticsPtr* output) { output->reset(); }

  static decltype(::device::mojom::GeolocationDiagnostics::provider_state) provider_state(
      const ::device::mojom::GeolocationDiagnosticsPtr& input) {
    return input->provider_state;
  }

  static const decltype(::device::mojom::GeolocationDiagnostics::network_location_diagnostics)& network_location_diagnostics(
      const ::device::mojom::GeolocationDiagnosticsPtr& input) {
    return input->network_location_diagnostics;
  }

  static const decltype(::device::mojom::GeolocationDiagnostics::position_cache_diagnostics)& position_cache_diagnostics(
      const ::device::mojom::GeolocationDiagnosticsPtr& input) {
    return input->position_cache_diagnostics;
  }

  static const decltype(::device::mojom::GeolocationDiagnostics::wifi_polling_policy_diagnostics)& wifi_polling_policy_diagnostics(
      const ::device::mojom::GeolocationDiagnosticsPtr& input) {
    return input->wifi_polling_policy_diagnostics;
  }

  static decltype(::device::mojom::GeolocationDiagnostics::location_provider_manager_mode) location_provider_manager_mode(
      const ::device::mojom::GeolocationDiagnosticsPtr& input) {
    return input->location_provider_manager_mode;
  }

  static bool Read(::device::mojom::GeolocationDiagnostics::DataView input, ::device::mojom::GeolocationDiagnosticsPtr* output);
};


template <>
struct  StructTraits<::device::mojom::NetworkLocationResponse::DataView,
                                         ::device::mojom::NetworkLocationResponsePtr> {
  static bool IsNull(const ::device::mojom::NetworkLocationResponsePtr& input) { return !input; }
  static void SetToNull(::device::mojom::NetworkLocationResponsePtr* output) { output->reset(); }

  static decltype(::device::mojom::NetworkLocationResponse::latitude) latitude(
      const ::device::mojom::NetworkLocationResponsePtr& input) {
    return input->latitude;
  }

  static decltype(::device::mojom::NetworkLocationResponse::longitude) longitude(
      const ::device::mojom::NetworkLocationResponsePtr& input) {
    return input->longitude;
  }

  static decltype(::device::mojom::NetworkLocationResponse::accuracy) accuracy(
      const ::device::mojom::NetworkLocationResponsePtr& input) {
    return input->accuracy;
  }

  static bool Read(::device::mojom::NetworkLocationResponse::DataView input, ::device::mojom::NetworkLocationResponsePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_GEOLOCATION_INTERNALS_MOJOM_H_