// services/device/public/mojom/geolocation_context.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('device.mojom.GeolocationClientId');
goog.require('device.mojom.Geolocation');
goog.require('url.mojom.Origin');
goog.require('url.mojom.Url');
goog.require('device.mojom.GeopositionResult');






goog.provide('device.mojom.GeolocationContext');
goog.provide('device.mojom.GeolocationContextReceiver');
goog.provide('device.mojom.GeolocationContextCallbackRouter');
goog.provide('device.mojom.GeolocationContextInterface');
goog.provide('device.mojom.GeolocationContextRemote');
goog.provide('device.mojom.GeolocationContextPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.GeolocationContextPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.GeolocationContext.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.GeolocationContextInterface = class {
  
  /**
   * @param { !device.mojom.GeolocationPendingReceiver } receiver
   * @param { !url.mojom.Url } requestingUrl
   * @param { !device.mojom.GeolocationClientId } clientId
   */

  bindGeolocation(receiver, requestingUrl, clientId) {}
  
  /**
   * @param { !url.mojom.Origin } origin
   */

  onPermissionRevoked(origin) {}
  
  /**
   * @param { !device.mojom.GeopositionResult } result
   */

  setOverride(result) {}
  
  /**
   */

  clearOverride() {}
};

/**
 * @export
 * @implements { device.mojom.GeolocationContextInterface }
 */
device.mojom.GeolocationContextRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.GeolocationContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.GeolocationContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.GeolocationContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.GeolocationPendingReceiver } receiver
   * @param { !url.mojom.Url } requestingUrl
   * @param { !device.mojom.GeolocationClientId } clientId
   */

  bindGeolocation(
      receiver,
      requestingUrl,
      clientId) {
    this.proxy.sendMessage(
        0,
        device.mojom.GeolocationContext_BindGeolocation_ParamsSpec.$,
        null,
        [
          receiver,
          requestingUrl,
          clientId
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Origin } origin
   */

  onPermissionRevoked(
      origin) {
    this.proxy.sendMessage(
        1,
        device.mojom.GeolocationContext_OnPermissionRevoked_ParamsSpec.$,
        null,
        [
          origin
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.GeopositionResult } result
   */

  setOverride(
      result) {
    this.proxy.sendMessage(
        2,
        device.mojom.GeolocationContext_SetOverride_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  
  /**
   */

  clearOverride() {
    this.proxy.sendMessage(
        3,
        device.mojom.GeolocationContext_ClearOverride_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the GeolocationContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.GeolocationContextReceiver = class {
  /**
   * @param {!device.mojom.GeolocationContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.GeolocationContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.GeolocationContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.GeolocationContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.GeolocationContext_BindGeolocation_ParamsSpec.$,
        null,
        impl.bindGeolocation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.GeolocationContext_OnPermissionRevoked_ParamsSpec.$,
        null,
        impl.onPermissionRevoked.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.GeolocationContext_SetOverride_ParamsSpec.$,
        null,
        impl.setOverride.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.GeolocationContext_ClearOverride_ParamsSpec.$,
        null,
        impl.clearOverride.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.GeolocationContext = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.GeolocationContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.GeolocationContextRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.GeolocationContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the GeolocationContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.GeolocationContextCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.GeolocationContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.GeolocationContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindGeolocation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.GeolocationContext_BindGeolocation_ParamsSpec.$,
        null,
        this.bindGeolocation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPermissionRevoked =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.GeolocationContext_OnPermissionRevoked_ParamsSpec.$,
        null,
        this.onPermissionRevoked.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setOverride =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.GeolocationContext_SetOverride_ParamsSpec.$,
        null,
        this.setOverride.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearOverride =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.GeolocationContext_ClearOverride_ParamsSpec.$,
        null,
        this.clearOverride.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.GeolocationContext_BindGeolocation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.GeolocationContext_BindGeolocation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.GeolocationContext_OnPermissionRevoked_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.GeolocationContext_OnPermissionRevoked_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.GeolocationContext_SetOverride_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.GeolocationContext_SetOverride_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.GeolocationContext_ClearOverride_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.GeolocationContext_ClearOverride_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.GeolocationContext_BindGeolocation_ParamsSpec.$,
    'GeolocationContext_BindGeolocation_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(device.mojom.GeolocationPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestingUrl', 8,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'clientId', 4,
        0,
        device.mojom.GeolocationClientIdSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.GeolocationContext_BindGeolocation_Params');

/** @record */
device.mojom.GeolocationContext_BindGeolocation_Params = class {
  constructor() {
    /** @export { !device.mojom.GeolocationPendingReceiver } */
    this.receiver;
    /** @export { !url.mojom.Url } */
    this.requestingUrl;
    /** @export { !device.mojom.GeolocationClientId } */
    this.clientId;
  }
};



mojo.internal.Struct(
    device.mojom.GeolocationContext_OnPermissionRevoked_ParamsSpec.$,
    'GeolocationContext_OnPermissionRevoked_Params',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url.mojom.OriginSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.GeolocationContext_OnPermissionRevoked_Params');

/** @record */
device.mojom.GeolocationContext_OnPermissionRevoked_Params = class {
  constructor() {
    /** @export { !url.mojom.Origin } */
    this.origin;
  }
};



mojo.internal.Struct(
    device.mojom.GeolocationContext_SetOverride_ParamsSpec.$,
    'GeolocationContext_SetOverride_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.GeopositionResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.GeolocationContext_SetOverride_Params');

/** @record */
device.mojom.GeolocationContext_SetOverride_Params = class {
  constructor() {
    /** @export { !device.mojom.GeopositionResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.GeolocationContext_ClearOverride_ParamsSpec.$,
    'GeolocationContext_ClearOverride_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.GeolocationContext_ClearOverride_Params');

/** @record */
device.mojom.GeolocationContext_ClearOverride_Params = class {
  constructor() {
  }
};

