// services/device/public/mojom/geolocation_context.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/geolocation_context.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/geolocation_context.mojom-params-data.h"
#include "services/device/public/mojom/geolocation_context.mojom-shared-message-ids.h"

#include "services/device/public/mojom/geolocation_context.mojom-blink-import-headers.h"
#include "services/device/public/mojom/geolocation_context.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
// The declaration includes the definition on other builds.

GeolocationContext::IPCStableHashFunction GeolocationContext::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GeolocationContext>(message.name())) {
    case messages::GeolocationContext::kBindGeolocation: {
      return &GeolocationContext::BindGeolocation_Sym::IPCStableHash;
    }
    case messages::GeolocationContext::kOnPermissionRevoked: {
      return &GeolocationContext::OnPermissionRevoked_Sym::IPCStableHash;
    }
    case messages::GeolocationContext::kSetOverride: {
      return &GeolocationContext::SetOverride_Sym::IPCStableHash;
    }
    case messages::GeolocationContext::kClearOverride: {
      return &GeolocationContext::ClearOverride_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GeolocationContext::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GeolocationContext>(message.name())) {
      case messages::GeolocationContext::kBindGeolocation:
            return "Receive device::mojom::GeolocationContext::BindGeolocation";
      case messages::GeolocationContext::kOnPermissionRevoked:
            return "Receive device::mojom::GeolocationContext::OnPermissionRevoked";
      case messages::GeolocationContext::kSetOverride:
            return "Receive device::mojom::GeolocationContext::SetOverride";
      case messages::GeolocationContext::kClearOverride:
            return "Receive device::mojom::GeolocationContext::ClearOverride";
    }
  } else {
    switch (static_cast<messages::GeolocationContext>(message.name())) {
      case messages::GeolocationContext::kBindGeolocation:
            return "Receive reply device::mojom::GeolocationContext::BindGeolocation";
      case messages::GeolocationContext::kOnPermissionRevoked:
            return "Receive reply device::mojom::GeolocationContext::OnPermissionRevoked";
      case messages::GeolocationContext::kSetOverride:
            return "Receive reply device::mojom::GeolocationContext::SetOverride";
      case messages::GeolocationContext::kClearOverride:
            return "Receive reply device::mojom::GeolocationContext::ClearOverride";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GeolocationContext::BindGeolocation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8812d137;  // IPCStableHash for device::mojom::GeolocationContext::BindGeolocation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GeolocationContext::OnPermissionRevoked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x56c7c880;  // IPCStableHash for device::mojom::GeolocationContext::OnPermissionRevoked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GeolocationContext::SetOverride_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49b838ea;  // IPCStableHash for device::mojom::GeolocationContext::SetOverride
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GeolocationContext::ClearOverride_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfe0ef1dd;  // IPCStableHash for device::mojom::GeolocationContext::ClearOverride
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

GeolocationContextProxy::GeolocationContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GeolocationContextProxy::BindGeolocation(
    ::mojo::PendingReceiver<::device::mojom::blink::Geolocation> in_receiver, const ::blink::KURL& in_requesting_url, ::device::mojom::blink::GeolocationClientId in_client_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::GeolocationContext::BindGeolocation", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::blink::Geolocation>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requesting_url"), in_requesting_url,
                        "<value of type const ::blink::KURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client_id"), in_client_id,
                        "<value of type ::device::mojom::blink::GeolocationClientId>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GeolocationContext::kBindGeolocation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GeolocationContext_BindGeolocation_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::GeolocationInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in GeolocationContext.BindGeolocation request");
  mojo::internal::MessageFragment<
      typename decltype(params->requesting_url)::BaseType> requesting_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_requesting_url,
    requesting_url_fragment);

  params->requesting_url.Set(
      requesting_url_fragment.is_null() ? nullptr : requesting_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requesting_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requesting_url in GeolocationContext.BindGeolocation request");

  
  mojo::internal::Serialize<::device::mojom::GeolocationClientId>(
    in_client_id,
    &params->client_id);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GeolocationContext::Name_);
  message.set_method_name("BindGeolocation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GeolocationContextProxy::OnPermissionRevoked(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& in_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::GeolocationContext::OnPermissionRevoked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("origin"), in_origin,
                        "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GeolocationContext::kOnPermissionRevoked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GeolocationContext_OnPermissionRevoked_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->origin)::BaseType> origin_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
    in_origin,
    origin_fragment);

  params->origin.Set(
      origin_fragment.is_null() ? nullptr : origin_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->origin.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null origin in GeolocationContext.OnPermissionRevoked request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GeolocationContext::Name_);
  message.set_method_name("OnPermissionRevoked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GeolocationContextProxy::SetOverride(
    ::device::mojom::blink::GeopositionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::GeolocationContext::SetOverride", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::device::mojom::blink::GeopositionResultPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GeolocationContext::kSetOverride), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GeolocationContext_SetOverride_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::device::mojom::GeopositionResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in GeolocationContext.SetOverride request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GeolocationContext::Name_);
  message.set_method_name("SetOverride");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GeolocationContextProxy::ClearOverride(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::GeolocationContext::ClearOverride");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GeolocationContext::kClearOverride), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::GeolocationContext_ClearOverride_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GeolocationContext::Name_);
  message.set_method_name("ClearOverride");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool GeolocationContextStubDispatch::Accept(
    GeolocationContext* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GeolocationContext>(message->header()->name)) {
    case messages::GeolocationContext::kBindGeolocation: {
      DCHECK(message->is_serialized());
      internal::GeolocationContext_BindGeolocation_Params_Data* params =
          reinterpret_cast<internal::GeolocationContext_BindGeolocation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GeolocationContext.0
      bool success = true;
      ::mojo::PendingReceiver<::device::mojom::blink::Geolocation> p_receiver{};
      ::blink::KURL p_requesting_url{};
      ::device::mojom::blink::GeolocationClientId p_client_id{};
      GeolocationContext_BindGeolocation_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success && !input_data_view.ReadRequestingUrl(&p_requesting_url))
        success = false;
      if (success && !input_data_view.ReadClientId(&p_client_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GeolocationContext::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindGeolocation(        
        std::move(p_receiver), 
        std::move(p_requesting_url), 
        std::move(p_client_id));
      return true;
    }
    case messages::GeolocationContext::kOnPermissionRevoked: {
      DCHECK(message->is_serialized());
      internal::GeolocationContext_OnPermissionRevoked_Params_Data* params =
          reinterpret_cast<internal::GeolocationContext_OnPermissionRevoked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GeolocationContext.1
      bool success = true;
      ::scoped_refptr<const ::blink::SecurityOrigin> p_origin{};
      GeolocationContext_OnPermissionRevoked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GeolocationContext::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnPermissionRevoked(        
        std::move(p_origin));
      return true;
    }
    case messages::GeolocationContext::kSetOverride: {
      DCHECK(message->is_serialized());
      internal::GeolocationContext_SetOverride_Params_Data* params =
          reinterpret_cast<internal::GeolocationContext_SetOverride_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GeolocationContext.2
      bool success = true;
      ::device::mojom::blink::GeopositionResultPtr p_result{};
      GeolocationContext_SetOverride_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GeolocationContext::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetOverride(        
        std::move(p_result));
      return true;
    }
    case messages::GeolocationContext::kClearOverride: {
      DCHECK(message->is_serialized());
      internal::GeolocationContext_ClearOverride_Params_Data* params =
          reinterpret_cast<internal::GeolocationContext_ClearOverride_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GeolocationContext.3
      bool success = true;
      GeolocationContext_ClearOverride_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GeolocationContext::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearOverride(        );
      return true;
    }
  }
  return false;
}

// static
bool GeolocationContextStubDispatch::AcceptWithResponder(
    GeolocationContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GeolocationContext>(message->header()->name)) {
    case messages::GeolocationContext::kBindGeolocation: {
      break;
    }
    case messages::GeolocationContext::kOnPermissionRevoked: {
      break;
    }
    case messages::GeolocationContext::kSetOverride: {
      break;
    }
    case messages::GeolocationContext::kClearOverride: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kGeolocationContextValidationInfo[] = {
    { &internal::GeolocationContext_BindGeolocation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GeolocationContext_OnPermissionRevoked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GeolocationContext_SetOverride_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::GeolocationContext_ClearOverride_Params_Data::Validate,
     nullptr /* no response */},
};

bool GeolocationContextRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::GeolocationContext::Name_,
    kGeolocationContextValidationInfo);
}



}  // device::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {


void GeolocationContextInterceptorForTesting::BindGeolocation(::mojo::PendingReceiver<::device::mojom::blink::Geolocation> receiver, const ::blink::KURL& requesting_url, ::device::mojom::blink::GeolocationClientId client_id) {
  GetForwardingInterface()->BindGeolocation(
    std::move(receiver)
    , 
    std::move(requesting_url)
    , 
    std::move(client_id)
    );
}
void GeolocationContextInterceptorForTesting::OnPermissionRevoked(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin) {
  GetForwardingInterface()->OnPermissionRevoked(
    std::move(origin)
    );
}
void GeolocationContextInterceptorForTesting::SetOverride(::device::mojom::blink::GeopositionResultPtr result) {
  GetForwardingInterface()->SetOverride(
    std::move(result)
    );
}
void GeolocationContextInterceptorForTesting::ClearOverride() {
  GetForwardingInterface()->ClearOverride();
}
GeolocationContextAsyncWaiter::GeolocationContextAsyncWaiter(
    GeolocationContext* proxy) : proxy_(proxy) {}

GeolocationContextAsyncWaiter::~GeolocationContextAsyncWaiter() = default;







}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif