// services/device/public/mojom/geolocation.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/geolocation.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/geolocation.mojom-params-data.h"
#include "services/device/public/mojom/geolocation.mojom-shared-message-ids.h"

#include "services/device/public/mojom/geolocation.mojom-import-headers.h"
#include "services/device/public/mojom/geolocation.mojom-test-utils.h"


namespace device::mojom {
// The declaration includes the definition on other builds.

Geolocation::IPCStableHashFunction Geolocation::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Geolocation>(message.name())) {
    case messages::Geolocation::kSetHighAccuracyHint: {
      return &Geolocation::SetHighAccuracyHint_Sym::IPCStableHash;
    }
    case messages::Geolocation::kQueryNextPosition: {
      return &Geolocation::QueryNextPosition_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Geolocation::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Geolocation>(message.name())) {
      case messages::Geolocation::kSetHighAccuracyHint:
            return "Receive device::mojom::Geolocation::SetHighAccuracyHint";
      case messages::Geolocation::kQueryNextPosition:
            return "Receive device::mojom::Geolocation::QueryNextPosition";
    }
  } else {
    switch (static_cast<messages::Geolocation>(message.name())) {
      case messages::Geolocation::kSetHighAccuracyHint:
            return "Receive reply device::mojom::Geolocation::SetHighAccuracyHint";
      case messages::Geolocation::kQueryNextPosition:
            return "Receive reply device::mojom::Geolocation::QueryNextPosition";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Geolocation::SetHighAccuracyHint_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x39b7495a;  // IPCStableHash for device::mojom::Geolocation::SetHighAccuracyHint
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Geolocation::QueryNextPosition_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x065605c5;  // IPCStableHash for device::mojom::Geolocation::QueryNextPosition
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Geolocation_QueryNextPosition_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Geolocation_QueryNextPosition_ForwardToCallback(
      Geolocation::QueryNextPositionCallback callback
      ) : callback_(std::move(callback)) {
  }

  Geolocation_QueryNextPosition_ForwardToCallback(const Geolocation_QueryNextPosition_ForwardToCallback&) = delete;
  Geolocation_QueryNextPosition_ForwardToCallback& operator=(const Geolocation_QueryNextPosition_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Geolocation::QueryNextPositionCallback callback_;
};

GeolocationProxy::GeolocationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GeolocationProxy::SetHighAccuracyHint(
    bool in_high_accuracy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::Geolocation::SetHighAccuracyHint", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("high_accuracy"), in_high_accuracy,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Geolocation::kSetHighAccuracyHint), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Geolocation_SetHighAccuracyHint_Params_Data> params(
          message);
  params.Allocate();

  params->high_accuracy = in_high_accuracy;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Geolocation::Name_);
  message.set_method_name("SetHighAccuracyHint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void GeolocationProxy::QueryNextPosition(
    QueryNextPositionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::Geolocation::QueryNextPosition");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Geolocation::kQueryNextPosition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Geolocation_QueryNextPosition_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Geolocation::Name_);
  message.set_method_name("QueryNextPosition");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Geolocation_QueryNextPosition_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Geolocation_QueryNextPosition_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Geolocation::QueryNextPositionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Geolocation_QueryNextPosition_ProxyToResponder> proxy(
        new Geolocation_QueryNextPosition_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Geolocation_QueryNextPosition_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Geolocation_QueryNextPosition_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Geolocation_QueryNextPosition_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Geolocation::QueryNextPositionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::device::mojom::GeopositionResultPtr in_result);
};

bool Geolocation_QueryNextPosition_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Geolocation_QueryNextPosition_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Geolocation_QueryNextPosition_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Geolocation.1
  bool success = true;
  ::device::mojom::GeopositionResultPtr p_result{};
  Geolocation_QueryNextPosition_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Geolocation::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void Geolocation_QueryNextPosition_ProxyToResponder::Run(
    ::device::mojom::GeopositionResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::Geolocation::QueryNextPosition", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::device::mojom::GeopositionResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Geolocation::kQueryNextPosition), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::Geolocation_QueryNextPosition_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::device::mojom::GeopositionResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Geolocation::Name_);
  message.set_method_name("QueryNextPosition");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GeolocationStubDispatch::Accept(
    Geolocation* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Geolocation>(message->header()->name)) {
    case messages::Geolocation::kSetHighAccuracyHint: {
      DCHECK(message->is_serialized());
      internal::Geolocation_SetHighAccuracyHint_Params_Data* params =
          reinterpret_cast<internal::Geolocation_SetHighAccuracyHint_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Geolocation.0
      bool success = true;
      bool p_high_accuracy{};
      Geolocation_SetHighAccuracyHint_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_high_accuracy = input_data_view.high_accuracy();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Geolocation::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHighAccuracyHint(        
        std::move(p_high_accuracy));
      return true;
    }
    case messages::Geolocation::kQueryNextPosition: {
      break;
    }
  }
  return false;
}

// static
bool GeolocationStubDispatch::AcceptWithResponder(
    Geolocation* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Geolocation>(message->header()->name)) {
    case messages::Geolocation::kSetHighAccuracyHint: {
      break;
    }
    case messages::Geolocation::kQueryNextPosition: {
      internal::Geolocation_QueryNextPosition_Params_Data* params =
          reinterpret_cast<
              internal::Geolocation_QueryNextPosition_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Geolocation.1
      bool success = true;
      Geolocation_QueryNextPosition_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Geolocation::Name_, 1, false);
        return false;
      }
      auto callback =
          Geolocation_QueryNextPosition_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryNextPosition(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kGeolocationValidationInfo[] = {
    { &internal::Geolocation_SetHighAccuracyHint_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Geolocation_QueryNextPosition_Params_Data::Validate,
     &internal::Geolocation_QueryNextPosition_ResponseParams_Data::Validate},
};

bool GeolocationRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::Geolocation::Name_,
    kGeolocationValidationInfo);
}

bool GeolocationResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::Geolocation::Name_,
    kGeolocationValidationInfo);
}


}  // device::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void GeolocationInterceptorForTesting::SetHighAccuracyHint(bool high_accuracy) {
  GetForwardingInterface()->SetHighAccuracyHint(
    std::move(high_accuracy)
    );
}
void GeolocationInterceptorForTesting::QueryNextPosition(QueryNextPositionCallback callback) {
  GetForwardingInterface()->QueryNextPosition(std::move(callback));
}
GeolocationAsyncWaiter::GeolocationAsyncWaiter(
    Geolocation* proxy) : proxy_(proxy) {}

GeolocationAsyncWaiter::~GeolocationAsyncWaiter() = default;


void GeolocationAsyncWaiter::QueryNextPosition(
    ::device::mojom::GeopositionResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->QueryNextPosition(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::device::mojom::GeopositionResultPtr* out_result
,
             ::device::mojom::GeopositionResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::device::mojom::GeopositionResultPtr GeolocationAsyncWaiter::QueryNextPosition(
    ) {
  ::device::mojom::GeopositionResultPtr async_wait_result;
  QueryNextPosition(&async_wait_result);
  return async_wait_result;
}






}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif