// services/data_decoder/public/mojom/gzipper.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/data_decoder/public/mojom/gzipper.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/data_decoder/public/mojom/gzipper.mojom-params-data.h"
#include "services/data_decoder/public/mojom/gzipper.mojom-shared-message-ids.h"

#include "services/data_decoder/public/mojom/gzipper.mojom-import-headers.h"
#include "services/data_decoder/public/mojom/gzipper.mojom-test-utils.h"


namespace data_decoder::mojom {
// The declaration includes the definition on other builds.

Gzipper::IPCStableHashFunction Gzipper::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Gzipper>(message.name())) {
    case messages::Gzipper::kDeflate: {
      return &Gzipper::Deflate_Sym::IPCStableHash;
    }
    case messages::Gzipper::kInflate: {
      return &Gzipper::Inflate_Sym::IPCStableHash;
    }
    case messages::Gzipper::kCompress: {
      return &Gzipper::Compress_Sym::IPCStableHash;
    }
    case messages::Gzipper::kUncompress: {
      return &Gzipper::Uncompress_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Gzipper::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Gzipper>(message.name())) {
      case messages::Gzipper::kDeflate:
            return "Receive data_decoder::mojom::Gzipper::Deflate";
      case messages::Gzipper::kInflate:
            return "Receive data_decoder::mojom::Gzipper::Inflate";
      case messages::Gzipper::kCompress:
            return "Receive data_decoder::mojom::Gzipper::Compress";
      case messages::Gzipper::kUncompress:
            return "Receive data_decoder::mojom::Gzipper::Uncompress";
    }
  } else {
    switch (static_cast<messages::Gzipper>(message.name())) {
      case messages::Gzipper::kDeflate:
            return "Receive reply data_decoder::mojom::Gzipper::Deflate";
      case messages::Gzipper::kInflate:
            return "Receive reply data_decoder::mojom::Gzipper::Inflate";
      case messages::Gzipper::kCompress:
            return "Receive reply data_decoder::mojom::Gzipper::Compress";
      case messages::Gzipper::kUncompress:
            return "Receive reply data_decoder::mojom::Gzipper::Uncompress";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Gzipper::Deflate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc38b6fce;  // IPCStableHash for data_decoder::mojom::Gzipper::Deflate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Gzipper::Inflate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf597348b;  // IPCStableHash for data_decoder::mojom::Gzipper::Inflate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Gzipper::Compress_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1f2ffb13;  // IPCStableHash for data_decoder::mojom::Gzipper::Compress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Gzipper::Uncompress_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x418428bf;  // IPCStableHash for data_decoder::mojom::Gzipper::Uncompress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Gzipper_Deflate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Gzipper_Deflate_ForwardToCallback(
      Gzipper::DeflateCallback callback
      ) : callback_(std::move(callback)) {
  }

  Gzipper_Deflate_ForwardToCallback(const Gzipper_Deflate_ForwardToCallback&) = delete;
  Gzipper_Deflate_ForwardToCallback& operator=(const Gzipper_Deflate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Gzipper::DeflateCallback callback_;
};

class Gzipper_Inflate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Gzipper_Inflate_ForwardToCallback(
      Gzipper::InflateCallback callback
      ) : callback_(std::move(callback)) {
  }

  Gzipper_Inflate_ForwardToCallback(const Gzipper_Inflate_ForwardToCallback&) = delete;
  Gzipper_Inflate_ForwardToCallback& operator=(const Gzipper_Inflate_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Gzipper::InflateCallback callback_;
};

class Gzipper_Compress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Gzipper_Compress_ForwardToCallback(
      Gzipper::CompressCallback callback
      ) : callback_(std::move(callback)) {
  }

  Gzipper_Compress_ForwardToCallback(const Gzipper_Compress_ForwardToCallback&) = delete;
  Gzipper_Compress_ForwardToCallback& operator=(const Gzipper_Compress_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Gzipper::CompressCallback callback_;
};

class Gzipper_Uncompress_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Gzipper_Uncompress_ForwardToCallback(
      Gzipper::UncompressCallback callback
      ) : callback_(std::move(callback)) {
  }

  Gzipper_Uncompress_ForwardToCallback(const Gzipper_Uncompress_ForwardToCallback&) = delete;
  Gzipper_Uncompress_ForwardToCallback& operator=(const Gzipper_Uncompress_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Gzipper::UncompressCallback callback_;
};

GzipperProxy::GzipperProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GzipperProxy::Deflate(
    ::mojo_base::BigBuffer in_data, DeflateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::Gzipper::Deflate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Gzipper::kDeflate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::Gzipper_Deflate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in Gzipper.Deflate request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gzipper::Name_);
  message.set_method_name("Deflate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Gzipper_Deflate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GzipperProxy::Inflate(
    ::mojo_base::BigBuffer in_data, uint64_t in_max_uncompressed_size, InflateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::Gzipper::Inflate", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("max_uncompressed_size"), in_max_uncompressed_size,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Gzipper::kInflate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::Gzipper_Inflate_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in Gzipper.Inflate request");

  params->max_uncompressed_size = in_max_uncompressed_size;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gzipper::Name_);
  message.set_method_name("Inflate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Gzipper_Inflate_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GzipperProxy::Compress(
    ::mojo_base::BigBuffer in_data, CompressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::Gzipper::Compress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Gzipper::kCompress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::Gzipper_Compress_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in Gzipper.Compress request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gzipper::Name_);
  message.set_method_name("Compress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Gzipper_Compress_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GzipperProxy::Uncompress(
    ::mojo_base::BigBuffer in_compressed_data, UncompressCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send data_decoder::mojom::Gzipper::Uncompress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compressed_data"), in_compressed_data,
                        "<value of type ::mojo_base::BigBuffer>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Gzipper::kUncompress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::Gzipper_Uncompress_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->compressed_data)>
      compressed_data_fragment(params.message());
  compressed_data_fragment.Claim(&params->compressed_data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_compressed_data,
    compressed_data_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->compressed_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null compressed_data in Gzipper.Uncompress request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gzipper::Name_);
  message.set_method_name("Uncompress");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Gzipper_Uncompress_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class Gzipper_Deflate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Gzipper::DeflateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Gzipper_Deflate_ProxyToResponder> proxy(
        new Gzipper_Deflate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Gzipper_Deflate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Gzipper_Deflate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Gzipper_Deflate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Gzipper::DeflateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::mojo_base::BigBuffer> in_deflated_data);
};

bool Gzipper_Deflate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Gzipper_Deflate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Gzipper_Deflate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Gzipper.0
  bool success = true;
  std::optional<::mojo_base::BigBuffer> p_deflated_data{};
  Gzipper_Deflate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDeflatedData(&p_deflated_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Gzipper::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_deflated_data));
  }
  return true;
}

void Gzipper_Deflate_ProxyToResponder::Run(
    std::optional<::mojo_base::BigBuffer> in_deflated_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_decoder::mojom::Gzipper::Deflate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("deflated_data"), in_deflated_data,
                        "<value of type std::optional<::mojo_base::BigBuffer>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Gzipper::kDeflate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::Gzipper_Deflate_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->deflated_data)>
      deflated_data_fragment(params.message());
  deflated_data_fragment.Claim(&params->deflated_data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_deflated_data,
    deflated_data_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gzipper::Name_);
  message.set_method_name("Deflate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Gzipper_Inflate_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Gzipper::InflateCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Gzipper_Inflate_ProxyToResponder> proxy(
        new Gzipper_Inflate_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Gzipper_Inflate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Gzipper_Inflate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Gzipper_Inflate_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Gzipper::InflateCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::mojo_base::BigBuffer> in_inflated_data);
};

bool Gzipper_Inflate_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Gzipper_Inflate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Gzipper_Inflate_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Gzipper.1
  bool success = true;
  std::optional<::mojo_base::BigBuffer> p_inflated_data{};
  Gzipper_Inflate_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadInflatedData(&p_inflated_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Gzipper::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_inflated_data));
  }
  return true;
}

void Gzipper_Inflate_ProxyToResponder::Run(
    std::optional<::mojo_base::BigBuffer> in_inflated_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_decoder::mojom::Gzipper::Inflate", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("inflated_data"), in_inflated_data,
                        "<value of type std::optional<::mojo_base::BigBuffer>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Gzipper::kInflate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::Gzipper_Inflate_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->inflated_data)>
      inflated_data_fragment(params.message());
  inflated_data_fragment.Claim(&params->inflated_data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_inflated_data,
    inflated_data_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gzipper::Name_);
  message.set_method_name("Inflate");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Gzipper_Compress_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Gzipper::CompressCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Gzipper_Compress_ProxyToResponder> proxy(
        new Gzipper_Compress_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Gzipper_Compress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Gzipper_Compress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Gzipper_Compress_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Gzipper::CompressCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::mojo_base::BigBuffer> in_compressed_data);
};

bool Gzipper_Compress_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Gzipper_Compress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Gzipper_Compress_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Gzipper.2
  bool success = true;
  std::optional<::mojo_base::BigBuffer> p_compressed_data{};
  Gzipper_Compress_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCompressedData(&p_compressed_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Gzipper::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_compressed_data));
  }
  return true;
}

void Gzipper_Compress_ProxyToResponder::Run(
    std::optional<::mojo_base::BigBuffer> in_compressed_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_decoder::mojom::Gzipper::Compress", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("compressed_data"), in_compressed_data,
                        "<value of type std::optional<::mojo_base::BigBuffer>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Gzipper::kCompress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::Gzipper_Compress_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->compressed_data)>
      compressed_data_fragment(params.message());
  compressed_data_fragment.Claim(&params->compressed_data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_compressed_data,
    compressed_data_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gzipper::Name_);
  message.set_method_name("Compress");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Gzipper_Uncompress_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Gzipper::UncompressCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Gzipper_Uncompress_ProxyToResponder> proxy(
        new Gzipper_Uncompress_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Gzipper_Uncompress_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Gzipper_Uncompress_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Gzipper_Uncompress_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "Gzipper::UncompressCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::optional<::mojo_base::BigBuffer> in_data);
};

bool Gzipper_Uncompress_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Gzipper_Uncompress_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Gzipper_Uncompress_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for Gzipper.3
  bool success = true;
  std::optional<::mojo_base::BigBuffer> p_data{};
  Gzipper_Uncompress_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Gzipper::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void Gzipper_Uncompress_ProxyToResponder::Run(
    std::optional<::mojo_base::BigBuffer> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply data_decoder::mojom::Gzipper::Uncompress", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type std::optional<::mojo_base::BigBuffer>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Gzipper::kUncompress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::data_decoder::mojom::internal::Gzipper_Uncompress_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->data)>
      data_fragment(params.message());
  data_fragment.Claim(&params->data);
  
  mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
    in_data,
    data_fragment,
    true);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Gzipper::Name_);
  message.set_method_name("Uncompress");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GzipperStubDispatch::Accept(
    Gzipper* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Gzipper>(message->header()->name)) {
    case messages::Gzipper::kDeflate: {
      break;
    }
    case messages::Gzipper::kInflate: {
      break;
    }
    case messages::Gzipper::kCompress: {
      break;
    }
    case messages::Gzipper::kUncompress: {
      break;
    }
  }
  return false;
}

// static
bool GzipperStubDispatch::AcceptWithResponder(
    Gzipper* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Gzipper>(message->header()->name)) {
    case messages::Gzipper::kDeflate: {
      internal::Gzipper_Deflate_Params_Data* params =
          reinterpret_cast<
              internal::Gzipper_Deflate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Gzipper.0
      bool success = true;
      ::mojo_base::BigBuffer p_data{};
      Gzipper_Deflate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Gzipper::Name_, 0, false);
        return false;
      }
      auto callback =
          Gzipper_Deflate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Deflate(        
        std::move(p_data), std::move(callback));
      return true;
    }
    case messages::Gzipper::kInflate: {
      internal::Gzipper_Inflate_Params_Data* params =
          reinterpret_cast<
              internal::Gzipper_Inflate_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Gzipper.1
      bool success = true;
      ::mojo_base::BigBuffer p_data{};
      uint64_t p_max_uncompressed_size{};
      Gzipper_Inflate_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (success)
        p_max_uncompressed_size = input_data_view.max_uncompressed_size();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Gzipper::Name_, 1, false);
        return false;
      }
      auto callback =
          Gzipper_Inflate_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Inflate(        
        std::move(p_data), 
        std::move(p_max_uncompressed_size), std::move(callback));
      return true;
    }
    case messages::Gzipper::kCompress: {
      internal::Gzipper_Compress_Params_Data* params =
          reinterpret_cast<
              internal::Gzipper_Compress_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Gzipper.2
      bool success = true;
      ::mojo_base::BigBuffer p_data{};
      Gzipper_Compress_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Gzipper::Name_, 2, false);
        return false;
      }
      auto callback =
          Gzipper_Compress_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Compress(        
        std::move(p_data), std::move(callback));
      return true;
    }
    case messages::Gzipper::kUncompress: {
      internal::Gzipper_Uncompress_Params_Data* params =
          reinterpret_cast<
              internal::Gzipper_Uncompress_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for Gzipper.3
      bool success = true;
      ::mojo_base::BigBuffer p_compressed_data{};
      Gzipper_Uncompress_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadCompressedData(&p_compressed_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Gzipper::Name_, 3, false);
        return false;
      }
      auto callback =
          Gzipper_Uncompress_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Uncompress(        
        std::move(p_compressed_data), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kGzipperValidationInfo[] = {
    { &internal::Gzipper_Deflate_Params_Data::Validate,
     &internal::Gzipper_Deflate_ResponseParams_Data::Validate},
    { &internal::Gzipper_Inflate_Params_Data::Validate,
     &internal::Gzipper_Inflate_ResponseParams_Data::Validate},
    { &internal::Gzipper_Compress_Params_Data::Validate,
     &internal::Gzipper_Compress_ResponseParams_Data::Validate},
    { &internal::Gzipper_Uncompress_Params_Data::Validate,
     &internal::Gzipper_Uncompress_ResponseParams_Data::Validate},
};

bool GzipperRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::data_decoder::mojom::Gzipper::Name_,
    kGzipperValidationInfo);
}

bool GzipperResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::data_decoder::mojom::Gzipper::Name_,
    kGzipperValidationInfo);
}


}  // data_decoder::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace data_decoder::mojom {


void GzipperInterceptorForTesting::Deflate(::mojo_base::BigBuffer data, DeflateCallback callback) {
  GetForwardingInterface()->Deflate(
    std::move(data)
    , std::move(callback));
}
void GzipperInterceptorForTesting::Inflate(::mojo_base::BigBuffer data, uint64_t max_uncompressed_size, InflateCallback callback) {
  GetForwardingInterface()->Inflate(
    std::move(data)
    , 
    std::move(max_uncompressed_size)
    , std::move(callback));
}
void GzipperInterceptorForTesting::Compress(::mojo_base::BigBuffer data, CompressCallback callback) {
  GetForwardingInterface()->Compress(
    std::move(data)
    , std::move(callback));
}
void GzipperInterceptorForTesting::Uncompress(::mojo_base::BigBuffer compressed_data, UncompressCallback callback) {
  GetForwardingInterface()->Uncompress(
    std::move(compressed_data)
    , std::move(callback));
}
GzipperAsyncWaiter::GzipperAsyncWaiter(
    Gzipper* proxy) : proxy_(proxy) {}

GzipperAsyncWaiter::~GzipperAsyncWaiter() = default;


void GzipperAsyncWaiter::Deflate(
    ::mojo_base::BigBuffer data, std::optional<::mojo_base::BigBuffer>* out_deflated_data) {
  base::RunLoop loop;
  proxy_->Deflate(
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::mojo_base::BigBuffer>* out_deflated_data
,
             std::optional<::mojo_base::BigBuffer> deflated_data) {*out_deflated_data = std::move(deflated_data);
            loop->Quit();
          },
          &loop,
          out_deflated_data));
  loop.Run();
}

std::optional<::mojo_base::BigBuffer> GzipperAsyncWaiter::Deflate(
    ::mojo_base::BigBuffer data) {
  std::optional<::mojo_base::BigBuffer> async_wait_result;
  Deflate(std::move(data),&async_wait_result);
  return async_wait_result;
}

void GzipperAsyncWaiter::Inflate(
    ::mojo_base::BigBuffer data, uint64_t max_uncompressed_size, std::optional<::mojo_base::BigBuffer>* out_inflated_data) {
  base::RunLoop loop;
  proxy_->Inflate(
      std::move(data),
      std::move(max_uncompressed_size),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::mojo_base::BigBuffer>* out_inflated_data
,
             std::optional<::mojo_base::BigBuffer> inflated_data) {*out_inflated_data = std::move(inflated_data);
            loop->Quit();
          },
          &loop,
          out_inflated_data));
  loop.Run();
}

std::optional<::mojo_base::BigBuffer> GzipperAsyncWaiter::Inflate(
    ::mojo_base::BigBuffer data, uint64_t max_uncompressed_size) {
  std::optional<::mojo_base::BigBuffer> async_wait_result;
  Inflate(std::move(data),std::move(max_uncompressed_size),&async_wait_result);
  return async_wait_result;
}

void GzipperAsyncWaiter::Compress(
    ::mojo_base::BigBuffer data, std::optional<::mojo_base::BigBuffer>* out_compressed_data) {
  base::RunLoop loop;
  proxy_->Compress(
      std::move(data),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::mojo_base::BigBuffer>* out_compressed_data
,
             std::optional<::mojo_base::BigBuffer> compressed_data) {*out_compressed_data = std::move(compressed_data);
            loop->Quit();
          },
          &loop,
          out_compressed_data));
  loop.Run();
}

std::optional<::mojo_base::BigBuffer> GzipperAsyncWaiter::Compress(
    ::mojo_base::BigBuffer data) {
  std::optional<::mojo_base::BigBuffer> async_wait_result;
  Compress(std::move(data),&async_wait_result);
  return async_wait_result;
}

void GzipperAsyncWaiter::Uncompress(
    ::mojo_base::BigBuffer compressed_data, std::optional<::mojo_base::BigBuffer>* out_data) {
  base::RunLoop loop;
  proxy_->Uncompress(
      std::move(compressed_data),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::optional<::mojo_base::BigBuffer>* out_data
,
             std::optional<::mojo_base::BigBuffer> data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

std::optional<::mojo_base::BigBuffer> GzipperAsyncWaiter::Uncompress(
    ::mojo_base::BigBuffer compressed_data) {
  std::optional<::mojo_base::BigBuffer> async_wait_result;
  Uncompress(std::move(compressed_data),&async_wait_result);
  return async_wait_result;
}






}  // data_decoder::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif