// services/audio/public/mojom/system_info.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_AUDIO_PUBLIC_MOJOM_SYSTEM_INFO_MOJOM_TEST_UTILS_H_
#define SERVICES_AUDIO_PUBLIC_MOJOM_SYSTEM_INFO_MOJOM_TEST_UTILS_H_

#include "services/audio/public/mojom/system_info.mojom.h"


namespace audio::mojom {


class  SystemInfoInterceptorForTesting : public SystemInfo {
  virtual SystemInfo* GetForwardingInterface() = 0;
  void GetInputStreamParameters(const std::string& device_id, GetInputStreamParametersCallback callback) override;
  void GetOutputStreamParameters(const std::string& device_id, GetOutputStreamParametersCallback callback) override;
  void HasInputDevices(HasInputDevicesCallback callback) override;
  void HasOutputDevices(HasOutputDevicesCallback callback) override;
  void GetInputDeviceDescriptions(GetInputDeviceDescriptionsCallback callback) override;
  void GetOutputDeviceDescriptions(GetOutputDeviceDescriptionsCallback callback) override;
  void GetAssociatedOutputDeviceID(const std::string& input_device_id, GetAssociatedOutputDeviceIDCallback callback) override;
  void GetInputDeviceInfo(const std::string& input_device_id, GetInputDeviceInfoCallback callback) override;
};
class  SystemInfoAsyncWaiter {
 public:
  explicit SystemInfoAsyncWaiter(SystemInfo* proxy);

  SystemInfoAsyncWaiter(const SystemInfoAsyncWaiter&) = delete;
  SystemInfoAsyncWaiter& operator=(const SystemInfoAsyncWaiter&) = delete;

  ~SystemInfoAsyncWaiter();
  void GetInputStreamParameters(
      const std::string& device_id, std::optional<::media::AudioParameters>* out_params);
  std::optional<::media::AudioParameters> GetInputStreamParameters(const std::string& device_id);
  void GetOutputStreamParameters(
      const std::string& device_id, std::optional<::media::AudioParameters>* out_params);
  std::optional<::media::AudioParameters> GetOutputStreamParameters(const std::string& device_id);
  void HasInputDevices(
      bool* out_has_input_devices);
  bool HasInputDevices();
  void HasOutputDevices(
      bool* out_has_output_devices);
  bool HasOutputDevices();
  void GetInputDeviceDescriptions(
      std::vector<::media::AudioDeviceDescription>* out_device_descriptions);
  std::vector<::media::AudioDeviceDescription> GetInputDeviceDescriptions();
  void GetOutputDeviceDescriptions(
      std::vector<::media::AudioDeviceDescription>* out_device_descriptions);
  std::vector<::media::AudioDeviceDescription> GetOutputDeviceDescriptions();
  void GetAssociatedOutputDeviceID(
      const std::string& input_device_id, std::optional<std::string>* out_associated_output_device_id);
  std::optional<std::string> GetAssociatedOutputDeviceID(const std::string& input_device_id);
  void GetInputDeviceInfo(
      const std::string& input_device_id, std::optional<::media::AudioParameters>* out_input_params, std::optional<std::string>* out_associated_output_device_id);
  

 private:
  SystemInfo* const proxy_;
};




}  // audio::mojom

#endif  // SERVICES_AUDIO_PUBLIC_MOJOM_SYSTEM_INFO_MOJOM_TEST_UTILS_H_