// printing/mojom/print.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef PRINTING_MOJOM_PRINT_MOJOM_BLINK_H_
#define PRINTING_MOJOM_PRINT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "printing/mojom/print.mojom-features.h"  // IWYU pragma: export
#include "printing/mojom/print.mojom-shared.h"  // IWYU pragma: export
#include "printing/mojom/print.mojom-blink-forward.h"  // IWYU pragma: export

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace printing::mojom::blink {






class  PageRange {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageRange, T>::value>;
  using DataView = PageRangeDataView;
  using Data_ = internal::PageRange_Data;

  template <typename... Args>
  static PageRangePtr New(Args&&... args) {
    return PageRangePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageRangePtr From(const U& u) {
    return mojo::TypeConverter<PageRangePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageRange>::Convert(*this);
  }


  PageRange();

  PageRange(
      uint32_t from,
      uint32_t to);


  ~PageRange();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageRangePtr>
  PageRangePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageRange::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PageRange::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PageRange::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageRange::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageRange::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageRange::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageRange_UnserializedMessageContext<
            UserType, PageRange::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PageRange::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PageRange::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageRange_UnserializedMessageContext<
            UserType, PageRange::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageRange::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint32_t from;
  
  uint32_t to;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageRange::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageRange::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageRange::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageRange::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  PageSizeMargins {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PageSizeMargins, T>::value>;
  using DataView = PageSizeMarginsDataView;
  using Data_ = internal::PageSizeMargins_Data;

  template <typename... Args>
  static PageSizeMarginsPtr New(Args&&... args) {
    return PageSizeMarginsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PageSizeMarginsPtr From(const U& u) {
    return mojo::TypeConverter<PageSizeMarginsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PageSizeMargins>::Convert(*this);
  }


  PageSizeMargins();

  PageSizeMargins(
      double content_width,
      double content_height,
      double margin_top,
      double margin_right,
      double margin_bottom,
      double margin_left);


  ~PageSizeMargins();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PageSizeMarginsPtr>
  PageSizeMarginsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PageSizeMargins::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PageSizeMargins::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PageSizeMargins::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageSizeMargins::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PageSizeMargins::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PageSizeMargins::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PageSizeMargins_UnserializedMessageContext<
            UserType, PageSizeMargins::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PageSizeMargins::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PageSizeMargins::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PageSizeMargins_UnserializedMessageContext<
            UserType, PageSizeMargins::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PageSizeMargins::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double content_width;
  
  double content_height;
  
  double margin_top;
  
  double margin_right;
  
  double margin_bottom;
  
  double margin_left;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PageSizeMargins::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PageSizeMargins::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PageSizeMargins::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PageSizeMargins::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
PageSizeMarginsPtr PageSizeMargins::Clone() const {
  return New(
      mojo::Clone(content_width),
      mojo::Clone(content_height),
      mojo::Clone(margin_top),
      mojo::Clone(margin_right),
      mojo::Clone(margin_bottom),
      mojo::Clone(margin_left)
  );
}

template <typename T, PageSizeMargins::EnableIfSame<T>*>
bool PageSizeMargins::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->content_width, other_struct.content_width))
    return false;
  if (!mojo::Equals(this->content_height, other_struct.content_height))
    return false;
  if (!mojo::Equals(this->margin_top, other_struct.margin_top))
    return false;
  if (!mojo::Equals(this->margin_right, other_struct.margin_right))
    return false;
  if (!mojo::Equals(this->margin_bottom, other_struct.margin_bottom))
    return false;
  if (!mojo::Equals(this->margin_left, other_struct.margin_left))
    return false;
  return true;
}

template <typename T, PageSizeMargins::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.content_width < rhs.content_width)
    return true;
  if (rhs.content_width < lhs.content_width)
    return false;
  if (lhs.content_height < rhs.content_height)
    return true;
  if (rhs.content_height < lhs.content_height)
    return false;
  if (lhs.margin_top < rhs.margin_top)
    return true;
  if (rhs.margin_top < lhs.margin_top)
    return false;
  if (lhs.margin_right < rhs.margin_right)
    return true;
  if (rhs.margin_right < lhs.margin_right)
    return false;
  if (lhs.margin_bottom < rhs.margin_bottom)
    return true;
  if (rhs.margin_bottom < lhs.margin_bottom)
    return false;
  if (lhs.margin_left < rhs.margin_left)
    return true;
  if (rhs.margin_left < lhs.margin_left)
    return false;
  return false;
}
template <typename StructPtrType>
PageRangePtr PageRange::Clone() const {
  return New(
      mojo::Clone(from),
      mojo::Clone(to)
  );
}

template <typename T, PageRange::EnableIfSame<T>*>
bool PageRange::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->from, other_struct.from))
    return false;
  if (!mojo::Equals(this->to, other_struct.to))
    return false;
  return true;
}

template <typename T, PageRange::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.from < rhs.from)
    return true;
  if (rhs.from < lhs.from)
    return false;
  if (lhs.to < rhs.to)
    return true;
  if (rhs.to < lhs.to)
    return false;
  return false;
}


}  // printing::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::printing::mojom::blink::PageSizeMargins::DataView,
                                         ::printing::mojom::blink::PageSizeMarginsPtr> {
  static bool IsNull(const ::printing::mojom::blink::PageSizeMarginsPtr& input) { return !input; }
  static void SetToNull(::printing::mojom::blink::PageSizeMarginsPtr* output) { output->reset(); }

  static decltype(::printing::mojom::blink::PageSizeMargins::content_width) content_width(
      const ::printing::mojom::blink::PageSizeMarginsPtr& input) {
    return input->content_width;
  }

  static decltype(::printing::mojom::blink::PageSizeMargins::content_height) content_height(
      const ::printing::mojom::blink::PageSizeMarginsPtr& input) {
    return input->content_height;
  }

  static decltype(::printing::mojom::blink::PageSizeMargins::margin_top) margin_top(
      const ::printing::mojom::blink::PageSizeMarginsPtr& input) {
    return input->margin_top;
  }

  static decltype(::printing::mojom::blink::PageSizeMargins::margin_right) margin_right(
      const ::printing::mojom::blink::PageSizeMarginsPtr& input) {
    return input->margin_right;
  }

  static decltype(::printing::mojom::blink::PageSizeMargins::margin_bottom) margin_bottom(
      const ::printing::mojom::blink::PageSizeMarginsPtr& input) {
    return input->margin_bottom;
  }

  static decltype(::printing::mojom::blink::PageSizeMargins::margin_left) margin_left(
      const ::printing::mojom::blink::PageSizeMarginsPtr& input) {
    return input->margin_left;
  }

  static bool Read(::printing::mojom::blink::PageSizeMargins::DataView input, ::printing::mojom::blink::PageSizeMarginsPtr* output);
};


template <>
struct  StructTraits<::printing::mojom::blink::PageRange::DataView,
                                         ::printing::mojom::blink::PageRangePtr> {
  static bool IsNull(const ::printing::mojom::blink::PageRangePtr& input) { return !input; }
  static void SetToNull(::printing::mojom::blink::PageRangePtr* output) { output->reset(); }

  static decltype(::printing::mojom::blink::PageRange::from) from(
      const ::printing::mojom::blink::PageRangePtr& input) {
    return input->from;
  }

  static decltype(::printing::mojom::blink::PageRange::to) to(
      const ::printing::mojom::blink::PageRangePtr& input) {
    return input->to;
  }

  static bool Read(::printing::mojom::blink::PageRange::DataView input, ::printing::mojom::blink::PageRangePtr* output);
};

}  // namespace mojo

#endif  // PRINTING_MOJOM_PRINT_MOJOM_BLINK_H_