// owl/mojom/web_view_session_data.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_VIEW_SESSION_DATA_MOJOM_H_
#define OWL_MOJOM_WEB_VIEW_SESSION_DATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/web_view_session_data.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/web_view_session_data.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/web_view_session_data.mojom-forward.h"  // IWYU pragma: export
#include "owl/mojom/web_view.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class WebViewSessionDataDecoderProxy;

template <typename ImplRefTraits>
class WebViewSessionDataDecoderStub;

class WebViewSessionDataDecoderRequestValidator;
class WebViewSessionDataDecoderResponseValidator;


class WebViewSessionDataDecoder
    : public WebViewSessionDataDecoderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WebViewSessionDataDecoder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebViewSessionDataDecoderInterfaceBase;
  using Proxy_ = WebViewSessionDataDecoderProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebViewSessionDataDecoderStub<ImplRefTraits>;

  using RequestValidator_ = WebViewSessionDataDecoderRequestValidator;
  using ResponseValidator_ = WebViewSessionDataDecoderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDecodeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Decode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebViewSessionDataDecoder() = default;

  using DecodeCallback = base::OnceCallback<void(std::vector<::owl::mojom::NavigationEntryPtr>, int32_t)>;
  using DecodeMojoCallback = base::OnceCallback<void(std::vector<::owl::mojom::NavigationEntryPtr>, int32_t)>;

  virtual void Decode(const std::vector<uint8_t>& session_data, DecodeCallback callback) = 0;
};



class  WebViewSessionDataDecoderProxy
    : public WebViewSessionDataDecoder {
 public:
  using InterfaceType = WebViewSessionDataDecoder;

  explicit WebViewSessionDataDecoderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Decode(const std::vector<uint8_t>& session_data, DecodeCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebViewSessionDataDecoderStubDispatch {
 public:
  static bool Accept(WebViewSessionDataDecoder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebViewSessionDataDecoder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebViewSessionDataDecoder>>
class WebViewSessionDataDecoderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebViewSessionDataDecoderStub() = default;
  ~WebViewSessionDataDecoderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebViewSessionDataDecoderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebViewSessionDataDecoderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebViewSessionDataDecoderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebViewSessionDataDecoderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  WebViewSessionData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<WebViewSessionData, T>::value>;
  using DataView = WebViewSessionDataDataView;
  using Data_ = internal::WebViewSessionData_Data;

  template <typename... Args>
  static WebViewSessionDataPtr New(Args&&... args) {
    return WebViewSessionDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static WebViewSessionDataPtr From(const U& u) {
    return mojo::TypeConverter<WebViewSessionDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, WebViewSessionData>::Convert(*this);
  }


  WebViewSessionData();

  WebViewSessionData(
      std::vector<std::vector<uint8_t>> navigations,
      int32_t selected_navigation);


  ~WebViewSessionData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = WebViewSessionDataPtr>
  WebViewSessionDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, WebViewSessionData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, WebViewSessionData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, WebViewSessionData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebViewSessionData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        WebViewSessionData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        WebViewSessionData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::WebViewSessionData_UnserializedMessageContext<
            UserType, WebViewSessionData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<WebViewSessionData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return WebViewSessionData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::WebViewSessionData_UnserializedMessageContext<
            UserType, WebViewSessionData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<WebViewSessionData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::vector<uint8_t>> navigations;
  
  int32_t selected_navigation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, WebViewSessionData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, WebViewSessionData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, WebViewSessionData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, WebViewSessionData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
WebViewSessionDataPtr WebViewSessionData::Clone() const {
  return New(
      mojo::Clone(navigations),
      mojo::Clone(selected_navigation)
  );
}

template <typename T, WebViewSessionData::EnableIfSame<T>*>
bool WebViewSessionData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->navigations, other_struct.navigations))
    return false;
  if (!mojo::Equals(this->selected_navigation, other_struct.selected_navigation))
    return false;
  return true;
}

template <typename T, WebViewSessionData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.navigations < rhs.navigations)
    return true;
  if (rhs.navigations < lhs.navigations)
    return false;
  if (lhs.selected_navigation < rhs.selected_navigation)
    return true;
  if (rhs.selected_navigation < lhs.selected_navigation)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::WebViewSessionData::DataView,
                                         ::owl::mojom::WebViewSessionDataPtr> {
  static bool IsNull(const ::owl::mojom::WebViewSessionDataPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::WebViewSessionDataPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::WebViewSessionData::navigations)& navigations(
      const ::owl::mojom::WebViewSessionDataPtr& input) {
    return input->navigations;
  }

  static decltype(::owl::mojom::WebViewSessionData::selected_navigation) selected_navigation(
      const ::owl::mojom::WebViewSessionDataPtr& input) {
    return input->selected_navigation;
  }

  static bool Read(::owl::mojom::WebViewSessionData::DataView input, ::owl::mojom::WebViewSessionDataPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_WEB_VIEW_SESSION_DATA_MOJOM_H_