// owl/mojom/web_view_group.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_VIEW_GROUP_MOJOM_H_
#define OWL_MOJOM_WEB_VIEW_GROUP_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/web_view_group.mojom-features.h"  // IWYU pragma: export
#include "owl/mojom/web_view_group.mojom-shared.h"  // IWYU pragma: export
#include "owl/mojom/web_view_group.mojom-forward.h"  // IWYU pragma: export
#include "owl/mojom/web_view.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace owl::mojom {

class WebViewGroupProxy;

template <typename ImplRefTraits>
class WebViewGroupStub;

class WebViewGroupRequestValidator;
class WebViewGroupResponseValidator;


class WebViewGroup
    : public WebViewGroupInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WebViewGroup";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebViewGroupInterfaceBase;
  using Proxy_ = WebViewGroupProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebViewGroupStub<ImplRefTraits>;

  using RequestValidator_ = WebViewGroupRequestValidator;
  using ResponseValidator_ = WebViewGroupResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateWebViewMinVersion = 0,
    kTabStripDidBecomeActiveMinVersion = 0,
    kEnableNavigationValidationMinVersion = 0,
    kEnableAgentModeRestrictionsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateWebView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct TabStripDidBecomeActive_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableNavigationValidation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableAgentModeRestrictions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebViewGroup() = default;

  using CreateWebViewCallback = base::OnceCallback<void(CreateWebViewResultPtr)>;
  using CreateWebViewMojoCallback = base::OnceCallback<void(CreateWebViewResultPtr)>;

  virtual void CreateWebView(CreateWebViewParamsPtr params, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebView> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewClient> client, CreateWebViewCallback callback) = 0;

  virtual void TabStripDidBecomeActive() = 0;

  virtual void EnableNavigationValidation(bool enabled) = 0;

  virtual void EnableAgentModeRestrictions() = 0;
};

class WebViewGroupClientProxy;

template <typename ImplRefTraits>
class WebViewGroupClientStub;

class WebViewGroupClientRequestValidator;
class WebViewGroupClientResponseValidator;


class WebViewGroupClient
    : public WebViewGroupClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "owl.mojom.WebViewGroupClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebViewGroupClientInterfaceBase;
  using Proxy_ = WebViewGroupClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebViewGroupClientStub<ImplRefTraits>;

  using RequestValidator_ = WebViewGroupClientRequestValidator;
  using ResponseValidator_ = WebViewGroupClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOpenChromeURLMinVersion = 0,
    kCreatedNewWebViewMinVersion = 0,
    kValidateNavigationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OpenChromeURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreatedNewWebView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ValidateNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebViewGroupClient() = default;

  virtual void OpenChromeURL(const ::GURL& url) = 0;

  virtual void CreatedNewWebView(uint64_t web_content_id, GroupScopedWebViewSource source, ::mojo::PendingAssociatedRemote<::owl::mojom::WebView> web_view, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewClient> web_view_client) = 0;

  using ValidateNavigationCallback = base::OnceCallback<void(NavigationValidationResult)>;
  using ValidateNavigationMojoCallback = base::OnceCallback<void(NavigationValidationResult)>;

  virtual void ValidateNavigation(const ::GURL& url, ValidateNavigationCallback callback) = 0;
};



class  WebViewGroupProxy
    : public WebViewGroup {
 public:
  using InterfaceType = WebViewGroup;

  explicit WebViewGroupProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateWebView(CreateWebViewParamsPtr params, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebView> receiver, ::mojo::PendingAssociatedRemote<::owl::mojom::WebViewClient> client, CreateWebViewCallback callback) final;
  
  void TabStripDidBecomeActive() final;
  
  void EnableNavigationValidation(bool enabled) final;
  
  void EnableAgentModeRestrictions() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  WebViewGroupClientProxy
    : public WebViewGroupClient {
 public:
  using InterfaceType = WebViewGroupClient;

  explicit WebViewGroupClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OpenChromeURL(const ::GURL& url) final;
  
  void CreatedNewWebView(uint64_t web_content_id, GroupScopedWebViewSource source, ::mojo::PendingAssociatedRemote<::owl::mojom::WebView> web_view, ::mojo::PendingAssociatedReceiver<::owl::mojom::WebViewClient> web_view_client) final;
  
  void ValidateNavigation(const ::GURL& url, ValidateNavigationCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  WebViewGroupStubDispatch {
 public:
  static bool Accept(WebViewGroup* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebViewGroup* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebViewGroup>>
class WebViewGroupStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebViewGroupStub() = default;
  ~WebViewGroupStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebViewGroupStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebViewGroupStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebViewGroupClientStubDispatch {
 public:
  static bool Accept(WebViewGroupClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebViewGroupClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebViewGroupClient>>
class WebViewGroupClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebViewGroupClientStub() = default;
  ~WebViewGroupClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebViewGroupClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebViewGroupClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  WebViewGroupRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebViewGroupClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebViewGroupResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  WebViewGroupClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  CreatedWebViewDetails {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreatedWebViewDetails, T>::value>;
  using DataView = CreatedWebViewDetailsDataView;
  using Data_ = internal::CreatedWebViewDetails_Data;

  template <typename... Args>
  static CreatedWebViewDetailsPtr New(Args&&... args) {
    return CreatedWebViewDetailsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreatedWebViewDetailsPtr From(const U& u) {
    return mojo::TypeConverter<CreatedWebViewDetailsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreatedWebViewDetails>::Convert(*this);
  }


  CreatedWebViewDetails();

  explicit CreatedWebViewDetails(
      uint64_t web_content_id);


  ~CreatedWebViewDetails();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreatedWebViewDetailsPtr>
  CreatedWebViewDetailsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreatedWebViewDetails::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreatedWebViewDetails::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreatedWebViewDetails::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreatedWebViewDetails::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreatedWebViewDetails::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreatedWebViewDetails::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreatedWebViewDetails_UnserializedMessageContext<
            UserType, CreatedWebViewDetails::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreatedWebViewDetails::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreatedWebViewDetails::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreatedWebViewDetails_UnserializedMessageContext<
            UserType, CreatedWebViewDetails::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreatedWebViewDetails::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  uint64_t web_content_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreatedWebViewDetails::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreatedWebViewDetails::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreatedWebViewDetails::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreatedWebViewDetails::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CreateWebViewInitializationData {
 public:
  using DataView = CreateWebViewInitializationDataDataView;
  using Data_ = internal::CreateWebViewInitializationData_Data;
  using Tag = Data_::CreateWebViewInitializationData_Tag;

  template <typename... Args>
  static CreateWebViewInitializationDataPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |initial_data|.
  static CreateWebViewInitializationDataPtr NewInitialData(
      CreateWebViewInitializationData_InitialDataPtr value);
  // Construct an instance holding |restore_data|.
  static CreateWebViewInitializationDataPtr NewRestoreData(
      CreateWebViewInitializationData_RestoreDataPtr value);

  template <typename U>
  static CreateWebViewInitializationDataPtr From(const U& u) {
    return mojo::TypeConverter<CreateWebViewInitializationDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateWebViewInitializationData>::Convert(*this);
  }
  ~CreateWebViewInitializationData();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CreateWebViewInitializationData(const CreateWebViewInitializationData& other) = delete;
  CreateWebViewInitializationData& operator=(const CreateWebViewInitializationData& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CreateWebViewInitializationDataPtr>
  CreateWebViewInitializationDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreateWebViewInitializationData>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreateWebViewInitializationData>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_initial_data() const { return tag_ == Tag::kInitialData; }
  const CreateWebViewInitializationData_InitialDataPtr& get_initial_data() const {
    CHECK(tag_ == Tag::kInitialData);
    return data_.initial_data;
  }
  CreateWebViewInitializationData_InitialDataPtr& get_initial_data() {
    CHECK(tag_ == Tag::kInitialData);
    return data_.initial_data;
  }
  void set_initial_data(CreateWebViewInitializationData_InitialDataPtr initial_data);

  bool is_restore_data() const { return tag_ == Tag::kRestoreData; }
  const CreateWebViewInitializationData_RestoreDataPtr& get_restore_data() const {
    CHECK(tag_ == Tag::kRestoreData);
    return data_.restore_data;
  }
  CreateWebViewInitializationData_RestoreDataPtr& get_restore_data() {
    CHECK(tag_ == Tag::kRestoreData);
    return data_.restore_data;
  }
  void set_restore_data(CreateWebViewInitializationData_RestoreDataPtr restore_data);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateWebViewInitializationData::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CreateWebViewInitializationData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kInitialData)>,
        CreateWebViewInitializationData_InitialDataPtr value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRestoreData)>,
        CreateWebViewInitializationData_RestoreDataPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    CreateWebViewInitializationData_InitialDataPtr initial_data;
    CreateWebViewInitializationData_RestoreDataPtr restore_data;
  };

  CreateWebViewInitializationData(
      std::in_place_index_t<static_cast<size_t>(Tag::kInitialData)>,
      CreateWebViewInitializationData_InitialDataPtr value);
  CreateWebViewInitializationData(
      std::in_place_index_t<static_cast<size_t>(Tag::kRestoreData)>,
      CreateWebViewInitializationData_RestoreDataPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  CreateWebViewResult {
 public:
  using DataView = CreateWebViewResultDataView;
  using Data_ = internal::CreateWebViewResult_Data;
  using Tag = Data_::CreateWebViewResult_Tag;

  template <typename... Args>
  static CreateWebViewResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |failure|.
  static CreateWebViewResultPtr NewFailure(
      const std::string& value);
  // Construct an instance holding |success|.
  static CreateWebViewResultPtr NewSuccess(
      CreatedWebViewDetailsPtr value);

  template <typename U>
  static CreateWebViewResultPtr From(const U& u) {
    return mojo::TypeConverter<CreateWebViewResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateWebViewResult>::Convert(*this);
  }
  ~CreateWebViewResult();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  CreateWebViewResult(const CreateWebViewResult& other) = delete;
  CreateWebViewResult& operator=(const CreateWebViewResult& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CreateWebViewResultPtr>
  CreateWebViewResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreateWebViewResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, CreateWebViewResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_failure() const { return tag_ == Tag::kFailure; }
  const std::string& get_failure() const {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  std::string& get_failure() {
    CHECK(tag_ == Tag::kFailure);
    return data_.failure;
  }
  void set_failure(const std::string& failure);

  bool is_success() const { return tag_ == Tag::kSuccess; }
  const CreatedWebViewDetailsPtr& get_success() const {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  CreatedWebViewDetailsPtr& get_success() {
    CHECK(tag_ == Tag::kSuccess);
    return data_.success;
  }
  void set_success(CreatedWebViewDetailsPtr success);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateWebViewResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CreateWebViewResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
        CreatedWebViewDetailsPtr value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::string failure;
    CreatedWebViewDetailsPtr success;
  };

  CreateWebViewResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kFailure)>,
      const std::string& value);
  CreateWebViewResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
      CreatedWebViewDetailsPtr value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  CreateWebViewInitializationData_InitialData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateWebViewInitializationData_InitialData, T>::value>;
  using DataView = CreateWebViewInitializationData_InitialDataDataView;
  using Data_ = internal::CreateWebViewInitializationData_InitialData_Data;

  template <typename... Args>
  static CreateWebViewInitializationData_InitialDataPtr New(Args&&... args) {
    return CreateWebViewInitializationData_InitialDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateWebViewInitializationData_InitialDataPtr From(const U& u) {
    return mojo::TypeConverter<CreateWebViewInitializationData_InitialDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateWebViewInitializationData_InitialData>::Convert(*this);
  }


  CreateWebViewInitializationData_InitialData();

  CreateWebViewInitializationData_InitialData(
      const ::GURL& url,
      ::owl::mojom::NavigationType navigation_type,
      const std::string& additional_headers);


  ~CreateWebViewInitializationData_InitialData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateWebViewInitializationData_InitialDataPtr>
  CreateWebViewInitializationData_InitialDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateWebViewInitializationData_InitialData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateWebViewInitializationData_InitialData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateWebViewInitializationData_InitialData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateWebViewInitializationData_InitialData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateWebViewInitializationData_InitialData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateWebViewInitializationData_InitialData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateWebViewInitializationData_InitialData_UnserializedMessageContext<
            UserType, CreateWebViewInitializationData_InitialData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateWebViewInitializationData_InitialData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateWebViewInitializationData_InitialData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateWebViewInitializationData_InitialData_UnserializedMessageContext<
            UserType, CreateWebViewInitializationData_InitialData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateWebViewInitializationData_InitialData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL url;
  
  ::owl::mojom::NavigationType navigation_type;
  
  std::string additional_headers;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateWebViewInitializationData_InitialData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateWebViewInitializationData_InitialData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateWebViewInitializationData_InitialData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateWebViewInitializationData_InitialData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CreateWebViewInitializationData_RestoreData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateWebViewInitializationData_RestoreData, T>::value>;
  using DataView = CreateWebViewInitializationData_RestoreDataDataView;
  using Data_ = internal::CreateWebViewInitializationData_RestoreData_Data;

  template <typename... Args>
  static CreateWebViewInitializationData_RestoreDataPtr New(Args&&... args) {
    return CreateWebViewInitializationData_RestoreDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateWebViewInitializationData_RestoreDataPtr From(const U& u) {
    return mojo::TypeConverter<CreateWebViewInitializationData_RestoreDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateWebViewInitializationData_RestoreData>::Convert(*this);
  }


  CreateWebViewInitializationData_RestoreData();

  CreateWebViewInitializationData_RestoreData(
      std::vector<uint8_t> session_data,
      std::optional<int32_t> navigation_index_override);


  ~CreateWebViewInitializationData_RestoreData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateWebViewInitializationData_RestoreDataPtr>
  CreateWebViewInitializationData_RestoreDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateWebViewInitializationData_RestoreData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateWebViewInitializationData_RestoreData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateWebViewInitializationData_RestoreData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateWebViewInitializationData_RestoreData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateWebViewInitializationData_RestoreData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateWebViewInitializationData_RestoreData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateWebViewInitializationData_RestoreData_UnserializedMessageContext<
            UserType, CreateWebViewInitializationData_RestoreData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateWebViewInitializationData_RestoreData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateWebViewInitializationData_RestoreData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateWebViewInitializationData_RestoreData_UnserializedMessageContext<
            UserType, CreateWebViewInitializationData_RestoreData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateWebViewInitializationData_RestoreData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<uint8_t> session_data;
  
  std::optional<int32_t> navigation_index_override;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateWebViewInitializationData_RestoreData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateWebViewInitializationData_RestoreData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateWebViewInitializationData_RestoreData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateWebViewInitializationData_RestoreData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CreateWebViewParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CreateWebViewParams, T>::value>;
  using DataView = CreateWebViewParamsDataView;
  using Data_ = internal::CreateWebViewParams_Data;

  template <typename... Args>
  static CreateWebViewParamsPtr New(Args&&... args) {
    return CreateWebViewParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CreateWebViewParamsPtr From(const U& u) {
    return mojo::TypeConverter<CreateWebViewParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CreateWebViewParams>::Convert(*this);
  }


  CreateWebViewParams();

  CreateWebViewParams(
      bool foreground,
      CreateWebViewInitializationDataPtr initialization_data,
      ::owl::mojom::StoragePartitionDescriptorPtr initial_storage_partition);

CreateWebViewParams(const CreateWebViewParams&) = delete;
CreateWebViewParams& operator=(const CreateWebViewParams&) = delete;

  ~CreateWebViewParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CreateWebViewParamsPtr>
  CreateWebViewParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CreateWebViewParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CreateWebViewParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CreateWebViewParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateWebViewParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CreateWebViewParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CreateWebViewParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CreateWebViewParams_UnserializedMessageContext<
            UserType, CreateWebViewParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CreateWebViewParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CreateWebViewParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CreateWebViewParams_UnserializedMessageContext<
            UserType, CreateWebViewParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CreateWebViewParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool foreground;
  
  CreateWebViewInitializationDataPtr initialization_data;
  
  ::owl::mojom::StoragePartitionDescriptorPtr initial_storage_partition;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CreateWebViewParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CreateWebViewParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CreateWebViewParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CreateWebViewParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename UnionPtrType>
CreateWebViewInitializationDataPtr CreateWebViewInitializationData::Clone() const {
  switch (tag_) {
    case Tag::kInitialData:
      return NewInitialData(
          mojo::Clone(data_.initial_data));
    case Tag::kRestoreData:
      return NewRestoreData(
          mojo::Clone(data_.restore_data));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CreateWebViewInitializationData>::value>::type*>
bool CreateWebViewInitializationData::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kInitialData:
      return mojo::Equals(data_.initial_data, other.data_.initial_data);
    case Tag::kRestoreData:
      return mojo::Equals(data_.restore_data, other.data_.restore_data);
  }

  return false;
}
template <typename UnionPtrType>
CreateWebViewResultPtr CreateWebViewResult::Clone() const {
  switch (tag_) {
    case Tag::kFailure:
      return NewFailure(
          mojo::Clone(data_.failure));
    case Tag::kSuccess:
      return NewSuccess(
          mojo::Clone(data_.success));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CreateWebViewResult>::value>::type*>
bool CreateWebViewResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kFailure:
      return mojo::Equals(data_.failure, other.data_.failure);
    case Tag::kSuccess:
      return mojo::Equals(data_.success, other.data_.success);
  }

  return false;
}
template <typename StructPtrType>
CreateWebViewInitializationData_InitialDataPtr CreateWebViewInitializationData_InitialData::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(navigation_type),
      mojo::Clone(additional_headers)
  );
}

template <typename T, CreateWebViewInitializationData_InitialData::EnableIfSame<T>*>
bool CreateWebViewInitializationData_InitialData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->navigation_type, other_struct.navigation_type))
    return false;
  if (!mojo::Equals(this->additional_headers, other_struct.additional_headers))
    return false;
  return true;
}

template <typename T, CreateWebViewInitializationData_InitialData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.navigation_type < rhs.navigation_type)
    return true;
  if (rhs.navigation_type < lhs.navigation_type)
    return false;
  if (lhs.additional_headers < rhs.additional_headers)
    return true;
  if (rhs.additional_headers < lhs.additional_headers)
    return false;
  return false;
}
template <typename StructPtrType>
CreateWebViewInitializationData_RestoreDataPtr CreateWebViewInitializationData_RestoreData::Clone() const {
  return New(
      mojo::Clone(session_data),
      mojo::Clone(navigation_index_override)
  );
}

template <typename T, CreateWebViewInitializationData_RestoreData::EnableIfSame<T>*>
bool CreateWebViewInitializationData_RestoreData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->session_data, other_struct.session_data))
    return false;
  if (!mojo::Equals(this->navigation_index_override, other_struct.navigation_index_override))
    return false;
  return true;
}

template <typename T, CreateWebViewInitializationData_RestoreData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.session_data < rhs.session_data)
    return true;
  if (rhs.session_data < lhs.session_data)
    return false;
  if (lhs.navigation_index_override < rhs.navigation_index_override)
    return true;
  if (rhs.navigation_index_override < lhs.navigation_index_override)
    return false;
  return false;
}
template <typename StructPtrType>
CreateWebViewParamsPtr CreateWebViewParams::Clone() const {
  return New(
      mojo::Clone(foreground),
      mojo::Clone(initialization_data),
      mojo::Clone(initial_storage_partition)
  );
}

template <typename T, CreateWebViewParams::EnableIfSame<T>*>
bool CreateWebViewParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->foreground, other_struct.foreground))
    return false;
  if (!mojo::Equals(this->initialization_data, other_struct.initialization_data))
    return false;
  if (!mojo::Equals(this->initial_storage_partition, other_struct.initial_storage_partition))
    return false;
  return true;
}

template <typename T, CreateWebViewParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.foreground < rhs.foreground)
    return true;
  if (rhs.foreground < lhs.foreground)
    return false;
  if (lhs.initialization_data < rhs.initialization_data)
    return true;
  if (rhs.initialization_data < lhs.initialization_data)
    return false;
  if (lhs.initial_storage_partition < rhs.initial_storage_partition)
    return true;
  if (rhs.initial_storage_partition < lhs.initial_storage_partition)
    return false;
  return false;
}
template <typename StructPtrType>
CreatedWebViewDetailsPtr CreatedWebViewDetails::Clone() const {
  return New(
      mojo::Clone(web_content_id)
  );
}

template <typename T, CreatedWebViewDetails::EnableIfSame<T>*>
bool CreatedWebViewDetails::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->web_content_id, other_struct.web_content_id))
    return false;
  return true;
}

template <typename T, CreatedWebViewDetails::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.web_content_id < rhs.web_content_id)
    return true;
  if (rhs.web_content_id < lhs.web_content_id)
    return false;
  return false;
}


}  // owl::mojom

namespace mojo {


template <>
struct  StructTraits<::owl::mojom::CreateWebViewInitializationData_InitialData::DataView,
                                         ::owl::mojom::CreateWebViewInitializationData_InitialDataPtr> {
  static bool IsNull(const ::owl::mojom::CreateWebViewInitializationData_InitialDataPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::CreateWebViewInitializationData_InitialDataPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::CreateWebViewInitializationData_InitialData::url)& url(
      const ::owl::mojom::CreateWebViewInitializationData_InitialDataPtr& input) {
    return input->url;
  }

  static decltype(::owl::mojom::CreateWebViewInitializationData_InitialData::navigation_type) navigation_type(
      const ::owl::mojom::CreateWebViewInitializationData_InitialDataPtr& input) {
    return input->navigation_type;
  }

  static const decltype(::owl::mojom::CreateWebViewInitializationData_InitialData::additional_headers)& additional_headers(
      const ::owl::mojom::CreateWebViewInitializationData_InitialDataPtr& input) {
    return input->additional_headers;
  }

  static bool Read(::owl::mojom::CreateWebViewInitializationData_InitialData::DataView input, ::owl::mojom::CreateWebViewInitializationData_InitialDataPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::CreateWebViewInitializationData_RestoreData::DataView,
                                         ::owl::mojom::CreateWebViewInitializationData_RestoreDataPtr> {
  static bool IsNull(const ::owl::mojom::CreateWebViewInitializationData_RestoreDataPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::CreateWebViewInitializationData_RestoreDataPtr* output) { output->reset(); }

  static const decltype(::owl::mojom::CreateWebViewInitializationData_RestoreData::session_data)& session_data(
      const ::owl::mojom::CreateWebViewInitializationData_RestoreDataPtr& input) {
    return input->session_data;
  }

  static decltype(::owl::mojom::CreateWebViewInitializationData_RestoreData::navigation_index_override) navigation_index_override(
      const ::owl::mojom::CreateWebViewInitializationData_RestoreDataPtr& input) {
    return input->navigation_index_override;
  }

  static bool Read(::owl::mojom::CreateWebViewInitializationData_RestoreData::DataView input, ::owl::mojom::CreateWebViewInitializationData_RestoreDataPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::CreateWebViewParams::DataView,
                                         ::owl::mojom::CreateWebViewParamsPtr> {
  static bool IsNull(const ::owl::mojom::CreateWebViewParamsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::CreateWebViewParamsPtr* output) { output->reset(); }

  static decltype(::owl::mojom::CreateWebViewParams::foreground) foreground(
      const ::owl::mojom::CreateWebViewParamsPtr& input) {
    return input->foreground;
  }

  static const decltype(::owl::mojom::CreateWebViewParams::initialization_data)& initialization_data(
      const ::owl::mojom::CreateWebViewParamsPtr& input) {
    return input->initialization_data;
  }

  static const decltype(::owl::mojom::CreateWebViewParams::initial_storage_partition)& initial_storage_partition(
      const ::owl::mojom::CreateWebViewParamsPtr& input) {
    return input->initial_storage_partition;
  }

  static bool Read(::owl::mojom::CreateWebViewParams::DataView input, ::owl::mojom::CreateWebViewParamsPtr* output);
};


template <>
struct  StructTraits<::owl::mojom::CreatedWebViewDetails::DataView,
                                         ::owl::mojom::CreatedWebViewDetailsPtr> {
  static bool IsNull(const ::owl::mojom::CreatedWebViewDetailsPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::CreatedWebViewDetailsPtr* output) { output->reset(); }

  static decltype(::owl::mojom::CreatedWebViewDetails::web_content_id) web_content_id(
      const ::owl::mojom::CreatedWebViewDetailsPtr& input) {
    return input->web_content_id;
  }

  static bool Read(::owl::mojom::CreatedWebViewDetails::DataView input, ::owl::mojom::CreatedWebViewDetailsPtr* output);
};


template <>
struct  UnionTraits<::owl::mojom::CreateWebViewInitializationData::DataView,
                                        ::owl::mojom::CreateWebViewInitializationDataPtr> {
  static bool IsNull(const ::owl::mojom::CreateWebViewInitializationDataPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::CreateWebViewInitializationDataPtr* output) { output->reset(); }

  static ::owl::mojom::CreateWebViewInitializationData::Tag GetTag(const ::owl::mojom::CreateWebViewInitializationDataPtr& input) {
    return input->which();
  }

  static const ::owl::mojom::CreateWebViewInitializationData_InitialDataPtr& initial_data(const ::owl::mojom::CreateWebViewInitializationDataPtr& input) {
    return input->get_initial_data();
  }

  static const ::owl::mojom::CreateWebViewInitializationData_RestoreDataPtr& restore_data(const ::owl::mojom::CreateWebViewInitializationDataPtr& input) {
    return input->get_restore_data();
  }

  static bool Read(::owl::mojom::CreateWebViewInitializationData::DataView input, ::owl::mojom::CreateWebViewInitializationDataPtr* output);
};


template <>
struct  UnionTraits<::owl::mojom::CreateWebViewResult::DataView,
                                        ::owl::mojom::CreateWebViewResultPtr> {
  static bool IsNull(const ::owl::mojom::CreateWebViewResultPtr& input) { return !input; }
  static void SetToNull(::owl::mojom::CreateWebViewResultPtr* output) { output->reset(); }

  static ::owl::mojom::CreateWebViewResult::Tag GetTag(const ::owl::mojom::CreateWebViewResultPtr& input) {
    return input->which();
  }

  static const std::string& failure(const ::owl::mojom::CreateWebViewResultPtr& input) {
    return input->get_failure();
  }

  static const ::owl::mojom::CreatedWebViewDetailsPtr& success(const ::owl::mojom::CreateWebViewResultPtr& input) {
    return input->get_success();
  }

  static bool Read(::owl::mojom::CreateWebViewResult::DataView input, ::owl::mojom::CreateWebViewResultPtr* output);
};

}  // namespace mojo

#endif  // OWL_MOJOM_WEB_VIEW_GROUP_MOJOM_H_