// owl/mojom/web_content_renderer.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_SHARED_H_
#define OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/web_content_renderer.mojom-shared-internal.h"
#include "mojo/public/mojom/base/process_id.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "owl/mojom/web_view_container_view.mojom-shared.h"
#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-shared.h"
#include "third_party/blink/public/mojom/webshare/share_error.mojom-shared.h"
#include "ui/base/cursor/mojom/cursor.mojom-shared.h"
#include "ui/base/ime/mojom/ime_types.mojom-shared.h"
#include "ui/display/mojom/screen_infos.mojom-shared.h"
#include "ui/events/mojom/event.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/ca_layer_params.mojom-shared.h"
#include "ui/gfx/range/mojom/range.mojom-shared.h"
#include "ui/base/mojom/attributed_string.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/web_content_renderer.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::OverscrollType>
    : public mojo::internal::EnumHashImpl<::owl::mojom::OverscrollType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::OverscrollType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::OverscrollType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::OverscrollType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::RectWithRangeDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::RectWithRangeDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::RectWithRange_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::rect(input)) in_rect = Traits::rect(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->rect)::BaseType> rect_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect,
      rect_fragment);

    fragment->rect.Set(
        rect_fragment.is_null() ? nullptr : rect_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->rect.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect in RectWithRange struct");

    decltype(Traits::range(input)) in_range = Traits::range(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->range)::BaseType> range_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RangeDataView>(
      in_range,
      range_fragment);

    fragment->range.Set(
        range_fragment.is_null() ? nullptr : range_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->range.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null range in RectWithRange struct");
  }

  static bool Deserialize(::owl::mojom::internal::RectWithRange_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::RectWithRangeDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::PopupMenuDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::PopupMenuDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::PopupMenu_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::items(input)) in_items = Traits::items(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->items)::BaseType>
        items_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::MenuItemDataView>>(
      in_items,
      items_fragment,
      &items_validate_params);

    fragment->items.Set(
        items_fragment.is_null() ? nullptr : items_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->items.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null items in PopupMenu struct");

    decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounds)::BaseType> bounds_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_bounds,
      bounds_fragment);

    fragment->bounds.Set(
        bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bounds.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in PopupMenu struct");

    fragment->item_font_size = Traits::item_font_size(input);

    fragment->right_aligned = Traits::right_aligned(input);

    fragment->selected_item = Traits::selected_item(input);

    decltype(Traits::receiver(input)) in_receiver = Traits::receiver(input);

    
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::owl::mojom::PopupMenuRunnerInterfaceBase>>(
      in_receiver,
      &fragment->receiver,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->receiver)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in PopupMenu struct");
  }

  static bool Deserialize(::owl::mojom::internal::PopupMenu_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::PopupMenuDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void RectWithRangeDataView::GetRectDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->rect.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void RectWithRangeDataView::GetRangeDataView(
    ::gfx::mojom::RangeDataView* output) {
  auto pointer = data_->range.Get();
  *output = ::gfx::mojom::RangeDataView(pointer, message_);
}


inline void PopupMenuDataView::GetItemsDataView(
    mojo::ArrayDataView<::blink::mojom::MenuItemDataView>* output) {
  auto pointer = data_->items.Get();
  *output = mojo::ArrayDataView<::blink::mojom::MenuItemDataView>(pointer, message_);
}
inline void PopupMenuDataView::GetBoundsDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->bounds.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}



}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::OverscrollType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::OverscrollType value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_WEB_CONTENT_RENDERER_MOJOM_SHARED_H_