// owl/mojom/session.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef OWL_MOJOM_SESSION_MOJOM_SHARED_H_
#define OWL_MOJOM_SESSION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "owl/mojom/session.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "owl/mojom/profile.mojom-shared.h"
#include "owl/mojom/web_view_session_data.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "owl/mojom/icloud_passkeys.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "owl/mojom/session.mojom-data-view.h"




namespace std {

template <>
struct hash<::owl::mojom::NetworkStatus>
    : public mojo::internal::EnumHashImpl<::owl::mojom::NetworkStatus> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::NetworkStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::owl::mojom::NetworkStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::owl::mojom::NetworkStatus>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::owl::mojom::InternalURLPatternDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::owl::mojom::InternalURLPatternDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::owl::mojom::internal::InternalURLPattern_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::prefix(input)) in_prefix = Traits::prefix(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->prefix)::BaseType> prefix_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_prefix,
      prefix_fragment);

    fragment->prefix.Set(
        prefix_fragment.is_null() ? nullptr : prefix_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->prefix.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null prefix in InternalURLPattern struct");

    decltype(Traits::query(input)) in_query = Traits::query(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->query)::BaseType> query_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_query,
      query_fragment);

    fragment->query.Set(
        query_fragment.is_null() ? nullptr : query_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->query.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null query in InternalURLPattern struct");
  }

  static bool Deserialize(::owl::mojom::internal::InternalURLPattern_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::owl::mojom::InternalURLPatternDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace owl::mojom {

inline void InternalURLPatternDataView::GetPrefixDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->prefix.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void InternalURLPatternDataView::GetQueryDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->query.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // owl::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::owl::mojom::NetworkStatus> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::owl::mojom::NetworkStatus value);
};

} // namespace perfetto

#endif  // OWL_MOJOM_SESSION_MOJOM_SHARED_H_