// owl/mojom/search_keyword.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/search_keyword.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/search_keyword.mojom-params-data.h"
#include "owl/mojom/search_keyword.mojom-shared-message-ids.h"

#include "owl/mojom/search_keyword.mojom-import-headers.h"
#include "owl/mojom/search_keyword.mojom-test-utils.h"


namespace owl::mojom {
SearchKeyword::SearchKeyword()
    : id(),
      name(),
      keyword(),
      url(),
      replacement_offset(),
      favicon_url(),
      type(),
      is_default(),
      suggestions_url(),
      suggestions_url_replacement_offset() {}

SearchKeyword::SearchKeyword(
    const std::string& id_in,
    const ::std::u16string& name_in,
    const ::std::u16string& keyword_in,
    const ::std::u16string& url_in,
    uint32_t replacement_offset_in,
    const ::GURL& favicon_url_in,
    SearchKeywordType type_in,
    bool is_default_in,
    const ::std::u16string& suggestions_url_in,
    uint32_t suggestions_url_replacement_offset_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      keyword(std::move(keyword_in)),
      url(std::move(url_in)),
      replacement_offset(std::move(replacement_offset_in)),
      favicon_url(std::move(favicon_url_in)),
      type(std::move(type_in)),
      is_default(std::move(is_default_in)),
      suggestions_url(std::move(suggestions_url_in)),
      suggestions_url_replacement_offset(std::move(suggestions_url_replacement_offset_in)) {}

SearchKeyword::~SearchKeyword() = default;

void SearchKeyword::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "keyword"), this->keyword,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "replacement_offset"), this->replacement_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicon_url"), this->favicon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SearchKeywordType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_default"), this->is_default,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestions_url"), this->suggestions_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "suggestions_url_replacement_offset"), this->suggestions_url_replacement_offset,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SearchKeyword::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SearchKeywordsClient::IPCStableHashFunction SearchKeywordsClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SearchKeywordsClient>(message.name())) {
    case messages::SearchKeywordsClient::kOnSearchKeywordsChanged: {
      return &SearchKeywordsClient::OnSearchKeywordsChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SearchKeywordsClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SearchKeywordsClient>(message.name())) {
      case messages::SearchKeywordsClient::kOnSearchKeywordsChanged:
            return "Receive owl::mojom::SearchKeywordsClient::OnSearchKeywordsChanged";
    }
  } else {
    switch (static_cast<messages::SearchKeywordsClient>(message.name())) {
      case messages::SearchKeywordsClient::kOnSearchKeywordsChanged:
            return "Receive reply owl::mojom::SearchKeywordsClient::OnSearchKeywordsChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SearchKeywordsClient::OnSearchKeywordsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x659207b5;  // IPCStableHash for owl::mojom::SearchKeywordsClient::OnSearchKeywordsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SearchKeywordsClientProxy::SearchKeywordsClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SearchKeywordsClientProxy::OnSearchKeywordsChanged(
    std::vector<SearchKeywordPtr> in_search_keywords) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::SearchKeywordsClient::OnSearchKeywordsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("search_keywords"), in_search_keywords,
                        "<value of type std::vector<SearchKeywordPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SearchKeywordsClient::kOnSearchKeywordsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SearchKeywordsClient_OnSearchKeywordsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->search_keywords)::BaseType>
      search_keywords_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& search_keywords_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::owl::mojom::SearchKeywordDataView>>(
    in_search_keywords,
    search_keywords_fragment,
    &search_keywords_validate_params);

  params->search_keywords.Set(
      search_keywords_fragment.is_null() ? nullptr : search_keywords_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->search_keywords.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null search_keywords in SearchKeywordsClient.OnSearchKeywordsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SearchKeywordsClient::Name_);
  message.set_method_name("OnSearchKeywordsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SearchKeywordsClientStubDispatch::Accept(
    SearchKeywordsClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SearchKeywordsClient>(message->header()->name)) {
    case messages::SearchKeywordsClient::kOnSearchKeywordsChanged: {
      DCHECK(message->is_serialized());
      internal::SearchKeywordsClient_OnSearchKeywordsChanged_Params_Data* params =
          reinterpret_cast<internal::SearchKeywordsClient_OnSearchKeywordsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SearchKeywordsClient.0
      bool success = true;
      std::vector<SearchKeywordPtr> p_search_keywords{};
      SearchKeywordsClient_OnSearchKeywordsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSearchKeywords(&p_search_keywords))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SearchKeywordsClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSearchKeywordsChanged(        
        std::move(p_search_keywords));
      return true;
    }
  }
  return false;
}

// static
bool SearchKeywordsClientStubDispatch::AcceptWithResponder(
    SearchKeywordsClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SearchKeywordsClient>(message->header()->name)) {
    case messages::SearchKeywordsClient::kOnSearchKeywordsChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSearchKeywordsClientValidationInfo[] = {
    { &internal::SearchKeywordsClient_OnSearchKeywordsChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool SearchKeywordsClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::SearchKeywordsClient::Name_,
    kSearchKeywordsClientValidationInfo);
}



}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::SearchKeyword::DataView, ::owl::mojom::SearchKeywordPtr>::Read(
    ::owl::mojom::SearchKeyword::DataView input,
    ::owl::mojom::SearchKeywordPtr* output) {
  bool success = true;
  ::owl::mojom::SearchKeywordPtr result(::owl::mojom::SearchKeyword::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadKeyword(&result->keyword))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->replacement_offset = input.replacement_offset();
      if (success && !input.ReadFaviconUrl(&result->favicon_url))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->is_default = input.is_default();
      if (success && !input.ReadSuggestionsUrl(&result->suggestions_url))
        success = false;
      if (success)
        result->suggestions_url_replacement_offset = input.suggestions_url_replacement_offset();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void SearchKeywordsClientInterceptorForTesting::OnSearchKeywordsChanged(std::vector<SearchKeywordPtr> search_keywords) {
  GetForwardingInterface()->OnSearchKeywordsChanged(
    std::move(search_keywords)
    );
}
SearchKeywordsClientAsyncWaiter::SearchKeywordsClientAsyncWaiter(
    SearchKeywordsClient* proxy) : proxy_(proxy) {}

SearchKeywordsClientAsyncWaiter::~SearchKeywordsClientAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif