// owl/mojom/password_prompt.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "owl/mojom/password_prompt.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "owl/mojom/password_prompt.mojom-params-data.h"
#include "owl/mojom/password_prompt.mojom-shared-message-ids.h"

#include "owl/mojom/password_prompt.mojom-import-headers.h"
#include "owl/mojom/password_prompt.mojom-test-utils.h"


namespace owl::mojom {
FederatedCredentials::FederatedCredentials()
    : upper_text(),
      lower_text() {}

FederatedCredentials::FederatedCredentials(
    const ::std::u16string& upper_text_in,
    const ::std::u16string& lower_text_in)
    : upper_text(std::move(upper_text_in)),
      lower_text(std::move(lower_text_in)) {}

FederatedCredentials::~FederatedCredentials() = default;

void FederatedCredentials::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "upper_text"), this->upper_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "lower_text"), this->lower_text,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool FederatedCredentials::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UsernamePasswordCredentials::UsernamePasswordCredentials()
    : username(),
      password(),
      all_usernames(),
      all_passwords() {}

UsernamePasswordCredentials::UsernamePasswordCredentials(
    const ::std::u16string& username_in,
    const ::std::u16string& password_in,
    std::vector<::std::u16string> all_usernames_in,
    std::vector<::std::u16string> all_passwords_in)
    : username(std::move(username_in)),
      password(std::move(password_in)),
      all_usernames(std::move(all_usernames_in)),
      all_passwords(std::move(all_passwords_in)) {}

UsernamePasswordCredentials::~UsernamePasswordCredentials() = default;

void UsernamePasswordCredentials::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "username"), this->username,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "password"), this->password,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_usernames"), this->all_usernames,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_passwords"), this->all_passwords,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UsernamePasswordCredentials::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SavePasswordPromptDetails::SavePasswordPromptDetails()
    : type(),
      credentials() {}

SavePasswordPromptDetails::SavePasswordPromptDetails(
    SavePasswordPromptType type_in,
    PasswordPromptCredentialsPtr credentials_in)
    : type(std::move(type_in)),
      credentials(std::move(credentials_in)) {}

SavePasswordPromptDetails::~SavePasswordPromptDetails() = default;

void SavePasswordPromptDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SavePasswordPromptType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credentials"), this->credentials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PasswordPromptCredentialsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SavePasswordPromptDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PasswordPromptCredentialsPtr
PasswordPromptCredentials::NewUsernamePasswordCredentials(
    UsernamePasswordCredentialsPtr value) {
  return PasswordPromptCredentialsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUsernamePasswordCredentials)>,
      std::move(value));
}

PasswordPromptCredentialsPtr
PasswordPromptCredentials::NewFederatedCredentials(
    FederatedCredentialsPtr value) {
  return PasswordPromptCredentialsPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kFederatedCredentials)>,
      std::move(value));
}

PasswordPromptCredentials::PasswordPromptCredentials(
    std::in_place_index_t<static_cast<size_t>(Tag::kUsernamePasswordCredentials)>,
    UsernamePasswordCredentialsPtr value)
    : tag_(Tag::kUsernamePasswordCredentials),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUsernamePasswordCredentials)>,
            std::move(value)) {}

PasswordPromptCredentials::PasswordPromptCredentials(
    std::in_place_index_t<static_cast<size_t>(Tag::kFederatedCredentials)>,
    FederatedCredentialsPtr value)
    : tag_(Tag::kFederatedCredentials),
      data_(std::in_place_index<static_cast<size_t>(Tag::kFederatedCredentials)>,
            std::move(value)) {}
PasswordPromptCredentials::~PasswordPromptCredentials() {
  DestroyActive();
}

void PasswordPromptCredentials::set_username_password_credentials(UsernamePasswordCredentialsPtr username_password_credentials) {
  if (tag_ == Tag::kUsernamePasswordCredentials) {
    data_.username_password_credentials = std::move(username_password_credentials);
  } else {
    DestroyActive();
    tag_ = Tag::kUsernamePasswordCredentials;
    new (&data_.username_password_credentials) UsernamePasswordCredentialsPtr(
        std::move(username_password_credentials));
  }
}

void PasswordPromptCredentials::set_federated_credentials(FederatedCredentialsPtr federated_credentials) {
  if (tag_ == Tag::kFederatedCredentials) {
    data_.federated_credentials = std::move(federated_credentials);
  } else {
    DestroyActive();
    tag_ = Tag::kFederatedCredentials;
    new (&data_.federated_credentials) FederatedCredentialsPtr(
        std::move(federated_credentials));
  }
}


PasswordPromptCredentials::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUsernamePasswordCredentials)>,
    UsernamePasswordCredentialsPtr value)
    : username_password_credentials(std::move(value)) {}

PasswordPromptCredentials::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kFederatedCredentials)>,
    FederatedCredentialsPtr value)
    : federated_credentials(std::move(value)) {}

void PasswordPromptCredentials::DestroyActive() {
  switch (tag_) {

    case Tag::kUsernamePasswordCredentials:
      std::destroy_at(&data_.username_password_credentials);
      break;
    case Tag::kFederatedCredentials:
      std::destroy_at(&data_.federated_credentials);
      break;
  }
}

bool PasswordPromptCredentials::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

SavePasswordPrompt::IPCStableHashFunction SavePasswordPrompt::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SavePasswordPrompt>(message.name())) {
    case messages::SavePasswordPrompt::kOnFederatedAvatarImageAvailable: {
      return &SavePasswordPrompt::OnFederatedAvatarImageAvailable_Sym::IPCStableHash;
    }
    case messages::SavePasswordPrompt::kClose: {
      return &SavePasswordPrompt::Close_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SavePasswordPrompt::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SavePasswordPrompt>(message.name())) {
      case messages::SavePasswordPrompt::kOnFederatedAvatarImageAvailable:
            return "Receive owl::mojom::SavePasswordPrompt::OnFederatedAvatarImageAvailable";
      case messages::SavePasswordPrompt::kClose:
            return "Receive owl::mojom::SavePasswordPrompt::Close";
    }
  } else {
    switch (static_cast<messages::SavePasswordPrompt>(message.name())) {
      case messages::SavePasswordPrompt::kOnFederatedAvatarImageAvailable:
            return "Receive reply owl::mojom::SavePasswordPrompt::OnFederatedAvatarImageAvailable";
      case messages::SavePasswordPrompt::kClose:
            return "Receive reply owl::mojom::SavePasswordPrompt::Close";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SavePasswordPrompt::OnFederatedAvatarImageAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf914868f;  // IPCStableHash for owl::mojom::SavePasswordPrompt::OnFederatedAvatarImageAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SavePasswordPrompt::Close_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x719d9617;  // IPCStableHash for owl::mojom::SavePasswordPrompt::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SavePasswordPromptProxy::SavePasswordPromptProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SavePasswordPromptProxy::OnFederatedAvatarImageAvailable(
    const ::gfx::ImageSkia& in_image) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::SavePasswordPrompt::OnFederatedAvatarImageAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("image"), in_image,
                        "<value of type const ::gfx::ImageSkia&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SavePasswordPrompt::kOnFederatedAvatarImageAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SavePasswordPrompt_OnFederatedAvatarImageAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->image)::BaseType> image_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::ImageSkiaDataView>(
    in_image,
    image_fragment);

  params->image.Set(
      image_fragment.is_null() ? nullptr : image_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->image.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null image in SavePasswordPrompt.OnFederatedAvatarImageAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SavePasswordPrompt::Name_);
  message.set_method_name("OnFederatedAvatarImageAvailable");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SavePasswordPromptProxy::Close(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::SavePasswordPrompt::Close");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SavePasswordPrompt::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SavePasswordPrompt_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SavePasswordPrompt::Name_);
  message.set_method_name("Close");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SavePasswordPromptStubDispatch::Accept(
    SavePasswordPrompt* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SavePasswordPrompt>(message->header()->name)) {
    case messages::SavePasswordPrompt::kOnFederatedAvatarImageAvailable: {
      DCHECK(message->is_serialized());
      internal::SavePasswordPrompt_OnFederatedAvatarImageAvailable_Params_Data* params =
          reinterpret_cast<internal::SavePasswordPrompt_OnFederatedAvatarImageAvailable_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SavePasswordPrompt.0
      bool success = true;
      ::gfx::ImageSkia p_image{};
      SavePasswordPrompt_OnFederatedAvatarImageAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SavePasswordPrompt::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFederatedAvatarImageAvailable(        
        std::move(p_image));
      return true;
    }
    case messages::SavePasswordPrompt::kClose: {
      DCHECK(message->is_serialized());
      internal::SavePasswordPrompt_Close_Params_Data* params =
          reinterpret_cast<internal::SavePasswordPrompt_Close_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SavePasswordPrompt.1
      bool success = true;
      SavePasswordPrompt_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SavePasswordPrompt::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(        );
      return true;
    }
  }
  return false;
}

// static
bool SavePasswordPromptStubDispatch::AcceptWithResponder(
    SavePasswordPrompt* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SavePasswordPrompt>(message->header()->name)) {
    case messages::SavePasswordPrompt::kOnFederatedAvatarImageAvailable: {
      break;
    }
    case messages::SavePasswordPrompt::kClose: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSavePasswordPromptValidationInfo[] = {
    { &internal::SavePasswordPrompt_OnFederatedAvatarImageAvailable_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SavePasswordPrompt_Close_Params_Data::Validate,
     nullptr /* no response */},
};

bool SavePasswordPromptRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::SavePasswordPrompt::Name_,
    kSavePasswordPromptValidationInfo);
}

// The declaration includes the definition on other builds.

SavePasswordPromptClient::IPCStableHashFunction SavePasswordPromptClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SavePasswordPromptClient>(message.name())) {
    case messages::SavePasswordPromptClient::kSetUsernameAndPassword: {
      return &SavePasswordPromptClient::SetUsernameAndPassword_Sym::IPCStableHash;
    }
    case messages::SavePasswordPromptClient::kNeverSaveForThisSite: {
      return &SavePasswordPromptClient::NeverSaveForThisSite_Sym::IPCStableHash;
    }
    case messages::SavePasswordPromptClient::kCreateOrUpdate: {
      return &SavePasswordPromptClient::CreateOrUpdate_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SavePasswordPromptClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SavePasswordPromptClient>(message.name())) {
      case messages::SavePasswordPromptClient::kSetUsernameAndPassword:
            return "Receive owl::mojom::SavePasswordPromptClient::SetUsernameAndPassword";
      case messages::SavePasswordPromptClient::kNeverSaveForThisSite:
            return "Receive owl::mojom::SavePasswordPromptClient::NeverSaveForThisSite";
      case messages::SavePasswordPromptClient::kCreateOrUpdate:
            return "Receive owl::mojom::SavePasswordPromptClient::CreateOrUpdate";
    }
  } else {
    switch (static_cast<messages::SavePasswordPromptClient>(message.name())) {
      case messages::SavePasswordPromptClient::kSetUsernameAndPassword:
            return "Receive reply owl::mojom::SavePasswordPromptClient::SetUsernameAndPassword";
      case messages::SavePasswordPromptClient::kNeverSaveForThisSite:
            return "Receive reply owl::mojom::SavePasswordPromptClient::NeverSaveForThisSite";
      case messages::SavePasswordPromptClient::kCreateOrUpdate:
            return "Receive reply owl::mojom::SavePasswordPromptClient::CreateOrUpdate";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SavePasswordPromptClient::SetUsernameAndPassword_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8141c184;  // IPCStableHash for owl::mojom::SavePasswordPromptClient::SetUsernameAndPassword
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SavePasswordPromptClient::NeverSaveForThisSite_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x49625968;  // IPCStableHash for owl::mojom::SavePasswordPromptClient::NeverSaveForThisSite
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SavePasswordPromptClient::CreateOrUpdate_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x89994282;  // IPCStableHash for owl::mojom::SavePasswordPromptClient::CreateOrUpdate
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SavePasswordPromptClientProxy::SavePasswordPromptClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SavePasswordPromptClientProxy::SetUsernameAndPassword(
    const ::std::u16string& in_username, const ::std::u16string& in_password) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send owl::mojom::SavePasswordPromptClient::SetUsernameAndPassword", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("username"), in_username,
                        "<value of type const ::std::u16string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("password"), in_password,
                        "<value of type const ::std::u16string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SavePasswordPromptClient::kSetUsernameAndPassword), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SavePasswordPromptClient_SetUsernameAndPassword_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->username)::BaseType> username_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_username,
    username_fragment);

  params->username.Set(
      username_fragment.is_null() ? nullptr : username_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->username.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null username in SavePasswordPromptClient.SetUsernameAndPassword request");
  mojo::internal::MessageFragment<
      typename decltype(params->password)::BaseType> password_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
    in_password,
    password_fragment);

  params->password.Set(
      password_fragment.is_null() ? nullptr : password_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->password.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null password in SavePasswordPromptClient.SetUsernameAndPassword request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SavePasswordPromptClient::Name_);
  message.set_method_name("SetUsernameAndPassword");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SavePasswordPromptClientProxy::NeverSaveForThisSite(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::SavePasswordPromptClient::NeverSaveForThisSite");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SavePasswordPromptClient::kNeverSaveForThisSite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SavePasswordPromptClient_NeverSaveForThisSite_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SavePasswordPromptClient::Name_);
  message.set_method_name("NeverSaveForThisSite");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void SavePasswordPromptClientProxy::CreateOrUpdate(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send owl::mojom::SavePasswordPromptClient::CreateOrUpdate");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SavePasswordPromptClient::kCreateOrUpdate), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::owl::mojom::internal::SavePasswordPromptClient_CreateOrUpdate_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SavePasswordPromptClient::Name_);
  message.set_method_name("CreateOrUpdate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SavePasswordPromptClientStubDispatch::Accept(
    SavePasswordPromptClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SavePasswordPromptClient>(message->header()->name)) {
    case messages::SavePasswordPromptClient::kSetUsernameAndPassword: {
      DCHECK(message->is_serialized());
      internal::SavePasswordPromptClient_SetUsernameAndPassword_Params_Data* params =
          reinterpret_cast<internal::SavePasswordPromptClient_SetUsernameAndPassword_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SavePasswordPromptClient.0
      bool success = true;
      ::std::u16string p_username{};
      ::std::u16string p_password{};
      SavePasswordPromptClient_SetUsernameAndPassword_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUsername(&p_username))
        success = false;
      if (success && !input_data_view.ReadPassword(&p_password))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SavePasswordPromptClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUsernameAndPassword(        
        std::move(p_username), 
        std::move(p_password));
      return true;
    }
    case messages::SavePasswordPromptClient::kNeverSaveForThisSite: {
      DCHECK(message->is_serialized());
      internal::SavePasswordPromptClient_NeverSaveForThisSite_Params_Data* params =
          reinterpret_cast<internal::SavePasswordPromptClient_NeverSaveForThisSite_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SavePasswordPromptClient.1
      bool success = true;
      SavePasswordPromptClient_NeverSaveForThisSite_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SavePasswordPromptClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NeverSaveForThisSite(        );
      return true;
    }
    case messages::SavePasswordPromptClient::kCreateOrUpdate: {
      DCHECK(message->is_serialized());
      internal::SavePasswordPromptClient_CreateOrUpdate_Params_Data* params =
          reinterpret_cast<internal::SavePasswordPromptClient_CreateOrUpdate_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SavePasswordPromptClient.2
      bool success = true;
      SavePasswordPromptClient_CreateOrUpdate_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SavePasswordPromptClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateOrUpdate(        );
      return true;
    }
  }
  return false;
}

// static
bool SavePasswordPromptClientStubDispatch::AcceptWithResponder(
    SavePasswordPromptClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SavePasswordPromptClient>(message->header()->name)) {
    case messages::SavePasswordPromptClient::kSetUsernameAndPassword: {
      break;
    }
    case messages::SavePasswordPromptClient::kNeverSaveForThisSite: {
      break;
    }
    case messages::SavePasswordPromptClient::kCreateOrUpdate: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSavePasswordPromptClientValidationInfo[] = {
    { &internal::SavePasswordPromptClient_SetUsernameAndPassword_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SavePasswordPromptClient_NeverSaveForThisSite_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::SavePasswordPromptClient_CreateOrUpdate_Params_Data::Validate,
     nullptr /* no response */},
};

bool SavePasswordPromptClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::owl::mojom::SavePasswordPromptClient::Name_,
    kSavePasswordPromptClientValidationInfo);
}



}  // owl::mojom


namespace mojo {


// static
bool StructTraits<::owl::mojom::FederatedCredentials::DataView, ::owl::mojom::FederatedCredentialsPtr>::Read(
    ::owl::mojom::FederatedCredentials::DataView input,
    ::owl::mojom::FederatedCredentialsPtr* output) {
  bool success = true;
  ::owl::mojom::FederatedCredentialsPtr result(::owl::mojom::FederatedCredentials::New());
  
      if (success && !input.ReadUpperText(&result->upper_text))
        success = false;
      if (success && !input.ReadLowerText(&result->lower_text))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::UsernamePasswordCredentials::DataView, ::owl::mojom::UsernamePasswordCredentialsPtr>::Read(
    ::owl::mojom::UsernamePasswordCredentials::DataView input,
    ::owl::mojom::UsernamePasswordCredentialsPtr* output) {
  bool success = true;
  ::owl::mojom::UsernamePasswordCredentialsPtr result(::owl::mojom::UsernamePasswordCredentials::New());
  
      if (success && !input.ReadUsername(&result->username))
        success = false;
      if (success && !input.ReadPassword(&result->password))
        success = false;
      if (success && !input.ReadAllUsernames(&result->all_usernames))
        success = false;
      if (success && !input.ReadAllPasswords(&result->all_passwords))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::owl::mojom::SavePasswordPromptDetails::DataView, ::owl::mojom::SavePasswordPromptDetailsPtr>::Read(
    ::owl::mojom::SavePasswordPromptDetails::DataView input,
    ::owl::mojom::SavePasswordPromptDetailsPtr* output) {
  bool success = true;
  ::owl::mojom::SavePasswordPromptDetailsPtr result(::owl::mojom::SavePasswordPromptDetails::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadCredentials(&result->credentials))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::owl::mojom::PasswordPromptCredentials::DataView, ::owl::mojom::PasswordPromptCredentialsPtr>::Read(
    ::owl::mojom::PasswordPromptCredentials::DataView input,
    ::owl::mojom::PasswordPromptCredentialsPtr* output) {
  using UnionType = ::owl::mojom::PasswordPromptCredentials;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kUsernamePasswordCredentials: {
      ::owl::mojom::UsernamePasswordCredentialsPtr result_username_password_credentials{};
      if (!input.ReadUsernamePasswordCredentials(&result_username_password_credentials))
        return false;

      *output = UnionType::NewUsernamePasswordCredentials(
          std::move(result_username_password_credentials));
      break;
    }
    case Tag::kFederatedCredentials: {
      ::owl::mojom::FederatedCredentialsPtr result_federated_credentials{};
      if (!input.ReadFederatedCredentials(&result_federated_credentials))
        return false;

      *output = UnionType::NewFederatedCredentials(
          std::move(result_federated_credentials));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace owl::mojom {


void SavePasswordPromptInterceptorForTesting::OnFederatedAvatarImageAvailable(const ::gfx::ImageSkia& image) {
  GetForwardingInterface()->OnFederatedAvatarImageAvailable(
    std::move(image)
    );
}
void SavePasswordPromptInterceptorForTesting::Close() {
  GetForwardingInterface()->Close();
}
SavePasswordPromptAsyncWaiter::SavePasswordPromptAsyncWaiter(
    SavePasswordPrompt* proxy) : proxy_(proxy) {}

SavePasswordPromptAsyncWaiter::~SavePasswordPromptAsyncWaiter() = default;





void SavePasswordPromptClientInterceptorForTesting::SetUsernameAndPassword(const ::std::u16string& username, const ::std::u16string& password) {
  GetForwardingInterface()->SetUsernameAndPassword(
    std::move(username)
    , 
    std::move(password)
    );
}
void SavePasswordPromptClientInterceptorForTesting::NeverSaveForThisSite() {
  GetForwardingInterface()->NeverSaveForThisSite();
}
void SavePasswordPromptClientInterceptorForTesting::CreateOrUpdate() {
  GetForwardingInterface()->CreateOrUpdate();
}
SavePasswordPromptClientAsyncWaiter::SavePasswordPromptClientAsyncWaiter(
    SavePasswordPromptClient* proxy) : proxy_(proxy) {}

SavePasswordPromptClientAsyncWaiter::~SavePasswordPromptClientAsyncWaiter() = default;







}  // owl::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif